/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.model.BasicTreeContainer;
import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphModel;
import java.io.Serializable;
import java.util.Vector;

public class TreeItems
implements Serializable {
    private BasicTreeContainer model = new BasicTreeContainer();
    private String[] items;
    private final String CR = "\n";
    private final String TAB = "\t";
    Vector itemArray;
    int depth = 0;

    public TreeItems(String[] items) {
        String text = "";
        if (items != null && items.length > 0) {
            text = items[0];
            for (int i = 1; i < items.length; ++i) {
                text = String.valueOf(String.valueOf(text)).concat(String.valueOf(String.valueOf("\n".concat(String.valueOf(String.valueOf(items[i]))))));
            }
        }
        this.processItems(text);
    }

    public TreeItems(String text) {
        this.processItems(text);
    }

    public TreeItems(GraphModel model) {
        if (model.getRoot() != null) {
            this.itemArray = new Vector();
            this.processChildren(model.getRoot());
            this.items = new String[this.itemArray.size()];
            for (int i = 0; i < this.items.length; ++i) {
                this.items[i] = this.itemArray.elementAt(i) != null ? this.itemArray.elementAt(i).toString() : "";
            }
        }
    }

    public String[] getItems() {
        return this.items;
    }

    public GraphModel getModel() {
        return this.model;
    }

    private void processItems(String text) {
        if (text.length() > 0) {
            GraphLocation lastNode;
            int begin = 0;
            int end = text.indexOf("\n", begin) > 0 ? text.indexOf("\n", begin) : text.length();
            this.model = new BasicTreeContainer(text.substring(begin, end));
            GraphLocation parent = lastNode = this.model.getRoot();
            int lastTabs = 0;
            begin = end + 1;
            int n = end = text.indexOf("\n", begin) > 0 ? text.indexOf("\n", begin) : text.length();
            while (end > begin) {
                String thisText = text.substring(begin, end);
                int thisTabs = this.getTabCount(thisText);
                if (thisTabs > lastTabs) {
                    parent = lastNode;
                } else if (thisTabs < lastTabs) {
                    int tabDiff = lastTabs - thisTabs;
                    for (int i = 0; i < tabDiff; ++i) {
                        parent = parent.getParent();
                    }
                }
                thisText = thisText.substring(thisTabs);
                lastNode = this.model.addChild(parent, thisText);
                lastTabs = thisTabs;
                begin = end > 0 ? end + 1 : end;
                end = text.indexOf("\n", begin) > 0 ? text.indexOf("\n", begin) : text.length();
            }
        }
    }

    private int getTabCount(String text) {
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (new Character(chars[i]).equals(new Character("\t".charAt(0)))) continue;
            return i;
        }
        return 0;
    }

    private void processChildren(GraphLocation node) {
        String tabs = "";
        for (int t = 0; t < this.depth; ++t) {
            tabs = String.valueOf(String.valueOf(tabs)).concat("\t");
        }
        this.itemArray.addElement(String.valueOf(String.valueOf(tabs)).concat(String.valueOf(String.valueOf(this.model.get(node)))));
        if (node.hasChildren() != 0) {
            ++this.depth;
            GraphLocation[] children = node.getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.processChildren(node.getChildren()[i]);
            }
            --this.depth;
        }
    }
}

