/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import alpine3d.SurfacePoint;

public class SurfaceArea {
    public static final int ALB = 5;
    public static final int DEM = 1;
    public static final int FIELD_CAPACITY = 12;
    public static final int LANDUSE = 10;
    public static final int LWR = 4;
    public static final int SDP = 7;
    public static final int SOIL_DEPTH = 11;
    public static final int SURFACE_CODE = 2;
    public static final int SWE = 8;
    public static final int SWR = 3;
    public static final int TSS = 9;
    public static final int WET = 6;
    private float cellsize = -1.0f;
    private float maxValue = -1000000.0f;
    private float minValue = 1000000.0f;
    private int nCols = -1;
    private int nRows = -1;
    private int noDataValue = -1;
    public SurfacePoint[][] sPoint;
    private float xllCorner = -1.0f;
    private float yllCorner = -1.0f;

    public void createNoValueSurfacePoints() {
        this.sPoint = new SurfacePoint[this.nRows][this.nCols];
        int i = 0;
        while (i < this.nRows) {
            int j = 0;
            while (j < this.nCols) {
                this.sPoint[i][j] = new SurfacePoint();
                this.sPoint[i][j].setValue(this.getNoDataValue());
                this.sPoint[i][j].setLanduse(-9999);
                this.sPoint[i][j].setSoilDepth(-9999);
                this.sPoint[i][j].setFieldCapacity(-9999);
                this.sPoint[i][j].setIsNoDataValue(true);
                ++j;
            }
            ++i;
        }
    }

    public void createSurfacePoints(int nRows, int nCols) {
        this.sPoint = new SurfacePoint[nRows][nCols];
        int i = 0;
        while (i < nRows) {
            int j = 0;
            while (j < nCols) {
                this.sPoint[i][j] = new SurfacePoint();
                ++j;
            }
            ++i;
        }
    }

    public void deleteHeader() {
        this.setNCols(-1);
        this.setNRows(-1);
        this.setXllCorner(-1.0f);
        this.setYllCorner(-1.0f);
        this.setCellsize(-1.0f);
        this.setNoDataValue(-1);
    }

    public void deleteMinAndMax() {
        this.setMinValue(1000000.0f);
        this.setMaxValue(-1000000.0f);
    }

    public float getCellsize() {
        return this.cellsize;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public int getNCols() {
        return this.nCols;
    }

    public int getNRows() {
        return this.nRows;
    }

    public int getNoDataValue() {
        return this.noDataValue;
    }

    public SurfacePoint getSurfacePoint(int i, int j) {
        return this.sPoint[i][j];
    }

    public float getXllCorner() {
        return this.xllCorner;
    }

    public float getYllCorner() {
        return this.yllCorner;
    }

    public float getYulCorner() {
        float yulCorner = this.yllCorner + (float)this.nRows * this.cellsize;
        return yulCorner;
    }

    public void setCellsize(float value) {
        this.cellsize = value;
    }

    public void setMaxValue(float value) {
        this.maxValue = value;
    }

    public void setMinValue(float value) {
        this.minValue = value;
    }

    public void setNCols(int value) {
        this.nCols = value;
    }

    public void setNRows(int value) {
        this.nRows = value;
    }

    public void setNoDataValue(int value) {
        this.noDataValue = value;
    }

    public void setXllCorner(float value) {
        this.xllCorner = value;
    }

    public void setYllCorner(float value) {
        this.yllCorner = value;
    }
}

