# - Find Oracle / Oracle Embedded
# Find the Oracle includes and client library
# This module defines
#  ORACLE_INCLUDE_DIR, where to find oracle.h
#  ORACLE_LIBRARIES, the libraries needed to use Oracle.
#  ORACLE_EMBEDDED_LIBRARIES, the libraries needed to use Oracle Embedded.
#  ORACLE_FOUND, If false, do not try to use Oracle.
#  ORACLE_EMBEDDED_FOUND, If false, do not try to use Oracle Embedded.

# Copyright (c) 2008, Julia Sanchez-Simon, <hithwen@gmail.com>
# Copyright (c) 2008, Miguel Angel Aragüez-Rey, <fizban87@gmail.com>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.





MACRO(MACRO_PUSH_REQUIRED_VARS)

   IF(NOT DEFINED _PUSH_REQUIRED_VARS_COUNTER)
      SET(_PUSH_REQUIRED_VARS_COUNTER 0)
   ENDIF(NOT DEFINED _PUSH_REQUIRED_VARS_COUNTER)

   MATH(EXPR _PUSH_REQUIRED_VARS_COUNTER "${_PUSH_REQUIRED_VARS_COUNTER}+1")

   SET(_CMAKE_REQUIRED_INCLUDES_SAVE_${_PUSH_REQUIRED_VARS_COUNTER}    ${CMAKE_REQUIRED_INCLUDES})
   SET(_CMAKE_REQUIRED_DEFINITIONS_SAVE_${_PUSH_REQUIRED_VARS_COUNTER} ${CMAKE_REQUIRED_DEFINITIONS})
   SET(_CMAKE_REQUIRED_LIBRARIES_SAVE_${_PUSH_REQUIRED_VARS_COUNTER}   ${CMAKE_REQUIRED_LIBRARIES})
   SET(_CMAKE_REQUIRED_FLAGS_SAVE_${_PUSH_REQUIRED_VARS_COUNTER}       ${CMAKE_REQUIRED_FLAGS})
ENDMACRO(MACRO_PUSH_REQUIRED_VARS)

MACRO(MACRO_POP_REQUIRED_VARS)

# don't pop more than we pushed
   IF("${_PUSH_REQUIRED_VARS_COUNTER}" GREATER "0")

      SET(CMAKE_REQUIRED_INCLUDES    ${_CMAKE_REQUIRED_INCLUDES_SAVE_${_PUSH_REQUIRED_VARS_COUNTER}})
      SET(CMAKE_REQUIRED_DEFINITIONS ${_CMAKE_REQUIRED_DEFINITIONS_SAVE_${_PUSH_REQUIRED_VARS_COUNTER}})
      SET(CMAKE_REQUIRED_LIBRARIES   ${_CMAKE_REQUIRED_LIBRARIES_SAVE_${_PUSH_REQUIRED_VARS_COUNTER}})
      SET(CMAKE_REQUIRED_FLAGS       ${_CMAKE_REQUIRED_FLAGS_SAVE_${_PUSH_REQUIRED_VARS_COUNTER}})

      MATH(EXPR _PUSH_REQUIRED_VARS_COUNTER "${_PUSH_REQUIRED_VARS_COUNTER}-1")
   ENDIF("${_PUSH_REQUIRED_VARS_COUNTER}" GREATER "0")

ENDMACRO(MACRO_POP_REQUIRED_VARS)

find_path(ORACLE_INCLUDE_DIR occi.h /usr/include/oracle/11.1.0.1/client)

find_library(ORACLE_LIBRARIES NAMES occi clntsh
   PATHS
   /usr/lib/oracle/11.1.0.1/client/lib
   /usr/lib/oracle/11.1.0.1/client/bin
)

macro_push_required_vars()
set( CMAKE_REQUIRED_INCLUDES ${ORACLE_INCLUDE_DIR} )
macro_pop_required_vars()

if(ORACLE_INCLUDE_DIR AND ORACLE_LIBRARIES)
   set(ORACLE_FOUND TRUE)
   message(STATUS "Found Oracle: ${ORACLE_INCLUDE_DIR}, ${ORACLE_LIBRARIES}")
else(ORACLE_INCLUDE_DIR AND ORACLE_LIBRARIES)
   set(ORACLE_FOUND FALSE)
   message(STATUS "Oracle not found.")
endif(ORACLE_INCLUDE_DIR AND ORACLE_LIBRARIES)

#mark_as_advanced(ORACLE_INCLUDE_DIR ORACLE_LIBRARIES)
