/* soapC.cpp
   Generated by gSOAP 2.8.7 from GSNWebService.h

Copyright(C) 2000-2011, Robert van Engelen, Genivia Inc. All Rights Reserved.
The generated code is released under one of the following licenses:
1) GPL or 2) Genivia's license for commercial use.
This program is released under the GPL with the additional exemption that
compiling, linking, and/or using OpenSSL is allowed.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "soapH.h"

SOAP_SOURCE_STAMP("@(#) soapC.cpp ver 2.8.7 2013-03-21 09:01:33 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (!soap->header)
	{	if ((soap->header = soap_new_SOAP_ENV__Header(soap, -1)))
			soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = soap_new_SOAP_ENV__Fault(soap, -1);
		if (!soap->fault)
			return;
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = soap_new_SOAP_ENV__Code(soap, -1);
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = soap_new_SOAP_ENV__Reason(soap, -1);
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	soap_fault(soap);
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Code)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = soap_new_SOAP_ENV__Code(soap, -1);
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (soap->fault->SOAP_ENV__Code && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
			return soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
		return NULL;
	}
	return soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = soap_new_SOAP_ENV__Detail(soap, -1);
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Detail)
		return soap->fault->SOAP_ENV__Detail->__any;
	if (soap->fault->detail)
		return soap->fault->detail->__any;
	return NULL;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	if (soap->version == 1)
	{	for (;;)
		{	if (!soap_getelement(soap, &t))
				if (soap->error || soap_ignore_element(soap))
					break;
		}
	}
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{	(void)type;
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_LONG64:
		return soap_in_LONG64(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_bool:
		return soap_in_bool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_ns2__GSNWebService_USCOREDetailsType:
		return soap_in_ns2__GSNWebService_USCOREDetailsType(soap, NULL, NULL, "ns2:GSNWebService_DetailsType");
	case SOAP_TYPE_std__string:
		return soap_in_std__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_ns3__AggregationCriterion:
		return soap_in_ns3__AggregationCriterion(soap, NULL, NULL, "ns3:AggregationCriterion");
	case SOAP_TYPE_ns3__StandardCriterion:
		return soap_in_ns3__StandardCriterion(soap, NULL, NULL, "ns3:StandardCriterion");
	case SOAP_TYPE_ns3__AbstractCriterion:
		return soap_in_ns3__AbstractCriterion(soap, NULL, NULL, "ns3:AbstractCriterion");
	case SOAP_TYPE_ns2__GSNWebService_USCOREWrapperURL:
		return soap_in_ns2__GSNWebService_USCOREWrapperURL(soap, NULL, NULL, "ns2:GSNWebService_WrapperURL");
	case SOAP_TYPE_ns2__GSNWebService_USCOREWrapperDetails:
		return soap_in_ns2__GSNWebService_USCOREWrapperDetails(soap, NULL, NULL, "ns2:GSNWebService_WrapperDetails");
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfWrapper:
		return soap_in_ns2__GSNWebService_USCOREConfWrapper(soap, NULL, NULL, "ns2:GSNWebService_ConfWrapper");
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfProcessor:
		return soap_in_ns2__GSNWebService_USCOREConfProcessor(soap, NULL, NULL, "ns2:GSNWebService_ConfProcessor");
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfOutputStructure:
		return soap_in_ns2__GSNWebService_USCOREConfOutputStructure(soap, NULL, NULL, "ns2:GSNWebService_ConfOutputStructure");
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfInfo:
		return soap_in_ns2__GSNWebService_USCOREConfInfo(soap, NULL, NULL, "ns2:GSNWebService_ConfInfo");
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfPredicate:
		return soap_in_ns2__GSNWebService_USCOREConfPredicate(soap, NULL, NULL, "ns2:GSNWebService_ConfPredicate");
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfAddressing:
		return soap_in_ns2__GSNWebService_USCOREConfAddressing(soap, NULL, NULL, "ns2:GSNWebService_ConfAddressing");
	case SOAP_TYPE_ns2__GSNWebService_USCOREVirtualSensorDetails:
		return soap_in_ns2__GSNWebService_USCOREVirtualSensorDetails(soap, NULL, NULL, "ns2:GSNWebService_VirtualSensorDetails");
	case SOAP_TYPE_ns2__GSNWebService_USCOREDataField:
		return soap_in_ns2__GSNWebService_USCOREDataField(soap, NULL, NULL, "ns2:GSNWebService_DataField");
	case SOAP_TYPE_ns2__GSNWebService_USCOREStreamElement:
		return soap_in_ns2__GSNWebService_USCOREStreamElement(soap, NULL, NULL, "ns2:GSNWebService_StreamElement");
	case SOAP_TYPE_ns2__GSNWebService_USCOREQueryResult:
		return soap_in_ns2__GSNWebService_USCOREQueryResult(soap, NULL, NULL, "ns2:GSNWebService_QueryResult");
	case SOAP_TYPE_ns2__GSNWebService_USCOREFieldSelector:
		return soap_in_ns2__GSNWebService_USCOREFieldSelector(soap, NULL, NULL, "ns2:GSNWebService_FieldSelector");
	case SOAP_TYPE_ns2__GSNWebService_USCOREContainerDetails:
		return soap_in_ns2__GSNWebService_USCOREContainerDetails(soap, NULL, NULL, "ns2:GSNWebService_ContainerDetails");
	case SOAP_TYPE_ns2__GSNWebService_USCOREACDetails:
		return soap_in_ns2__GSNWebService_USCOREACDetails(soap, NULL, NULL, "ns2:GSNWebService_ACDetails");
	case SOAP_TYPE_PointerTo_ns1__listWrapperURLsResponse:
		return soap_in_PointerTo_ns1__listWrapperURLsResponse(soap, NULL, NULL, "ns1:listWrapperURLsResponse");
	case SOAP_TYPE_PointerTo_ns1__listWrapperURLs:
		return soap_in_PointerTo_ns1__listWrapperURLs(soap, NULL, NULL, "ns1:listWrapperURLs");
	case SOAP_TYPE_PointerTo_ns1__createVirtualSensorResponse:
		return soap_in_PointerTo_ns1__createVirtualSensorResponse(soap, NULL, NULL, "ns1:createVirtualSensorResponse");
	case SOAP_TYPE_PointerTo_ns1__createVirtualSensor:
		return soap_in_PointerTo_ns1__createVirtualSensor(soap, NULL, NULL, "ns1:createVirtualSensor");
	case SOAP_TYPE_PointerTo_ns1__getVirtualSensorsDetailsResponse:
		return soap_in_PointerTo_ns1__getVirtualSensorsDetailsResponse(soap, NULL, NULL, "ns1:getVirtualSensorsDetailsResponse");
	case SOAP_TYPE_PointerTo_ns1__getVirtualSensorsDetails:
		return soap_in_PointerTo_ns1__getVirtualSensorsDetails(soap, NULL, NULL, "ns1:getVirtualSensorsDetails");
	case SOAP_TYPE_PointerTo_ns1__deleteVirtualSensorResponse:
		return soap_in_PointerTo_ns1__deleteVirtualSensorResponse(soap, NULL, NULL, "ns1:deleteVirtualSensorResponse");
	case SOAP_TYPE_PointerTo_ns1__deleteVirtualSensor:
		return soap_in_PointerTo_ns1__deleteVirtualSensor(soap, NULL, NULL, "ns1:deleteVirtualSensor");
	case SOAP_TYPE_PointerTo_ns1__getLatestMultiDataResponse:
		return soap_in_PointerTo_ns1__getLatestMultiDataResponse(soap, NULL, NULL, "ns1:getLatestMultiDataResponse");
	case SOAP_TYPE_PointerTo_ns1__getLatestMultiData:
		return soap_in_PointerTo_ns1__getLatestMultiData(soap, NULL, NULL, "ns1:getLatestMultiData");
	case SOAP_TYPE_PointerTo_ns1__unregisterQueryResponse:
		return soap_in_PointerTo_ns1__unregisterQueryResponse(soap, NULL, NULL, "ns1:unregisterQueryResponse");
	case SOAP_TYPE_PointerTo_ns1__unregisterQuery:
		return soap_in_PointerTo_ns1__unregisterQuery(soap, NULL, NULL, "ns1:unregisterQuery");
	case SOAP_TYPE_PointerTo_ns1__registerQueryResponse:
		return soap_in_PointerTo_ns1__registerQueryResponse(soap, NULL, NULL, "ns1:registerQueryResponse");
	case SOAP_TYPE_PointerTo_ns1__registerQuery:
		return soap_in_PointerTo_ns1__registerQuery(soap, NULL, NULL, "ns1:registerQuery");
	case SOAP_TYPE_PointerTo_ns1__getNextDataResponse:
		return soap_in_PointerTo_ns1__getNextDataResponse(soap, NULL, NULL, "ns1:getNextDataResponse");
	case SOAP_TYPE_PointerTo_ns1__getNextData:
		return soap_in_PointerTo_ns1__getNextData(soap, NULL, NULL, "ns1:getNextData");
	case SOAP_TYPE_PointerTo_ns1__listVirtualSensorNamesResponse:
		return soap_in_PointerTo_ns1__listVirtualSensorNamesResponse(soap, NULL, NULL, "ns1:listVirtualSensorNamesResponse");
	case SOAP_TYPE_PointerTo_ns1__listVirtualSensorNames:
		return soap_in_PointerTo_ns1__listVirtualSensorNames(soap, NULL, NULL, "ns1:listVirtualSensorNames");
	case SOAP_TYPE_PointerTo_ns1__getMultiDataResponse:
		return soap_in_PointerTo_ns1__getMultiDataResponse(soap, NULL, NULL, "ns1:getMultiDataResponse");
	case SOAP_TYPE_PointerTo_ns1__getMultiData:
		return soap_in_PointerTo_ns1__getMultiData(soap, NULL, NULL, "ns1:getMultiData");
	case SOAP_TYPE_PointerTo_ns1__getContainerInfoResponse:
		return soap_in_PointerTo_ns1__getContainerInfoResponse(soap, NULL, NULL, "ns1:getContainerInfoResponse");
	case SOAP_TYPE_PointerTo_ns1__getContainerInfo:
		return soap_in_PointerTo_ns1__getContainerInfo(soap, NULL, NULL, "ns1:getContainerInfo");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREVirtualSensorDetails:
		return soap_in_PointerTons2__GSNWebService_USCOREVirtualSensorDetails(soap, NULL, NULL, "ns2:GSNWebService_VirtualSensorDetails");
	case SOAP_TYPE_PointerToLONG64:
		return soap_in_PointerToLONG64(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_PointerTons3__AggregationCriterion:
		return soap_in_PointerTons3__AggregationCriterion(soap, NULL, NULL, "ns3:AggregationCriterion");
	case SOAP_TYPE_PointerTons3__StandardCriterion:
		return soap_in_PointerTons3__StandardCriterion(soap, NULL, NULL, "ns3:StandardCriterion");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREQueryResult:
		return soap_in_PointerTons2__GSNWebService_USCOREQueryResult(soap, NULL, NULL, "ns2:GSNWebService_QueryResult");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREFieldSelector:
		return soap_in_PointerTons2__GSNWebService_USCOREFieldSelector(soap, NULL, NULL, "ns2:GSNWebService_FieldSelector");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREContainerDetails:
		return soap_in_PointerTons2__GSNWebService_USCOREContainerDetails(soap, NULL, NULL, "ns2:GSNWebService_ContainerDetails");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREACDetails:
		return soap_in_PointerTons2__GSNWebService_USCOREACDetails(soap, NULL, NULL, "ns2:GSNWebService_ACDetails");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREWrapperURL:
		return soap_in_PointerTons2__GSNWebService_USCOREWrapperURL(soap, NULL, NULL, "ns2:GSNWebService_WrapperURL");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREWrapperDetails:
		return soap_in_PointerTons2__GSNWebService_USCOREWrapperDetails(soap, NULL, NULL, "ns2:GSNWebService_WrapperDetails");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfPredicate:
		return soap_in_PointerTons2__GSNWebService_USCOREConfPredicate(soap, NULL, NULL, "ns2:GSNWebService_ConfPredicate");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfWrapper:
		return soap_in_PointerTons2__GSNWebService_USCOREConfWrapper(soap, NULL, NULL, "ns2:GSNWebService_ConfWrapper");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfProcessor:
		return soap_in_PointerTons2__GSNWebService_USCOREConfProcessor(soap, NULL, NULL, "ns2:GSNWebService_ConfProcessor");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfOutputStructure:
		return soap_in_PointerTons2__GSNWebService_USCOREConfOutputStructure(soap, NULL, NULL, "ns2:GSNWebService_ConfOutputStructure");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfInfo:
		return soap_in_PointerTons2__GSNWebService_USCOREConfInfo(soap, NULL, NULL, "ns2:GSNWebService_ConfInfo");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfAddressing:
		return soap_in_PointerTons2__GSNWebService_USCOREConfAddressing(soap, NULL, NULL, "ns2:GSNWebService_ConfAddressing");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREDataField:
		return soap_in_PointerTons2__GSNWebService_USCOREDataField(soap, NULL, NULL, "ns2:GSNWebService_DataField");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREStreamElement:
		return soap_in_PointerTons2__GSNWebService_USCOREStreamElement(soap, NULL, NULL, "ns2:GSNWebService_StreamElement");
	case SOAP_TYPE_PointerTostd__string:
		return soap_in_PointerTostd__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerToint:
		return soap_in_PointerToint(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	*type = SOAP_TYPE_std__string;
			return soap_in_std__string(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns3:AggregationCriterion"))
		{	*type = SOAP_TYPE_ns3__AggregationCriterion;
			return soap_in_ns3__AggregationCriterion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns3:StandardCriterion"))
		{	*type = SOAP_TYPE_ns3__StandardCriterion;
			return soap_in_ns3__StandardCriterion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns3:AbstractCriterion"))
		{	*type = SOAP_TYPE_ns3__AbstractCriterion;
			return soap_in_ns3__AbstractCriterion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:GSNWebService_WrapperURL"))
		{	*type = SOAP_TYPE_ns2__GSNWebService_USCOREWrapperURL;
			return soap_in_ns2__GSNWebService_USCOREWrapperURL(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:GSNWebService_WrapperDetails"))
		{	*type = SOAP_TYPE_ns2__GSNWebService_USCOREWrapperDetails;
			return soap_in_ns2__GSNWebService_USCOREWrapperDetails(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:GSNWebService_ConfWrapper"))
		{	*type = SOAP_TYPE_ns2__GSNWebService_USCOREConfWrapper;
			return soap_in_ns2__GSNWebService_USCOREConfWrapper(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:GSNWebService_ConfProcessor"))
		{	*type = SOAP_TYPE_ns2__GSNWebService_USCOREConfProcessor;
			return soap_in_ns2__GSNWebService_USCOREConfProcessor(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:GSNWebService_ConfOutputStructure"))
		{	*type = SOAP_TYPE_ns2__GSNWebService_USCOREConfOutputStructure;
			return soap_in_ns2__GSNWebService_USCOREConfOutputStructure(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:GSNWebService_ConfInfo"))
		{	*type = SOAP_TYPE_ns2__GSNWebService_USCOREConfInfo;
			return soap_in_ns2__GSNWebService_USCOREConfInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:GSNWebService_ConfPredicate"))
		{	*type = SOAP_TYPE_ns2__GSNWebService_USCOREConfPredicate;
			return soap_in_ns2__GSNWebService_USCOREConfPredicate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:GSNWebService_ConfAddressing"))
		{	*type = SOAP_TYPE_ns2__GSNWebService_USCOREConfAddressing;
			return soap_in_ns2__GSNWebService_USCOREConfAddressing(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:GSNWebService_VirtualSensorDetails"))
		{	*type = SOAP_TYPE_ns2__GSNWebService_USCOREVirtualSensorDetails;
			return soap_in_ns2__GSNWebService_USCOREVirtualSensorDetails(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:GSNWebService_DataField"))
		{	*type = SOAP_TYPE_ns2__GSNWebService_USCOREDataField;
			return soap_in_ns2__GSNWebService_USCOREDataField(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:GSNWebService_StreamElement"))
		{	*type = SOAP_TYPE_ns2__GSNWebService_USCOREStreamElement;
			return soap_in_ns2__GSNWebService_USCOREStreamElement(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:GSNWebService_QueryResult"))
		{	*type = SOAP_TYPE_ns2__GSNWebService_USCOREQueryResult;
			return soap_in_ns2__GSNWebService_USCOREQueryResult(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:GSNWebService_FieldSelector"))
		{	*type = SOAP_TYPE_ns2__GSNWebService_USCOREFieldSelector;
			return soap_in_ns2__GSNWebService_USCOREFieldSelector(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:GSNWebService_ContainerDetails"))
		{	*type = SOAP_TYPE_ns2__GSNWebService_USCOREContainerDetails;
			return soap_in_ns2__GSNWebService_USCOREContainerDetails(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:GSNWebService_ACDetails"))
		{	*type = SOAP_TYPE_ns2__GSNWebService_USCOREACDetails;
			return soap_in_ns2__GSNWebService_USCOREACDetails(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:long"))
		{	*type = SOAP_TYPE_LONG64;
			return soap_in_LONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_bool;
			return soap_in_bool(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:GSNWebService_DetailsType"))
		{	*type = SOAP_TYPE_ns2__GSNWebService_USCOREDetailsType;
			return soap_in_ns2__GSNWebService_USCOREDetailsType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "ns1:unregisterQueryResponse"))
		{	*type = SOAP_TYPE__ns1__unregisterQueryResponse;
			return soap_in__ns1__unregisterQueryResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:unregisterQuery"))
		{	*type = SOAP_TYPE__ns1__unregisterQuery;
			return soap_in__ns1__unregisterQuery(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:registerQueryResponse"))
		{	*type = SOAP_TYPE__ns1__registerQueryResponse;
			return soap_in__ns1__registerQueryResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:registerQuery"))
		{	*type = SOAP_TYPE__ns1__registerQuery;
			return soap_in__ns1__registerQuery(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:deleteVirtualSensorResponse"))
		{	*type = SOAP_TYPE__ns1__deleteVirtualSensorResponse;
			return soap_in__ns1__deleteVirtualSensorResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:deleteVirtualSensor"))
		{	*type = SOAP_TYPE__ns1__deleteVirtualSensor;
			return soap_in__ns1__deleteVirtualSensor(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:createVirtualSensorResponse"))
		{	*type = SOAP_TYPE__ns1__createVirtualSensorResponse;
			return soap_in__ns1__createVirtualSensorResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:createVirtualSensor"))
		{	*type = SOAP_TYPE__ns1__createVirtualSensor;
			return soap_in__ns1__createVirtualSensor(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:listWrapperURLsResponse"))
		{	*type = SOAP_TYPE__ns1__listWrapperURLsResponse;
			return soap_in__ns1__listWrapperURLsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:listWrapperURLs"))
		{	*type = SOAP_TYPE__ns1__listWrapperURLs;
			return soap_in__ns1__listWrapperURLs(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:listVirtualSensorNamesResponse"))
		{	*type = SOAP_TYPE__ns1__listVirtualSensorNamesResponse;
			return soap_in__ns1__listVirtualSensorNamesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:listVirtualSensorNames"))
		{	*type = SOAP_TYPE__ns1__listVirtualSensorNames;
			return soap_in__ns1__listVirtualSensorNames(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getVirtualSensorsDetailsResponse"))
		{	*type = SOAP_TYPE__ns1__getVirtualSensorsDetailsResponse;
			return soap_in__ns1__getVirtualSensorsDetailsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getVirtualSensorsDetails"))
		{	*type = SOAP_TYPE__ns1__getVirtualSensorsDetails;
			return soap_in__ns1__getVirtualSensorsDetails(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getNextDataResponse"))
		{	*type = SOAP_TYPE__ns1__getNextDataResponse;
			return soap_in__ns1__getNextDataResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getNextData"))
		{	*type = SOAP_TYPE__ns1__getNextData;
			return soap_in__ns1__getNextData(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getMultiDataResponse"))
		{	*type = SOAP_TYPE__ns1__getMultiDataResponse;
			return soap_in__ns1__getMultiDataResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getMultiData"))
		{	*type = SOAP_TYPE__ns1__getMultiData;
			return soap_in__ns1__getMultiData(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getLatestMultiDataResponse"))
		{	*type = SOAP_TYPE__ns1__getLatestMultiDataResponse;
			return soap_in__ns1__getLatestMultiDataResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getLatestMultiData"))
		{	*type = SOAP_TYPE__ns1__getLatestMultiData;
			return soap_in__ns1__getLatestMultiData(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getContainerInfoResponse"))
		{	*type = SOAP_TYPE__ns1__getContainerInfoResponse;
			return soap_in__ns1__getContainerInfoResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getContainerInfo"))
		{	*type = SOAP_TYPE__ns1__getContainerInfo;
			return soap_in__ns1__getContainerInfo(soap, NULL, NULL, NULL);
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{	(void)tag;
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_LONG64:
		return soap_out_LONG64(soap, tag, id, (const LONG64 *)ptr, "xsd:long");
	case SOAP_TYPE_bool:
		return soap_out_bool(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_ns2__GSNWebService_USCOREDetailsType:
		return soap_out_ns2__GSNWebService_USCOREDetailsType(soap, tag, id, (const enum ns2__GSNWebService_USCOREDetailsType *)ptr, "ns2:GSNWebService_DetailsType");
	case SOAP_TYPE_std__string:
		return soap_out_std__string(soap, tag, id, (const std::string *)ptr, "xsd:string");
	case SOAP_TYPE__ns1__unregisterQueryResponse:
		return ((_ns1__unregisterQueryResponse *)ptr)->soap_out(soap, "ns1:unregisterQueryResponse", id, NULL);
	case SOAP_TYPE__ns1__unregisterQuery:
		return ((_ns1__unregisterQuery *)ptr)->soap_out(soap, "ns1:unregisterQuery", id, NULL);
	case SOAP_TYPE__ns1__registerQueryResponse:
		return ((_ns1__registerQueryResponse *)ptr)->soap_out(soap, "ns1:registerQueryResponse", id, NULL);
	case SOAP_TYPE__ns1__registerQuery:
		return ((_ns1__registerQuery *)ptr)->soap_out(soap, "ns1:registerQuery", id, NULL);
	case SOAP_TYPE__ns1__deleteVirtualSensorResponse:
		return ((_ns1__deleteVirtualSensorResponse *)ptr)->soap_out(soap, "ns1:deleteVirtualSensorResponse", id, NULL);
	case SOAP_TYPE__ns1__deleteVirtualSensor:
		return ((_ns1__deleteVirtualSensor *)ptr)->soap_out(soap, "ns1:deleteVirtualSensor", id, NULL);
	case SOAP_TYPE__ns1__createVirtualSensorResponse:
		return ((_ns1__createVirtualSensorResponse *)ptr)->soap_out(soap, "ns1:createVirtualSensorResponse", id, NULL);
	case SOAP_TYPE__ns1__createVirtualSensor:
		return ((_ns1__createVirtualSensor *)ptr)->soap_out(soap, "ns1:createVirtualSensor", id, NULL);
	case SOAP_TYPE__ns1__listWrapperURLsResponse:
		return ((_ns1__listWrapperURLsResponse *)ptr)->soap_out(soap, "ns1:listWrapperURLsResponse", id, NULL);
	case SOAP_TYPE__ns1__listWrapperURLs:
		return ((_ns1__listWrapperURLs *)ptr)->soap_out(soap, "ns1:listWrapperURLs", id, NULL);
	case SOAP_TYPE__ns1__listVirtualSensorNamesResponse:
		return ((_ns1__listVirtualSensorNamesResponse *)ptr)->soap_out(soap, "ns1:listVirtualSensorNamesResponse", id, NULL);
	case SOAP_TYPE__ns1__listVirtualSensorNames:
		return ((_ns1__listVirtualSensorNames *)ptr)->soap_out(soap, "ns1:listVirtualSensorNames", id, NULL);
	case SOAP_TYPE__ns1__getVirtualSensorsDetailsResponse:
		return ((_ns1__getVirtualSensorsDetailsResponse *)ptr)->soap_out(soap, "ns1:getVirtualSensorsDetailsResponse", id, NULL);
	case SOAP_TYPE__ns1__getVirtualSensorsDetails:
		return ((_ns1__getVirtualSensorsDetails *)ptr)->soap_out(soap, "ns1:getVirtualSensorsDetails", id, NULL);
	case SOAP_TYPE__ns1__getNextDataResponse:
		return ((_ns1__getNextDataResponse *)ptr)->soap_out(soap, "ns1:getNextDataResponse", id, NULL);
	case SOAP_TYPE__ns1__getNextData:
		return ((_ns1__getNextData *)ptr)->soap_out(soap, "ns1:getNextData", id, NULL);
	case SOAP_TYPE__ns1__getMultiDataResponse:
		return ((_ns1__getMultiDataResponse *)ptr)->soap_out(soap, "ns1:getMultiDataResponse", id, NULL);
	case SOAP_TYPE__ns1__getMultiData:
		return ((_ns1__getMultiData *)ptr)->soap_out(soap, "ns1:getMultiData", id, NULL);
	case SOAP_TYPE__ns1__getLatestMultiDataResponse:
		return ((_ns1__getLatestMultiDataResponse *)ptr)->soap_out(soap, "ns1:getLatestMultiDataResponse", id, NULL);
	case SOAP_TYPE__ns1__getLatestMultiData:
		return ((_ns1__getLatestMultiData *)ptr)->soap_out(soap, "ns1:getLatestMultiData", id, NULL);
	case SOAP_TYPE__ns1__getContainerInfoResponse:
		return ((_ns1__getContainerInfoResponse *)ptr)->soap_out(soap, "ns1:getContainerInfoResponse", id, NULL);
	case SOAP_TYPE__ns1__getContainerInfo:
		return ((_ns1__getContainerInfo *)ptr)->soap_out(soap, "ns1:getContainerInfo", id, NULL);
	case SOAP_TYPE_ns3__AggregationCriterion:
		return ((ns3__AggregationCriterion *)ptr)->soap_out(soap, tag, id, "ns3:AggregationCriterion");
	case SOAP_TYPE_ns3__StandardCriterion:
		return ((ns3__StandardCriterion *)ptr)->soap_out(soap, tag, id, "ns3:StandardCriterion");
	case SOAP_TYPE_ns3__AbstractCriterion:
		return ((ns3__AbstractCriterion *)ptr)->soap_out(soap, tag, id, "ns3:AbstractCriterion");
	case SOAP_TYPE_ns2__GSNWebService_USCOREWrapperURL:
		return ((ns2__GSNWebService_USCOREWrapperURL *)ptr)->soap_out(soap, tag, id, "ns2:GSNWebService_WrapperURL");
	case SOAP_TYPE_ns2__GSNWebService_USCOREWrapperDetails:
		return ((ns2__GSNWebService_USCOREWrapperDetails *)ptr)->soap_out(soap, tag, id, "ns2:GSNWebService_WrapperDetails");
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfWrapper:
		return ((ns2__GSNWebService_USCOREConfWrapper *)ptr)->soap_out(soap, tag, id, "ns2:GSNWebService_ConfWrapper");
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfProcessor:
		return ((ns2__GSNWebService_USCOREConfProcessor *)ptr)->soap_out(soap, tag, id, "ns2:GSNWebService_ConfProcessor");
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfOutputStructure:
		return ((ns2__GSNWebService_USCOREConfOutputStructure *)ptr)->soap_out(soap, tag, id, "ns2:GSNWebService_ConfOutputStructure");
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfInfo:
		return ((ns2__GSNWebService_USCOREConfInfo *)ptr)->soap_out(soap, tag, id, "ns2:GSNWebService_ConfInfo");
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfPredicate:
		return ((ns2__GSNWebService_USCOREConfPredicate *)ptr)->soap_out(soap, tag, id, "ns2:GSNWebService_ConfPredicate");
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfAddressing:
		return ((ns2__GSNWebService_USCOREConfAddressing *)ptr)->soap_out(soap, tag, id, "ns2:GSNWebService_ConfAddressing");
	case SOAP_TYPE_ns2__GSNWebService_USCOREVirtualSensorDetails:
		return ((ns2__GSNWebService_USCOREVirtualSensorDetails *)ptr)->soap_out(soap, tag, id, "ns2:GSNWebService_VirtualSensorDetails");
	case SOAP_TYPE_ns2__GSNWebService_USCOREDataField:
		return ((ns2__GSNWebService_USCOREDataField *)ptr)->soap_out(soap, tag, id, "ns2:GSNWebService_DataField");
	case SOAP_TYPE_ns2__GSNWebService_USCOREStreamElement:
		return ((ns2__GSNWebService_USCOREStreamElement *)ptr)->soap_out(soap, tag, id, "ns2:GSNWebService_StreamElement");
	case SOAP_TYPE_ns2__GSNWebService_USCOREQueryResult:
		return ((ns2__GSNWebService_USCOREQueryResult *)ptr)->soap_out(soap, tag, id, "ns2:GSNWebService_QueryResult");
	case SOAP_TYPE_ns2__GSNWebService_USCOREFieldSelector:
		return ((ns2__GSNWebService_USCOREFieldSelector *)ptr)->soap_out(soap, tag, id, "ns2:GSNWebService_FieldSelector");
	case SOAP_TYPE_ns2__GSNWebService_USCOREContainerDetails:
		return ((ns2__GSNWebService_USCOREContainerDetails *)ptr)->soap_out(soap, tag, id, "ns2:GSNWebService_ContainerDetails");
	case SOAP_TYPE_ns2__GSNWebService_USCOREACDetails:
		return ((ns2__GSNWebService_USCOREACDetails *)ptr)->soap_out(soap, tag, id, "ns2:GSNWebService_ACDetails");
	case SOAP_TYPE_PointerTo_ns1__listWrapperURLsResponse:
		return soap_out_PointerTo_ns1__listWrapperURLsResponse(soap, tag, id, (_ns1__listWrapperURLsResponse *const*)ptr, "ns1:listWrapperURLsResponse");
	case SOAP_TYPE_PointerTo_ns1__listWrapperURLs:
		return soap_out_PointerTo_ns1__listWrapperURLs(soap, tag, id, (_ns1__listWrapperURLs *const*)ptr, "ns1:listWrapperURLs");
	case SOAP_TYPE_PointerTo_ns1__createVirtualSensorResponse:
		return soap_out_PointerTo_ns1__createVirtualSensorResponse(soap, tag, id, (_ns1__createVirtualSensorResponse *const*)ptr, "ns1:createVirtualSensorResponse");
	case SOAP_TYPE_PointerTo_ns1__createVirtualSensor:
		return soap_out_PointerTo_ns1__createVirtualSensor(soap, tag, id, (_ns1__createVirtualSensor *const*)ptr, "ns1:createVirtualSensor");
	case SOAP_TYPE_PointerTo_ns1__getVirtualSensorsDetailsResponse:
		return soap_out_PointerTo_ns1__getVirtualSensorsDetailsResponse(soap, tag, id, (_ns1__getVirtualSensorsDetailsResponse *const*)ptr, "ns1:getVirtualSensorsDetailsResponse");
	case SOAP_TYPE_PointerTo_ns1__getVirtualSensorsDetails:
		return soap_out_PointerTo_ns1__getVirtualSensorsDetails(soap, tag, id, (_ns1__getVirtualSensorsDetails *const*)ptr, "ns1:getVirtualSensorsDetails");
	case SOAP_TYPE_PointerTo_ns1__deleteVirtualSensorResponse:
		return soap_out_PointerTo_ns1__deleteVirtualSensorResponse(soap, tag, id, (_ns1__deleteVirtualSensorResponse *const*)ptr, "ns1:deleteVirtualSensorResponse");
	case SOAP_TYPE_PointerTo_ns1__deleteVirtualSensor:
		return soap_out_PointerTo_ns1__deleteVirtualSensor(soap, tag, id, (_ns1__deleteVirtualSensor *const*)ptr, "ns1:deleteVirtualSensor");
	case SOAP_TYPE_PointerTo_ns1__getLatestMultiDataResponse:
		return soap_out_PointerTo_ns1__getLatestMultiDataResponse(soap, tag, id, (_ns1__getLatestMultiDataResponse *const*)ptr, "ns1:getLatestMultiDataResponse");
	case SOAP_TYPE_PointerTo_ns1__getLatestMultiData:
		return soap_out_PointerTo_ns1__getLatestMultiData(soap, tag, id, (_ns1__getLatestMultiData *const*)ptr, "ns1:getLatestMultiData");
	case SOAP_TYPE_PointerTo_ns1__unregisterQueryResponse:
		return soap_out_PointerTo_ns1__unregisterQueryResponse(soap, tag, id, (_ns1__unregisterQueryResponse *const*)ptr, "ns1:unregisterQueryResponse");
	case SOAP_TYPE_PointerTo_ns1__unregisterQuery:
		return soap_out_PointerTo_ns1__unregisterQuery(soap, tag, id, (_ns1__unregisterQuery *const*)ptr, "ns1:unregisterQuery");
	case SOAP_TYPE_PointerTo_ns1__registerQueryResponse:
		return soap_out_PointerTo_ns1__registerQueryResponse(soap, tag, id, (_ns1__registerQueryResponse *const*)ptr, "ns1:registerQueryResponse");
	case SOAP_TYPE_PointerTo_ns1__registerQuery:
		return soap_out_PointerTo_ns1__registerQuery(soap, tag, id, (_ns1__registerQuery *const*)ptr, "ns1:registerQuery");
	case SOAP_TYPE_PointerTo_ns1__getNextDataResponse:
		return soap_out_PointerTo_ns1__getNextDataResponse(soap, tag, id, (_ns1__getNextDataResponse *const*)ptr, "ns1:getNextDataResponse");
	case SOAP_TYPE_PointerTo_ns1__getNextData:
		return soap_out_PointerTo_ns1__getNextData(soap, tag, id, (_ns1__getNextData *const*)ptr, "ns1:getNextData");
	case SOAP_TYPE_PointerTo_ns1__listVirtualSensorNamesResponse:
		return soap_out_PointerTo_ns1__listVirtualSensorNamesResponse(soap, tag, id, (_ns1__listVirtualSensorNamesResponse *const*)ptr, "ns1:listVirtualSensorNamesResponse");
	case SOAP_TYPE_PointerTo_ns1__listVirtualSensorNames:
		return soap_out_PointerTo_ns1__listVirtualSensorNames(soap, tag, id, (_ns1__listVirtualSensorNames *const*)ptr, "ns1:listVirtualSensorNames");
	case SOAP_TYPE_PointerTo_ns1__getMultiDataResponse:
		return soap_out_PointerTo_ns1__getMultiDataResponse(soap, tag, id, (_ns1__getMultiDataResponse *const*)ptr, "ns1:getMultiDataResponse");
	case SOAP_TYPE_PointerTo_ns1__getMultiData:
		return soap_out_PointerTo_ns1__getMultiData(soap, tag, id, (_ns1__getMultiData *const*)ptr, "ns1:getMultiData");
	case SOAP_TYPE_PointerTo_ns1__getContainerInfoResponse:
		return soap_out_PointerTo_ns1__getContainerInfoResponse(soap, tag, id, (_ns1__getContainerInfoResponse *const*)ptr, "ns1:getContainerInfoResponse");
	case SOAP_TYPE_PointerTo_ns1__getContainerInfo:
		return soap_out_PointerTo_ns1__getContainerInfo(soap, tag, id, (_ns1__getContainerInfo *const*)ptr, "ns1:getContainerInfo");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREVirtualSensorDetails:
		return soap_out_PointerTons2__GSNWebService_USCOREVirtualSensorDetails(soap, tag, id, (ns2__GSNWebService_USCOREVirtualSensorDetails *const*)ptr, "ns2:GSNWebService_VirtualSensorDetails");
	case SOAP_TYPE_PointerToLONG64:
		return soap_out_PointerToLONG64(soap, tag, id, (LONG64 *const*)ptr, "xsd:long");
	case SOAP_TYPE_PointerTons3__AggregationCriterion:
		return soap_out_PointerTons3__AggregationCriterion(soap, tag, id, (ns3__AggregationCriterion *const*)ptr, "ns3:AggregationCriterion");
	case SOAP_TYPE_PointerTons3__StandardCriterion:
		return soap_out_PointerTons3__StandardCriterion(soap, tag, id, (ns3__StandardCriterion *const*)ptr, "ns3:StandardCriterion");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREQueryResult:
		return soap_out_PointerTons2__GSNWebService_USCOREQueryResult(soap, tag, id, (ns2__GSNWebService_USCOREQueryResult *const*)ptr, "ns2:GSNWebService_QueryResult");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREFieldSelector:
		return soap_out_PointerTons2__GSNWebService_USCOREFieldSelector(soap, tag, id, (ns2__GSNWebService_USCOREFieldSelector *const*)ptr, "ns2:GSNWebService_FieldSelector");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREContainerDetails:
		return soap_out_PointerTons2__GSNWebService_USCOREContainerDetails(soap, tag, id, (ns2__GSNWebService_USCOREContainerDetails *const*)ptr, "ns2:GSNWebService_ContainerDetails");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREACDetails:
		return soap_out_PointerTons2__GSNWebService_USCOREACDetails(soap, tag, id, (ns2__GSNWebService_USCOREACDetails *const*)ptr, "ns2:GSNWebService_ACDetails");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREWrapperURL:
		return soap_out_PointerTons2__GSNWebService_USCOREWrapperURL(soap, tag, id, (ns2__GSNWebService_USCOREWrapperURL *const*)ptr, "ns2:GSNWebService_WrapperURL");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREWrapperDetails:
		return soap_out_PointerTons2__GSNWebService_USCOREWrapperDetails(soap, tag, id, (ns2__GSNWebService_USCOREWrapperDetails *const*)ptr, "ns2:GSNWebService_WrapperDetails");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfPredicate:
		return soap_out_PointerTons2__GSNWebService_USCOREConfPredicate(soap, tag, id, (ns2__GSNWebService_USCOREConfPredicate *const*)ptr, "ns2:GSNWebService_ConfPredicate");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfWrapper:
		return soap_out_PointerTons2__GSNWebService_USCOREConfWrapper(soap, tag, id, (ns2__GSNWebService_USCOREConfWrapper *const*)ptr, "ns2:GSNWebService_ConfWrapper");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfProcessor:
		return soap_out_PointerTons2__GSNWebService_USCOREConfProcessor(soap, tag, id, (ns2__GSNWebService_USCOREConfProcessor *const*)ptr, "ns2:GSNWebService_ConfProcessor");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfOutputStructure:
		return soap_out_PointerTons2__GSNWebService_USCOREConfOutputStructure(soap, tag, id, (ns2__GSNWebService_USCOREConfOutputStructure *const*)ptr, "ns2:GSNWebService_ConfOutputStructure");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfInfo:
		return soap_out_PointerTons2__GSNWebService_USCOREConfInfo(soap, tag, id, (ns2__GSNWebService_USCOREConfInfo *const*)ptr, "ns2:GSNWebService_ConfInfo");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfAddressing:
		return soap_out_PointerTons2__GSNWebService_USCOREConfAddressing(soap, tag, id, (ns2__GSNWebService_USCOREConfAddressing *const*)ptr, "ns2:GSNWebService_ConfAddressing");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREDataField:
		return soap_out_PointerTons2__GSNWebService_USCOREDataField(soap, tag, id, (ns2__GSNWebService_USCOREDataField *const*)ptr, "ns2:GSNWebService_DataField");
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREStreamElement:
		return soap_out_PointerTons2__GSNWebService_USCOREStreamElement(soap, tag, id, (ns2__GSNWebService_USCOREStreamElement *const*)ptr, "ns2:GSNWebService_StreamElement");
	case SOAP_TYPE_PointerTostd__string:
		return soap_out_PointerTostd__string(soap, tag, id, (std::string *const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerToint:
		return soap_out_PointerToint(soap, tag, id, (int *const*)ptr, "xsd:int");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}

#ifdef __cplusplus
}
#endif
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_std__string:
		soap_serialize_std__string(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE__ns1__unregisterQueryResponse:
		((_ns1__unregisterQueryResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__unregisterQuery:
		((_ns1__unregisterQuery *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__registerQueryResponse:
		((_ns1__registerQueryResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__registerQuery:
		((_ns1__registerQuery *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__deleteVirtualSensorResponse:
		((_ns1__deleteVirtualSensorResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__deleteVirtualSensor:
		((_ns1__deleteVirtualSensor *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__createVirtualSensorResponse:
		((_ns1__createVirtualSensorResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__createVirtualSensor:
		((_ns1__createVirtualSensor *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__listWrapperURLsResponse:
		((_ns1__listWrapperURLsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__listWrapperURLs:
		((_ns1__listWrapperURLs *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__listVirtualSensorNamesResponse:
		((_ns1__listVirtualSensorNamesResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__listVirtualSensorNames:
		((_ns1__listVirtualSensorNames *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__getVirtualSensorsDetailsResponse:
		((_ns1__getVirtualSensorsDetailsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__getVirtualSensorsDetails:
		((_ns1__getVirtualSensorsDetails *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__getNextDataResponse:
		((_ns1__getNextDataResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__getNextData:
		((_ns1__getNextData *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__getMultiDataResponse:
		((_ns1__getMultiDataResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__getMultiData:
		((_ns1__getMultiData *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__getLatestMultiDataResponse:
		((_ns1__getLatestMultiDataResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__getLatestMultiData:
		((_ns1__getLatestMultiData *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__getContainerInfoResponse:
		((_ns1__getContainerInfoResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__getContainerInfo:
		((_ns1__getContainerInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns3__AggregationCriterion:
		((ns3__AggregationCriterion *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns3__StandardCriterion:
		((ns3__StandardCriterion *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns3__AbstractCriterion:
		((ns3__AbstractCriterion *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREWrapperURL:
		((ns2__GSNWebService_USCOREWrapperURL *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREWrapperDetails:
		((ns2__GSNWebService_USCOREWrapperDetails *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfWrapper:
		((ns2__GSNWebService_USCOREConfWrapper *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfProcessor:
		((ns2__GSNWebService_USCOREConfProcessor *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfOutputStructure:
		((ns2__GSNWebService_USCOREConfOutputStructure *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfInfo:
		((ns2__GSNWebService_USCOREConfInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfPredicate:
		((ns2__GSNWebService_USCOREConfPredicate *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfAddressing:
		((ns2__GSNWebService_USCOREConfAddressing *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREVirtualSensorDetails:
		((ns2__GSNWebService_USCOREVirtualSensorDetails *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREDataField:
		((ns2__GSNWebService_USCOREDataField *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREStreamElement:
		((ns2__GSNWebService_USCOREStreamElement *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREQueryResult:
		((ns2__GSNWebService_USCOREQueryResult *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREFieldSelector:
		((ns2__GSNWebService_USCOREFieldSelector *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREContainerDetails:
		((ns2__GSNWebService_USCOREContainerDetails *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREACDetails:
		((ns2__GSNWebService_USCOREACDetails *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE___ns5__listWrapperURLs:
		soap_serialize___ns5__listWrapperURLs(soap, (const struct __ns5__listWrapperURLs *)ptr);
		break;
	case SOAP_TYPE___ns5__createVirtualSensor:
		soap_serialize___ns5__createVirtualSensor(soap, (const struct __ns5__createVirtualSensor *)ptr);
		break;
	case SOAP_TYPE___ns5__getVirtualSensorsDetails:
		soap_serialize___ns5__getVirtualSensorsDetails(soap, (const struct __ns5__getVirtualSensorsDetails *)ptr);
		break;
	case SOAP_TYPE___ns5__deleteVirtualSensor:
		soap_serialize___ns5__deleteVirtualSensor(soap, (const struct __ns5__deleteVirtualSensor *)ptr);
		break;
	case SOAP_TYPE___ns5__getLatestMultiData:
		soap_serialize___ns5__getLatestMultiData(soap, (const struct __ns5__getLatestMultiData *)ptr);
		break;
	case SOAP_TYPE___ns5__unregisterQuery:
		soap_serialize___ns5__unregisterQuery(soap, (const struct __ns5__unregisterQuery *)ptr);
		break;
	case SOAP_TYPE___ns5__registerQuery:
		soap_serialize___ns5__registerQuery(soap, (const struct __ns5__registerQuery *)ptr);
		break;
	case SOAP_TYPE___ns5__getNextData:
		soap_serialize___ns5__getNextData(soap, (const struct __ns5__getNextData *)ptr);
		break;
	case SOAP_TYPE___ns5__listVirtualSensorNames:
		soap_serialize___ns5__listVirtualSensorNames(soap, (const struct __ns5__listVirtualSensorNames *)ptr);
		break;
	case SOAP_TYPE___ns5__getMultiData:
		soap_serialize___ns5__getMultiData(soap, (const struct __ns5__getMultiData *)ptr);
		break;
	case SOAP_TYPE___ns5__getContainerInfo:
		soap_serialize___ns5__getContainerInfo(soap, (const struct __ns5__getContainerInfo *)ptr);
		break;
	case SOAP_TYPE___ns4__listWrapperURLs:
		soap_serialize___ns4__listWrapperURLs(soap, (const struct __ns4__listWrapperURLs *)ptr);
		break;
	case SOAP_TYPE___ns4__createVirtualSensor:
		soap_serialize___ns4__createVirtualSensor(soap, (const struct __ns4__createVirtualSensor *)ptr);
		break;
	case SOAP_TYPE___ns4__getVirtualSensorsDetails:
		soap_serialize___ns4__getVirtualSensorsDetails(soap, (const struct __ns4__getVirtualSensorsDetails *)ptr);
		break;
	case SOAP_TYPE___ns4__deleteVirtualSensor:
		soap_serialize___ns4__deleteVirtualSensor(soap, (const struct __ns4__deleteVirtualSensor *)ptr);
		break;
	case SOAP_TYPE___ns4__getLatestMultiData:
		soap_serialize___ns4__getLatestMultiData(soap, (const struct __ns4__getLatestMultiData *)ptr);
		break;
	case SOAP_TYPE___ns4__unregisterQuery:
		soap_serialize___ns4__unregisterQuery(soap, (const struct __ns4__unregisterQuery *)ptr);
		break;
	case SOAP_TYPE___ns4__registerQuery:
		soap_serialize___ns4__registerQuery(soap, (const struct __ns4__registerQuery *)ptr);
		break;
	case SOAP_TYPE___ns4__getNextData:
		soap_serialize___ns4__getNextData(soap, (const struct __ns4__getNextData *)ptr);
		break;
	case SOAP_TYPE___ns4__listVirtualSensorNames:
		soap_serialize___ns4__listVirtualSensorNames(soap, (const struct __ns4__listVirtualSensorNames *)ptr);
		break;
	case SOAP_TYPE___ns4__getMultiData:
		soap_serialize___ns4__getMultiData(soap, (const struct __ns4__getMultiData *)ptr);
		break;
	case SOAP_TYPE___ns4__getContainerInfo:
		soap_serialize___ns4__getContainerInfo(soap, (const struct __ns4__getContainerInfo *)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__listWrapperURLsResponse:
		soap_serialize_PointerTo_ns1__listWrapperURLsResponse(soap, (_ns1__listWrapperURLsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__listWrapperURLs:
		soap_serialize_PointerTo_ns1__listWrapperURLs(soap, (_ns1__listWrapperURLs *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__createVirtualSensorResponse:
		soap_serialize_PointerTo_ns1__createVirtualSensorResponse(soap, (_ns1__createVirtualSensorResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__createVirtualSensor:
		soap_serialize_PointerTo_ns1__createVirtualSensor(soap, (_ns1__createVirtualSensor *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getVirtualSensorsDetailsResponse:
		soap_serialize_PointerTo_ns1__getVirtualSensorsDetailsResponse(soap, (_ns1__getVirtualSensorsDetailsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getVirtualSensorsDetails:
		soap_serialize_PointerTo_ns1__getVirtualSensorsDetails(soap, (_ns1__getVirtualSensorsDetails *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__deleteVirtualSensorResponse:
		soap_serialize_PointerTo_ns1__deleteVirtualSensorResponse(soap, (_ns1__deleteVirtualSensorResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__deleteVirtualSensor:
		soap_serialize_PointerTo_ns1__deleteVirtualSensor(soap, (_ns1__deleteVirtualSensor *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getLatestMultiDataResponse:
		soap_serialize_PointerTo_ns1__getLatestMultiDataResponse(soap, (_ns1__getLatestMultiDataResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getLatestMultiData:
		soap_serialize_PointerTo_ns1__getLatestMultiData(soap, (_ns1__getLatestMultiData *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__unregisterQueryResponse:
		soap_serialize_PointerTo_ns1__unregisterQueryResponse(soap, (_ns1__unregisterQueryResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__unregisterQuery:
		soap_serialize_PointerTo_ns1__unregisterQuery(soap, (_ns1__unregisterQuery *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__registerQueryResponse:
		soap_serialize_PointerTo_ns1__registerQueryResponse(soap, (_ns1__registerQueryResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__registerQuery:
		soap_serialize_PointerTo_ns1__registerQuery(soap, (_ns1__registerQuery *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getNextDataResponse:
		soap_serialize_PointerTo_ns1__getNextDataResponse(soap, (_ns1__getNextDataResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getNextData:
		soap_serialize_PointerTo_ns1__getNextData(soap, (_ns1__getNextData *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__listVirtualSensorNamesResponse:
		soap_serialize_PointerTo_ns1__listVirtualSensorNamesResponse(soap, (_ns1__listVirtualSensorNamesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__listVirtualSensorNames:
		soap_serialize_PointerTo_ns1__listVirtualSensorNames(soap, (_ns1__listVirtualSensorNames *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getMultiDataResponse:
		soap_serialize_PointerTo_ns1__getMultiDataResponse(soap, (_ns1__getMultiDataResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getMultiData:
		soap_serialize_PointerTo_ns1__getMultiData(soap, (_ns1__getMultiData *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getContainerInfoResponse:
		soap_serialize_PointerTo_ns1__getContainerInfoResponse(soap, (_ns1__getContainerInfoResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getContainerInfo:
		soap_serialize_PointerTo_ns1__getContainerInfo(soap, (_ns1__getContainerInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREVirtualSensorDetails:
		soap_serialize_PointerTons2__GSNWebService_USCOREVirtualSensorDetails(soap, (ns2__GSNWebService_USCOREVirtualSensorDetails *const*)ptr);
		break;
	case SOAP_TYPE_PointerToLONG64:
		soap_serialize_PointerToLONG64(soap, (LONG64 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons3__AggregationCriterion:
		soap_serialize_PointerTons3__AggregationCriterion(soap, (ns3__AggregationCriterion *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons3__StandardCriterion:
		soap_serialize_PointerTons3__StandardCriterion(soap, (ns3__StandardCriterion *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREQueryResult:
		soap_serialize_PointerTons2__GSNWebService_USCOREQueryResult(soap, (ns2__GSNWebService_USCOREQueryResult *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREFieldSelector:
		soap_serialize_PointerTons2__GSNWebService_USCOREFieldSelector(soap, (ns2__GSNWebService_USCOREFieldSelector *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREContainerDetails:
		soap_serialize_PointerTons2__GSNWebService_USCOREContainerDetails(soap, (ns2__GSNWebService_USCOREContainerDetails *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREACDetails:
		soap_serialize_PointerTons2__GSNWebService_USCOREACDetails(soap, (ns2__GSNWebService_USCOREACDetails *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREWrapperURL:
		soap_serialize_PointerTons2__GSNWebService_USCOREWrapperURL(soap, (ns2__GSNWebService_USCOREWrapperURL *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREWrapperDetails:
		soap_serialize_PointerTons2__GSNWebService_USCOREWrapperDetails(soap, (ns2__GSNWebService_USCOREWrapperDetails *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfPredicate:
		soap_serialize_PointerTons2__GSNWebService_USCOREConfPredicate(soap, (ns2__GSNWebService_USCOREConfPredicate *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfWrapper:
		soap_serialize_PointerTons2__GSNWebService_USCOREConfWrapper(soap, (ns2__GSNWebService_USCOREConfWrapper *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfProcessor:
		soap_serialize_PointerTons2__GSNWebService_USCOREConfProcessor(soap, (ns2__GSNWebService_USCOREConfProcessor *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfOutputStructure:
		soap_serialize_PointerTons2__GSNWebService_USCOREConfOutputStructure(soap, (ns2__GSNWebService_USCOREConfOutputStructure *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfInfo:
		soap_serialize_PointerTons2__GSNWebService_USCOREConfInfo(soap, (ns2__GSNWebService_USCOREConfInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfAddressing:
		soap_serialize_PointerTons2__GSNWebService_USCOREConfAddressing(soap, (ns2__GSNWebService_USCOREConfAddressing *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREDataField:
		soap_serialize_PointerTons2__GSNWebService_USCOREDataField(soap, (ns2__GSNWebService_USCOREDataField *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__GSNWebService_USCOREStreamElement:
		soap_serialize_PointerTons2__GSNWebService_USCOREStreamElement(soap, (ns2__GSNWebService_USCOREStreamElement *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostd__string:
		soap_serialize_PointerTostd__string(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerToint:
		soap_serialize_PointerToint(soap, (int *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{	(void)type;
	switch (t)
	{
	case SOAP_TYPE_std__string:
		return (void*)soap_instantiate_std__string(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__GSNWebService_USCOREACDetails:
		return (void*)soap_instantiate_ns2__GSNWebService_USCOREACDetails(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__GSNWebService_USCOREContainerDetails:
		return (void*)soap_instantiate_ns2__GSNWebService_USCOREContainerDetails(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__GSNWebService_USCOREFieldSelector:
		return (void*)soap_instantiate_ns2__GSNWebService_USCOREFieldSelector(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__GSNWebService_USCOREQueryResult:
		return (void*)soap_instantiate_ns2__GSNWebService_USCOREQueryResult(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__GSNWebService_USCOREStreamElement:
		return (void*)soap_instantiate_ns2__GSNWebService_USCOREStreamElement(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__GSNWebService_USCOREVirtualSensorDetails:
		return (void*)soap_instantiate_ns2__GSNWebService_USCOREVirtualSensorDetails(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfAddressing:
		return (void*)soap_instantiate_ns2__GSNWebService_USCOREConfAddressing(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfInfo:
		return (void*)soap_instantiate_ns2__GSNWebService_USCOREConfInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfOutputStructure:
		return (void*)soap_instantiate_ns2__GSNWebService_USCOREConfOutputStructure(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfProcessor:
		return (void*)soap_instantiate_ns2__GSNWebService_USCOREConfProcessor(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfWrapper:
		return (void*)soap_instantiate_ns2__GSNWebService_USCOREConfWrapper(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__GSNWebService_USCOREWrapperDetails:
		return (void*)soap_instantiate_ns2__GSNWebService_USCOREWrapperDetails(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__GSNWebService_USCOREWrapperURL:
		return (void*)soap_instantiate_ns2__GSNWebService_USCOREWrapperURL(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns3__AbstractCriterion:
		return (void*)soap_instantiate_ns3__AbstractCriterion(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__getContainerInfo:
		return (void*)soap_instantiate__ns1__getContainerInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__getContainerInfoResponse:
		return (void*)soap_instantiate__ns1__getContainerInfoResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__getLatestMultiData:
		return (void*)soap_instantiate__ns1__getLatestMultiData(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__getLatestMultiDataResponse:
		return (void*)soap_instantiate__ns1__getLatestMultiDataResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__getMultiData:
		return (void*)soap_instantiate__ns1__getMultiData(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__getMultiDataResponse:
		return (void*)soap_instantiate__ns1__getMultiDataResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__getNextData:
		return (void*)soap_instantiate__ns1__getNextData(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__getNextDataResponse:
		return (void*)soap_instantiate__ns1__getNextDataResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__getVirtualSensorsDetails:
		return (void*)soap_instantiate__ns1__getVirtualSensorsDetails(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__getVirtualSensorsDetailsResponse:
		return (void*)soap_instantiate__ns1__getVirtualSensorsDetailsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__listVirtualSensorNames:
		return (void*)soap_instantiate__ns1__listVirtualSensorNames(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__listVirtualSensorNamesResponse:
		return (void*)soap_instantiate__ns1__listVirtualSensorNamesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__listWrapperURLs:
		return (void*)soap_instantiate__ns1__listWrapperURLs(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__listWrapperURLsResponse:
		return (void*)soap_instantiate__ns1__listWrapperURLsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__createVirtualSensor:
		return (void*)soap_instantiate__ns1__createVirtualSensor(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__createVirtualSensorResponse:
		return (void*)soap_instantiate__ns1__createVirtualSensorResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__deleteVirtualSensor:
		return (void*)soap_instantiate__ns1__deleteVirtualSensor(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__deleteVirtualSensorResponse:
		return (void*)soap_instantiate__ns1__deleteVirtualSensorResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__registerQuery:
		return (void*)soap_instantiate__ns1__registerQuery(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__registerQueryResponse:
		return (void*)soap_instantiate__ns1__registerQueryResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__unregisterQuery:
		return (void*)soap_instantiate__ns1__unregisterQuery(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__unregisterQueryResponse:
		return (void*)soap_instantiate__ns1__unregisterQueryResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__GSNWebService_USCOREDataField:
		return (void*)soap_instantiate_ns2__GSNWebService_USCOREDataField(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfPredicate:
		return (void*)soap_instantiate_ns2__GSNWebService_USCOREConfPredicate(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns3__StandardCriterion:
		return (void*)soap_instantiate_ns3__StandardCriterion(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns3__AggregationCriterion:
		return (void*)soap_instantiate_ns3__AggregationCriterion(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns4__getContainerInfo:
		return (void*)soap_instantiate___ns4__getContainerInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns4__getMultiData:
		return (void*)soap_instantiate___ns4__getMultiData(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns4__listVirtualSensorNames:
		return (void*)soap_instantiate___ns4__listVirtualSensorNames(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns4__getNextData:
		return (void*)soap_instantiate___ns4__getNextData(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns4__registerQuery:
		return (void*)soap_instantiate___ns4__registerQuery(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns4__unregisterQuery:
		return (void*)soap_instantiate___ns4__unregisterQuery(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns4__getLatestMultiData:
		return (void*)soap_instantiate___ns4__getLatestMultiData(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns4__deleteVirtualSensor:
		return (void*)soap_instantiate___ns4__deleteVirtualSensor(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns4__getVirtualSensorsDetails:
		return (void*)soap_instantiate___ns4__getVirtualSensorsDetails(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns4__createVirtualSensor:
		return (void*)soap_instantiate___ns4__createVirtualSensor(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns4__listWrapperURLs:
		return (void*)soap_instantiate___ns4__listWrapperURLs(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns5__getContainerInfo:
		return (void*)soap_instantiate___ns5__getContainerInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns5__getMultiData:
		return (void*)soap_instantiate___ns5__getMultiData(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns5__listVirtualSensorNames:
		return (void*)soap_instantiate___ns5__listVirtualSensorNames(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns5__getNextData:
		return (void*)soap_instantiate___ns5__getNextData(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns5__registerQuery:
		return (void*)soap_instantiate___ns5__registerQuery(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns5__unregisterQuery:
		return (void*)soap_instantiate___ns5__unregisterQuery(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns5__getLatestMultiData:
		return (void*)soap_instantiate___ns5__getLatestMultiData(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns5__deleteVirtualSensor:
		return (void*)soap_instantiate___ns5__deleteVirtualSensor(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns5__getVirtualSensorsDetails:
		return (void*)soap_instantiate___ns5__getVirtualSensorsDetails(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns5__createVirtualSensor:
		return (void*)soap_instantiate___ns5__createVirtualSensor(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns5__listWrapperURLs:
		return (void*)soap_instantiate___ns5__listWrapperURLs(soap, -1, type, arrayType, n);
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		return (void*)soap_instantiate_SOAP_ENV__Header(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		return (void*)soap_instantiate_SOAP_ENV__Code(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		return (void*)soap_instantiate_SOAP_ENV__Detail(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		return (void*)soap_instantiate_SOAP_ENV__Reason(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		return (void*)soap_instantiate_SOAP_ENV__Fault(soap, -1, type, arrayType, n);
#endif
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType:
		return (void*)soap_instantiate_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTons3__StandardCriterion:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTons3__StandardCriterion(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfstd__string:
		return (void*)soap_instantiate_std__vectorTemplateOfstd__string(soap, -1, type, arrayType, n);
	}
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE_std__string:
		if (p->size < 0)
			SOAP_DELETE((std::string*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::string*)p->ptr);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREACDetails:
		if (p->size < 0)
			SOAP_DELETE((ns2__GSNWebService_USCOREACDetails*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns2__GSNWebService_USCOREACDetails*)p->ptr);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREContainerDetails:
		if (p->size < 0)
			SOAP_DELETE((ns2__GSNWebService_USCOREContainerDetails*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns2__GSNWebService_USCOREContainerDetails*)p->ptr);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREFieldSelector:
		if (p->size < 0)
			SOAP_DELETE((ns2__GSNWebService_USCOREFieldSelector*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns2__GSNWebService_USCOREFieldSelector*)p->ptr);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREQueryResult:
		if (p->size < 0)
			SOAP_DELETE((ns2__GSNWebService_USCOREQueryResult*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns2__GSNWebService_USCOREQueryResult*)p->ptr);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREStreamElement:
		if (p->size < 0)
			SOAP_DELETE((ns2__GSNWebService_USCOREStreamElement*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns2__GSNWebService_USCOREStreamElement*)p->ptr);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREVirtualSensorDetails:
		if (p->size < 0)
			SOAP_DELETE((ns2__GSNWebService_USCOREVirtualSensorDetails*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns2__GSNWebService_USCOREVirtualSensorDetails*)p->ptr);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfAddressing:
		if (p->size < 0)
			SOAP_DELETE((ns2__GSNWebService_USCOREConfAddressing*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns2__GSNWebService_USCOREConfAddressing*)p->ptr);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfInfo:
		if (p->size < 0)
			SOAP_DELETE((ns2__GSNWebService_USCOREConfInfo*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns2__GSNWebService_USCOREConfInfo*)p->ptr);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfOutputStructure:
		if (p->size < 0)
			SOAP_DELETE((ns2__GSNWebService_USCOREConfOutputStructure*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns2__GSNWebService_USCOREConfOutputStructure*)p->ptr);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfProcessor:
		if (p->size < 0)
			SOAP_DELETE((ns2__GSNWebService_USCOREConfProcessor*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns2__GSNWebService_USCOREConfProcessor*)p->ptr);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfWrapper:
		if (p->size < 0)
			SOAP_DELETE((ns2__GSNWebService_USCOREConfWrapper*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns2__GSNWebService_USCOREConfWrapper*)p->ptr);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREWrapperDetails:
		if (p->size < 0)
			SOAP_DELETE((ns2__GSNWebService_USCOREWrapperDetails*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns2__GSNWebService_USCOREWrapperDetails*)p->ptr);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREWrapperURL:
		if (p->size < 0)
			SOAP_DELETE((ns2__GSNWebService_USCOREWrapperURL*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns2__GSNWebService_USCOREWrapperURL*)p->ptr);
		break;
	case SOAP_TYPE_ns3__AbstractCriterion:
		if (p->size < 0)
			SOAP_DELETE((ns3__AbstractCriterion*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns3__AbstractCriterion*)p->ptr);
		break;
	case SOAP_TYPE__ns1__getContainerInfo:
		if (p->size < 0)
			SOAP_DELETE((_ns1__getContainerInfo*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__getContainerInfo*)p->ptr);
		break;
	case SOAP_TYPE__ns1__getContainerInfoResponse:
		if (p->size < 0)
			SOAP_DELETE((_ns1__getContainerInfoResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__getContainerInfoResponse*)p->ptr);
		break;
	case SOAP_TYPE__ns1__getLatestMultiData:
		if (p->size < 0)
			SOAP_DELETE((_ns1__getLatestMultiData*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__getLatestMultiData*)p->ptr);
		break;
	case SOAP_TYPE__ns1__getLatestMultiDataResponse:
		if (p->size < 0)
			SOAP_DELETE((_ns1__getLatestMultiDataResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__getLatestMultiDataResponse*)p->ptr);
		break;
	case SOAP_TYPE__ns1__getMultiData:
		if (p->size < 0)
			SOAP_DELETE((_ns1__getMultiData*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__getMultiData*)p->ptr);
		break;
	case SOAP_TYPE__ns1__getMultiDataResponse:
		if (p->size < 0)
			SOAP_DELETE((_ns1__getMultiDataResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__getMultiDataResponse*)p->ptr);
		break;
	case SOAP_TYPE__ns1__getNextData:
		if (p->size < 0)
			SOAP_DELETE((_ns1__getNextData*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__getNextData*)p->ptr);
		break;
	case SOAP_TYPE__ns1__getNextDataResponse:
		if (p->size < 0)
			SOAP_DELETE((_ns1__getNextDataResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__getNextDataResponse*)p->ptr);
		break;
	case SOAP_TYPE__ns1__getVirtualSensorsDetails:
		if (p->size < 0)
			SOAP_DELETE((_ns1__getVirtualSensorsDetails*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__getVirtualSensorsDetails*)p->ptr);
		break;
	case SOAP_TYPE__ns1__getVirtualSensorsDetailsResponse:
		if (p->size < 0)
			SOAP_DELETE((_ns1__getVirtualSensorsDetailsResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__getVirtualSensorsDetailsResponse*)p->ptr);
		break;
	case SOAP_TYPE__ns1__listVirtualSensorNames:
		if (p->size < 0)
			SOAP_DELETE((_ns1__listVirtualSensorNames*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__listVirtualSensorNames*)p->ptr);
		break;
	case SOAP_TYPE__ns1__listVirtualSensorNamesResponse:
		if (p->size < 0)
			SOAP_DELETE((_ns1__listVirtualSensorNamesResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__listVirtualSensorNamesResponse*)p->ptr);
		break;
	case SOAP_TYPE__ns1__listWrapperURLs:
		if (p->size < 0)
			SOAP_DELETE((_ns1__listWrapperURLs*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__listWrapperURLs*)p->ptr);
		break;
	case SOAP_TYPE__ns1__listWrapperURLsResponse:
		if (p->size < 0)
			SOAP_DELETE((_ns1__listWrapperURLsResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__listWrapperURLsResponse*)p->ptr);
		break;
	case SOAP_TYPE__ns1__createVirtualSensor:
		if (p->size < 0)
			SOAP_DELETE((_ns1__createVirtualSensor*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__createVirtualSensor*)p->ptr);
		break;
	case SOAP_TYPE__ns1__createVirtualSensorResponse:
		if (p->size < 0)
			SOAP_DELETE((_ns1__createVirtualSensorResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__createVirtualSensorResponse*)p->ptr);
		break;
	case SOAP_TYPE__ns1__deleteVirtualSensor:
		if (p->size < 0)
			SOAP_DELETE((_ns1__deleteVirtualSensor*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__deleteVirtualSensor*)p->ptr);
		break;
	case SOAP_TYPE__ns1__deleteVirtualSensorResponse:
		if (p->size < 0)
			SOAP_DELETE((_ns1__deleteVirtualSensorResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__deleteVirtualSensorResponse*)p->ptr);
		break;
	case SOAP_TYPE__ns1__registerQuery:
		if (p->size < 0)
			SOAP_DELETE((_ns1__registerQuery*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__registerQuery*)p->ptr);
		break;
	case SOAP_TYPE__ns1__registerQueryResponse:
		if (p->size < 0)
			SOAP_DELETE((_ns1__registerQueryResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__registerQueryResponse*)p->ptr);
		break;
	case SOAP_TYPE__ns1__unregisterQuery:
		if (p->size < 0)
			SOAP_DELETE((_ns1__unregisterQuery*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__unregisterQuery*)p->ptr);
		break;
	case SOAP_TYPE__ns1__unregisterQueryResponse:
		if (p->size < 0)
			SOAP_DELETE((_ns1__unregisterQueryResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__unregisterQueryResponse*)p->ptr);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREDataField:
		if (p->size < 0)
			SOAP_DELETE((ns2__GSNWebService_USCOREDataField*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns2__GSNWebService_USCOREDataField*)p->ptr);
		break;
	case SOAP_TYPE_ns2__GSNWebService_USCOREConfPredicate:
		if (p->size < 0)
			SOAP_DELETE((ns2__GSNWebService_USCOREConfPredicate*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns2__GSNWebService_USCOREConfPredicate*)p->ptr);
		break;
	case SOAP_TYPE_ns3__StandardCriterion:
		if (p->size < 0)
			SOAP_DELETE((ns3__StandardCriterion*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns3__StandardCriterion*)p->ptr);
		break;
	case SOAP_TYPE_ns3__AggregationCriterion:
		if (p->size < 0)
			SOAP_DELETE((ns3__AggregationCriterion*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns3__AggregationCriterion*)p->ptr);
		break;
	case SOAP_TYPE___ns4__getContainerInfo:
		if (p->size < 0)
			SOAP_DELETE((struct __ns4__getContainerInfo*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns4__getContainerInfo*)p->ptr);
		break;
	case SOAP_TYPE___ns4__getMultiData:
		if (p->size < 0)
			SOAP_DELETE((struct __ns4__getMultiData*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns4__getMultiData*)p->ptr);
		break;
	case SOAP_TYPE___ns4__listVirtualSensorNames:
		if (p->size < 0)
			SOAP_DELETE((struct __ns4__listVirtualSensorNames*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns4__listVirtualSensorNames*)p->ptr);
		break;
	case SOAP_TYPE___ns4__getNextData:
		if (p->size < 0)
			SOAP_DELETE((struct __ns4__getNextData*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns4__getNextData*)p->ptr);
		break;
	case SOAP_TYPE___ns4__registerQuery:
		if (p->size < 0)
			SOAP_DELETE((struct __ns4__registerQuery*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns4__registerQuery*)p->ptr);
		break;
	case SOAP_TYPE___ns4__unregisterQuery:
		if (p->size < 0)
			SOAP_DELETE((struct __ns4__unregisterQuery*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns4__unregisterQuery*)p->ptr);
		break;
	case SOAP_TYPE___ns4__getLatestMultiData:
		if (p->size < 0)
			SOAP_DELETE((struct __ns4__getLatestMultiData*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns4__getLatestMultiData*)p->ptr);
		break;
	case SOAP_TYPE___ns4__deleteVirtualSensor:
		if (p->size < 0)
			SOAP_DELETE((struct __ns4__deleteVirtualSensor*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns4__deleteVirtualSensor*)p->ptr);
		break;
	case SOAP_TYPE___ns4__getVirtualSensorsDetails:
		if (p->size < 0)
			SOAP_DELETE((struct __ns4__getVirtualSensorsDetails*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns4__getVirtualSensorsDetails*)p->ptr);
		break;
	case SOAP_TYPE___ns4__createVirtualSensor:
		if (p->size < 0)
			SOAP_DELETE((struct __ns4__createVirtualSensor*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns4__createVirtualSensor*)p->ptr);
		break;
	case SOAP_TYPE___ns4__listWrapperURLs:
		if (p->size < 0)
			SOAP_DELETE((struct __ns4__listWrapperURLs*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns4__listWrapperURLs*)p->ptr);
		break;
	case SOAP_TYPE___ns5__getContainerInfo:
		if (p->size < 0)
			SOAP_DELETE((struct __ns5__getContainerInfo*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns5__getContainerInfo*)p->ptr);
		break;
	case SOAP_TYPE___ns5__getMultiData:
		if (p->size < 0)
			SOAP_DELETE((struct __ns5__getMultiData*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns5__getMultiData*)p->ptr);
		break;
	case SOAP_TYPE___ns5__listVirtualSensorNames:
		if (p->size < 0)
			SOAP_DELETE((struct __ns5__listVirtualSensorNames*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns5__listVirtualSensorNames*)p->ptr);
		break;
	case SOAP_TYPE___ns5__getNextData:
		if (p->size < 0)
			SOAP_DELETE((struct __ns5__getNextData*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns5__getNextData*)p->ptr);
		break;
	case SOAP_TYPE___ns5__registerQuery:
		if (p->size < 0)
			SOAP_DELETE((struct __ns5__registerQuery*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns5__registerQuery*)p->ptr);
		break;
	case SOAP_TYPE___ns5__unregisterQuery:
		if (p->size < 0)
			SOAP_DELETE((struct __ns5__unregisterQuery*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns5__unregisterQuery*)p->ptr);
		break;
	case SOAP_TYPE___ns5__getLatestMultiData:
		if (p->size < 0)
			SOAP_DELETE((struct __ns5__getLatestMultiData*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns5__getLatestMultiData*)p->ptr);
		break;
	case SOAP_TYPE___ns5__deleteVirtualSensor:
		if (p->size < 0)
			SOAP_DELETE((struct __ns5__deleteVirtualSensor*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns5__deleteVirtualSensor*)p->ptr);
		break;
	case SOAP_TYPE___ns5__getVirtualSensorsDetails:
		if (p->size < 0)
			SOAP_DELETE((struct __ns5__getVirtualSensorsDetails*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns5__getVirtualSensorsDetails*)p->ptr);
		break;
	case SOAP_TYPE___ns5__createVirtualSensor:
		if (p->size < 0)
			SOAP_DELETE((struct __ns5__createVirtualSensor*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns5__createVirtualSensor*)p->ptr);
		break;
	case SOAP_TYPE___ns5__listWrapperURLs:
		if (p->size < 0)
			SOAP_DELETE((struct __ns5__listWrapperURLs*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns5__listWrapperURLs*)p->ptr);
		break;
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Header*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Header*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Code*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Code*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Detail*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Detail*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Reason*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Reason*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Fault*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Fault*)p->ptr);
		break;
#endif
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL:
		if (p->size < 0)
			SOAP_DELETE((std::vector<ns2__GSNWebService_USCOREWrapperURL * >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<ns2__GSNWebService_USCOREWrapperURL * >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails:
		if (p->size < 0)
			SOAP_DELETE((std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType:
		if (p->size < 0)
			SOAP_DELETE((std::vector<enum ns2__GSNWebService_USCOREDetailsType >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<enum ns2__GSNWebService_USCOREDetailsType >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTons3__StandardCriterion:
		if (p->size < 0)
			SOAP_DELETE((std::vector<ns3__StandardCriterion * >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<ns3__StandardCriterion * >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult:
		if (p->size < 0)
			SOAP_DELETE((std::vector<ns2__GSNWebService_USCOREQueryResult * >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<ns2__GSNWebService_USCOREQueryResult * >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector:
		if (p->size < 0)
			SOAP_DELETE((std::vector<ns2__GSNWebService_USCOREFieldSelector * >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<ns2__GSNWebService_USCOREFieldSelector * >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails:
		if (p->size < 0)
			SOAP_DELETE((std::vector<ns2__GSNWebService_USCOREWrapperDetails * >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<ns2__GSNWebService_USCOREWrapperDetails * >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate:
		if (p->size < 0)
			SOAP_DELETE((std::vector<ns2__GSNWebService_USCOREConfPredicate * >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<ns2__GSNWebService_USCOREConfPredicate * >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField:
		if (p->size < 0)
			SOAP_DELETE((std::vector<ns2__GSNWebService_USCOREDataField * >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<ns2__GSNWebService_USCOREDataField * >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement:
		if (p->size < 0)
			SOAP_DELETE((std::vector<ns2__GSNWebService_USCOREStreamElement * >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<ns2__GSNWebService_USCOREStreamElement * >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfstd__string:
		if (p->size < 0)
			SOAP_DELETE((std::vector<std::string >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<std::string >*)p->ptr);
		break;
	default:	return SOAP_ERR;
	}
	return SOAP_OK;
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_container_id_forward(struct soap *soap, const char *href, void *p, size_t len, int st, int tt, size_t n, unsigned int k)
{	return soap_id_forward(soap, href, p, len, st, tt, n, k, soap_container_insert);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_container_insert(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
#ifdef WIN32
#pragma warning(push)
#pragma warning(disable:4065)
#endif
{
	(void)soap; (void)st; (void)p; (void)len; (void)q; (void)n; /* appease -Wall -Werror */
	switch (tt)
	{
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container soap_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<ns2__GSNWebService_USCOREWrapperURL * >*)p)[len] = *(ns2__GSNWebService_USCOREWrapperURL **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container soap_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >*)p)[len] = *(ns2__GSNWebService_USCOREVirtualSensorDetails **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container soap_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<enum ns2__GSNWebService_USCOREDetailsType >*)p)[len] = *(enum ns2__GSNWebService_USCOREDetailsType *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTons3__StandardCriterion:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container soap_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<ns3__StandardCriterion * >*)p)[len] = *(ns3__StandardCriterion **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container soap_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<ns2__GSNWebService_USCOREQueryResult * >*)p)[len] = *(ns2__GSNWebService_USCOREQueryResult **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container soap_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<ns2__GSNWebService_USCOREFieldSelector * >*)p)[len] = *(ns2__GSNWebService_USCOREFieldSelector **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container soap_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<ns2__GSNWebService_USCOREWrapperDetails * >*)p)[len] = *(ns2__GSNWebService_USCOREWrapperDetails **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container soap_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<ns2__GSNWebService_USCOREConfPredicate * >*)p)[len] = *(ns2__GSNWebService_USCOREConfPredicate **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container soap_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<ns2__GSNWebService_USCOREDataField * >*)p)[len] = *(ns2__GSNWebService_USCOREDataField **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container soap_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<ns2__GSNWebService_USCOREStreamElement * >*)p)[len] = *(ns2__GSNWebService_USCOREStreamElement **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfstd__string:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container soap_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<std::string >*)p)[len] = *(std::string *)q;
		break;
	default:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Could not insert type=%d in %d\n", st, tt));
	}
#ifdef WIN32
#pragma warning(pop)
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{	char *p;
	p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{	int *p;
	p = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_LONG64(struct soap *soap, LONG64 *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_LONG64
	*a = SOAP_DEFAULT_LONG64;
#else
	*a = (LONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_LONG64(struct soap *soap, const char *tag, int id, const LONG64 *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outLONG64(soap, tag, id, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_in_LONG64(struct soap *soap, const char *tag, LONG64 *a, const char *type)
{	LONG64 *p;
	p = soap_inLONG64(soap, tag, a, type, SOAP_TYPE_LONG64);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_LONG64(struct soap *soap, const LONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_LONG64);
	if (soap_out_LONG64(soap, tag?tag:"long", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_get_LONG64(struct soap *soap, LONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_LONG64(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_bool(struct soap *soap, bool *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_bool
	*a = SOAP_DEFAULT_bool;
#else
	*a = (bool)0;
#endif
}

static const struct soap_code_map soap_codes_bool[] =
{	{ (long)false, "false" },
	{ (long)true, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{
	(void)soap; /* appease -Wall -Werror */
return soap_code_str(soap_codes_bool, n!=0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type) || soap_send(soap, soap_bool2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_bool, s);
	if (map)
		*a = (bool)(map->code != 0);
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (bool)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2bool(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_bool, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_bool);
	if (soap_out_bool(soap, tag?tag:"boolean", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_bool(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__GSNWebService_USCOREDetailsType(struct soap *soap, enum ns2__GSNWebService_USCOREDetailsType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ns2__GSNWebService_USCOREDetailsType
	*a = SOAP_DEFAULT_ns2__GSNWebService_USCOREDetailsType;
#else
	*a = (enum ns2__GSNWebService_USCOREDetailsType)0;
#endif
}

static const struct soap_code_map soap_codes_ns2__GSNWebService_USCOREDetailsType[] =
{	{ (long)ns2__GSNWebService_USCOREDetailsType__INFO, "INFO" },
	{ (long)ns2__GSNWebService_USCOREDetailsType__PROCESSOR, "PROCESSOR" },
	{ (long)ns2__GSNWebService_USCOREDetailsType__ADDRESSING, "ADDRESSING" },
	{ (long)ns2__GSNWebService_USCOREDetailsType__OUTPUTSTRUCTURE, "OUTPUTSTRUCTURE" },
	{ (long)ns2__GSNWebService_USCOREDetailsType__WRAPPER, "WRAPPER" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ns2__GSNWebService_USCOREDetailsType2s(struct soap *soap, enum ns2__GSNWebService_USCOREDetailsType n)
{	const char *s = soap_code_str(soap_codes_ns2__GSNWebService_USCOREDetailsType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__GSNWebService_USCOREDetailsType(struct soap *soap, const char *tag, int id, const enum ns2__GSNWebService_USCOREDetailsType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__GSNWebService_USCOREDetailsType), type) || soap_send(soap, soap_ns2__GSNWebService_USCOREDetailsType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ns2__GSNWebService_USCOREDetailsType(struct soap *soap, const char *s, enum ns2__GSNWebService_USCOREDetailsType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_ns2__GSNWebService_USCOREDetailsType, s);
	if (map)
		*a = (enum ns2__GSNWebService_USCOREDetailsType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 4)))
			return soap->error = SOAP_TYPE;
		*a = (enum ns2__GSNWebService_USCOREDetailsType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ns2__GSNWebService_USCOREDetailsType * SOAP_FMAC4 soap_in_ns2__GSNWebService_USCOREDetailsType(struct soap *soap, const char *tag, enum ns2__GSNWebService_USCOREDetailsType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum ns2__GSNWebService_USCOREDetailsType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__GSNWebService_USCOREDetailsType, sizeof(enum ns2__GSNWebService_USCOREDetailsType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ns2__GSNWebService_USCOREDetailsType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ns2__GSNWebService_USCOREDetailsType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__GSNWebService_USCOREDetailsType, 0, sizeof(enum ns2__GSNWebService_USCOREDetailsType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__GSNWebService_USCOREDetailsType(struct soap *soap, const enum ns2__GSNWebService_USCOREDetailsType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__GSNWebService_USCOREDetailsType);
	if (soap_out_ns2__GSNWebService_USCOREDetailsType(soap, tag?tag:"ns2:GSNWebService_DetailsType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum ns2__GSNWebService_USCOREDetailsType * SOAP_FMAC4 soap_get_ns2__GSNWebService_USCOREDetailsType(struct soap *soap, enum ns2__GSNWebService_USCOREDetailsType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__GSNWebService_USCOREDetailsType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__string(struct soap *soap, std::string *p)
{
	(void)soap; /* appease -Wall -Werror */
	p->erase();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__string(struct soap *soap, const std::string *a)
{	(void)soap; (void)a; /* appease -Wall -Werror */
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__string(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_std__string), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_in_std__string(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
		{	if (!(t = soap_string_in(soap, 1, 0, -1)))
				return NULL;
			s->assign(t);
		}
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_std__string, 0, sizeof(std::string), 0, soap_copy_std__string);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_std__string(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_std__string);
	if (soap_out_std__string(soap, tag?tag:"string", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_std__string(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_std__string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_instantiate_std__string(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__string(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__string, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::string);
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::string[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::string);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__string(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

void _ns1__unregisterQueryResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_bool(soap, &this->_ns1__unregisterQueryResponse::status);
	/* transient soap skipped */
}

void _ns1__unregisterQueryResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int _ns1__unregisterQueryResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__unregisterQueryResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__unregisterQueryResponse(struct soap *soap, const char *tag, int id, const _ns1__unregisterQueryResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__unregisterQueryResponse), type))
		return soap->error;
	soap_element_result(soap, "ns1:status");
	if (soap_out_bool(soap, "ns1:status", -1, &(a->_ns1__unregisterQueryResponse::status), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__unregisterQueryResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__unregisterQueryResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__unregisterQueryResponse * SOAP_FMAC4 soap_in__ns1__unregisterQueryResponse(struct soap *soap, const char *tag, _ns1__unregisterQueryResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__unregisterQueryResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__unregisterQueryResponse, sizeof(_ns1__unregisterQueryResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__unregisterQueryResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__unregisterQueryResponse *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "ns1:status", &(a->_ns1__unregisterQueryResponse::status), "xsd:boolean"))
				{	soap_flag_status1--;
					continue;
				}
			/* transient soap skipped */
			soap_check_result(soap, "ns1:status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__unregisterQueryResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__unregisterQueryResponse, 0, sizeof(_ns1__unregisterQueryResponse), 0, soap_copy__ns1__unregisterQueryResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int _ns1__unregisterQueryResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__unregisterQueryResponse);
	if (this->soap_out(soap, tag?tag:"ns1:unregisterQueryResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__unregisterQueryResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__unregisterQueryResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__unregisterQueryResponse * SOAP_FMAC4 soap_get__ns1__unregisterQueryResponse(struct soap *soap, _ns1__unregisterQueryResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__unregisterQueryResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__unregisterQueryResponse * SOAP_FMAC2 soap_instantiate__ns1__unregisterQueryResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__unregisterQueryResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__unregisterQueryResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__unregisterQueryResponse);
		if (size)
			*size = sizeof(_ns1__unregisterQueryResponse);
		((_ns1__unregisterQueryResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__unregisterQueryResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__unregisterQueryResponse);
		for (int i = 0; i < n; i++)
			((_ns1__unregisterQueryResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__unregisterQueryResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__unregisterQueryResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__unregisterQueryResponse %p -> %p\n", q, p));
	*(_ns1__unregisterQueryResponse*)p = *(_ns1__unregisterQueryResponse*)q;
}

void _ns1__unregisterQuery::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__unregisterQuery::acDetails = NULL;
	soap_default_std__string(soap, &this->_ns1__unregisterQuery::queryName);
	/* transient soap skipped */
}

void _ns1__unregisterQuery::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__GSNWebService_USCOREACDetails(soap, &this->_ns1__unregisterQuery::acDetails);
	soap_embedded(soap, &this->_ns1__unregisterQuery::queryName, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &this->_ns1__unregisterQuery::queryName);
	/* transient soap skipped */
}

int _ns1__unregisterQuery::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__unregisterQuery(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__unregisterQuery(struct soap *soap, const char *tag, int id, const _ns1__unregisterQuery *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__unregisterQuery), type))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", -1, &(a->_ns1__unregisterQuery::acDetails), ""))
		return soap->error;
	if (soap_out_std__string(soap, "ns1:queryName", -1, &(a->_ns1__unregisterQuery::queryName), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__unregisterQuery::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__unregisterQuery(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__unregisterQuery * SOAP_FMAC4 soap_in__ns1__unregisterQuery(struct soap *soap, const char *tag, _ns1__unregisterQuery *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__unregisterQuery *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__unregisterQuery, sizeof(_ns1__unregisterQuery), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__unregisterQuery)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__unregisterQuery *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_acDetails1 = 1;
	size_t soap_flag_queryName1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_acDetails1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", &(a->_ns1__unregisterQuery::acDetails), "ns2:GSNWebService_ACDetails"))
				{	soap_flag_acDetails1--;
					continue;
				}
			if (soap_flag_queryName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "ns1:queryName", &(a->_ns1__unregisterQuery::queryName), "xsd:string"))
				{	soap_flag_queryName1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__unregisterQuery *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__unregisterQuery, 0, sizeof(_ns1__unregisterQuery), 0, soap_copy__ns1__unregisterQuery);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_queryName1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int _ns1__unregisterQuery::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__unregisterQuery);
	if (this->soap_out(soap, tag?tag:"ns1:unregisterQuery", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__unregisterQuery::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__unregisterQuery(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__unregisterQuery * SOAP_FMAC4 soap_get__ns1__unregisterQuery(struct soap *soap, _ns1__unregisterQuery *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__unregisterQuery(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__unregisterQuery * SOAP_FMAC2 soap_instantiate__ns1__unregisterQuery(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__unregisterQuery(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__unregisterQuery, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__unregisterQuery);
		if (size)
			*size = sizeof(_ns1__unregisterQuery);
		((_ns1__unregisterQuery*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__unregisterQuery[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__unregisterQuery);
		for (int i = 0; i < n; i++)
			((_ns1__unregisterQuery*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__unregisterQuery*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__unregisterQuery(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__unregisterQuery %p -> %p\n", q, p));
	*(_ns1__unregisterQuery*)p = *(_ns1__unregisterQuery*)q;
}

void _ns1__registerQueryResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_bool(soap, &this->_ns1__registerQueryResponse::status);
	/* transient soap skipped */
}

void _ns1__registerQueryResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int _ns1__registerQueryResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__registerQueryResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__registerQueryResponse(struct soap *soap, const char *tag, int id, const _ns1__registerQueryResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__registerQueryResponse), type))
		return soap->error;
	soap_element_result(soap, "ns1:status");
	if (soap_out_bool(soap, "ns1:status", -1, &(a->_ns1__registerQueryResponse::status), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__registerQueryResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__registerQueryResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__registerQueryResponse * SOAP_FMAC4 soap_in__ns1__registerQueryResponse(struct soap *soap, const char *tag, _ns1__registerQueryResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__registerQueryResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__registerQueryResponse, sizeof(_ns1__registerQueryResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__registerQueryResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__registerQueryResponse *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "ns1:status", &(a->_ns1__registerQueryResponse::status), "xsd:boolean"))
				{	soap_flag_status1--;
					continue;
				}
			/* transient soap skipped */
			soap_check_result(soap, "ns1:status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__registerQueryResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__registerQueryResponse, 0, sizeof(_ns1__registerQueryResponse), 0, soap_copy__ns1__registerQueryResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int _ns1__registerQueryResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__registerQueryResponse);
	if (this->soap_out(soap, tag?tag:"ns1:registerQueryResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__registerQueryResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__registerQueryResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__registerQueryResponse * SOAP_FMAC4 soap_get__ns1__registerQueryResponse(struct soap *soap, _ns1__registerQueryResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__registerQueryResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__registerQueryResponse * SOAP_FMAC2 soap_instantiate__ns1__registerQueryResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__registerQueryResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__registerQueryResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__registerQueryResponse);
		if (size)
			*size = sizeof(_ns1__registerQueryResponse);
		((_ns1__registerQueryResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__registerQueryResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__registerQueryResponse);
		for (int i = 0; i < n; i++)
			((_ns1__registerQueryResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__registerQueryResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__registerQueryResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__registerQueryResponse %p -> %p\n", q, p));
	*(_ns1__registerQueryResponse*)p = *(_ns1__registerQueryResponse*)q;
}

void _ns1__registerQuery::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__registerQuery::acDetails = NULL;
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, &this->_ns1__registerQuery::outputStructure);
	soap_default_std__vectorTemplateOfstd__string(soap, &this->_ns1__registerQuery::vsnames);
	soap_default_std__string(soap, &this->_ns1__registerQuery::queryName);
	soap_default_std__string(soap, &this->_ns1__registerQuery::query);
	/* transient soap skipped */
}

void _ns1__registerQuery::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__GSNWebService_USCOREACDetails(soap, &this->_ns1__registerQuery::acDetails);
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, &this->_ns1__registerQuery::outputStructure);
	soap_serialize_std__vectorTemplateOfstd__string(soap, &this->_ns1__registerQuery::vsnames);
	/* transient soap skipped */
}

int _ns1__registerQuery::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__registerQuery(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__registerQuery(struct soap *soap, const char *tag, int id, const _ns1__registerQuery *a, const char *type)
{
	soap_set_attr(soap, "ns1:queryName", ((_ns1__registerQuery*)a)->queryName.c_str(), 1);
	soap_set_attr(soap, "ns1:query", ((_ns1__registerQuery*)a)->query.c_str(), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__registerQuery), type))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", -1, &(a->_ns1__registerQuery::acDetails), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, "ns1:outputStructure", -1, &(a->_ns1__registerQuery::outputStructure), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfstd__string(soap, "ns1:vsnames", -1, &(a->_ns1__registerQuery::vsnames), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__registerQuery::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__registerQuery(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__registerQuery * SOAP_FMAC4 soap_in__ns1__registerQuery(struct soap *soap, const char *tag, _ns1__registerQuery *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__registerQuery *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__registerQuery, sizeof(_ns1__registerQuery), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__registerQuery)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__registerQuery *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "ns1:queryName", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((_ns1__registerQuery*)a)->queryName.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "ns1:query", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((_ns1__registerQuery*)a)->query.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	size_t soap_flag_acDetails1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_acDetails1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", &(a->_ns1__registerQuery::acDetails), "ns2:GSNWebService_ACDetails"))
				{	soap_flag_acDetails1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, "ns1:outputStructure", &(a->_ns1__registerQuery::outputStructure), "ns2:GSNWebService_DataField"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfstd__string(soap, "ns1:vsnames", &(a->_ns1__registerQuery::vsnames), "xsd:string"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__registerQuery *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__registerQuery, 0, sizeof(_ns1__registerQuery), 0, soap_copy__ns1__registerQuery);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__registerQuery::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__registerQuery);
	if (this->soap_out(soap, tag?tag:"ns1:registerQuery", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__registerQuery::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__registerQuery(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__registerQuery * SOAP_FMAC4 soap_get__ns1__registerQuery(struct soap *soap, _ns1__registerQuery *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__registerQuery(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__registerQuery * SOAP_FMAC2 soap_instantiate__ns1__registerQuery(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__registerQuery(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__registerQuery, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__registerQuery);
		if (size)
			*size = sizeof(_ns1__registerQuery);
		((_ns1__registerQuery*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__registerQuery[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__registerQuery);
		for (int i = 0; i < n; i++)
			((_ns1__registerQuery*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__registerQuery*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__registerQuery(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__registerQuery %p -> %p\n", q, p));
	*(_ns1__registerQuery*)p = *(_ns1__registerQuery*)q;
}

void _ns1__deleteVirtualSensorResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_bool(soap, &this->_ns1__deleteVirtualSensorResponse::status);
	/* transient soap skipped */
}

void _ns1__deleteVirtualSensorResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int _ns1__deleteVirtualSensorResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__deleteVirtualSensorResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__deleteVirtualSensorResponse(struct soap *soap, const char *tag, int id, const _ns1__deleteVirtualSensorResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__deleteVirtualSensorResponse), type))
		return soap->error;
	soap_element_result(soap, "ns1:status");
	if (soap_out_bool(soap, "ns1:status", -1, &(a->_ns1__deleteVirtualSensorResponse::status), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__deleteVirtualSensorResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__deleteVirtualSensorResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__deleteVirtualSensorResponse * SOAP_FMAC4 soap_in__ns1__deleteVirtualSensorResponse(struct soap *soap, const char *tag, _ns1__deleteVirtualSensorResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__deleteVirtualSensorResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__deleteVirtualSensorResponse, sizeof(_ns1__deleteVirtualSensorResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__deleteVirtualSensorResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__deleteVirtualSensorResponse *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "ns1:status", &(a->_ns1__deleteVirtualSensorResponse::status), "xsd:boolean"))
				{	soap_flag_status1--;
					continue;
				}
			/* transient soap skipped */
			soap_check_result(soap, "ns1:status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__deleteVirtualSensorResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__deleteVirtualSensorResponse, 0, sizeof(_ns1__deleteVirtualSensorResponse), 0, soap_copy__ns1__deleteVirtualSensorResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int _ns1__deleteVirtualSensorResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__deleteVirtualSensorResponse);
	if (this->soap_out(soap, tag?tag:"ns1:deleteVirtualSensorResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__deleteVirtualSensorResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__deleteVirtualSensorResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__deleteVirtualSensorResponse * SOAP_FMAC4 soap_get__ns1__deleteVirtualSensorResponse(struct soap *soap, _ns1__deleteVirtualSensorResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__deleteVirtualSensorResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__deleteVirtualSensorResponse * SOAP_FMAC2 soap_instantiate__ns1__deleteVirtualSensorResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__deleteVirtualSensorResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__deleteVirtualSensorResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__deleteVirtualSensorResponse);
		if (size)
			*size = sizeof(_ns1__deleteVirtualSensorResponse);
		((_ns1__deleteVirtualSensorResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__deleteVirtualSensorResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__deleteVirtualSensorResponse);
		for (int i = 0; i < n; i++)
			((_ns1__deleteVirtualSensorResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__deleteVirtualSensorResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__deleteVirtualSensorResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__deleteVirtualSensorResponse %p -> %p\n", q, p));
	*(_ns1__deleteVirtualSensorResponse*)p = *(_ns1__deleteVirtualSensorResponse*)q;
}

void _ns1__deleteVirtualSensor::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__deleteVirtualSensor::acDetails = NULL;
	soap_default_std__string(soap, &this->_ns1__deleteVirtualSensor::vsname);
	/* transient soap skipped */
}

void _ns1__deleteVirtualSensor::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__GSNWebService_USCOREACDetails(soap, &this->_ns1__deleteVirtualSensor::acDetails);
	/* transient soap skipped */
}

int _ns1__deleteVirtualSensor::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__deleteVirtualSensor(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__deleteVirtualSensor(struct soap *soap, const char *tag, int id, const _ns1__deleteVirtualSensor *a, const char *type)
{
	soap_set_attr(soap, "ns1:vsname", ((_ns1__deleteVirtualSensor*)a)->vsname.c_str(), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__deleteVirtualSensor), type))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", -1, &(a->_ns1__deleteVirtualSensor::acDetails), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__deleteVirtualSensor::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__deleteVirtualSensor(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__deleteVirtualSensor * SOAP_FMAC4 soap_in__ns1__deleteVirtualSensor(struct soap *soap, const char *tag, _ns1__deleteVirtualSensor *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__deleteVirtualSensor *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__deleteVirtualSensor, sizeof(_ns1__deleteVirtualSensor), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__deleteVirtualSensor)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__deleteVirtualSensor *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "ns1:vsname", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((_ns1__deleteVirtualSensor*)a)->vsname.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	size_t soap_flag_acDetails1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_acDetails1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", &(a->_ns1__deleteVirtualSensor::acDetails), "ns2:GSNWebService_ACDetails"))
				{	soap_flag_acDetails1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__deleteVirtualSensor *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__deleteVirtualSensor, 0, sizeof(_ns1__deleteVirtualSensor), 0, soap_copy__ns1__deleteVirtualSensor);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__deleteVirtualSensor::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__deleteVirtualSensor);
	if (this->soap_out(soap, tag?tag:"ns1:deleteVirtualSensor", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__deleteVirtualSensor::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__deleteVirtualSensor(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__deleteVirtualSensor * SOAP_FMAC4 soap_get__ns1__deleteVirtualSensor(struct soap *soap, _ns1__deleteVirtualSensor *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__deleteVirtualSensor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__deleteVirtualSensor * SOAP_FMAC2 soap_instantiate__ns1__deleteVirtualSensor(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__deleteVirtualSensor(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__deleteVirtualSensor, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__deleteVirtualSensor);
		if (size)
			*size = sizeof(_ns1__deleteVirtualSensor);
		((_ns1__deleteVirtualSensor*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__deleteVirtualSensor[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__deleteVirtualSensor);
		for (int i = 0; i < n; i++)
			((_ns1__deleteVirtualSensor*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__deleteVirtualSensor*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__deleteVirtualSensor(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__deleteVirtualSensor %p -> %p\n", q, p));
	*(_ns1__deleteVirtualSensor*)p = *(_ns1__deleteVirtualSensor*)q;
}

void _ns1__createVirtualSensorResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_bool(soap, &this->_ns1__createVirtualSensorResponse::status);
	/* transient soap skipped */
}

void _ns1__createVirtualSensorResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int _ns1__createVirtualSensorResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__createVirtualSensorResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__createVirtualSensorResponse(struct soap *soap, const char *tag, int id, const _ns1__createVirtualSensorResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__createVirtualSensorResponse), type))
		return soap->error;
	soap_element_result(soap, "ns1:status");
	if (soap_out_bool(soap, "ns1:status", -1, &(a->_ns1__createVirtualSensorResponse::status), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__createVirtualSensorResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__createVirtualSensorResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__createVirtualSensorResponse * SOAP_FMAC4 soap_in__ns1__createVirtualSensorResponse(struct soap *soap, const char *tag, _ns1__createVirtualSensorResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__createVirtualSensorResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__createVirtualSensorResponse, sizeof(_ns1__createVirtualSensorResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__createVirtualSensorResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__createVirtualSensorResponse *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "ns1:status", &(a->_ns1__createVirtualSensorResponse::status), "xsd:boolean"))
				{	soap_flag_status1--;
					continue;
				}
			/* transient soap skipped */
			soap_check_result(soap, "ns1:status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__createVirtualSensorResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__createVirtualSensorResponse, 0, sizeof(_ns1__createVirtualSensorResponse), 0, soap_copy__ns1__createVirtualSensorResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int _ns1__createVirtualSensorResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__createVirtualSensorResponse);
	if (this->soap_out(soap, tag?tag:"ns1:createVirtualSensorResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__createVirtualSensorResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__createVirtualSensorResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__createVirtualSensorResponse * SOAP_FMAC4 soap_get__ns1__createVirtualSensorResponse(struct soap *soap, _ns1__createVirtualSensorResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__createVirtualSensorResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__createVirtualSensorResponse * SOAP_FMAC2 soap_instantiate__ns1__createVirtualSensorResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__createVirtualSensorResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__createVirtualSensorResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__createVirtualSensorResponse);
		if (size)
			*size = sizeof(_ns1__createVirtualSensorResponse);
		((_ns1__createVirtualSensorResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__createVirtualSensorResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__createVirtualSensorResponse);
		for (int i = 0; i < n; i++)
			((_ns1__createVirtualSensorResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__createVirtualSensorResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__createVirtualSensorResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__createVirtualSensorResponse %p -> %p\n", q, p));
	*(_ns1__createVirtualSensorResponse*)p = *(_ns1__createVirtualSensorResponse*)q;
}

void _ns1__createVirtualSensor::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__createVirtualSensor::acDetails = NULL;
	soap_default_std__string(soap, &this->_ns1__createVirtualSensor::descriptionFileContent);
	soap_default_std__string(soap, &this->_ns1__createVirtualSensor::vsname);
	/* transient soap skipped */
}

void _ns1__createVirtualSensor::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__GSNWebService_USCOREACDetails(soap, &this->_ns1__createVirtualSensor::acDetails);
	soap_embedded(soap, &this->_ns1__createVirtualSensor::descriptionFileContent, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &this->_ns1__createVirtualSensor::descriptionFileContent);
	/* transient soap skipped */
}

int _ns1__createVirtualSensor::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__createVirtualSensor(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__createVirtualSensor(struct soap *soap, const char *tag, int id, const _ns1__createVirtualSensor *a, const char *type)
{
	soap_set_attr(soap, "ns1:vsname", ((_ns1__createVirtualSensor*)a)->vsname.c_str(), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__createVirtualSensor), type))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", -1, &(a->_ns1__createVirtualSensor::acDetails), ""))
		return soap->error;
	if (soap_out_std__string(soap, "ns1:descriptionFileContent", -1, &(a->_ns1__createVirtualSensor::descriptionFileContent), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__createVirtualSensor::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__createVirtualSensor(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__createVirtualSensor * SOAP_FMAC4 soap_in__ns1__createVirtualSensor(struct soap *soap, const char *tag, _ns1__createVirtualSensor *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__createVirtualSensor *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__createVirtualSensor, sizeof(_ns1__createVirtualSensor), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__createVirtualSensor)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__createVirtualSensor *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "ns1:vsname", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((_ns1__createVirtualSensor*)a)->vsname.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	size_t soap_flag_acDetails1 = 1;
	size_t soap_flag_descriptionFileContent1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_acDetails1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", &(a->_ns1__createVirtualSensor::acDetails), "ns2:GSNWebService_ACDetails"))
				{	soap_flag_acDetails1--;
					continue;
				}
			if (soap_flag_descriptionFileContent1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "ns1:descriptionFileContent", &(a->_ns1__createVirtualSensor::descriptionFileContent), "xsd:string"))
				{	soap_flag_descriptionFileContent1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__createVirtualSensor *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__createVirtualSensor, 0, sizeof(_ns1__createVirtualSensor), 0, soap_copy__ns1__createVirtualSensor);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_descriptionFileContent1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int _ns1__createVirtualSensor::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__createVirtualSensor);
	if (this->soap_out(soap, tag?tag:"ns1:createVirtualSensor", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__createVirtualSensor::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__createVirtualSensor(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__createVirtualSensor * SOAP_FMAC4 soap_get__ns1__createVirtualSensor(struct soap *soap, _ns1__createVirtualSensor *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__createVirtualSensor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__createVirtualSensor * SOAP_FMAC2 soap_instantiate__ns1__createVirtualSensor(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__createVirtualSensor(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__createVirtualSensor, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__createVirtualSensor);
		if (size)
			*size = sizeof(_ns1__createVirtualSensor);
		((_ns1__createVirtualSensor*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__createVirtualSensor[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__createVirtualSensor);
		for (int i = 0; i < n; i++)
			((_ns1__createVirtualSensor*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__createVirtualSensor*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__createVirtualSensor(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__createVirtualSensor %p -> %p\n", q, p));
	*(_ns1__createVirtualSensor*)p = *(_ns1__createVirtualSensor*)q;
}

void _ns1__listWrapperURLsResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL(soap, &this->_ns1__listWrapperURLsResponse::wrapperURLs);
	/* transient soap skipped */
}

void _ns1__listWrapperURLsResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL(soap, &this->_ns1__listWrapperURLsResponse::wrapperURLs);
	/* transient soap skipped */
}

int _ns1__listWrapperURLsResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__listWrapperURLsResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__listWrapperURLsResponse(struct soap *soap, const char *tag, int id, const _ns1__listWrapperURLsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__listWrapperURLsResponse), type))
		return soap->error;
	soap_element_result(soap, "ns1:wrapperURLs");
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL(soap, "ns1:wrapperURLs", -1, &(a->_ns1__listWrapperURLsResponse::wrapperURLs), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__listWrapperURLsResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__listWrapperURLsResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__listWrapperURLsResponse * SOAP_FMAC4 soap_in__ns1__listWrapperURLsResponse(struct soap *soap, const char *tag, _ns1__listWrapperURLsResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__listWrapperURLsResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__listWrapperURLsResponse, sizeof(_ns1__listWrapperURLsResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__listWrapperURLsResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__listWrapperURLsResponse *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL(soap, "ns1:wrapperURLs", &(a->_ns1__listWrapperURLsResponse::wrapperURLs), "ns2:GSNWebService_WrapperURL"))
					continue;
			/* transient soap skipped */
			soap_check_result(soap, "ns1:wrapperURLs");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__listWrapperURLsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__listWrapperURLsResponse, 0, sizeof(_ns1__listWrapperURLsResponse), 0, soap_copy__ns1__listWrapperURLsResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__listWrapperURLsResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__listWrapperURLsResponse);
	if (this->soap_out(soap, tag?tag:"ns1:listWrapperURLsResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__listWrapperURLsResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__listWrapperURLsResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__listWrapperURLsResponse * SOAP_FMAC4 soap_get__ns1__listWrapperURLsResponse(struct soap *soap, _ns1__listWrapperURLsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__listWrapperURLsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__listWrapperURLsResponse * SOAP_FMAC2 soap_instantiate__ns1__listWrapperURLsResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__listWrapperURLsResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__listWrapperURLsResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__listWrapperURLsResponse);
		if (size)
			*size = sizeof(_ns1__listWrapperURLsResponse);
		((_ns1__listWrapperURLsResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__listWrapperURLsResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__listWrapperURLsResponse);
		for (int i = 0; i < n; i++)
			((_ns1__listWrapperURLsResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__listWrapperURLsResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__listWrapperURLsResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__listWrapperURLsResponse %p -> %p\n", q, p));
	*(_ns1__listWrapperURLsResponse*)p = *(_ns1__listWrapperURLsResponse*)q;
}

void _ns1__listWrapperURLs::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__listWrapperURLs::acDetails = NULL;
	/* transient soap skipped */
}

void _ns1__listWrapperURLs::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__GSNWebService_USCOREACDetails(soap, &this->_ns1__listWrapperURLs::acDetails);
	/* transient soap skipped */
}

int _ns1__listWrapperURLs::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__listWrapperURLs(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__listWrapperURLs(struct soap *soap, const char *tag, int id, const _ns1__listWrapperURLs *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__listWrapperURLs), type))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", -1, &(a->_ns1__listWrapperURLs::acDetails), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__listWrapperURLs::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__listWrapperURLs(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__listWrapperURLs * SOAP_FMAC4 soap_in__ns1__listWrapperURLs(struct soap *soap, const char *tag, _ns1__listWrapperURLs *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__listWrapperURLs *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__listWrapperURLs, sizeof(_ns1__listWrapperURLs), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__listWrapperURLs)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__listWrapperURLs *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_acDetails1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_acDetails1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", &(a->_ns1__listWrapperURLs::acDetails), "ns2:GSNWebService_ACDetails"))
				{	soap_flag_acDetails1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__listWrapperURLs *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__listWrapperURLs, 0, sizeof(_ns1__listWrapperURLs), 0, soap_copy__ns1__listWrapperURLs);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__listWrapperURLs::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__listWrapperURLs);
	if (this->soap_out(soap, tag?tag:"ns1:listWrapperURLs", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__listWrapperURLs::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__listWrapperURLs(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__listWrapperURLs * SOAP_FMAC4 soap_get__ns1__listWrapperURLs(struct soap *soap, _ns1__listWrapperURLs *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__listWrapperURLs(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__listWrapperURLs * SOAP_FMAC2 soap_instantiate__ns1__listWrapperURLs(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__listWrapperURLs(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__listWrapperURLs, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__listWrapperURLs);
		if (size)
			*size = sizeof(_ns1__listWrapperURLs);
		((_ns1__listWrapperURLs*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__listWrapperURLs[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__listWrapperURLs);
		for (int i = 0; i < n; i++)
			((_ns1__listWrapperURLs*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__listWrapperURLs*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__listWrapperURLs(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__listWrapperURLs %p -> %p\n", q, p));
	*(_ns1__listWrapperURLs*)p = *(_ns1__listWrapperURLs*)q;
}

void _ns1__listVirtualSensorNamesResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfstd__string(soap, &this->_ns1__listVirtualSensorNamesResponse::virtualSensorName);
	/* transient soap skipped */
}

void _ns1__listVirtualSensorNamesResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfstd__string(soap, &this->_ns1__listVirtualSensorNamesResponse::virtualSensorName);
	/* transient soap skipped */
}

int _ns1__listVirtualSensorNamesResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__listVirtualSensorNamesResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__listVirtualSensorNamesResponse(struct soap *soap, const char *tag, int id, const _ns1__listVirtualSensorNamesResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__listVirtualSensorNamesResponse), type))
		return soap->error;
	soap_element_result(soap, "ns1:virtualSensorName");
	if (soap_out_std__vectorTemplateOfstd__string(soap, "ns1:virtualSensorName", -1, &(a->_ns1__listVirtualSensorNamesResponse::virtualSensorName), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__listVirtualSensorNamesResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__listVirtualSensorNamesResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__listVirtualSensorNamesResponse * SOAP_FMAC4 soap_in__ns1__listVirtualSensorNamesResponse(struct soap *soap, const char *tag, _ns1__listVirtualSensorNamesResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__listVirtualSensorNamesResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__listVirtualSensorNamesResponse, sizeof(_ns1__listVirtualSensorNamesResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__listVirtualSensorNamesResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__listVirtualSensorNamesResponse *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfstd__string(soap, "ns1:virtualSensorName", &(a->_ns1__listVirtualSensorNamesResponse::virtualSensorName), "xsd:string"))
					continue;
			/* transient soap skipped */
			soap_check_result(soap, "ns1:virtualSensorName");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__listVirtualSensorNamesResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__listVirtualSensorNamesResponse, 0, sizeof(_ns1__listVirtualSensorNamesResponse), 0, soap_copy__ns1__listVirtualSensorNamesResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__listVirtualSensorNamesResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__listVirtualSensorNamesResponse);
	if (this->soap_out(soap, tag?tag:"ns1:listVirtualSensorNamesResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__listVirtualSensorNamesResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__listVirtualSensorNamesResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__listVirtualSensorNamesResponse * SOAP_FMAC4 soap_get__ns1__listVirtualSensorNamesResponse(struct soap *soap, _ns1__listVirtualSensorNamesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__listVirtualSensorNamesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__listVirtualSensorNamesResponse * SOAP_FMAC2 soap_instantiate__ns1__listVirtualSensorNamesResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__listVirtualSensorNamesResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__listVirtualSensorNamesResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__listVirtualSensorNamesResponse);
		if (size)
			*size = sizeof(_ns1__listVirtualSensorNamesResponse);
		((_ns1__listVirtualSensorNamesResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__listVirtualSensorNamesResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__listVirtualSensorNamesResponse);
		for (int i = 0; i < n; i++)
			((_ns1__listVirtualSensorNamesResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__listVirtualSensorNamesResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__listVirtualSensorNamesResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__listVirtualSensorNamesResponse %p -> %p\n", q, p));
	*(_ns1__listVirtualSensorNamesResponse*)p = *(_ns1__listVirtualSensorNamesResponse*)q;
}

void _ns1__listVirtualSensorNames::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__listVirtualSensorNames::acDetails = NULL;
	/* transient soap skipped */
}

void _ns1__listVirtualSensorNames::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__GSNWebService_USCOREACDetails(soap, &this->_ns1__listVirtualSensorNames::acDetails);
	/* transient soap skipped */
}

int _ns1__listVirtualSensorNames::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__listVirtualSensorNames(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__listVirtualSensorNames(struct soap *soap, const char *tag, int id, const _ns1__listVirtualSensorNames *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__listVirtualSensorNames), type))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", -1, &(a->_ns1__listVirtualSensorNames::acDetails), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__listVirtualSensorNames::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__listVirtualSensorNames(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__listVirtualSensorNames * SOAP_FMAC4 soap_in__ns1__listVirtualSensorNames(struct soap *soap, const char *tag, _ns1__listVirtualSensorNames *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__listVirtualSensorNames *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__listVirtualSensorNames, sizeof(_ns1__listVirtualSensorNames), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__listVirtualSensorNames)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__listVirtualSensorNames *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_acDetails1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_acDetails1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", &(a->_ns1__listVirtualSensorNames::acDetails), "ns2:GSNWebService_ACDetails"))
				{	soap_flag_acDetails1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__listVirtualSensorNames *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__listVirtualSensorNames, 0, sizeof(_ns1__listVirtualSensorNames), 0, soap_copy__ns1__listVirtualSensorNames);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__listVirtualSensorNames::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__listVirtualSensorNames);
	if (this->soap_out(soap, tag?tag:"ns1:listVirtualSensorNames", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__listVirtualSensorNames::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__listVirtualSensorNames(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__listVirtualSensorNames * SOAP_FMAC4 soap_get__ns1__listVirtualSensorNames(struct soap *soap, _ns1__listVirtualSensorNames *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__listVirtualSensorNames(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__listVirtualSensorNames * SOAP_FMAC2 soap_instantiate__ns1__listVirtualSensorNames(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__listVirtualSensorNames(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__listVirtualSensorNames, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__listVirtualSensorNames);
		if (size)
			*size = sizeof(_ns1__listVirtualSensorNames);
		((_ns1__listVirtualSensorNames*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__listVirtualSensorNames[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__listVirtualSensorNames);
		for (int i = 0; i < n; i++)
			((_ns1__listVirtualSensorNames*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__listVirtualSensorNames*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__listVirtualSensorNames(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__listVirtualSensorNames %p -> %p\n", q, p));
	*(_ns1__listVirtualSensorNames*)p = *(_ns1__listVirtualSensorNames*)q;
}

void _ns1__getVirtualSensorsDetailsResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails(soap, &this->_ns1__getVirtualSensorsDetailsResponse::virtualSensorDetails);
	/* transient soap skipped */
}

void _ns1__getVirtualSensorsDetailsResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails(soap, &this->_ns1__getVirtualSensorsDetailsResponse::virtualSensorDetails);
	/* transient soap skipped */
}

int _ns1__getVirtualSensorsDetailsResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__getVirtualSensorsDetailsResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getVirtualSensorsDetailsResponse(struct soap *soap, const char *tag, int id, const _ns1__getVirtualSensorsDetailsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getVirtualSensorsDetailsResponse), type))
		return soap->error;
	soap_element_result(soap, "ns1:virtualSensorDetails");
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails(soap, "ns1:virtualSensorDetails", -1, &(a->_ns1__getVirtualSensorsDetailsResponse::virtualSensorDetails), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__getVirtualSensorsDetailsResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__getVirtualSensorsDetailsResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__getVirtualSensorsDetailsResponse * SOAP_FMAC4 soap_in__ns1__getVirtualSensorsDetailsResponse(struct soap *soap, const char *tag, _ns1__getVirtualSensorsDetailsResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__getVirtualSensorsDetailsResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getVirtualSensorsDetailsResponse, sizeof(_ns1__getVirtualSensorsDetailsResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__getVirtualSensorsDetailsResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__getVirtualSensorsDetailsResponse *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails(soap, "ns1:virtualSensorDetails", &(a->_ns1__getVirtualSensorsDetailsResponse::virtualSensorDetails), "ns2:GSNWebService_VirtualSensorDetails"))
					continue;
			/* transient soap skipped */
			soap_check_result(soap, "ns1:virtualSensorDetails");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__getVirtualSensorsDetailsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getVirtualSensorsDetailsResponse, 0, sizeof(_ns1__getVirtualSensorsDetailsResponse), 0, soap_copy__ns1__getVirtualSensorsDetailsResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__getVirtualSensorsDetailsResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__getVirtualSensorsDetailsResponse);
	if (this->soap_out(soap, tag?tag:"ns1:getVirtualSensorsDetailsResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__getVirtualSensorsDetailsResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__getVirtualSensorsDetailsResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__getVirtualSensorsDetailsResponse * SOAP_FMAC4 soap_get__ns1__getVirtualSensorsDetailsResponse(struct soap *soap, _ns1__getVirtualSensorsDetailsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getVirtualSensorsDetailsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__getVirtualSensorsDetailsResponse * SOAP_FMAC2 soap_instantiate__ns1__getVirtualSensorsDetailsResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__getVirtualSensorsDetailsResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__getVirtualSensorsDetailsResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getVirtualSensorsDetailsResponse);
		if (size)
			*size = sizeof(_ns1__getVirtualSensorsDetailsResponse);
		((_ns1__getVirtualSensorsDetailsResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getVirtualSensorsDetailsResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__getVirtualSensorsDetailsResponse);
		for (int i = 0; i < n; i++)
			((_ns1__getVirtualSensorsDetailsResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__getVirtualSensorsDetailsResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__getVirtualSensorsDetailsResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__getVirtualSensorsDetailsResponse %p -> %p\n", q, p));
	*(_ns1__getVirtualSensorsDetailsResponse*)p = *(_ns1__getVirtualSensorsDetailsResponse*)q;
}

void _ns1__getVirtualSensorsDetails::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__getVirtualSensorsDetails::acDetails = NULL;
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(soap, &this->_ns1__getVirtualSensorsDetails::fieldSelector);
	soap_default_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType(soap, &this->_ns1__getVirtualSensorsDetails::detailsType);
	/* transient soap skipped */
}

void _ns1__getVirtualSensorsDetails::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__GSNWebService_USCOREACDetails(soap, &this->_ns1__getVirtualSensorsDetails::acDetails);
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(soap, &this->_ns1__getVirtualSensorsDetails::fieldSelector);
	soap_serialize_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType(soap, &this->_ns1__getVirtualSensorsDetails::detailsType);
	/* transient soap skipped */
}

int _ns1__getVirtualSensorsDetails::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__getVirtualSensorsDetails(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getVirtualSensorsDetails(struct soap *soap, const char *tag, int id, const _ns1__getVirtualSensorsDetails *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getVirtualSensorsDetails), type))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", -1, &(a->_ns1__getVirtualSensorsDetails::acDetails), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(soap, "ns1:fieldSelector", -1, &(a->_ns1__getVirtualSensorsDetails::fieldSelector), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType(soap, "ns1:detailsType", -1, &(a->_ns1__getVirtualSensorsDetails::detailsType), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__getVirtualSensorsDetails::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__getVirtualSensorsDetails(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__getVirtualSensorsDetails * SOAP_FMAC4 soap_in__ns1__getVirtualSensorsDetails(struct soap *soap, const char *tag, _ns1__getVirtualSensorsDetails *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__getVirtualSensorsDetails *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getVirtualSensorsDetails, sizeof(_ns1__getVirtualSensorsDetails), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__getVirtualSensorsDetails)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__getVirtualSensorsDetails *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_acDetails1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_acDetails1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", &(a->_ns1__getVirtualSensorsDetails::acDetails), "ns2:GSNWebService_ACDetails"))
				{	soap_flag_acDetails1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(soap, "ns1:fieldSelector", &(a->_ns1__getVirtualSensorsDetails::fieldSelector), "ns2:GSNWebService_FieldSelector"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType(soap, "ns1:detailsType", &(a->_ns1__getVirtualSensorsDetails::detailsType), "ns2:GSNWebService_DetailsType"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__getVirtualSensorsDetails *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getVirtualSensorsDetails, 0, sizeof(_ns1__getVirtualSensorsDetails), 0, soap_copy__ns1__getVirtualSensorsDetails);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__getVirtualSensorsDetails::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__getVirtualSensorsDetails);
	if (this->soap_out(soap, tag?tag:"ns1:getVirtualSensorsDetails", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__getVirtualSensorsDetails::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__getVirtualSensorsDetails(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__getVirtualSensorsDetails * SOAP_FMAC4 soap_get__ns1__getVirtualSensorsDetails(struct soap *soap, _ns1__getVirtualSensorsDetails *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getVirtualSensorsDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__getVirtualSensorsDetails * SOAP_FMAC2 soap_instantiate__ns1__getVirtualSensorsDetails(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__getVirtualSensorsDetails(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__getVirtualSensorsDetails, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getVirtualSensorsDetails);
		if (size)
			*size = sizeof(_ns1__getVirtualSensorsDetails);
		((_ns1__getVirtualSensorsDetails*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getVirtualSensorsDetails[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__getVirtualSensorsDetails);
		for (int i = 0; i < n; i++)
			((_ns1__getVirtualSensorsDetails*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__getVirtualSensorsDetails*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__getVirtualSensorsDetails(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__getVirtualSensorsDetails %p -> %p\n", q, p));
	*(_ns1__getVirtualSensorsDetails*)p = *(_ns1__getVirtualSensorsDetails*)q;
}

void _ns1__getNextDataResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(soap, &this->_ns1__getNextDataResponse::queryResult);
	/* transient soap skipped */
}

void _ns1__getNextDataResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(soap, &this->_ns1__getNextDataResponse::queryResult);
	/* transient soap skipped */
}

int _ns1__getNextDataResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__getNextDataResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getNextDataResponse(struct soap *soap, const char *tag, int id, const _ns1__getNextDataResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getNextDataResponse), type))
		return soap->error;
	soap_element_result(soap, "ns1:queryResult");
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(soap, "ns1:queryResult", -1, &(a->_ns1__getNextDataResponse::queryResult), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__getNextDataResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__getNextDataResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__getNextDataResponse * SOAP_FMAC4 soap_in__ns1__getNextDataResponse(struct soap *soap, const char *tag, _ns1__getNextDataResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__getNextDataResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getNextDataResponse, sizeof(_ns1__getNextDataResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__getNextDataResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__getNextDataResponse *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(soap, "ns1:queryResult", &(a->_ns1__getNextDataResponse::queryResult), "ns2:GSNWebService_QueryResult"))
					continue;
			/* transient soap skipped */
			soap_check_result(soap, "ns1:queryResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__getNextDataResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getNextDataResponse, 0, sizeof(_ns1__getNextDataResponse), 0, soap_copy__ns1__getNextDataResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__getNextDataResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__getNextDataResponse);
	if (this->soap_out(soap, tag?tag:"ns1:getNextDataResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__getNextDataResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__getNextDataResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__getNextDataResponse * SOAP_FMAC4 soap_get__ns1__getNextDataResponse(struct soap *soap, _ns1__getNextDataResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getNextDataResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__getNextDataResponse * SOAP_FMAC2 soap_instantiate__ns1__getNextDataResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__getNextDataResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__getNextDataResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getNextDataResponse);
		if (size)
			*size = sizeof(_ns1__getNextDataResponse);
		((_ns1__getNextDataResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getNextDataResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__getNextDataResponse);
		for (int i = 0; i < n; i++)
			((_ns1__getNextDataResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__getNextDataResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__getNextDataResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__getNextDataResponse %p -> %p\n", q, p));
	*(_ns1__getNextDataResponse*)p = *(_ns1__getNextDataResponse*)q;
}

void _ns1__getNextData::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__getNextData::acDetails = NULL;
	soap_default_std__string(soap, &this->_ns1__getNextData::sid);
	/* transient soap skipped */
}

void _ns1__getNextData::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__GSNWebService_USCOREACDetails(soap, &this->_ns1__getNextData::acDetails);
	/* transient soap skipped */
}

int _ns1__getNextData::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__getNextData(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getNextData(struct soap *soap, const char *tag, int id, const _ns1__getNextData *a, const char *type)
{
	soap_set_attr(soap, "ns1:sid", ((_ns1__getNextData*)a)->sid.c_str(), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getNextData), type))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", -1, &(a->_ns1__getNextData::acDetails), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__getNextData::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__getNextData(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__getNextData * SOAP_FMAC4 soap_in__ns1__getNextData(struct soap *soap, const char *tag, _ns1__getNextData *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__getNextData *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getNextData, sizeof(_ns1__getNextData), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__getNextData)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__getNextData *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "ns1:sid", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((_ns1__getNextData*)a)->sid.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	size_t soap_flag_acDetails1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_acDetails1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", &(a->_ns1__getNextData::acDetails), "ns2:GSNWebService_ACDetails"))
				{	soap_flag_acDetails1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__getNextData *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getNextData, 0, sizeof(_ns1__getNextData), 0, soap_copy__ns1__getNextData);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__getNextData::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__getNextData);
	if (this->soap_out(soap, tag?tag:"ns1:getNextData", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__getNextData::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__getNextData(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__getNextData * SOAP_FMAC4 soap_get__ns1__getNextData(struct soap *soap, _ns1__getNextData *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getNextData(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__getNextData * SOAP_FMAC2 soap_instantiate__ns1__getNextData(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__getNextData(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__getNextData, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getNextData);
		if (size)
			*size = sizeof(_ns1__getNextData);
		((_ns1__getNextData*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getNextData[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__getNextData);
		for (int i = 0; i < n; i++)
			((_ns1__getNextData*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__getNextData*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__getNextData(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__getNextData %p -> %p\n", q, p));
	*(_ns1__getNextData*)p = *(_ns1__getNextData*)q;
}

void _ns1__getMultiDataResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(soap, &this->_ns1__getMultiDataResponse::queryResult);
	/* transient soap skipped */
}

void _ns1__getMultiDataResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(soap, &this->_ns1__getMultiDataResponse::queryResult);
	/* transient soap skipped */
}

int _ns1__getMultiDataResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__getMultiDataResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getMultiDataResponse(struct soap *soap, const char *tag, int id, const _ns1__getMultiDataResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getMultiDataResponse), type))
		return soap->error;
	soap_element_result(soap, "ns1:queryResult");
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(soap, "ns1:queryResult", -1, &(a->_ns1__getMultiDataResponse::queryResult), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__getMultiDataResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__getMultiDataResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__getMultiDataResponse * SOAP_FMAC4 soap_in__ns1__getMultiDataResponse(struct soap *soap, const char *tag, _ns1__getMultiDataResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__getMultiDataResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getMultiDataResponse, sizeof(_ns1__getMultiDataResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__getMultiDataResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__getMultiDataResponse *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(soap, "ns1:queryResult", &(a->_ns1__getMultiDataResponse::queryResult), "ns2:GSNWebService_QueryResult"))
					continue;
			/* transient soap skipped */
			soap_check_result(soap, "ns1:queryResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__getMultiDataResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getMultiDataResponse, 0, sizeof(_ns1__getMultiDataResponse), 0, soap_copy__ns1__getMultiDataResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__getMultiDataResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__getMultiDataResponse);
	if (this->soap_out(soap, tag?tag:"ns1:getMultiDataResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__getMultiDataResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__getMultiDataResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__getMultiDataResponse * SOAP_FMAC4 soap_get__ns1__getMultiDataResponse(struct soap *soap, _ns1__getMultiDataResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getMultiDataResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__getMultiDataResponse * SOAP_FMAC2 soap_instantiate__ns1__getMultiDataResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__getMultiDataResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__getMultiDataResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getMultiDataResponse);
		if (size)
			*size = sizeof(_ns1__getMultiDataResponse);
		((_ns1__getMultiDataResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getMultiDataResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__getMultiDataResponse);
		for (int i = 0; i < n; i++)
			((_ns1__getMultiDataResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__getMultiDataResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__getMultiDataResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__getMultiDataResponse %p -> %p\n", q, p));
	*(_ns1__getMultiDataResponse*)p = *(_ns1__getMultiDataResponse*)q;
}

void _ns1__getMultiData::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__getMultiData::acDetails = NULL;
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(soap, &this->_ns1__getMultiData::fieldSelector);
	soap_default_std__vectorTemplateOfPointerTons3__StandardCriterion(soap, &this->_ns1__getMultiData::conditions);
	this->_ns1__getMultiData::aggregation = NULL;
	this->_ns1__getMultiData::from = NULL;
	this->_ns1__getMultiData::to = NULL;
	this->_ns1__getMultiData::nb = NULL;
	this->_ns1__getMultiData::timeFormat = NULL;
	/* transient soap skipped */
}

void _ns1__getMultiData::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__GSNWebService_USCOREACDetails(soap, &this->_ns1__getMultiData::acDetails);
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(soap, &this->_ns1__getMultiData::fieldSelector);
	soap_serialize_std__vectorTemplateOfPointerTons3__StandardCriterion(soap, &this->_ns1__getMultiData::conditions);
	soap_serialize_PointerTons3__AggregationCriterion(soap, &this->_ns1__getMultiData::aggregation);
	/* transient soap skipped */
}

int _ns1__getMultiData::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__getMultiData(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getMultiData(struct soap *soap, const char *tag, int id, const _ns1__getMultiData *a, const char *type)
{
	if (((_ns1__getMultiData*)a)->from)
		soap_set_attr(soap, "ns1:from", soap_LONG642s(soap, *((_ns1__getMultiData*)a)->from), 1);
	if (((_ns1__getMultiData*)a)->to)
		soap_set_attr(soap, "ns1:to", soap_LONG642s(soap, *((_ns1__getMultiData*)a)->to), 1);
	if (((_ns1__getMultiData*)a)->nb)
		soap_set_attr(soap, "ns1:nb", soap_int2s(soap, *((_ns1__getMultiData*)a)->nb), 1);
	if (((_ns1__getMultiData*)a)->timeFormat)
		soap_set_attr(soap, "ns1:timeFormat", ((_ns1__getMultiData*)a)->timeFormat->c_str(), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getMultiData), type))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", -1, &(a->_ns1__getMultiData::acDetails), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(soap, "ns1:fieldSelector", -1, &(a->_ns1__getMultiData::fieldSelector), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTons3__StandardCriterion(soap, "ns1:conditions", -1, &(a->_ns1__getMultiData::conditions), ""))
		return soap->error;
	if (soap_out_PointerTons3__AggregationCriterion(soap, "ns1:aggregation", -1, &(a->_ns1__getMultiData::aggregation), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__getMultiData::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__getMultiData(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__getMultiData * SOAP_FMAC4 soap_in__ns1__getMultiData(struct soap *soap, const char *tag, _ns1__getMultiData *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__getMultiData *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getMultiData, sizeof(_ns1__getMultiData), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__getMultiData)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__getMultiData *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "ns1:from", 0);
		if (t)
		{
			if (!(((_ns1__getMultiData*)a)->from = (LONG64 *)soap_malloc(soap, sizeof(LONG64))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (soap_s2LONG64(soap, t, ((_ns1__getMultiData*)a)->from))
			return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "ns1:to", 0);
		if (t)
		{
			if (!(((_ns1__getMultiData*)a)->to = (LONG64 *)soap_malloc(soap, sizeof(LONG64))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (soap_s2LONG64(soap, t, ((_ns1__getMultiData*)a)->to))
			return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "ns1:nb", 0);
		if (t)
		{
			if (!(((_ns1__getMultiData*)a)->nb = (int *)soap_malloc(soap, sizeof(int))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (soap_s2int(soap, t, ((_ns1__getMultiData*)a)->nb))
				return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "ns1:timeFormat", 0);
		if (t)
		{
			char *s = NULL;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			if (s)
			{	((_ns1__getMultiData*)a)->timeFormat = soap_new_std__string(soap, -1);
				((_ns1__getMultiData*)a)->timeFormat->assign(s);
			}
		}
		else if (soap->error)
			return NULL;
	}
	size_t soap_flag_acDetails1 = 1;
	size_t soap_flag_aggregation1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_acDetails1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", &(a->_ns1__getMultiData::acDetails), "ns2:GSNWebService_ACDetails"))
				{	soap_flag_acDetails1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(soap, "ns1:fieldSelector", &(a->_ns1__getMultiData::fieldSelector), "ns2:GSNWebService_FieldSelector"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons3__StandardCriterion(soap, "ns1:conditions", &(a->_ns1__getMultiData::conditions), "ns3:StandardCriterion"))
					continue;
			if (soap_flag_aggregation1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons3__AggregationCriterion(soap, "ns1:aggregation", &(a->_ns1__getMultiData::aggregation), "ns3:AggregationCriterion"))
				{	soap_flag_aggregation1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__getMultiData *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getMultiData, 0, sizeof(_ns1__getMultiData), 0, soap_copy__ns1__getMultiData);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__getMultiData::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__getMultiData);
	if (this->soap_out(soap, tag?tag:"ns1:getMultiData", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__getMultiData::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__getMultiData(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__getMultiData * SOAP_FMAC4 soap_get__ns1__getMultiData(struct soap *soap, _ns1__getMultiData *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getMultiData(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__getMultiData * SOAP_FMAC2 soap_instantiate__ns1__getMultiData(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__getMultiData(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__getMultiData, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getMultiData);
		if (size)
			*size = sizeof(_ns1__getMultiData);
		((_ns1__getMultiData*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getMultiData[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__getMultiData);
		for (int i = 0; i < n; i++)
			((_ns1__getMultiData*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__getMultiData*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__getMultiData(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__getMultiData %p -> %p\n", q, p));
	*(_ns1__getMultiData*)p = *(_ns1__getMultiData*)q;
}

void _ns1__getLatestMultiDataResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(soap, &this->_ns1__getLatestMultiDataResponse::queryResult);
	/* transient soap skipped */
}

void _ns1__getLatestMultiDataResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(soap, &this->_ns1__getLatestMultiDataResponse::queryResult);
	/* transient soap skipped */
}

int _ns1__getLatestMultiDataResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__getLatestMultiDataResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getLatestMultiDataResponse(struct soap *soap, const char *tag, int id, const _ns1__getLatestMultiDataResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getLatestMultiDataResponse), type))
		return soap->error;
	soap_element_result(soap, "ns1:queryResult");
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(soap, "ns1:queryResult", -1, &(a->_ns1__getLatestMultiDataResponse::queryResult), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__getLatestMultiDataResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__getLatestMultiDataResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__getLatestMultiDataResponse * SOAP_FMAC4 soap_in__ns1__getLatestMultiDataResponse(struct soap *soap, const char *tag, _ns1__getLatestMultiDataResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__getLatestMultiDataResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getLatestMultiDataResponse, sizeof(_ns1__getLatestMultiDataResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__getLatestMultiDataResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__getLatestMultiDataResponse *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(soap, "ns1:queryResult", &(a->_ns1__getLatestMultiDataResponse::queryResult), "ns2:GSNWebService_QueryResult"))
					continue;
			/* transient soap skipped */
			soap_check_result(soap, "ns1:queryResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__getLatestMultiDataResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getLatestMultiDataResponse, 0, sizeof(_ns1__getLatestMultiDataResponse), 0, soap_copy__ns1__getLatestMultiDataResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__getLatestMultiDataResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__getLatestMultiDataResponse);
	if (this->soap_out(soap, tag?tag:"ns1:getLatestMultiDataResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__getLatestMultiDataResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__getLatestMultiDataResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__getLatestMultiDataResponse * SOAP_FMAC4 soap_get__ns1__getLatestMultiDataResponse(struct soap *soap, _ns1__getLatestMultiDataResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getLatestMultiDataResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__getLatestMultiDataResponse * SOAP_FMAC2 soap_instantiate__ns1__getLatestMultiDataResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__getLatestMultiDataResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__getLatestMultiDataResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getLatestMultiDataResponse);
		if (size)
			*size = sizeof(_ns1__getLatestMultiDataResponse);
		((_ns1__getLatestMultiDataResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getLatestMultiDataResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__getLatestMultiDataResponse);
		for (int i = 0; i < n; i++)
			((_ns1__getLatestMultiDataResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__getLatestMultiDataResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__getLatestMultiDataResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__getLatestMultiDataResponse %p -> %p\n", q, p));
	*(_ns1__getLatestMultiDataResponse*)p = *(_ns1__getLatestMultiDataResponse*)q;
}

void _ns1__getLatestMultiData::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__getLatestMultiData::acDetails = NULL;
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(soap, &this->_ns1__getLatestMultiData::fieldSelector);
	this->_ns1__getLatestMultiData::timeFormat = NULL;
	/* transient soap skipped */
}

void _ns1__getLatestMultiData::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__GSNWebService_USCOREACDetails(soap, &this->_ns1__getLatestMultiData::acDetails);
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(soap, &this->_ns1__getLatestMultiData::fieldSelector);
	/* transient soap skipped */
}

int _ns1__getLatestMultiData::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__getLatestMultiData(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getLatestMultiData(struct soap *soap, const char *tag, int id, const _ns1__getLatestMultiData *a, const char *type)
{
	if (((_ns1__getLatestMultiData*)a)->timeFormat)
		soap_set_attr(soap, "ns1:timeFormat", ((_ns1__getLatestMultiData*)a)->timeFormat->c_str(), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getLatestMultiData), type))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", -1, &(a->_ns1__getLatestMultiData::acDetails), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(soap, "ns1:fieldSelector", -1, &(a->_ns1__getLatestMultiData::fieldSelector), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__getLatestMultiData::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__getLatestMultiData(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__getLatestMultiData * SOAP_FMAC4 soap_in__ns1__getLatestMultiData(struct soap *soap, const char *tag, _ns1__getLatestMultiData *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__getLatestMultiData *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getLatestMultiData, sizeof(_ns1__getLatestMultiData), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__getLatestMultiData)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__getLatestMultiData *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "ns1:timeFormat", 0);
		if (t)
		{
			char *s = NULL;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			if (s)
			{	((_ns1__getLatestMultiData*)a)->timeFormat = soap_new_std__string(soap, -1);
				((_ns1__getLatestMultiData*)a)->timeFormat->assign(s);
			}
		}
		else if (soap->error)
			return NULL;
	}
	size_t soap_flag_acDetails1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_acDetails1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", &(a->_ns1__getLatestMultiData::acDetails), "ns2:GSNWebService_ACDetails"))
				{	soap_flag_acDetails1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(soap, "ns1:fieldSelector", &(a->_ns1__getLatestMultiData::fieldSelector), "ns2:GSNWebService_FieldSelector"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__getLatestMultiData *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getLatestMultiData, 0, sizeof(_ns1__getLatestMultiData), 0, soap_copy__ns1__getLatestMultiData);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__getLatestMultiData::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__getLatestMultiData);
	if (this->soap_out(soap, tag?tag:"ns1:getLatestMultiData", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__getLatestMultiData::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__getLatestMultiData(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__getLatestMultiData * SOAP_FMAC4 soap_get__ns1__getLatestMultiData(struct soap *soap, _ns1__getLatestMultiData *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getLatestMultiData(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__getLatestMultiData * SOAP_FMAC2 soap_instantiate__ns1__getLatestMultiData(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__getLatestMultiData(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__getLatestMultiData, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getLatestMultiData);
		if (size)
			*size = sizeof(_ns1__getLatestMultiData);
		((_ns1__getLatestMultiData*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getLatestMultiData[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__getLatestMultiData);
		for (int i = 0; i < n; i++)
			((_ns1__getLatestMultiData*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__getLatestMultiData*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__getLatestMultiData(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__getLatestMultiData %p -> %p\n", q, p));
	*(_ns1__getLatestMultiData*)p = *(_ns1__getLatestMultiData*)q;
}

void _ns1__getContainerInfoResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__getContainerInfoResponse::containerDetails = NULL;
	/* transient soap skipped */
}

void _ns1__getContainerInfoResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__GSNWebService_USCOREContainerDetails(soap, &this->_ns1__getContainerInfoResponse::containerDetails);
	/* transient soap skipped */
}

int _ns1__getContainerInfoResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__getContainerInfoResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getContainerInfoResponse(struct soap *soap, const char *tag, int id, const _ns1__getContainerInfoResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getContainerInfoResponse), type))
		return soap->error;
	if (a->containerDetails)
		soap_element_result(soap, "ns1:containerDetails");
	if (a->_ns1__getContainerInfoResponse::containerDetails)
	{	if (soap_out_PointerTons2__GSNWebService_USCOREContainerDetails(soap, "ns1:containerDetails", -1, &a->_ns1__getContainerInfoResponse::containerDetails, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "ns1:containerDetails"))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__getContainerInfoResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__getContainerInfoResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__getContainerInfoResponse * SOAP_FMAC4 soap_in__ns1__getContainerInfoResponse(struct soap *soap, const char *tag, _ns1__getContainerInfoResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__getContainerInfoResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getContainerInfoResponse, sizeof(_ns1__getContainerInfoResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__getContainerInfoResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__getContainerInfoResponse *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_containerDetails1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_containerDetails1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREContainerDetails(soap, "ns1:containerDetails", &(a->_ns1__getContainerInfoResponse::containerDetails), "ns2:GSNWebService_ContainerDetails"))
				{	soap_flag_containerDetails1--;
					continue;
				}
			/* transient soap skipped */
			soap_check_result(soap, "ns1:containerDetails");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__getContainerInfoResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getContainerInfoResponse, 0, sizeof(_ns1__getContainerInfoResponse), 0, soap_copy__ns1__getContainerInfoResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_containerDetails1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int _ns1__getContainerInfoResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__getContainerInfoResponse);
	if (this->soap_out(soap, tag?tag:"ns1:getContainerInfoResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__getContainerInfoResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__getContainerInfoResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__getContainerInfoResponse * SOAP_FMAC4 soap_get__ns1__getContainerInfoResponse(struct soap *soap, _ns1__getContainerInfoResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getContainerInfoResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__getContainerInfoResponse * SOAP_FMAC2 soap_instantiate__ns1__getContainerInfoResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__getContainerInfoResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__getContainerInfoResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getContainerInfoResponse);
		if (size)
			*size = sizeof(_ns1__getContainerInfoResponse);
		((_ns1__getContainerInfoResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getContainerInfoResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__getContainerInfoResponse);
		for (int i = 0; i < n; i++)
			((_ns1__getContainerInfoResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__getContainerInfoResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__getContainerInfoResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__getContainerInfoResponse %p -> %p\n", q, p));
	*(_ns1__getContainerInfoResponse*)p = *(_ns1__getContainerInfoResponse*)q;
}

void _ns1__getContainerInfo::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__getContainerInfo::acDetails = NULL;
	/* transient soap skipped */
}

void _ns1__getContainerInfo::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__GSNWebService_USCOREACDetails(soap, &this->_ns1__getContainerInfo::acDetails);
	/* transient soap skipped */
}

int _ns1__getContainerInfo::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__getContainerInfo(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getContainerInfo(struct soap *soap, const char *tag, int id, const _ns1__getContainerInfo *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getContainerInfo), type))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", -1, &(a->_ns1__getContainerInfo::acDetails), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__getContainerInfo::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__getContainerInfo(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__getContainerInfo * SOAP_FMAC4 soap_in__ns1__getContainerInfo(struct soap *soap, const char *tag, _ns1__getContainerInfo *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__getContainerInfo *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getContainerInfo, sizeof(_ns1__getContainerInfo), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__getContainerInfo)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__getContainerInfo *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_acDetails1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_acDetails1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREACDetails(soap, "ns1:acDetails", &(a->_ns1__getContainerInfo::acDetails), "ns2:GSNWebService_ACDetails"))
				{	soap_flag_acDetails1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__getContainerInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getContainerInfo, 0, sizeof(_ns1__getContainerInfo), 0, soap_copy__ns1__getContainerInfo);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__getContainerInfo::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__getContainerInfo);
	if (this->soap_out(soap, tag?tag:"ns1:getContainerInfo", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__getContainerInfo::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__getContainerInfo(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__getContainerInfo * SOAP_FMAC4 soap_get__ns1__getContainerInfo(struct soap *soap, _ns1__getContainerInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getContainerInfo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__getContainerInfo * SOAP_FMAC2 soap_instantiate__ns1__getContainerInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__getContainerInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__getContainerInfo, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getContainerInfo);
		if (size)
			*size = sizeof(_ns1__getContainerInfo);
		((_ns1__getContainerInfo*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__getContainerInfo[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__getContainerInfo);
		for (int i = 0; i < n; i++)
			((_ns1__getContainerInfo*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__getContainerInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__getContainerInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__getContainerInfo %p -> %p\n", q, p));
	*(_ns1__getContainerInfo*)p = *(_ns1__getContainerInfo*)q;
}

void ns3__AggregationCriterion::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->ns3__AggregationCriterion::groupOperator);
	soap_default_std__string(soap, &this->ns3__AggregationCriterion::timeRange);
	/* transient soap skipped */
}

void ns3__AggregationCriterion::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int ns3__AggregationCriterion::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns3__AggregationCriterion(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns3__AggregationCriterion(struct soap *soap, const char *tag, int id, const ns3__AggregationCriterion *a, const char *type)
{
	soap_set_attr(soap, "ns3:groupOperator", ((ns3__AggregationCriterion*)a)->groupOperator.c_str(), 1);
	soap_set_attr(soap, "ns3:timeRange", ((ns3__AggregationCriterion*)a)->timeRange.c_str(), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns3__AggregationCriterion), "ns3:AggregationCriterion"))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns3__AggregationCriterion::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns3__AggregationCriterion(soap, tag, this, type);
}

SOAP_FMAC3 ns3__AggregationCriterion * SOAP_FMAC4 soap_in_ns3__AggregationCriterion(struct soap *soap, const char *tag, ns3__AggregationCriterion *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns3__AggregationCriterion *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns3__AggregationCriterion, sizeof(ns3__AggregationCriterion), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns3__AggregationCriterion)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns3__AggregationCriterion *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "ns3:groupOperator", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns3__AggregationCriterion*)a)->groupOperator.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "ns3:timeRange", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns3__AggregationCriterion*)a)->timeRange.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns3__AggregationCriterion *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns3__AggregationCriterion, 0, sizeof(ns3__AggregationCriterion), 0, soap_copy_ns3__AggregationCriterion);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns3__AggregationCriterion::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns3__AggregationCriterion);
	if (this->soap_out(soap, tag?tag:"ns3:AggregationCriterion", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns3__AggregationCriterion::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns3__AggregationCriterion(soap, this, tag, type);
}

SOAP_FMAC3 ns3__AggregationCriterion * SOAP_FMAC4 soap_get_ns3__AggregationCriterion(struct soap *soap, ns3__AggregationCriterion *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns3__AggregationCriterion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns3__AggregationCriterion * SOAP_FMAC2 soap_instantiate_ns3__AggregationCriterion(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns3__AggregationCriterion(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns3__AggregationCriterion, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns3__AggregationCriterion);
		if (size)
			*size = sizeof(ns3__AggregationCriterion);
		((ns3__AggregationCriterion*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns3__AggregationCriterion[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns3__AggregationCriterion);
		for (int i = 0; i < n; i++)
			((ns3__AggregationCriterion*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns3__AggregationCriterion*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns3__AggregationCriterion(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns3__AggregationCriterion %p -> %p\n", q, p));
	*(ns3__AggregationCriterion*)p = *(ns3__AggregationCriterion*)q;
}

void ns3__StandardCriterion::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->ns3__StandardCriterion::critJoin);
	soap_default_std__string(soap, &this->ns3__StandardCriterion::field);
	soap_default_std__string(soap, &this->ns3__StandardCriterion::negation);
	soap_default_std__string(soap, &this->ns3__StandardCriterion::operator_);
	soap_default_std__string(soap, &this->ns3__StandardCriterion::value);
	soap_default_std__string(soap, &this->ns3__StandardCriterion::vsname);
	/* transient soap skipped */
}

void ns3__StandardCriterion::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int ns3__StandardCriterion::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns3__StandardCriterion(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns3__StandardCriterion(struct soap *soap, const char *tag, int id, const ns3__StandardCriterion *a, const char *type)
{
	soap_set_attr(soap, "ns3:critJoin", ((ns3__StandardCriterion*)a)->critJoin.c_str(), 1);
	soap_set_attr(soap, "ns3:field", ((ns3__StandardCriterion*)a)->field.c_str(), 1);
	soap_set_attr(soap, "ns3:negation", ((ns3__StandardCriterion*)a)->negation.c_str(), 1);
	soap_set_attr(soap, "ns3:operator", ((ns3__StandardCriterion*)a)->operator_.c_str(), 1);
	soap_set_attr(soap, "ns3:value", ((ns3__StandardCriterion*)a)->value.c_str(), 1);
	soap_set_attr(soap, "ns3:vsname", ((ns3__StandardCriterion*)a)->vsname.c_str(), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns3__StandardCriterion), "ns3:StandardCriterion"))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns3__StandardCriterion::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns3__StandardCriterion(soap, tag, this, type);
}

SOAP_FMAC3 ns3__StandardCriterion * SOAP_FMAC4 soap_in_ns3__StandardCriterion(struct soap *soap, const char *tag, ns3__StandardCriterion *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns3__StandardCriterion *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns3__StandardCriterion, sizeof(ns3__StandardCriterion), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns3__StandardCriterion)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns3__StandardCriterion *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "ns3:critJoin", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns3__StandardCriterion*)a)->critJoin.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "ns3:field", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns3__StandardCriterion*)a)->field.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "ns3:negation", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns3__StandardCriterion*)a)->negation.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "ns3:operator", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns3__StandardCriterion*)a)->operator_.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "ns3:value", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns3__StandardCriterion*)a)->value.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "ns3:vsname", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns3__StandardCriterion*)a)->vsname.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns3__StandardCriterion *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns3__StandardCriterion, 0, sizeof(ns3__StandardCriterion), 0, soap_copy_ns3__StandardCriterion);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns3__StandardCriterion::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns3__StandardCriterion);
	if (this->soap_out(soap, tag?tag:"ns3:StandardCriterion", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns3__StandardCriterion::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns3__StandardCriterion(soap, this, tag, type);
}

SOAP_FMAC3 ns3__StandardCriterion * SOAP_FMAC4 soap_get_ns3__StandardCriterion(struct soap *soap, ns3__StandardCriterion *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns3__StandardCriterion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns3__StandardCriterion * SOAP_FMAC2 soap_instantiate_ns3__StandardCriterion(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns3__StandardCriterion(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns3__StandardCriterion, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns3__StandardCriterion);
		if (size)
			*size = sizeof(ns3__StandardCriterion);
		((ns3__StandardCriterion*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns3__StandardCriterion[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns3__StandardCriterion);
		for (int i = 0; i < n; i++)
			((ns3__StandardCriterion*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns3__StandardCriterion*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns3__StandardCriterion(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns3__StandardCriterion %p -> %p\n", q, p));
	*(ns3__StandardCriterion*)p = *(ns3__StandardCriterion*)q;
}

void ns3__AbstractCriterion::soap_default(struct soap *soap)
{
	this->soap = soap;
	/* transient soap skipped */
}

void ns3__AbstractCriterion::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int ns3__AbstractCriterion::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns3__AbstractCriterion(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns3__AbstractCriterion(struct soap *soap, const char *tag, int id, const ns3__AbstractCriterion *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns3__AbstractCriterion), type))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns3__AbstractCriterion::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns3__AbstractCriterion(soap, tag, this, type);
}

SOAP_FMAC3 ns3__AbstractCriterion * SOAP_FMAC4 soap_in_ns3__AbstractCriterion(struct soap *soap, const char *tag, ns3__AbstractCriterion *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns3__AbstractCriterion *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns3__AbstractCriterion, sizeof(ns3__AbstractCriterion), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns3__AbstractCriterion)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns3__AbstractCriterion *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns3__AbstractCriterion *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns3__AbstractCriterion, 0, sizeof(ns3__AbstractCriterion), 0, soap_copy_ns3__AbstractCriterion);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns3__AbstractCriterion::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns3__AbstractCriterion);
	if (this->soap_out(soap, tag?tag:"ns3:AbstractCriterion", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns3__AbstractCriterion::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns3__AbstractCriterion(soap, this, tag, type);
}

SOAP_FMAC3 ns3__AbstractCriterion * SOAP_FMAC4 soap_get_ns3__AbstractCriterion(struct soap *soap, ns3__AbstractCriterion *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns3__AbstractCriterion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns3__AbstractCriterion * SOAP_FMAC2 soap_instantiate_ns3__AbstractCriterion(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns3__AbstractCriterion(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns3__AbstractCriterion, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (type && !soap_match_tag(soap, type, "ns3:StandardCriterion"))
	{	cp->type = SOAP_TYPE_ns3__StandardCriterion;
		if (n < 0)
		{	cp->ptr = (void*)SOAP_NEW(ns3__StandardCriterion);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns3__StandardCriterion);
			((ns3__StandardCriterion*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)SOAP_NEW(ns3__StandardCriterion[n]);
			if (size)
				*size = n * sizeof(ns3__StandardCriterion);
			for (int i = 0; i < n; i++)
				((ns3__StandardCriterion*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns3__StandardCriterion*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns3:AggregationCriterion"))
	{	cp->type = SOAP_TYPE_ns3__AggregationCriterion;
		if (n < 0)
		{	cp->ptr = (void*)SOAP_NEW(ns3__AggregationCriterion);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns3__AggregationCriterion);
			((ns3__AggregationCriterion*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)SOAP_NEW(ns3__AggregationCriterion[n]);
			if (size)
				*size = n * sizeof(ns3__AggregationCriterion);
			for (int i = 0; i < n; i++)
				((ns3__AggregationCriterion*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns3__AggregationCriterion*)cp->ptr;
	}
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns3__AbstractCriterion);
		if (size)
			*size = sizeof(ns3__AbstractCriterion);
		((ns3__AbstractCriterion*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns3__AbstractCriterion[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns3__AbstractCriterion);
		for (int i = 0; i < n; i++)
			((ns3__AbstractCriterion*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns3__AbstractCriterion*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns3__AbstractCriterion(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns3__AbstractCriterion %p -> %p\n", q, p));
	*(ns3__AbstractCriterion*)p = *(ns3__AbstractCriterion*)q;
}

void ns2__GSNWebService_USCOREWrapperURL::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->ns2__GSNWebService_USCOREWrapperURL::virtualSensor);
	soap_default_std__string(soap, &this->ns2__GSNWebService_USCOREWrapperURL::source);
	soap_default_std__string(soap, &this->ns2__GSNWebService_USCOREWrapperURL::stream);
	soap_default_std__string(soap, &this->ns2__GSNWebService_USCOREWrapperURL::wrapper);
	/* transient soap skipped */
}

void ns2__GSNWebService_USCOREWrapperURL::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int ns2__GSNWebService_USCOREWrapperURL::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__GSNWebService_USCOREWrapperURL(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__GSNWebService_USCOREWrapperURL(struct soap *soap, const char *tag, int id, const ns2__GSNWebService_USCOREWrapperURL *a, const char *type)
{
	soap_set_attr(soap, "ns2:virtualSensor", ((ns2__GSNWebService_USCOREWrapperURL*)a)->virtualSensor.c_str(), 1);
	soap_set_attr(soap, "ns2:source", ((ns2__GSNWebService_USCOREWrapperURL*)a)->source.c_str(), 1);
	soap_set_attr(soap, "ns2:stream", ((ns2__GSNWebService_USCOREWrapperURL*)a)->stream.c_str(), 1);
	soap_set_attr(soap, "ns2:wrapper", ((ns2__GSNWebService_USCOREWrapperURL*)a)->wrapper.c_str(), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__GSNWebService_USCOREWrapperURL), type))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__GSNWebService_USCOREWrapperURL::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__GSNWebService_USCOREWrapperURL(soap, tag, this, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREWrapperURL * SOAP_FMAC4 soap_in_ns2__GSNWebService_USCOREWrapperURL(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREWrapperURL *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__GSNWebService_USCOREWrapperURL *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__GSNWebService_USCOREWrapperURL, sizeof(ns2__GSNWebService_USCOREWrapperURL), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__GSNWebService_USCOREWrapperURL)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__GSNWebService_USCOREWrapperURL *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "ns2:virtualSensor", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns2__GSNWebService_USCOREWrapperURL*)a)->virtualSensor.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "ns2:source", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns2__GSNWebService_USCOREWrapperURL*)a)->source.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "ns2:stream", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns2__GSNWebService_USCOREWrapperURL*)a)->stream.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "ns2:wrapper", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns2__GSNWebService_USCOREWrapperURL*)a)->wrapper.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__GSNWebService_USCOREWrapperURL *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__GSNWebService_USCOREWrapperURL, 0, sizeof(ns2__GSNWebService_USCOREWrapperURL), 0, soap_copy_ns2__GSNWebService_USCOREWrapperURL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__GSNWebService_USCOREWrapperURL::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__GSNWebService_USCOREWrapperURL);
	if (this->soap_out(soap, tag?tag:"ns2:GSNWebService_WrapperURL", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__GSNWebService_USCOREWrapperURL::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__GSNWebService_USCOREWrapperURL(soap, this, tag, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREWrapperURL * SOAP_FMAC4 soap_get_ns2__GSNWebService_USCOREWrapperURL(struct soap *soap, ns2__GSNWebService_USCOREWrapperURL *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__GSNWebService_USCOREWrapperURL(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__GSNWebService_USCOREWrapperURL * SOAP_FMAC2 soap_instantiate_ns2__GSNWebService_USCOREWrapperURL(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__GSNWebService_USCOREWrapperURL(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__GSNWebService_USCOREWrapperURL, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREWrapperURL);
		if (size)
			*size = sizeof(ns2__GSNWebService_USCOREWrapperURL);
		((ns2__GSNWebService_USCOREWrapperURL*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREWrapperURL[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__GSNWebService_USCOREWrapperURL);
		for (int i = 0; i < n; i++)
			((ns2__GSNWebService_USCOREWrapperURL*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__GSNWebService_USCOREWrapperURL*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__GSNWebService_USCOREWrapperURL(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__GSNWebService_USCOREWrapperURL %p -> %p\n", q, p));
	*(ns2__GSNWebService_USCOREWrapperURL*)p = *(ns2__GSNWebService_USCOREWrapperURL*)q;
}

void ns2__GSNWebService_USCOREWrapperDetails::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->ns2__GSNWebService_USCOREWrapperDetails::wrapperURLs = NULL;
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, &this->ns2__GSNWebService_USCOREWrapperDetails::outputFormat);
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(soap, &this->ns2__GSNWebService_USCOREWrapperDetails::predicates);
	/* transient soap skipped */
}

void ns2__GSNWebService_USCOREWrapperDetails::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__GSNWebService_USCOREWrapperURL(soap, &this->ns2__GSNWebService_USCOREWrapperDetails::wrapperURLs);
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, &this->ns2__GSNWebService_USCOREWrapperDetails::outputFormat);
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(soap, &this->ns2__GSNWebService_USCOREWrapperDetails::predicates);
	/* transient soap skipped */
}

int ns2__GSNWebService_USCOREWrapperDetails::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__GSNWebService_USCOREWrapperDetails(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__GSNWebService_USCOREWrapperDetails(struct soap *soap, const char *tag, int id, const ns2__GSNWebService_USCOREWrapperDetails *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__GSNWebService_USCOREWrapperDetails), type))
		return soap->error;
	if (a->ns2__GSNWebService_USCOREWrapperDetails::wrapperURLs)
	{	if (soap_out_PointerTons2__GSNWebService_USCOREWrapperURL(soap, "ns2:wrapperURLs", -1, &a->ns2__GSNWebService_USCOREWrapperDetails::wrapperURLs, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "ns2:wrapperURLs"))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, "ns2:outputFormat", -1, &(a->ns2__GSNWebService_USCOREWrapperDetails::outputFormat), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(soap, "ns2:predicates", -1, &(a->ns2__GSNWebService_USCOREWrapperDetails::predicates), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__GSNWebService_USCOREWrapperDetails::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__GSNWebService_USCOREWrapperDetails(soap, tag, this, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREWrapperDetails * SOAP_FMAC4 soap_in_ns2__GSNWebService_USCOREWrapperDetails(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREWrapperDetails *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__GSNWebService_USCOREWrapperDetails *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__GSNWebService_USCOREWrapperDetails, sizeof(ns2__GSNWebService_USCOREWrapperDetails), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__GSNWebService_USCOREWrapperDetails)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__GSNWebService_USCOREWrapperDetails *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_wrapperURLs1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wrapperURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREWrapperURL(soap, "ns2:wrapperURLs", &(a->ns2__GSNWebService_USCOREWrapperDetails::wrapperURLs), "ns2:GSNWebService_WrapperURL"))
				{	soap_flag_wrapperURLs1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, "ns2:outputFormat", &(a->ns2__GSNWebService_USCOREWrapperDetails::outputFormat), "ns2:GSNWebService_DataField"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(soap, "ns2:predicates", &(a->ns2__GSNWebService_USCOREWrapperDetails::predicates), "ns2:GSNWebService_ConfPredicate"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__GSNWebService_USCOREWrapperDetails *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__GSNWebService_USCOREWrapperDetails, 0, sizeof(ns2__GSNWebService_USCOREWrapperDetails), 0, soap_copy_ns2__GSNWebService_USCOREWrapperDetails);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wrapperURLs1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int ns2__GSNWebService_USCOREWrapperDetails::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__GSNWebService_USCOREWrapperDetails);
	if (this->soap_out(soap, tag?tag:"ns2:GSNWebService_WrapperDetails", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__GSNWebService_USCOREWrapperDetails::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__GSNWebService_USCOREWrapperDetails(soap, this, tag, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREWrapperDetails * SOAP_FMAC4 soap_get_ns2__GSNWebService_USCOREWrapperDetails(struct soap *soap, ns2__GSNWebService_USCOREWrapperDetails *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__GSNWebService_USCOREWrapperDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__GSNWebService_USCOREWrapperDetails * SOAP_FMAC2 soap_instantiate_ns2__GSNWebService_USCOREWrapperDetails(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__GSNWebService_USCOREWrapperDetails(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__GSNWebService_USCOREWrapperDetails, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREWrapperDetails);
		if (size)
			*size = sizeof(ns2__GSNWebService_USCOREWrapperDetails);
		((ns2__GSNWebService_USCOREWrapperDetails*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREWrapperDetails[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__GSNWebService_USCOREWrapperDetails);
		for (int i = 0; i < n; i++)
			((ns2__GSNWebService_USCOREWrapperDetails*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__GSNWebService_USCOREWrapperDetails*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__GSNWebService_USCOREWrapperDetails(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__GSNWebService_USCOREWrapperDetails %p -> %p\n", q, p));
	*(ns2__GSNWebService_USCOREWrapperDetails*)p = *(ns2__GSNWebService_USCOREWrapperDetails*)q;
}

void ns2__GSNWebService_USCOREConfWrapper::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails(soap, &this->ns2__GSNWebService_USCOREConfWrapper::wrapperDetails);
	/* transient soap skipped */
}

void ns2__GSNWebService_USCOREConfWrapper::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails(soap, &this->ns2__GSNWebService_USCOREConfWrapper::wrapperDetails);
	/* transient soap skipped */
}

int ns2__GSNWebService_USCOREConfWrapper::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__GSNWebService_USCOREConfWrapper(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__GSNWebService_USCOREConfWrapper(struct soap *soap, const char *tag, int id, const ns2__GSNWebService_USCOREConfWrapper *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__GSNWebService_USCOREConfWrapper), type))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails(soap, "ns2:wrapperDetails", -1, &(a->ns2__GSNWebService_USCOREConfWrapper::wrapperDetails), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__GSNWebService_USCOREConfWrapper::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__GSNWebService_USCOREConfWrapper(soap, tag, this, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfWrapper * SOAP_FMAC4 soap_in_ns2__GSNWebService_USCOREConfWrapper(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREConfWrapper *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__GSNWebService_USCOREConfWrapper *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__GSNWebService_USCOREConfWrapper, sizeof(ns2__GSNWebService_USCOREConfWrapper), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__GSNWebService_USCOREConfWrapper)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__GSNWebService_USCOREConfWrapper *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails(soap, "ns2:wrapperDetails", &(a->ns2__GSNWebService_USCOREConfWrapper::wrapperDetails), "ns2:GSNWebService_WrapperDetails"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__GSNWebService_USCOREConfWrapper *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__GSNWebService_USCOREConfWrapper, 0, sizeof(ns2__GSNWebService_USCOREConfWrapper), 0, soap_copy_ns2__GSNWebService_USCOREConfWrapper);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__GSNWebService_USCOREConfWrapper::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__GSNWebService_USCOREConfWrapper);
	if (this->soap_out(soap, tag?tag:"ns2:GSNWebService_ConfWrapper", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__GSNWebService_USCOREConfWrapper::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__GSNWebService_USCOREConfWrapper(soap, this, tag, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfWrapper * SOAP_FMAC4 soap_get_ns2__GSNWebService_USCOREConfWrapper(struct soap *soap, ns2__GSNWebService_USCOREConfWrapper *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__GSNWebService_USCOREConfWrapper(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__GSNWebService_USCOREConfWrapper * SOAP_FMAC2 soap_instantiate_ns2__GSNWebService_USCOREConfWrapper(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__GSNWebService_USCOREConfWrapper(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__GSNWebService_USCOREConfWrapper, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREConfWrapper);
		if (size)
			*size = sizeof(ns2__GSNWebService_USCOREConfWrapper);
		((ns2__GSNWebService_USCOREConfWrapper*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREConfWrapper[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__GSNWebService_USCOREConfWrapper);
		for (int i = 0; i < n; i++)
			((ns2__GSNWebService_USCOREConfWrapper*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__GSNWebService_USCOREConfWrapper*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__GSNWebService_USCOREConfWrapper(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__GSNWebService_USCOREConfWrapper %p -> %p\n", q, p));
	*(ns2__GSNWebService_USCOREConfWrapper*)p = *(ns2__GSNWebService_USCOREConfWrapper*)q;
}

void ns2__GSNWebService_USCOREConfProcessor::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(soap, &this->ns2__GSNWebService_USCOREConfProcessor::initParams);
	soap_default_std__string(soap, &this->ns2__GSNWebService_USCOREConfProcessor::className);
	/* transient soap skipped */
}

void ns2__GSNWebService_USCOREConfProcessor::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(soap, &this->ns2__GSNWebService_USCOREConfProcessor::initParams);
	/* transient soap skipped */
}

int ns2__GSNWebService_USCOREConfProcessor::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__GSNWebService_USCOREConfProcessor(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__GSNWebService_USCOREConfProcessor(struct soap *soap, const char *tag, int id, const ns2__GSNWebService_USCOREConfProcessor *a, const char *type)
{
	soap_set_attr(soap, "ns2:className", ((ns2__GSNWebService_USCOREConfProcessor*)a)->className.c_str(), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__GSNWebService_USCOREConfProcessor), type))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(soap, "ns2:initParams", -1, &(a->ns2__GSNWebService_USCOREConfProcessor::initParams), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__GSNWebService_USCOREConfProcessor::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__GSNWebService_USCOREConfProcessor(soap, tag, this, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfProcessor * SOAP_FMAC4 soap_in_ns2__GSNWebService_USCOREConfProcessor(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREConfProcessor *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__GSNWebService_USCOREConfProcessor *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__GSNWebService_USCOREConfProcessor, sizeof(ns2__GSNWebService_USCOREConfProcessor), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__GSNWebService_USCOREConfProcessor)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__GSNWebService_USCOREConfProcessor *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "ns2:className", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns2__GSNWebService_USCOREConfProcessor*)a)->className.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(soap, "ns2:initParams", &(a->ns2__GSNWebService_USCOREConfProcessor::initParams), "ns2:GSNWebService_ConfPredicate"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__GSNWebService_USCOREConfProcessor *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__GSNWebService_USCOREConfProcessor, 0, sizeof(ns2__GSNWebService_USCOREConfProcessor), 0, soap_copy_ns2__GSNWebService_USCOREConfProcessor);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__GSNWebService_USCOREConfProcessor::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__GSNWebService_USCOREConfProcessor);
	if (this->soap_out(soap, tag?tag:"ns2:GSNWebService_ConfProcessor", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__GSNWebService_USCOREConfProcessor::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__GSNWebService_USCOREConfProcessor(soap, this, tag, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfProcessor * SOAP_FMAC4 soap_get_ns2__GSNWebService_USCOREConfProcessor(struct soap *soap, ns2__GSNWebService_USCOREConfProcessor *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__GSNWebService_USCOREConfProcessor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__GSNWebService_USCOREConfProcessor * SOAP_FMAC2 soap_instantiate_ns2__GSNWebService_USCOREConfProcessor(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__GSNWebService_USCOREConfProcessor(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__GSNWebService_USCOREConfProcessor, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREConfProcessor);
		if (size)
			*size = sizeof(ns2__GSNWebService_USCOREConfProcessor);
		((ns2__GSNWebService_USCOREConfProcessor*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREConfProcessor[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__GSNWebService_USCOREConfProcessor);
		for (int i = 0; i < n; i++)
			((ns2__GSNWebService_USCOREConfProcessor*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__GSNWebService_USCOREConfProcessor*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__GSNWebService_USCOREConfProcessor(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__GSNWebService_USCOREConfProcessor %p -> %p\n", q, p));
	*(ns2__GSNWebService_USCOREConfProcessor*)p = *(ns2__GSNWebService_USCOREConfProcessor*)q;
}

void ns2__GSNWebService_USCOREConfOutputStructure::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, &this->ns2__GSNWebService_USCOREConfOutputStructure::fields);
	/* transient soap skipped */
}

void ns2__GSNWebService_USCOREConfOutputStructure::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, &this->ns2__GSNWebService_USCOREConfOutputStructure::fields);
	/* transient soap skipped */
}

int ns2__GSNWebService_USCOREConfOutputStructure::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__GSNWebService_USCOREConfOutputStructure(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__GSNWebService_USCOREConfOutputStructure(struct soap *soap, const char *tag, int id, const ns2__GSNWebService_USCOREConfOutputStructure *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__GSNWebService_USCOREConfOutputStructure), type))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, "ns2:fields", -1, &(a->ns2__GSNWebService_USCOREConfOutputStructure::fields), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__GSNWebService_USCOREConfOutputStructure::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__GSNWebService_USCOREConfOutputStructure(soap, tag, this, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfOutputStructure * SOAP_FMAC4 soap_in_ns2__GSNWebService_USCOREConfOutputStructure(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREConfOutputStructure *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__GSNWebService_USCOREConfOutputStructure *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__GSNWebService_USCOREConfOutputStructure, sizeof(ns2__GSNWebService_USCOREConfOutputStructure), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__GSNWebService_USCOREConfOutputStructure)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__GSNWebService_USCOREConfOutputStructure *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, "ns2:fields", &(a->ns2__GSNWebService_USCOREConfOutputStructure::fields), "ns2:GSNWebService_DataField"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__GSNWebService_USCOREConfOutputStructure *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__GSNWebService_USCOREConfOutputStructure, 0, sizeof(ns2__GSNWebService_USCOREConfOutputStructure), 0, soap_copy_ns2__GSNWebService_USCOREConfOutputStructure);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__GSNWebService_USCOREConfOutputStructure::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__GSNWebService_USCOREConfOutputStructure);
	if (this->soap_out(soap, tag?tag:"ns2:GSNWebService_ConfOutputStructure", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__GSNWebService_USCOREConfOutputStructure::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__GSNWebService_USCOREConfOutputStructure(soap, this, tag, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfOutputStructure * SOAP_FMAC4 soap_get_ns2__GSNWebService_USCOREConfOutputStructure(struct soap *soap, ns2__GSNWebService_USCOREConfOutputStructure *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__GSNWebService_USCOREConfOutputStructure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__GSNWebService_USCOREConfOutputStructure * SOAP_FMAC2 soap_instantiate_ns2__GSNWebService_USCOREConfOutputStructure(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__GSNWebService_USCOREConfOutputStructure(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__GSNWebService_USCOREConfOutputStructure, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREConfOutputStructure);
		if (size)
			*size = sizeof(ns2__GSNWebService_USCOREConfOutputStructure);
		((ns2__GSNWebService_USCOREConfOutputStructure*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREConfOutputStructure[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__GSNWebService_USCOREConfOutputStructure);
		for (int i = 0; i < n; i++)
			((ns2__GSNWebService_USCOREConfOutputStructure*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__GSNWebService_USCOREConfOutputStructure*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__GSNWebService_USCOREConfOutputStructure(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__GSNWebService_USCOREConfOutputStructure %p -> %p\n", q, p));
	*(ns2__GSNWebService_USCOREConfOutputStructure*)p = *(ns2__GSNWebService_USCOREConfOutputStructure*)q;
}

void ns2__GSNWebService_USCOREConfInfo::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->ns2__GSNWebService_USCOREConfInfo::author = NULL;
	this->ns2__GSNWebService_USCOREConfInfo::description = NULL;
	this->ns2__GSNWebService_USCOREConfInfo::email = NULL;
	this->ns2__GSNWebService_USCOREConfInfo::rate = NULL;
	/* transient soap skipped */
}

void ns2__GSNWebService_USCOREConfInfo::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTostd__string(soap, &this->ns2__GSNWebService_USCOREConfInfo::author);
	soap_serialize_PointerTostd__string(soap, &this->ns2__GSNWebService_USCOREConfInfo::description);
	soap_serialize_PointerTostd__string(soap, &this->ns2__GSNWebService_USCOREConfInfo::email);
	soap_serialize_PointerTostd__string(soap, &this->ns2__GSNWebService_USCOREConfInfo::rate);
	/* transient soap skipped */
}

int ns2__GSNWebService_USCOREConfInfo::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__GSNWebService_USCOREConfInfo(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__GSNWebService_USCOREConfInfo(struct soap *soap, const char *tag, int id, const ns2__GSNWebService_USCOREConfInfo *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__GSNWebService_USCOREConfInfo), type))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns2:author", -1, &(a->ns2__GSNWebService_USCOREConfInfo::author), ""))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns2:description", -1, &(a->ns2__GSNWebService_USCOREConfInfo::description), ""))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns2:email", -1, &(a->ns2__GSNWebService_USCOREConfInfo::email), ""))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns2:rate", -1, &(a->ns2__GSNWebService_USCOREConfInfo::rate), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__GSNWebService_USCOREConfInfo::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__GSNWebService_USCOREConfInfo(soap, tag, this, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfInfo * SOAP_FMAC4 soap_in_ns2__GSNWebService_USCOREConfInfo(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREConfInfo *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__GSNWebService_USCOREConfInfo *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__GSNWebService_USCOREConfInfo, sizeof(ns2__GSNWebService_USCOREConfInfo), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__GSNWebService_USCOREConfInfo)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__GSNWebService_USCOREConfInfo *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_author1 = 1;
	size_t soap_flag_description1 = 1;
	size_t soap_flag_email1 = 1;
	size_t soap_flag_rate1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_author1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns2:author", &(a->ns2__GSNWebService_USCOREConfInfo::author), "xsd:string"))
				{	soap_flag_author1--;
					continue;
				}
			if (soap_flag_description1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns2:description", &(a->ns2__GSNWebService_USCOREConfInfo::description), "xsd:string"))
				{	soap_flag_description1--;
					continue;
				}
			if (soap_flag_email1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns2:email", &(a->ns2__GSNWebService_USCOREConfInfo::email), "xsd:string"))
				{	soap_flag_email1--;
					continue;
				}
			if (soap_flag_rate1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns2:rate", &(a->ns2__GSNWebService_USCOREConfInfo::rate), "xsd:string"))
				{	soap_flag_rate1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__GSNWebService_USCOREConfInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__GSNWebService_USCOREConfInfo, 0, sizeof(ns2__GSNWebService_USCOREConfInfo), 0, soap_copy_ns2__GSNWebService_USCOREConfInfo);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__GSNWebService_USCOREConfInfo::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__GSNWebService_USCOREConfInfo);
	if (this->soap_out(soap, tag?tag:"ns2:GSNWebService_ConfInfo", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__GSNWebService_USCOREConfInfo::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__GSNWebService_USCOREConfInfo(soap, this, tag, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfInfo * SOAP_FMAC4 soap_get_ns2__GSNWebService_USCOREConfInfo(struct soap *soap, ns2__GSNWebService_USCOREConfInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__GSNWebService_USCOREConfInfo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__GSNWebService_USCOREConfInfo * SOAP_FMAC2 soap_instantiate_ns2__GSNWebService_USCOREConfInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__GSNWebService_USCOREConfInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__GSNWebService_USCOREConfInfo, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREConfInfo);
		if (size)
			*size = sizeof(ns2__GSNWebService_USCOREConfInfo);
		((ns2__GSNWebService_USCOREConfInfo*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREConfInfo[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__GSNWebService_USCOREConfInfo);
		for (int i = 0; i < n; i++)
			((ns2__GSNWebService_USCOREConfInfo*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__GSNWebService_USCOREConfInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__GSNWebService_USCOREConfInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__GSNWebService_USCOREConfInfo %p -> %p\n", q, p));
	*(ns2__GSNWebService_USCOREConfInfo*)p = *(ns2__GSNWebService_USCOREConfInfo*)q;
}

void ns2__GSNWebService_USCOREConfPredicate::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->ns2__GSNWebService_USCOREConfPredicate::__item);
	soap_default_std__string(soap, &this->ns2__GSNWebService_USCOREConfPredicate::name);
	/* transient soap skipped */
}

void ns2__GSNWebService_USCOREConfPredicate::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->ns2__GSNWebService_USCOREConfPredicate::__item, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &this->ns2__GSNWebService_USCOREConfPredicate::__item);
	/* transient soap skipped */
}

int ns2__GSNWebService_USCOREConfPredicate::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__GSNWebService_USCOREConfPredicate(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__GSNWebService_USCOREConfPredicate(struct soap *soap, const char *tag, int id, const ns2__GSNWebService_USCOREConfPredicate *a, const char *type)
{
	soap_set_attr(soap, "ns2:name", ((ns2__GSNWebService_USCOREConfPredicate*)a)->name.c_str(), 1);
	return soap_out_std__string(soap, tag, id, &a->ns2__GSNWebService_USCOREConfPredicate::__item, "");
}

void *ns2__GSNWebService_USCOREConfPredicate::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__GSNWebService_USCOREConfPredicate(soap, tag, this, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfPredicate * SOAP_FMAC4 soap_in_ns2__GSNWebService_USCOREConfPredicate(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREConfPredicate *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (ns2__GSNWebService_USCOREConfPredicate *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__GSNWebService_USCOREConfPredicate, sizeof(ns2__GSNWebService_USCOREConfPredicate), soap->type, soap->arrayType)))
	{	soap->error = SOAP_TAG_MISMATCH;
		return NULL;
	}
	soap_revert(soap);
	*soap->id = '\0';
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__GSNWebService_USCOREConfPredicate)
			return (ns2__GSNWebService_USCOREConfPredicate *)a->soap_in(soap, tag, type);
	}
	{	const char *t = soap_attr_value(soap, "ns2:name", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns2__GSNWebService_USCOREConfPredicate*)a)->name.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	if (!soap_in_std__string(soap, tag, &(a->ns2__GSNWebService_USCOREConfPredicate::__item), "ns2:GSNWebService_ConfPredicate"))
		return NULL;
	return a;
}

int ns2__GSNWebService_USCOREConfPredicate::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__GSNWebService_USCOREConfPredicate);
	if (this->soap_out(soap, tag?tag:"ns2:GSNWebService_ConfPredicate", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__GSNWebService_USCOREConfPredicate::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__GSNWebService_USCOREConfPredicate(soap, this, tag, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfPredicate * SOAP_FMAC4 soap_get_ns2__GSNWebService_USCOREConfPredicate(struct soap *soap, ns2__GSNWebService_USCOREConfPredicate *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__GSNWebService_USCOREConfPredicate(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__GSNWebService_USCOREConfPredicate * SOAP_FMAC2 soap_instantiate_ns2__GSNWebService_USCOREConfPredicate(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__GSNWebService_USCOREConfPredicate(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__GSNWebService_USCOREConfPredicate, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREConfPredicate);
		if (size)
			*size = sizeof(ns2__GSNWebService_USCOREConfPredicate);
		((ns2__GSNWebService_USCOREConfPredicate*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREConfPredicate[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__GSNWebService_USCOREConfPredicate);
		for (int i = 0; i < n; i++)
			((ns2__GSNWebService_USCOREConfPredicate*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__GSNWebService_USCOREConfPredicate*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__GSNWebService_USCOREConfPredicate(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__GSNWebService_USCOREConfPredicate %p -> %p\n", q, p));
	*(ns2__GSNWebService_USCOREConfPredicate*)p = *(ns2__GSNWebService_USCOREConfPredicate*)q;
}

void ns2__GSNWebService_USCOREConfAddressing::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(soap, &this->ns2__GSNWebService_USCOREConfAddressing::predicates);
	/* transient soap skipped */
}

void ns2__GSNWebService_USCOREConfAddressing::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(soap, &this->ns2__GSNWebService_USCOREConfAddressing::predicates);
	/* transient soap skipped */
}

int ns2__GSNWebService_USCOREConfAddressing::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__GSNWebService_USCOREConfAddressing(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__GSNWebService_USCOREConfAddressing(struct soap *soap, const char *tag, int id, const ns2__GSNWebService_USCOREConfAddressing *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__GSNWebService_USCOREConfAddressing), type))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(soap, "ns2:predicates", -1, &(a->ns2__GSNWebService_USCOREConfAddressing::predicates), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__GSNWebService_USCOREConfAddressing::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__GSNWebService_USCOREConfAddressing(soap, tag, this, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfAddressing * SOAP_FMAC4 soap_in_ns2__GSNWebService_USCOREConfAddressing(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREConfAddressing *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__GSNWebService_USCOREConfAddressing *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__GSNWebService_USCOREConfAddressing, sizeof(ns2__GSNWebService_USCOREConfAddressing), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__GSNWebService_USCOREConfAddressing)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__GSNWebService_USCOREConfAddressing *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(soap, "ns2:predicates", &(a->ns2__GSNWebService_USCOREConfAddressing::predicates), "ns2:GSNWebService_ConfPredicate"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__GSNWebService_USCOREConfAddressing *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__GSNWebService_USCOREConfAddressing, 0, sizeof(ns2__GSNWebService_USCOREConfAddressing), 0, soap_copy_ns2__GSNWebService_USCOREConfAddressing);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__GSNWebService_USCOREConfAddressing::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__GSNWebService_USCOREConfAddressing);
	if (this->soap_out(soap, tag?tag:"ns2:GSNWebService_ConfAddressing", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__GSNWebService_USCOREConfAddressing::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__GSNWebService_USCOREConfAddressing(soap, this, tag, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfAddressing * SOAP_FMAC4 soap_get_ns2__GSNWebService_USCOREConfAddressing(struct soap *soap, ns2__GSNWebService_USCOREConfAddressing *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__GSNWebService_USCOREConfAddressing(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__GSNWebService_USCOREConfAddressing * SOAP_FMAC2 soap_instantiate_ns2__GSNWebService_USCOREConfAddressing(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__GSNWebService_USCOREConfAddressing(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__GSNWebService_USCOREConfAddressing, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREConfAddressing);
		if (size)
			*size = sizeof(ns2__GSNWebService_USCOREConfAddressing);
		((ns2__GSNWebService_USCOREConfAddressing*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREConfAddressing[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__GSNWebService_USCOREConfAddressing);
		for (int i = 0; i < n; i++)
			((ns2__GSNWebService_USCOREConfAddressing*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__GSNWebService_USCOREConfAddressing*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__GSNWebService_USCOREConfAddressing(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__GSNWebService_USCOREConfAddressing %p -> %p\n", q, p));
	*(ns2__GSNWebService_USCOREConfAddressing*)p = *(ns2__GSNWebService_USCOREConfAddressing*)q;
}

void ns2__GSNWebService_USCOREVirtualSensorDetails::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->ns2__GSNWebService_USCOREVirtualSensorDetails::addressing = NULL;
	this->ns2__GSNWebService_USCOREVirtualSensorDetails::info = NULL;
	this->ns2__GSNWebService_USCOREVirtualSensorDetails::outputStructure = NULL;
	this->ns2__GSNWebService_USCOREVirtualSensorDetails::processor = NULL;
	this->ns2__GSNWebService_USCOREVirtualSensorDetails::wrapper = NULL;
	soap_default_std__string(soap, &this->ns2__GSNWebService_USCOREVirtualSensorDetails::vsname);
	/* transient soap skipped */
}

void ns2__GSNWebService_USCOREVirtualSensorDetails::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__GSNWebService_USCOREConfAddressing(soap, &this->ns2__GSNWebService_USCOREVirtualSensorDetails::addressing);
	soap_serialize_PointerTons2__GSNWebService_USCOREConfInfo(soap, &this->ns2__GSNWebService_USCOREVirtualSensorDetails::info);
	soap_serialize_PointerTons2__GSNWebService_USCOREConfOutputStructure(soap, &this->ns2__GSNWebService_USCOREVirtualSensorDetails::outputStructure);
	soap_serialize_PointerTons2__GSNWebService_USCOREConfProcessor(soap, &this->ns2__GSNWebService_USCOREVirtualSensorDetails::processor);
	soap_serialize_PointerTons2__GSNWebService_USCOREConfWrapper(soap, &this->ns2__GSNWebService_USCOREVirtualSensorDetails::wrapper);
	/* transient soap skipped */
}

int ns2__GSNWebService_USCOREVirtualSensorDetails::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__GSNWebService_USCOREVirtualSensorDetails(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__GSNWebService_USCOREVirtualSensorDetails(struct soap *soap, const char *tag, int id, const ns2__GSNWebService_USCOREVirtualSensorDetails *a, const char *type)
{
	soap_set_attr(soap, "ns2:vsname", ((ns2__GSNWebService_USCOREVirtualSensorDetails*)a)->vsname.c_str(), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__GSNWebService_USCOREVirtualSensorDetails), type))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREConfAddressing(soap, "ns2:addressing", -1, &(a->ns2__GSNWebService_USCOREVirtualSensorDetails::addressing), ""))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREConfInfo(soap, "ns2:info", -1, &(a->ns2__GSNWebService_USCOREVirtualSensorDetails::info), ""))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREConfOutputStructure(soap, "ns2:outputStructure", -1, &(a->ns2__GSNWebService_USCOREVirtualSensorDetails::outputStructure), ""))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREConfProcessor(soap, "ns2:processor", -1, &(a->ns2__GSNWebService_USCOREVirtualSensorDetails::processor), ""))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREConfWrapper(soap, "ns2:wrapper", -1, &(a->ns2__GSNWebService_USCOREVirtualSensorDetails::wrapper), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__GSNWebService_USCOREVirtualSensorDetails::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__GSNWebService_USCOREVirtualSensorDetails(soap, tag, this, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREVirtualSensorDetails * SOAP_FMAC4 soap_in_ns2__GSNWebService_USCOREVirtualSensorDetails(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREVirtualSensorDetails *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__GSNWebService_USCOREVirtualSensorDetails *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__GSNWebService_USCOREVirtualSensorDetails, sizeof(ns2__GSNWebService_USCOREVirtualSensorDetails), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__GSNWebService_USCOREVirtualSensorDetails)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__GSNWebService_USCOREVirtualSensorDetails *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "ns2:vsname", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns2__GSNWebService_USCOREVirtualSensorDetails*)a)->vsname.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	size_t soap_flag_addressing1 = 1;
	size_t soap_flag_info1 = 1;
	size_t soap_flag_outputStructure1 = 1;
	size_t soap_flag_processor1 = 1;
	size_t soap_flag_wrapper1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_addressing1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREConfAddressing(soap, "ns2:addressing", &(a->ns2__GSNWebService_USCOREVirtualSensorDetails::addressing), "ns2:GSNWebService_ConfAddressing"))
				{	soap_flag_addressing1--;
					continue;
				}
			if (soap_flag_info1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREConfInfo(soap, "ns2:info", &(a->ns2__GSNWebService_USCOREVirtualSensorDetails::info), "ns2:GSNWebService_ConfInfo"))
				{	soap_flag_info1--;
					continue;
				}
			if (soap_flag_outputStructure1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREConfOutputStructure(soap, "ns2:outputStructure", &(a->ns2__GSNWebService_USCOREVirtualSensorDetails::outputStructure), "ns2:GSNWebService_ConfOutputStructure"))
				{	soap_flag_outputStructure1--;
					continue;
				}
			if (soap_flag_processor1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREConfProcessor(soap, "ns2:processor", &(a->ns2__GSNWebService_USCOREVirtualSensorDetails::processor), "ns2:GSNWebService_ConfProcessor"))
				{	soap_flag_processor1--;
					continue;
				}
			if (soap_flag_wrapper1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREConfWrapper(soap, "ns2:wrapper", &(a->ns2__GSNWebService_USCOREVirtualSensorDetails::wrapper), "ns2:GSNWebService_ConfWrapper"))
				{	soap_flag_wrapper1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__GSNWebService_USCOREVirtualSensorDetails *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__GSNWebService_USCOREVirtualSensorDetails, 0, sizeof(ns2__GSNWebService_USCOREVirtualSensorDetails), 0, soap_copy_ns2__GSNWebService_USCOREVirtualSensorDetails);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__GSNWebService_USCOREVirtualSensorDetails::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__GSNWebService_USCOREVirtualSensorDetails);
	if (this->soap_out(soap, tag?tag:"ns2:GSNWebService_VirtualSensorDetails", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__GSNWebService_USCOREVirtualSensorDetails::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__GSNWebService_USCOREVirtualSensorDetails(soap, this, tag, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREVirtualSensorDetails * SOAP_FMAC4 soap_get_ns2__GSNWebService_USCOREVirtualSensorDetails(struct soap *soap, ns2__GSNWebService_USCOREVirtualSensorDetails *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__GSNWebService_USCOREVirtualSensorDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__GSNWebService_USCOREVirtualSensorDetails * SOAP_FMAC2 soap_instantiate_ns2__GSNWebService_USCOREVirtualSensorDetails(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__GSNWebService_USCOREVirtualSensorDetails(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__GSNWebService_USCOREVirtualSensorDetails, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREVirtualSensorDetails);
		if (size)
			*size = sizeof(ns2__GSNWebService_USCOREVirtualSensorDetails);
		((ns2__GSNWebService_USCOREVirtualSensorDetails*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREVirtualSensorDetails[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__GSNWebService_USCOREVirtualSensorDetails);
		for (int i = 0; i < n; i++)
			((ns2__GSNWebService_USCOREVirtualSensorDetails*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__GSNWebService_USCOREVirtualSensorDetails*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__GSNWebService_USCOREVirtualSensorDetails(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__GSNWebService_USCOREVirtualSensorDetails %p -> %p\n", q, p));
	*(ns2__GSNWebService_USCOREVirtualSensorDetails*)p = *(ns2__GSNWebService_USCOREVirtualSensorDetails*)q;
}

void ns2__GSNWebService_USCOREDataField::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->ns2__GSNWebService_USCOREDataField::__item);
	this->ns2__GSNWebService_USCOREDataField::name = NULL;
	this->ns2__GSNWebService_USCOREDataField::type = NULL;
	this->ns2__GSNWebService_USCOREDataField::description = NULL;
	/* transient soap skipped */
}

void ns2__GSNWebService_USCOREDataField::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->ns2__GSNWebService_USCOREDataField::__item, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &this->ns2__GSNWebService_USCOREDataField::__item);
	/* transient soap skipped */
}

int ns2__GSNWebService_USCOREDataField::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__GSNWebService_USCOREDataField(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__GSNWebService_USCOREDataField(struct soap *soap, const char *tag, int id, const ns2__GSNWebService_USCOREDataField *a, const char *type)
{
	if (((ns2__GSNWebService_USCOREDataField*)a)->name)
		soap_set_attr(soap, "ns2:name", ((ns2__GSNWebService_USCOREDataField*)a)->name->c_str(), 1);
	if (((ns2__GSNWebService_USCOREDataField*)a)->type)
		soap_set_attr(soap, "ns2:type", ((ns2__GSNWebService_USCOREDataField*)a)->type->c_str(), 1);
	if (((ns2__GSNWebService_USCOREDataField*)a)->description)
		soap_set_attr(soap, "ns2:description", ((ns2__GSNWebService_USCOREDataField*)a)->description->c_str(), 1);
	return soap_out_std__string(soap, tag, id, &a->ns2__GSNWebService_USCOREDataField::__item, "");
}

void *ns2__GSNWebService_USCOREDataField::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__GSNWebService_USCOREDataField(soap, tag, this, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREDataField * SOAP_FMAC4 soap_in_ns2__GSNWebService_USCOREDataField(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREDataField *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (ns2__GSNWebService_USCOREDataField *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__GSNWebService_USCOREDataField, sizeof(ns2__GSNWebService_USCOREDataField), soap->type, soap->arrayType)))
	{	soap->error = SOAP_TAG_MISMATCH;
		return NULL;
	}
	soap_revert(soap);
	*soap->id = '\0';
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__GSNWebService_USCOREDataField)
			return (ns2__GSNWebService_USCOREDataField *)a->soap_in(soap, tag, type);
	}
	{	const char *t = soap_attr_value(soap, "ns2:name", 0);
		if (t)
		{
			char *s = NULL;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			if (s)
			{	((ns2__GSNWebService_USCOREDataField*)a)->name = soap_new_std__string(soap, -1);
				((ns2__GSNWebService_USCOREDataField*)a)->name->assign(s);
			}
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "ns2:type", 0);
		if (t)
		{
			char *s = NULL;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			if (s)
			{	((ns2__GSNWebService_USCOREDataField*)a)->type = soap_new_std__string(soap, -1);
				((ns2__GSNWebService_USCOREDataField*)a)->type->assign(s);
			}
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "ns2:description", 0);
		if (t)
		{
			char *s = NULL;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			if (s)
			{	((ns2__GSNWebService_USCOREDataField*)a)->description = soap_new_std__string(soap, -1);
				((ns2__GSNWebService_USCOREDataField*)a)->description->assign(s);
			}
		}
		else if (soap->error)
			return NULL;
	}
	if (!soap_in_std__string(soap, tag, &(a->ns2__GSNWebService_USCOREDataField::__item), "ns2:GSNWebService_DataField"))
		return NULL;
	return a;
}

int ns2__GSNWebService_USCOREDataField::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__GSNWebService_USCOREDataField);
	if (this->soap_out(soap, tag?tag:"ns2:GSNWebService_DataField", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__GSNWebService_USCOREDataField::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__GSNWebService_USCOREDataField(soap, this, tag, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREDataField * SOAP_FMAC4 soap_get_ns2__GSNWebService_USCOREDataField(struct soap *soap, ns2__GSNWebService_USCOREDataField *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__GSNWebService_USCOREDataField(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__GSNWebService_USCOREDataField * SOAP_FMAC2 soap_instantiate_ns2__GSNWebService_USCOREDataField(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__GSNWebService_USCOREDataField(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__GSNWebService_USCOREDataField, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREDataField);
		if (size)
			*size = sizeof(ns2__GSNWebService_USCOREDataField);
		((ns2__GSNWebService_USCOREDataField*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREDataField[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__GSNWebService_USCOREDataField);
		for (int i = 0; i < n; i++)
			((ns2__GSNWebService_USCOREDataField*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__GSNWebService_USCOREDataField*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__GSNWebService_USCOREDataField(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__GSNWebService_USCOREDataField %p -> %p\n", q, p));
	*(ns2__GSNWebService_USCOREDataField*)p = *(ns2__GSNWebService_USCOREDataField*)q;
}

void ns2__GSNWebService_USCOREStreamElement::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, &this->ns2__GSNWebService_USCOREStreamElement::field);
	this->ns2__GSNWebService_USCOREStreamElement::timed = NULL;
	/* transient soap skipped */
}

void ns2__GSNWebService_USCOREStreamElement::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, &this->ns2__GSNWebService_USCOREStreamElement::field);
	/* transient soap skipped */
}

int ns2__GSNWebService_USCOREStreamElement::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__GSNWebService_USCOREStreamElement(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__GSNWebService_USCOREStreamElement(struct soap *soap, const char *tag, int id, const ns2__GSNWebService_USCOREStreamElement *a, const char *type)
{
	if (((ns2__GSNWebService_USCOREStreamElement*)a)->timed)
		soap_set_attr(soap, "ns2:timed", ((ns2__GSNWebService_USCOREStreamElement*)a)->timed->c_str(), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__GSNWebService_USCOREStreamElement), type))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, "ns2:field", -1, &(a->ns2__GSNWebService_USCOREStreamElement::field), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__GSNWebService_USCOREStreamElement::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__GSNWebService_USCOREStreamElement(soap, tag, this, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREStreamElement * SOAP_FMAC4 soap_in_ns2__GSNWebService_USCOREStreamElement(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREStreamElement *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__GSNWebService_USCOREStreamElement *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__GSNWebService_USCOREStreamElement, sizeof(ns2__GSNWebService_USCOREStreamElement), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__GSNWebService_USCOREStreamElement)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__GSNWebService_USCOREStreamElement *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "ns2:timed", 0);
		if (t)
		{
			char *s = NULL;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			if (s)
			{	((ns2__GSNWebService_USCOREStreamElement*)a)->timed = soap_new_std__string(soap, -1);
				((ns2__GSNWebService_USCOREStreamElement*)a)->timed->assign(s);
			}
		}
		else if (soap->error)
			return NULL;
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, "ns2:field", &(a->ns2__GSNWebService_USCOREStreamElement::field), "ns2:GSNWebService_DataField"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__GSNWebService_USCOREStreamElement *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__GSNWebService_USCOREStreamElement, 0, sizeof(ns2__GSNWebService_USCOREStreamElement), 0, soap_copy_ns2__GSNWebService_USCOREStreamElement);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__GSNWebService_USCOREStreamElement::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__GSNWebService_USCOREStreamElement);
	if (this->soap_out(soap, tag?tag:"ns2:GSNWebService_StreamElement", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__GSNWebService_USCOREStreamElement::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__GSNWebService_USCOREStreamElement(soap, this, tag, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREStreamElement * SOAP_FMAC4 soap_get_ns2__GSNWebService_USCOREStreamElement(struct soap *soap, ns2__GSNWebService_USCOREStreamElement *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__GSNWebService_USCOREStreamElement(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__GSNWebService_USCOREStreamElement * SOAP_FMAC2 soap_instantiate_ns2__GSNWebService_USCOREStreamElement(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__GSNWebService_USCOREStreamElement(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__GSNWebService_USCOREStreamElement, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREStreamElement);
		if (size)
			*size = sizeof(ns2__GSNWebService_USCOREStreamElement);
		((ns2__GSNWebService_USCOREStreamElement*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREStreamElement[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__GSNWebService_USCOREStreamElement);
		for (int i = 0; i < n; i++)
			((ns2__GSNWebService_USCOREStreamElement*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__GSNWebService_USCOREStreamElement*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__GSNWebService_USCOREStreamElement(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__GSNWebService_USCOREStreamElement %p -> %p\n", q, p));
	*(ns2__GSNWebService_USCOREStreamElement*)p = *(ns2__GSNWebService_USCOREStreamElement*)q;
}

void ns2__GSNWebService_USCOREQueryResult::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->ns2__GSNWebService_USCOREQueryResult::format = NULL;
	soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement(soap, &this->ns2__GSNWebService_USCOREQueryResult::streamElements);
	this->ns2__GSNWebService_USCOREQueryResult::executedQuery = NULL;
	soap_default_bool(soap, &this->ns2__GSNWebService_USCOREQueryResult::hasNext);
	soap_default_std__string(soap, &this->ns2__GSNWebService_USCOREQueryResult::vsname);
	soap_default_std__string(soap, &this->ns2__GSNWebService_USCOREQueryResult::sid);
	/* transient soap skipped */
}

void ns2__GSNWebService_USCOREQueryResult::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__GSNWebService_USCOREStreamElement(soap, &this->ns2__GSNWebService_USCOREQueryResult::format);
	soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement(soap, &this->ns2__GSNWebService_USCOREQueryResult::streamElements);
	soap_serialize_PointerTostd__string(soap, &this->ns2__GSNWebService_USCOREQueryResult::executedQuery);
	/* transient soap skipped */
}

int ns2__GSNWebService_USCOREQueryResult::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__GSNWebService_USCOREQueryResult(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__GSNWebService_USCOREQueryResult(struct soap *soap, const char *tag, int id, const ns2__GSNWebService_USCOREQueryResult *a, const char *type)
{
	soap_set_attr(soap, "ns2:hasNext", soap_bool2s(soap, ((ns2__GSNWebService_USCOREQueryResult*)a)->hasNext), 1);
	soap_set_attr(soap, "ns2:vsname", ((ns2__GSNWebService_USCOREQueryResult*)a)->vsname.c_str(), 1);
	soap_set_attr(soap, "ns2:sid", ((ns2__GSNWebService_USCOREQueryResult*)a)->sid.c_str(), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__GSNWebService_USCOREQueryResult), type))
		return soap->error;
	if (soap_out_PointerTons2__GSNWebService_USCOREStreamElement(soap, "ns2:format", -1, &(a->ns2__GSNWebService_USCOREQueryResult::format), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement(soap, "ns2:streamElements", -1, &(a->ns2__GSNWebService_USCOREQueryResult::streamElements), ""))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns2:executedQuery", -1, &(a->ns2__GSNWebService_USCOREQueryResult::executedQuery), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__GSNWebService_USCOREQueryResult::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__GSNWebService_USCOREQueryResult(soap, tag, this, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREQueryResult * SOAP_FMAC4 soap_in_ns2__GSNWebService_USCOREQueryResult(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREQueryResult *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__GSNWebService_USCOREQueryResult *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__GSNWebService_USCOREQueryResult, sizeof(ns2__GSNWebService_USCOREQueryResult), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__GSNWebService_USCOREQueryResult)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__GSNWebService_USCOREQueryResult *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2bool(soap, soap_attr_value(soap, "ns2:hasNext", 1), &((ns2__GSNWebService_USCOREQueryResult*)a)->hasNext))
		return NULL;
	{	const char *t = soap_attr_value(soap, "ns2:vsname", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns2__GSNWebService_USCOREQueryResult*)a)->vsname.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "ns2:sid", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns2__GSNWebService_USCOREQueryResult*)a)->sid.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	size_t soap_flag_format1 = 1;
	size_t soap_flag_executedQuery1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_format1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__GSNWebService_USCOREStreamElement(soap, "ns2:format", &(a->ns2__GSNWebService_USCOREQueryResult::format), "ns2:GSNWebService_StreamElement"))
				{	soap_flag_format1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement(soap, "ns2:streamElements", &(a->ns2__GSNWebService_USCOREQueryResult::streamElements), "ns2:GSNWebService_StreamElement"))
					continue;
			if (soap_flag_executedQuery1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns2:executedQuery", &(a->ns2__GSNWebService_USCOREQueryResult::executedQuery), "xsd:string"))
				{	soap_flag_executedQuery1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__GSNWebService_USCOREQueryResult *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__GSNWebService_USCOREQueryResult, 0, sizeof(ns2__GSNWebService_USCOREQueryResult), 0, soap_copy_ns2__GSNWebService_USCOREQueryResult);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__GSNWebService_USCOREQueryResult::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__GSNWebService_USCOREQueryResult);
	if (this->soap_out(soap, tag?tag:"ns2:GSNWebService_QueryResult", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__GSNWebService_USCOREQueryResult::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__GSNWebService_USCOREQueryResult(soap, this, tag, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREQueryResult * SOAP_FMAC4 soap_get_ns2__GSNWebService_USCOREQueryResult(struct soap *soap, ns2__GSNWebService_USCOREQueryResult *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__GSNWebService_USCOREQueryResult(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__GSNWebService_USCOREQueryResult * SOAP_FMAC2 soap_instantiate_ns2__GSNWebService_USCOREQueryResult(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__GSNWebService_USCOREQueryResult(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__GSNWebService_USCOREQueryResult, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREQueryResult);
		if (size)
			*size = sizeof(ns2__GSNWebService_USCOREQueryResult);
		((ns2__GSNWebService_USCOREQueryResult*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREQueryResult[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__GSNWebService_USCOREQueryResult);
		for (int i = 0; i < n; i++)
			((ns2__GSNWebService_USCOREQueryResult*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__GSNWebService_USCOREQueryResult*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__GSNWebService_USCOREQueryResult(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__GSNWebService_USCOREQueryResult %p -> %p\n", q, p));
	*(ns2__GSNWebService_USCOREQueryResult*)p = *(ns2__GSNWebService_USCOREQueryResult*)q;
}

void ns2__GSNWebService_USCOREFieldSelector::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfstd__string(soap, &this->ns2__GSNWebService_USCOREFieldSelector::fieldNames);
	soap_default_std__string(soap, &this->ns2__GSNWebService_USCOREFieldSelector::vsname);
	/* transient soap skipped */
}

void ns2__GSNWebService_USCOREFieldSelector::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfstd__string(soap, &this->ns2__GSNWebService_USCOREFieldSelector::fieldNames);
	/* transient soap skipped */
}

int ns2__GSNWebService_USCOREFieldSelector::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__GSNWebService_USCOREFieldSelector(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__GSNWebService_USCOREFieldSelector(struct soap *soap, const char *tag, int id, const ns2__GSNWebService_USCOREFieldSelector *a, const char *type)
{
	soap_set_attr(soap, "ns2:vsname", ((ns2__GSNWebService_USCOREFieldSelector*)a)->vsname.c_str(), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__GSNWebService_USCOREFieldSelector), type))
		return soap->error;
	if (soap_out_std__vectorTemplateOfstd__string(soap, "ns2:fieldNames", -1, &(a->ns2__GSNWebService_USCOREFieldSelector::fieldNames), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__GSNWebService_USCOREFieldSelector::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__GSNWebService_USCOREFieldSelector(soap, tag, this, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREFieldSelector * SOAP_FMAC4 soap_in_ns2__GSNWebService_USCOREFieldSelector(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREFieldSelector *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__GSNWebService_USCOREFieldSelector *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__GSNWebService_USCOREFieldSelector, sizeof(ns2__GSNWebService_USCOREFieldSelector), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__GSNWebService_USCOREFieldSelector)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__GSNWebService_USCOREFieldSelector *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "ns2:vsname", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s, 0, -1))
				return NULL;
			((ns2__GSNWebService_USCOREFieldSelector*)a)->vsname.assign(s);
		}
		else if (soap->error)
			return NULL;
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfstd__string(soap, "ns2:fieldNames", &(a->ns2__GSNWebService_USCOREFieldSelector::fieldNames), "xsd:string"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__GSNWebService_USCOREFieldSelector *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__GSNWebService_USCOREFieldSelector, 0, sizeof(ns2__GSNWebService_USCOREFieldSelector), 0, soap_copy_ns2__GSNWebService_USCOREFieldSelector);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__GSNWebService_USCOREFieldSelector::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__GSNWebService_USCOREFieldSelector);
	if (this->soap_out(soap, tag?tag:"ns2:GSNWebService_FieldSelector", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__GSNWebService_USCOREFieldSelector::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__GSNWebService_USCOREFieldSelector(soap, this, tag, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREFieldSelector * SOAP_FMAC4 soap_get_ns2__GSNWebService_USCOREFieldSelector(struct soap *soap, ns2__GSNWebService_USCOREFieldSelector *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__GSNWebService_USCOREFieldSelector(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__GSNWebService_USCOREFieldSelector * SOAP_FMAC2 soap_instantiate_ns2__GSNWebService_USCOREFieldSelector(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__GSNWebService_USCOREFieldSelector(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__GSNWebService_USCOREFieldSelector, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREFieldSelector);
		if (size)
			*size = sizeof(ns2__GSNWebService_USCOREFieldSelector);
		((ns2__GSNWebService_USCOREFieldSelector*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREFieldSelector[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__GSNWebService_USCOREFieldSelector);
		for (int i = 0; i < n; i++)
			((ns2__GSNWebService_USCOREFieldSelector*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__GSNWebService_USCOREFieldSelector*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__GSNWebService_USCOREFieldSelector(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__GSNWebService_USCOREFieldSelector %p -> %p\n", q, p));
	*(ns2__GSNWebService_USCOREFieldSelector*)p = *(ns2__GSNWebService_USCOREFieldSelector*)q;
}

void ns2__GSNWebService_USCOREContainerDetails::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_int(soap, &this->ns2__GSNWebService_USCOREContainerDetails::port);
	this->ns2__GSNWebService_USCOREContainerDetails::sslPort = NULL;
	this->ns2__GSNWebService_USCOREContainerDetails::author = NULL;
	this->ns2__GSNWebService_USCOREContainerDetails::description = NULL;
	this->ns2__GSNWebService_USCOREContainerDetails::email = NULL;
	this->ns2__GSNWebService_USCOREContainerDetails::name = NULL;
	this->ns2__GSNWebService_USCOREContainerDetails::sslKeyPassword = NULL;
	this->ns2__GSNWebService_USCOREContainerDetails::sslKeystorePassword = NULL;
	this->ns2__GSNWebService_USCOREContainerDetails::timeFormat = NULL;
	/* transient soap skipped */
}

void ns2__GSNWebService_USCOREContainerDetails::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->ns2__GSNWebService_USCOREContainerDetails::port, SOAP_TYPE_int);
	soap_serialize_PointerToint(soap, &this->ns2__GSNWebService_USCOREContainerDetails::sslPort);
	soap_serialize_PointerTostd__string(soap, &this->ns2__GSNWebService_USCOREContainerDetails::author);
	soap_serialize_PointerTostd__string(soap, &this->ns2__GSNWebService_USCOREContainerDetails::description);
	soap_serialize_PointerTostd__string(soap, &this->ns2__GSNWebService_USCOREContainerDetails::email);
	soap_serialize_PointerTostd__string(soap, &this->ns2__GSNWebService_USCOREContainerDetails::name);
	soap_serialize_PointerTostd__string(soap, &this->ns2__GSNWebService_USCOREContainerDetails::sslKeyPassword);
	soap_serialize_PointerTostd__string(soap, &this->ns2__GSNWebService_USCOREContainerDetails::sslKeystorePassword);
	soap_serialize_PointerTostd__string(soap, &this->ns2__GSNWebService_USCOREContainerDetails::timeFormat);
	/* transient soap skipped */
}

int ns2__GSNWebService_USCOREContainerDetails::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__GSNWebService_USCOREContainerDetails(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__GSNWebService_USCOREContainerDetails(struct soap *soap, const char *tag, int id, const ns2__GSNWebService_USCOREContainerDetails *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__GSNWebService_USCOREContainerDetails), type))
		return soap->error;
	if (soap_out_int(soap, "ns2:port", -1, &(a->ns2__GSNWebService_USCOREContainerDetails::port), ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "ns2:sslPort", -1, &(a->ns2__GSNWebService_USCOREContainerDetails::sslPort), ""))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns2:author", -1, &(a->ns2__GSNWebService_USCOREContainerDetails::author), ""))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns2:description", -1, &(a->ns2__GSNWebService_USCOREContainerDetails::description), ""))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns2:email", -1, &(a->ns2__GSNWebService_USCOREContainerDetails::email), ""))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns2:name", -1, &(a->ns2__GSNWebService_USCOREContainerDetails::name), ""))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns2:sslKeyPassword", -1, &(a->ns2__GSNWebService_USCOREContainerDetails::sslKeyPassword), ""))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns2:sslKeystorePassword", -1, &(a->ns2__GSNWebService_USCOREContainerDetails::sslKeystorePassword), ""))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns2:timeFormat", -1, &(a->ns2__GSNWebService_USCOREContainerDetails::timeFormat), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__GSNWebService_USCOREContainerDetails::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__GSNWebService_USCOREContainerDetails(soap, tag, this, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREContainerDetails * SOAP_FMAC4 soap_in_ns2__GSNWebService_USCOREContainerDetails(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREContainerDetails *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__GSNWebService_USCOREContainerDetails *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__GSNWebService_USCOREContainerDetails, sizeof(ns2__GSNWebService_USCOREContainerDetails), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__GSNWebService_USCOREContainerDetails)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__GSNWebService_USCOREContainerDetails *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_port1 = 1;
	size_t soap_flag_sslPort1 = 1;
	size_t soap_flag_author1 = 1;
	size_t soap_flag_description1 = 1;
	size_t soap_flag_email1 = 1;
	size_t soap_flag_name1 = 1;
	size_t soap_flag_sslKeyPassword1 = 1;
	size_t soap_flag_sslKeystorePassword1 = 1;
	size_t soap_flag_timeFormat1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_port1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "ns2:port", &(a->ns2__GSNWebService_USCOREContainerDetails::port), "xsd:int"))
				{	soap_flag_port1--;
					continue;
				}
			if (soap_flag_sslPort1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "ns2:sslPort", &(a->ns2__GSNWebService_USCOREContainerDetails::sslPort), "xsd:int"))
				{	soap_flag_sslPort1--;
					continue;
				}
			if (soap_flag_author1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns2:author", &(a->ns2__GSNWebService_USCOREContainerDetails::author), "xsd:string"))
				{	soap_flag_author1--;
					continue;
				}
			if (soap_flag_description1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns2:description", &(a->ns2__GSNWebService_USCOREContainerDetails::description), "xsd:string"))
				{	soap_flag_description1--;
					continue;
				}
			if (soap_flag_email1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns2:email", &(a->ns2__GSNWebService_USCOREContainerDetails::email), "xsd:string"))
				{	soap_flag_email1--;
					continue;
				}
			if (soap_flag_name1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns2:name", &(a->ns2__GSNWebService_USCOREContainerDetails::name), "xsd:string"))
				{	soap_flag_name1--;
					continue;
				}
			if (soap_flag_sslKeyPassword1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns2:sslKeyPassword", &(a->ns2__GSNWebService_USCOREContainerDetails::sslKeyPassword), "xsd:string"))
				{	soap_flag_sslKeyPassword1--;
					continue;
				}
			if (soap_flag_sslKeystorePassword1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns2:sslKeystorePassword", &(a->ns2__GSNWebService_USCOREContainerDetails::sslKeystorePassword), "xsd:string"))
				{	soap_flag_sslKeystorePassword1--;
					continue;
				}
			if (soap_flag_timeFormat1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns2:timeFormat", &(a->ns2__GSNWebService_USCOREContainerDetails::timeFormat), "xsd:string"))
				{	soap_flag_timeFormat1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__GSNWebService_USCOREContainerDetails *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__GSNWebService_USCOREContainerDetails, 0, sizeof(ns2__GSNWebService_USCOREContainerDetails), 0, soap_copy_ns2__GSNWebService_USCOREContainerDetails);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_port1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int ns2__GSNWebService_USCOREContainerDetails::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__GSNWebService_USCOREContainerDetails);
	if (this->soap_out(soap, tag?tag:"ns2:GSNWebService_ContainerDetails", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__GSNWebService_USCOREContainerDetails::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__GSNWebService_USCOREContainerDetails(soap, this, tag, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREContainerDetails * SOAP_FMAC4 soap_get_ns2__GSNWebService_USCOREContainerDetails(struct soap *soap, ns2__GSNWebService_USCOREContainerDetails *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__GSNWebService_USCOREContainerDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__GSNWebService_USCOREContainerDetails * SOAP_FMAC2 soap_instantiate_ns2__GSNWebService_USCOREContainerDetails(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__GSNWebService_USCOREContainerDetails(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__GSNWebService_USCOREContainerDetails, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREContainerDetails);
		if (size)
			*size = sizeof(ns2__GSNWebService_USCOREContainerDetails);
		((ns2__GSNWebService_USCOREContainerDetails*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREContainerDetails[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__GSNWebService_USCOREContainerDetails);
		for (int i = 0; i < n; i++)
			((ns2__GSNWebService_USCOREContainerDetails*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__GSNWebService_USCOREContainerDetails*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__GSNWebService_USCOREContainerDetails(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__GSNWebService_USCOREContainerDetails %p -> %p\n", q, p));
	*(ns2__GSNWebService_USCOREContainerDetails*)p = *(ns2__GSNWebService_USCOREContainerDetails*)q;
}

void ns2__GSNWebService_USCOREACDetails::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->ns2__GSNWebService_USCOREACDetails::username);
	soap_default_std__string(soap, &this->ns2__GSNWebService_USCOREACDetails::password);
	/* transient soap skipped */
}

void ns2__GSNWebService_USCOREACDetails::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->ns2__GSNWebService_USCOREACDetails::username, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &this->ns2__GSNWebService_USCOREACDetails::username);
	soap_embedded(soap, &this->ns2__GSNWebService_USCOREACDetails::password, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &this->ns2__GSNWebService_USCOREACDetails::password);
	/* transient soap skipped */
}

int ns2__GSNWebService_USCOREACDetails::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__GSNWebService_USCOREACDetails(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__GSNWebService_USCOREACDetails(struct soap *soap, const char *tag, int id, const ns2__GSNWebService_USCOREACDetails *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__GSNWebService_USCOREACDetails), type))
		return soap->error;
	if (soap_out_std__string(soap, "ns2:username", -1, &(a->ns2__GSNWebService_USCOREACDetails::username), ""))
		return soap->error;
	if (soap_out_std__string(soap, "ns2:password", -1, &(a->ns2__GSNWebService_USCOREACDetails::password), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__GSNWebService_USCOREACDetails::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__GSNWebService_USCOREACDetails(soap, tag, this, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREACDetails * SOAP_FMAC4 soap_in_ns2__GSNWebService_USCOREACDetails(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREACDetails *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__GSNWebService_USCOREACDetails *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__GSNWebService_USCOREACDetails, sizeof(ns2__GSNWebService_USCOREACDetails), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__GSNWebService_USCOREACDetails)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__GSNWebService_USCOREACDetails *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_username1 = 1;
	size_t soap_flag_password1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_username1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "ns2:username", &(a->ns2__GSNWebService_USCOREACDetails::username), "xsd:string"))
				{	soap_flag_username1--;
					continue;
				}
			if (soap_flag_password1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "ns2:password", &(a->ns2__GSNWebService_USCOREACDetails::password), "xsd:string"))
				{	soap_flag_password1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__GSNWebService_USCOREACDetails *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__GSNWebService_USCOREACDetails, 0, sizeof(ns2__GSNWebService_USCOREACDetails), 0, soap_copy_ns2__GSNWebService_USCOREACDetails);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_username1 > 0 || soap_flag_password1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int ns2__GSNWebService_USCOREACDetails::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__GSNWebService_USCOREACDetails);
	if (this->soap_out(soap, tag?tag:"ns2:GSNWebService_ACDetails", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__GSNWebService_USCOREACDetails::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__GSNWebService_USCOREACDetails(soap, this, tag, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREACDetails * SOAP_FMAC4 soap_get_ns2__GSNWebService_USCOREACDetails(struct soap *soap, ns2__GSNWebService_USCOREACDetails *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__GSNWebService_USCOREACDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__GSNWebService_USCOREACDetails * SOAP_FMAC2 soap_instantiate_ns2__GSNWebService_USCOREACDetails(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__GSNWebService_USCOREACDetails(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__GSNWebService_USCOREACDetails, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREACDetails);
		if (size)
			*size = sizeof(ns2__GSNWebService_USCOREACDetails);
		((ns2__GSNWebService_USCOREACDetails*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns2__GSNWebService_USCOREACDetails[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__GSNWebService_USCOREACDetails);
		for (int i = 0; i < n; i++)
			((ns2__GSNWebService_USCOREACDetails*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__GSNWebService_USCOREACDetails*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__GSNWebService_USCOREACDetails(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__GSNWebService_USCOREACDetails %p -> %p\n", q, p));
	*(ns2__GSNWebService_USCOREACDetails*)p = *(ns2__GSNWebService_USCOREACDetails*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag?tag:"SOAP-ENV:Fault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Fault * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Fault);
		if (size)
			*size = sizeof(struct SOAP_ENV__Fault);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Fault[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Fault);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
	*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang, 1);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Reason * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Reason);
		if (size)
			*size = sizeof(struct SOAP_ENV__Reason);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Reason[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Reason);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Reason*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
	*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__any = NULL;
	a->__type = 0;
	a->fault = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	size_t soap_flag___any = 1;
	size_t soap_flag_fault = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Detail * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Detail);
		if (size)
			*size = sizeof(struct SOAP_ENV__Detail);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Detail[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Detail);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Detail*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Detail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Detail %p -> %p\n", q, p));
	*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Code * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Code);
		if (size)
			*size = sizeof(struct SOAP_ENV__Code);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Code[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Code);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Code*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
	*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag?tag:"SOAP-ENV:Header", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Header * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Header);
		if (size)
			*size = sizeof(struct SOAP_ENV__Header);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Header[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Header);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Header*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
	*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns5__listWrapperURLs(struct soap *soap, struct __ns5__listWrapperURLs *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__listWrapperURLs = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns5__listWrapperURLs(struct soap *soap, const struct __ns5__listWrapperURLs *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__listWrapperURLs(soap, &a->ns1__listWrapperURLs);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns5__listWrapperURLs(struct soap *soap, const char *tag, int id, const struct __ns5__listWrapperURLs *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__listWrapperURLs(soap, "ns1:listWrapperURLs", -1, &a->ns1__listWrapperURLs, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__listWrapperURLs * SOAP_FMAC4 soap_in___ns5__listWrapperURLs(struct soap *soap, const char *tag, struct __ns5__listWrapperURLs *a, const char *type)
{
	size_t soap_flag_ns1__listWrapperURLs = 1;
	short soap_flag;
	a = (struct __ns5__listWrapperURLs *)soap_id_enter(soap, "", a, SOAP_TYPE___ns5__listWrapperURLs, sizeof(struct __ns5__listWrapperURLs), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns5__listWrapperURLs(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__listWrapperURLs && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__listWrapperURLs(soap, "ns1:listWrapperURLs", &a->ns1__listWrapperURLs, ""))
				{	soap_flag_ns1__listWrapperURLs--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns5__listWrapperURLs(struct soap *soap, const struct __ns5__listWrapperURLs *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns5__listWrapperURLs(soap, tag?tag:"-ns5:listWrapperURLs", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__listWrapperURLs * SOAP_FMAC4 soap_get___ns5__listWrapperURLs(struct soap *soap, struct __ns5__listWrapperURLs *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns5__listWrapperURLs(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns5__listWrapperURLs * SOAP_FMAC2 soap_instantiate___ns5__listWrapperURLs(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns5__listWrapperURLs(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns5__listWrapperURLs, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__listWrapperURLs);
		if (size)
			*size = sizeof(struct __ns5__listWrapperURLs);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__listWrapperURLs[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns5__listWrapperURLs);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns5__listWrapperURLs*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns5__listWrapperURLs(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns5__listWrapperURLs %p -> %p\n", q, p));
	*(struct __ns5__listWrapperURLs*)p = *(struct __ns5__listWrapperURLs*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns5__createVirtualSensor(struct soap *soap, struct __ns5__createVirtualSensor *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__createVirtualSensor = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns5__createVirtualSensor(struct soap *soap, const struct __ns5__createVirtualSensor *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__createVirtualSensor(soap, &a->ns1__createVirtualSensor);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns5__createVirtualSensor(struct soap *soap, const char *tag, int id, const struct __ns5__createVirtualSensor *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__createVirtualSensor(soap, "ns1:createVirtualSensor", -1, &a->ns1__createVirtualSensor, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__createVirtualSensor * SOAP_FMAC4 soap_in___ns5__createVirtualSensor(struct soap *soap, const char *tag, struct __ns5__createVirtualSensor *a, const char *type)
{
	size_t soap_flag_ns1__createVirtualSensor = 1;
	short soap_flag;
	a = (struct __ns5__createVirtualSensor *)soap_id_enter(soap, "", a, SOAP_TYPE___ns5__createVirtualSensor, sizeof(struct __ns5__createVirtualSensor), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns5__createVirtualSensor(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__createVirtualSensor && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__createVirtualSensor(soap, "ns1:createVirtualSensor", &a->ns1__createVirtualSensor, ""))
				{	soap_flag_ns1__createVirtualSensor--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns5__createVirtualSensor(struct soap *soap, const struct __ns5__createVirtualSensor *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns5__createVirtualSensor(soap, tag?tag:"-ns5:createVirtualSensor", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__createVirtualSensor * SOAP_FMAC4 soap_get___ns5__createVirtualSensor(struct soap *soap, struct __ns5__createVirtualSensor *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns5__createVirtualSensor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns5__createVirtualSensor * SOAP_FMAC2 soap_instantiate___ns5__createVirtualSensor(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns5__createVirtualSensor(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns5__createVirtualSensor, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__createVirtualSensor);
		if (size)
			*size = sizeof(struct __ns5__createVirtualSensor);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__createVirtualSensor[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns5__createVirtualSensor);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns5__createVirtualSensor*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns5__createVirtualSensor(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns5__createVirtualSensor %p -> %p\n", q, p));
	*(struct __ns5__createVirtualSensor*)p = *(struct __ns5__createVirtualSensor*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns5__getVirtualSensorsDetails(struct soap *soap, struct __ns5__getVirtualSensorsDetails *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getVirtualSensorsDetails = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns5__getVirtualSensorsDetails(struct soap *soap, const struct __ns5__getVirtualSensorsDetails *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getVirtualSensorsDetails(soap, &a->ns1__getVirtualSensorsDetails);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns5__getVirtualSensorsDetails(struct soap *soap, const char *tag, int id, const struct __ns5__getVirtualSensorsDetails *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__getVirtualSensorsDetails(soap, "ns1:getVirtualSensorsDetails", -1, &a->ns1__getVirtualSensorsDetails, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__getVirtualSensorsDetails * SOAP_FMAC4 soap_in___ns5__getVirtualSensorsDetails(struct soap *soap, const char *tag, struct __ns5__getVirtualSensorsDetails *a, const char *type)
{
	size_t soap_flag_ns1__getVirtualSensorsDetails = 1;
	short soap_flag;
	a = (struct __ns5__getVirtualSensorsDetails *)soap_id_enter(soap, "", a, SOAP_TYPE___ns5__getVirtualSensorsDetails, sizeof(struct __ns5__getVirtualSensorsDetails), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns5__getVirtualSensorsDetails(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getVirtualSensorsDetails && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getVirtualSensorsDetails(soap, "ns1:getVirtualSensorsDetails", &a->ns1__getVirtualSensorsDetails, ""))
				{	soap_flag_ns1__getVirtualSensorsDetails--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns5__getVirtualSensorsDetails(struct soap *soap, const struct __ns5__getVirtualSensorsDetails *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns5__getVirtualSensorsDetails(soap, tag?tag:"-ns5:getVirtualSensorsDetails", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__getVirtualSensorsDetails * SOAP_FMAC4 soap_get___ns5__getVirtualSensorsDetails(struct soap *soap, struct __ns5__getVirtualSensorsDetails *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns5__getVirtualSensorsDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns5__getVirtualSensorsDetails * SOAP_FMAC2 soap_instantiate___ns5__getVirtualSensorsDetails(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns5__getVirtualSensorsDetails(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns5__getVirtualSensorsDetails, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__getVirtualSensorsDetails);
		if (size)
			*size = sizeof(struct __ns5__getVirtualSensorsDetails);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__getVirtualSensorsDetails[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns5__getVirtualSensorsDetails);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns5__getVirtualSensorsDetails*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns5__getVirtualSensorsDetails(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns5__getVirtualSensorsDetails %p -> %p\n", q, p));
	*(struct __ns5__getVirtualSensorsDetails*)p = *(struct __ns5__getVirtualSensorsDetails*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns5__deleteVirtualSensor(struct soap *soap, struct __ns5__deleteVirtualSensor *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__deleteVirtualSensor = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns5__deleteVirtualSensor(struct soap *soap, const struct __ns5__deleteVirtualSensor *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__deleteVirtualSensor(soap, &a->ns1__deleteVirtualSensor);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns5__deleteVirtualSensor(struct soap *soap, const char *tag, int id, const struct __ns5__deleteVirtualSensor *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__deleteVirtualSensor(soap, "ns1:deleteVirtualSensor", -1, &a->ns1__deleteVirtualSensor, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__deleteVirtualSensor * SOAP_FMAC4 soap_in___ns5__deleteVirtualSensor(struct soap *soap, const char *tag, struct __ns5__deleteVirtualSensor *a, const char *type)
{
	size_t soap_flag_ns1__deleteVirtualSensor = 1;
	short soap_flag;
	a = (struct __ns5__deleteVirtualSensor *)soap_id_enter(soap, "", a, SOAP_TYPE___ns5__deleteVirtualSensor, sizeof(struct __ns5__deleteVirtualSensor), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns5__deleteVirtualSensor(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__deleteVirtualSensor && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__deleteVirtualSensor(soap, "ns1:deleteVirtualSensor", &a->ns1__deleteVirtualSensor, ""))
				{	soap_flag_ns1__deleteVirtualSensor--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns5__deleteVirtualSensor(struct soap *soap, const struct __ns5__deleteVirtualSensor *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns5__deleteVirtualSensor(soap, tag?tag:"-ns5:deleteVirtualSensor", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__deleteVirtualSensor * SOAP_FMAC4 soap_get___ns5__deleteVirtualSensor(struct soap *soap, struct __ns5__deleteVirtualSensor *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns5__deleteVirtualSensor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns5__deleteVirtualSensor * SOAP_FMAC2 soap_instantiate___ns5__deleteVirtualSensor(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns5__deleteVirtualSensor(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns5__deleteVirtualSensor, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__deleteVirtualSensor);
		if (size)
			*size = sizeof(struct __ns5__deleteVirtualSensor);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__deleteVirtualSensor[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns5__deleteVirtualSensor);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns5__deleteVirtualSensor*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns5__deleteVirtualSensor(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns5__deleteVirtualSensor %p -> %p\n", q, p));
	*(struct __ns5__deleteVirtualSensor*)p = *(struct __ns5__deleteVirtualSensor*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns5__getLatestMultiData(struct soap *soap, struct __ns5__getLatestMultiData *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getLatestMultiData = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns5__getLatestMultiData(struct soap *soap, const struct __ns5__getLatestMultiData *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getLatestMultiData(soap, &a->ns1__getLatestMultiData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns5__getLatestMultiData(struct soap *soap, const char *tag, int id, const struct __ns5__getLatestMultiData *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__getLatestMultiData(soap, "ns1:getLatestMultiData", -1, &a->ns1__getLatestMultiData, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__getLatestMultiData * SOAP_FMAC4 soap_in___ns5__getLatestMultiData(struct soap *soap, const char *tag, struct __ns5__getLatestMultiData *a, const char *type)
{
	size_t soap_flag_ns1__getLatestMultiData = 1;
	short soap_flag;
	a = (struct __ns5__getLatestMultiData *)soap_id_enter(soap, "", a, SOAP_TYPE___ns5__getLatestMultiData, sizeof(struct __ns5__getLatestMultiData), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns5__getLatestMultiData(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getLatestMultiData && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getLatestMultiData(soap, "ns1:getLatestMultiData", &a->ns1__getLatestMultiData, ""))
				{	soap_flag_ns1__getLatestMultiData--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns5__getLatestMultiData(struct soap *soap, const struct __ns5__getLatestMultiData *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns5__getLatestMultiData(soap, tag?tag:"-ns5:getLatestMultiData", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__getLatestMultiData * SOAP_FMAC4 soap_get___ns5__getLatestMultiData(struct soap *soap, struct __ns5__getLatestMultiData *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns5__getLatestMultiData(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns5__getLatestMultiData * SOAP_FMAC2 soap_instantiate___ns5__getLatestMultiData(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns5__getLatestMultiData(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns5__getLatestMultiData, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__getLatestMultiData);
		if (size)
			*size = sizeof(struct __ns5__getLatestMultiData);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__getLatestMultiData[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns5__getLatestMultiData);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns5__getLatestMultiData*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns5__getLatestMultiData(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns5__getLatestMultiData %p -> %p\n", q, p));
	*(struct __ns5__getLatestMultiData*)p = *(struct __ns5__getLatestMultiData*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns5__unregisterQuery(struct soap *soap, struct __ns5__unregisterQuery *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__unregisterQuery = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns5__unregisterQuery(struct soap *soap, const struct __ns5__unregisterQuery *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__unregisterQuery(soap, &a->ns1__unregisterQuery);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns5__unregisterQuery(struct soap *soap, const char *tag, int id, const struct __ns5__unregisterQuery *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__unregisterQuery(soap, "ns1:unregisterQuery", -1, &a->ns1__unregisterQuery, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__unregisterQuery * SOAP_FMAC4 soap_in___ns5__unregisterQuery(struct soap *soap, const char *tag, struct __ns5__unregisterQuery *a, const char *type)
{
	size_t soap_flag_ns1__unregisterQuery = 1;
	short soap_flag;
	a = (struct __ns5__unregisterQuery *)soap_id_enter(soap, "", a, SOAP_TYPE___ns5__unregisterQuery, sizeof(struct __ns5__unregisterQuery), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns5__unregisterQuery(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__unregisterQuery && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__unregisterQuery(soap, "ns1:unregisterQuery", &a->ns1__unregisterQuery, ""))
				{	soap_flag_ns1__unregisterQuery--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns5__unregisterQuery(struct soap *soap, const struct __ns5__unregisterQuery *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns5__unregisterQuery(soap, tag?tag:"-ns5:unregisterQuery", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__unregisterQuery * SOAP_FMAC4 soap_get___ns5__unregisterQuery(struct soap *soap, struct __ns5__unregisterQuery *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns5__unregisterQuery(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns5__unregisterQuery * SOAP_FMAC2 soap_instantiate___ns5__unregisterQuery(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns5__unregisterQuery(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns5__unregisterQuery, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__unregisterQuery);
		if (size)
			*size = sizeof(struct __ns5__unregisterQuery);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__unregisterQuery[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns5__unregisterQuery);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns5__unregisterQuery*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns5__unregisterQuery(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns5__unregisterQuery %p -> %p\n", q, p));
	*(struct __ns5__unregisterQuery*)p = *(struct __ns5__unregisterQuery*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns5__registerQuery(struct soap *soap, struct __ns5__registerQuery *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__registerQuery = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns5__registerQuery(struct soap *soap, const struct __ns5__registerQuery *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__registerQuery(soap, &a->ns1__registerQuery);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns5__registerQuery(struct soap *soap, const char *tag, int id, const struct __ns5__registerQuery *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__registerQuery(soap, "ns1:registerQuery", -1, &a->ns1__registerQuery, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__registerQuery * SOAP_FMAC4 soap_in___ns5__registerQuery(struct soap *soap, const char *tag, struct __ns5__registerQuery *a, const char *type)
{
	size_t soap_flag_ns1__registerQuery = 1;
	short soap_flag;
	a = (struct __ns5__registerQuery *)soap_id_enter(soap, "", a, SOAP_TYPE___ns5__registerQuery, sizeof(struct __ns5__registerQuery), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns5__registerQuery(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__registerQuery && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__registerQuery(soap, "ns1:registerQuery", &a->ns1__registerQuery, ""))
				{	soap_flag_ns1__registerQuery--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns5__registerQuery(struct soap *soap, const struct __ns5__registerQuery *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns5__registerQuery(soap, tag?tag:"-ns5:registerQuery", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__registerQuery * SOAP_FMAC4 soap_get___ns5__registerQuery(struct soap *soap, struct __ns5__registerQuery *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns5__registerQuery(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns5__registerQuery * SOAP_FMAC2 soap_instantiate___ns5__registerQuery(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns5__registerQuery(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns5__registerQuery, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__registerQuery);
		if (size)
			*size = sizeof(struct __ns5__registerQuery);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__registerQuery[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns5__registerQuery);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns5__registerQuery*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns5__registerQuery(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns5__registerQuery %p -> %p\n", q, p));
	*(struct __ns5__registerQuery*)p = *(struct __ns5__registerQuery*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns5__getNextData(struct soap *soap, struct __ns5__getNextData *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getNextData = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns5__getNextData(struct soap *soap, const struct __ns5__getNextData *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getNextData(soap, &a->ns1__getNextData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns5__getNextData(struct soap *soap, const char *tag, int id, const struct __ns5__getNextData *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__getNextData(soap, "ns1:getNextData", -1, &a->ns1__getNextData, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__getNextData * SOAP_FMAC4 soap_in___ns5__getNextData(struct soap *soap, const char *tag, struct __ns5__getNextData *a, const char *type)
{
	size_t soap_flag_ns1__getNextData = 1;
	short soap_flag;
	a = (struct __ns5__getNextData *)soap_id_enter(soap, "", a, SOAP_TYPE___ns5__getNextData, sizeof(struct __ns5__getNextData), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns5__getNextData(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getNextData && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getNextData(soap, "ns1:getNextData", &a->ns1__getNextData, ""))
				{	soap_flag_ns1__getNextData--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns5__getNextData(struct soap *soap, const struct __ns5__getNextData *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns5__getNextData(soap, tag?tag:"-ns5:getNextData", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__getNextData * SOAP_FMAC4 soap_get___ns5__getNextData(struct soap *soap, struct __ns5__getNextData *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns5__getNextData(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns5__getNextData * SOAP_FMAC2 soap_instantiate___ns5__getNextData(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns5__getNextData(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns5__getNextData, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__getNextData);
		if (size)
			*size = sizeof(struct __ns5__getNextData);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__getNextData[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns5__getNextData);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns5__getNextData*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns5__getNextData(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns5__getNextData %p -> %p\n", q, p));
	*(struct __ns5__getNextData*)p = *(struct __ns5__getNextData*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns5__listVirtualSensorNames(struct soap *soap, struct __ns5__listVirtualSensorNames *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__listVirtualSensorNames = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns5__listVirtualSensorNames(struct soap *soap, const struct __ns5__listVirtualSensorNames *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__listVirtualSensorNames(soap, &a->ns1__listVirtualSensorNames);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns5__listVirtualSensorNames(struct soap *soap, const char *tag, int id, const struct __ns5__listVirtualSensorNames *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__listVirtualSensorNames(soap, "ns1:listVirtualSensorNames", -1, &a->ns1__listVirtualSensorNames, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__listVirtualSensorNames * SOAP_FMAC4 soap_in___ns5__listVirtualSensorNames(struct soap *soap, const char *tag, struct __ns5__listVirtualSensorNames *a, const char *type)
{
	size_t soap_flag_ns1__listVirtualSensorNames = 1;
	short soap_flag;
	a = (struct __ns5__listVirtualSensorNames *)soap_id_enter(soap, "", a, SOAP_TYPE___ns5__listVirtualSensorNames, sizeof(struct __ns5__listVirtualSensorNames), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns5__listVirtualSensorNames(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__listVirtualSensorNames && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__listVirtualSensorNames(soap, "ns1:listVirtualSensorNames", &a->ns1__listVirtualSensorNames, ""))
				{	soap_flag_ns1__listVirtualSensorNames--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns5__listVirtualSensorNames(struct soap *soap, const struct __ns5__listVirtualSensorNames *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns5__listVirtualSensorNames(soap, tag?tag:"-ns5:listVirtualSensorNames", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__listVirtualSensorNames * SOAP_FMAC4 soap_get___ns5__listVirtualSensorNames(struct soap *soap, struct __ns5__listVirtualSensorNames *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns5__listVirtualSensorNames(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns5__listVirtualSensorNames * SOAP_FMAC2 soap_instantiate___ns5__listVirtualSensorNames(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns5__listVirtualSensorNames(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns5__listVirtualSensorNames, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__listVirtualSensorNames);
		if (size)
			*size = sizeof(struct __ns5__listVirtualSensorNames);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__listVirtualSensorNames[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns5__listVirtualSensorNames);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns5__listVirtualSensorNames*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns5__listVirtualSensorNames(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns5__listVirtualSensorNames %p -> %p\n", q, p));
	*(struct __ns5__listVirtualSensorNames*)p = *(struct __ns5__listVirtualSensorNames*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns5__getMultiData(struct soap *soap, struct __ns5__getMultiData *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getMultiData = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns5__getMultiData(struct soap *soap, const struct __ns5__getMultiData *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getMultiData(soap, &a->ns1__getMultiData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns5__getMultiData(struct soap *soap, const char *tag, int id, const struct __ns5__getMultiData *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__getMultiData(soap, "ns1:getMultiData", -1, &a->ns1__getMultiData, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__getMultiData * SOAP_FMAC4 soap_in___ns5__getMultiData(struct soap *soap, const char *tag, struct __ns5__getMultiData *a, const char *type)
{
	size_t soap_flag_ns1__getMultiData = 1;
	short soap_flag;
	a = (struct __ns5__getMultiData *)soap_id_enter(soap, "", a, SOAP_TYPE___ns5__getMultiData, sizeof(struct __ns5__getMultiData), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns5__getMultiData(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getMultiData && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getMultiData(soap, "ns1:getMultiData", &a->ns1__getMultiData, ""))
				{	soap_flag_ns1__getMultiData--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns5__getMultiData(struct soap *soap, const struct __ns5__getMultiData *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns5__getMultiData(soap, tag?tag:"-ns5:getMultiData", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__getMultiData * SOAP_FMAC4 soap_get___ns5__getMultiData(struct soap *soap, struct __ns5__getMultiData *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns5__getMultiData(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns5__getMultiData * SOAP_FMAC2 soap_instantiate___ns5__getMultiData(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns5__getMultiData(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns5__getMultiData, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__getMultiData);
		if (size)
			*size = sizeof(struct __ns5__getMultiData);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__getMultiData[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns5__getMultiData);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns5__getMultiData*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns5__getMultiData(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns5__getMultiData %p -> %p\n", q, p));
	*(struct __ns5__getMultiData*)p = *(struct __ns5__getMultiData*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns5__getContainerInfo(struct soap *soap, struct __ns5__getContainerInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getContainerInfo = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns5__getContainerInfo(struct soap *soap, const struct __ns5__getContainerInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getContainerInfo(soap, &a->ns1__getContainerInfo);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns5__getContainerInfo(struct soap *soap, const char *tag, int id, const struct __ns5__getContainerInfo *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__getContainerInfo(soap, "ns1:getContainerInfo", -1, &a->ns1__getContainerInfo, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__getContainerInfo * SOAP_FMAC4 soap_in___ns5__getContainerInfo(struct soap *soap, const char *tag, struct __ns5__getContainerInfo *a, const char *type)
{
	size_t soap_flag_ns1__getContainerInfo = 1;
	short soap_flag;
	a = (struct __ns5__getContainerInfo *)soap_id_enter(soap, "", a, SOAP_TYPE___ns5__getContainerInfo, sizeof(struct __ns5__getContainerInfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns5__getContainerInfo(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getContainerInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getContainerInfo(soap, "ns1:getContainerInfo", &a->ns1__getContainerInfo, ""))
				{	soap_flag_ns1__getContainerInfo--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns5__getContainerInfo(struct soap *soap, const struct __ns5__getContainerInfo *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns5__getContainerInfo(soap, tag?tag:"-ns5:getContainerInfo", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__getContainerInfo * SOAP_FMAC4 soap_get___ns5__getContainerInfo(struct soap *soap, struct __ns5__getContainerInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns5__getContainerInfo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns5__getContainerInfo * SOAP_FMAC2 soap_instantiate___ns5__getContainerInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns5__getContainerInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns5__getContainerInfo, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__getContainerInfo);
		if (size)
			*size = sizeof(struct __ns5__getContainerInfo);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns5__getContainerInfo[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns5__getContainerInfo);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns5__getContainerInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns5__getContainerInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns5__getContainerInfo %p -> %p\n", q, p));
	*(struct __ns5__getContainerInfo*)p = *(struct __ns5__getContainerInfo*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns4__listWrapperURLs(struct soap *soap, struct __ns4__listWrapperURLs *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__listWrapperURLs = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns4__listWrapperURLs(struct soap *soap, const struct __ns4__listWrapperURLs *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__listWrapperURLs(soap, &a->ns1__listWrapperURLs);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns4__listWrapperURLs(struct soap *soap, const char *tag, int id, const struct __ns4__listWrapperURLs *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__listWrapperURLs(soap, "ns1:listWrapperURLs", -1, &a->ns1__listWrapperURLs, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__listWrapperURLs * SOAP_FMAC4 soap_in___ns4__listWrapperURLs(struct soap *soap, const char *tag, struct __ns4__listWrapperURLs *a, const char *type)
{
	size_t soap_flag_ns1__listWrapperURLs = 1;
	short soap_flag;
	a = (struct __ns4__listWrapperURLs *)soap_id_enter(soap, "", a, SOAP_TYPE___ns4__listWrapperURLs, sizeof(struct __ns4__listWrapperURLs), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns4__listWrapperURLs(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__listWrapperURLs && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__listWrapperURLs(soap, "ns1:listWrapperURLs", &a->ns1__listWrapperURLs, ""))
				{	soap_flag_ns1__listWrapperURLs--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns4__listWrapperURLs(struct soap *soap, const struct __ns4__listWrapperURLs *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns4__listWrapperURLs(soap, tag?tag:"-ns4:listWrapperURLs", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__listWrapperURLs * SOAP_FMAC4 soap_get___ns4__listWrapperURLs(struct soap *soap, struct __ns4__listWrapperURLs *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns4__listWrapperURLs(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns4__listWrapperURLs * SOAP_FMAC2 soap_instantiate___ns4__listWrapperURLs(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns4__listWrapperURLs(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns4__listWrapperURLs, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__listWrapperURLs);
		if (size)
			*size = sizeof(struct __ns4__listWrapperURLs);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__listWrapperURLs[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns4__listWrapperURLs);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns4__listWrapperURLs*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns4__listWrapperURLs(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns4__listWrapperURLs %p -> %p\n", q, p));
	*(struct __ns4__listWrapperURLs*)p = *(struct __ns4__listWrapperURLs*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns4__createVirtualSensor(struct soap *soap, struct __ns4__createVirtualSensor *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__createVirtualSensor = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns4__createVirtualSensor(struct soap *soap, const struct __ns4__createVirtualSensor *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__createVirtualSensor(soap, &a->ns1__createVirtualSensor);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns4__createVirtualSensor(struct soap *soap, const char *tag, int id, const struct __ns4__createVirtualSensor *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__createVirtualSensor(soap, "ns1:createVirtualSensor", -1, &a->ns1__createVirtualSensor, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__createVirtualSensor * SOAP_FMAC4 soap_in___ns4__createVirtualSensor(struct soap *soap, const char *tag, struct __ns4__createVirtualSensor *a, const char *type)
{
	size_t soap_flag_ns1__createVirtualSensor = 1;
	short soap_flag;
	a = (struct __ns4__createVirtualSensor *)soap_id_enter(soap, "", a, SOAP_TYPE___ns4__createVirtualSensor, sizeof(struct __ns4__createVirtualSensor), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns4__createVirtualSensor(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__createVirtualSensor && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__createVirtualSensor(soap, "ns1:createVirtualSensor", &a->ns1__createVirtualSensor, ""))
				{	soap_flag_ns1__createVirtualSensor--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns4__createVirtualSensor(struct soap *soap, const struct __ns4__createVirtualSensor *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns4__createVirtualSensor(soap, tag?tag:"-ns4:createVirtualSensor", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__createVirtualSensor * SOAP_FMAC4 soap_get___ns4__createVirtualSensor(struct soap *soap, struct __ns4__createVirtualSensor *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns4__createVirtualSensor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns4__createVirtualSensor * SOAP_FMAC2 soap_instantiate___ns4__createVirtualSensor(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns4__createVirtualSensor(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns4__createVirtualSensor, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__createVirtualSensor);
		if (size)
			*size = sizeof(struct __ns4__createVirtualSensor);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__createVirtualSensor[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns4__createVirtualSensor);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns4__createVirtualSensor*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns4__createVirtualSensor(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns4__createVirtualSensor %p -> %p\n", q, p));
	*(struct __ns4__createVirtualSensor*)p = *(struct __ns4__createVirtualSensor*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns4__getVirtualSensorsDetails(struct soap *soap, struct __ns4__getVirtualSensorsDetails *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getVirtualSensorsDetails = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns4__getVirtualSensorsDetails(struct soap *soap, const struct __ns4__getVirtualSensorsDetails *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getVirtualSensorsDetails(soap, &a->ns1__getVirtualSensorsDetails);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns4__getVirtualSensorsDetails(struct soap *soap, const char *tag, int id, const struct __ns4__getVirtualSensorsDetails *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__getVirtualSensorsDetails(soap, "ns1:getVirtualSensorsDetails", -1, &a->ns1__getVirtualSensorsDetails, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__getVirtualSensorsDetails * SOAP_FMAC4 soap_in___ns4__getVirtualSensorsDetails(struct soap *soap, const char *tag, struct __ns4__getVirtualSensorsDetails *a, const char *type)
{
	size_t soap_flag_ns1__getVirtualSensorsDetails = 1;
	short soap_flag;
	a = (struct __ns4__getVirtualSensorsDetails *)soap_id_enter(soap, "", a, SOAP_TYPE___ns4__getVirtualSensorsDetails, sizeof(struct __ns4__getVirtualSensorsDetails), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns4__getVirtualSensorsDetails(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getVirtualSensorsDetails && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getVirtualSensorsDetails(soap, "ns1:getVirtualSensorsDetails", &a->ns1__getVirtualSensorsDetails, ""))
				{	soap_flag_ns1__getVirtualSensorsDetails--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns4__getVirtualSensorsDetails(struct soap *soap, const struct __ns4__getVirtualSensorsDetails *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns4__getVirtualSensorsDetails(soap, tag?tag:"-ns4:getVirtualSensorsDetails", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__getVirtualSensorsDetails * SOAP_FMAC4 soap_get___ns4__getVirtualSensorsDetails(struct soap *soap, struct __ns4__getVirtualSensorsDetails *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns4__getVirtualSensorsDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns4__getVirtualSensorsDetails * SOAP_FMAC2 soap_instantiate___ns4__getVirtualSensorsDetails(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns4__getVirtualSensorsDetails(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns4__getVirtualSensorsDetails, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__getVirtualSensorsDetails);
		if (size)
			*size = sizeof(struct __ns4__getVirtualSensorsDetails);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__getVirtualSensorsDetails[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns4__getVirtualSensorsDetails);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns4__getVirtualSensorsDetails*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns4__getVirtualSensorsDetails(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns4__getVirtualSensorsDetails %p -> %p\n", q, p));
	*(struct __ns4__getVirtualSensorsDetails*)p = *(struct __ns4__getVirtualSensorsDetails*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns4__deleteVirtualSensor(struct soap *soap, struct __ns4__deleteVirtualSensor *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__deleteVirtualSensor = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns4__deleteVirtualSensor(struct soap *soap, const struct __ns4__deleteVirtualSensor *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__deleteVirtualSensor(soap, &a->ns1__deleteVirtualSensor);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns4__deleteVirtualSensor(struct soap *soap, const char *tag, int id, const struct __ns4__deleteVirtualSensor *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__deleteVirtualSensor(soap, "ns1:deleteVirtualSensor", -1, &a->ns1__deleteVirtualSensor, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__deleteVirtualSensor * SOAP_FMAC4 soap_in___ns4__deleteVirtualSensor(struct soap *soap, const char *tag, struct __ns4__deleteVirtualSensor *a, const char *type)
{
	size_t soap_flag_ns1__deleteVirtualSensor = 1;
	short soap_flag;
	a = (struct __ns4__deleteVirtualSensor *)soap_id_enter(soap, "", a, SOAP_TYPE___ns4__deleteVirtualSensor, sizeof(struct __ns4__deleteVirtualSensor), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns4__deleteVirtualSensor(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__deleteVirtualSensor && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__deleteVirtualSensor(soap, "ns1:deleteVirtualSensor", &a->ns1__deleteVirtualSensor, ""))
				{	soap_flag_ns1__deleteVirtualSensor--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns4__deleteVirtualSensor(struct soap *soap, const struct __ns4__deleteVirtualSensor *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns4__deleteVirtualSensor(soap, tag?tag:"-ns4:deleteVirtualSensor", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__deleteVirtualSensor * SOAP_FMAC4 soap_get___ns4__deleteVirtualSensor(struct soap *soap, struct __ns4__deleteVirtualSensor *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns4__deleteVirtualSensor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns4__deleteVirtualSensor * SOAP_FMAC2 soap_instantiate___ns4__deleteVirtualSensor(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns4__deleteVirtualSensor(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns4__deleteVirtualSensor, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__deleteVirtualSensor);
		if (size)
			*size = sizeof(struct __ns4__deleteVirtualSensor);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__deleteVirtualSensor[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns4__deleteVirtualSensor);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns4__deleteVirtualSensor*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns4__deleteVirtualSensor(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns4__deleteVirtualSensor %p -> %p\n", q, p));
	*(struct __ns4__deleteVirtualSensor*)p = *(struct __ns4__deleteVirtualSensor*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns4__getLatestMultiData(struct soap *soap, struct __ns4__getLatestMultiData *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getLatestMultiData = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns4__getLatestMultiData(struct soap *soap, const struct __ns4__getLatestMultiData *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getLatestMultiData(soap, &a->ns1__getLatestMultiData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns4__getLatestMultiData(struct soap *soap, const char *tag, int id, const struct __ns4__getLatestMultiData *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__getLatestMultiData(soap, "ns1:getLatestMultiData", -1, &a->ns1__getLatestMultiData, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__getLatestMultiData * SOAP_FMAC4 soap_in___ns4__getLatestMultiData(struct soap *soap, const char *tag, struct __ns4__getLatestMultiData *a, const char *type)
{
	size_t soap_flag_ns1__getLatestMultiData = 1;
	short soap_flag;
	a = (struct __ns4__getLatestMultiData *)soap_id_enter(soap, "", a, SOAP_TYPE___ns4__getLatestMultiData, sizeof(struct __ns4__getLatestMultiData), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns4__getLatestMultiData(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getLatestMultiData && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getLatestMultiData(soap, "ns1:getLatestMultiData", &a->ns1__getLatestMultiData, ""))
				{	soap_flag_ns1__getLatestMultiData--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns4__getLatestMultiData(struct soap *soap, const struct __ns4__getLatestMultiData *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns4__getLatestMultiData(soap, tag?tag:"-ns4:getLatestMultiData", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__getLatestMultiData * SOAP_FMAC4 soap_get___ns4__getLatestMultiData(struct soap *soap, struct __ns4__getLatestMultiData *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns4__getLatestMultiData(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns4__getLatestMultiData * SOAP_FMAC2 soap_instantiate___ns4__getLatestMultiData(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns4__getLatestMultiData(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns4__getLatestMultiData, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__getLatestMultiData);
		if (size)
			*size = sizeof(struct __ns4__getLatestMultiData);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__getLatestMultiData[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns4__getLatestMultiData);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns4__getLatestMultiData*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns4__getLatestMultiData(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns4__getLatestMultiData %p -> %p\n", q, p));
	*(struct __ns4__getLatestMultiData*)p = *(struct __ns4__getLatestMultiData*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns4__unregisterQuery(struct soap *soap, struct __ns4__unregisterQuery *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__unregisterQuery = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns4__unregisterQuery(struct soap *soap, const struct __ns4__unregisterQuery *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__unregisterQuery(soap, &a->ns1__unregisterQuery);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns4__unregisterQuery(struct soap *soap, const char *tag, int id, const struct __ns4__unregisterQuery *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__unregisterQuery(soap, "ns1:unregisterQuery", -1, &a->ns1__unregisterQuery, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__unregisterQuery * SOAP_FMAC4 soap_in___ns4__unregisterQuery(struct soap *soap, const char *tag, struct __ns4__unregisterQuery *a, const char *type)
{
	size_t soap_flag_ns1__unregisterQuery = 1;
	short soap_flag;
	a = (struct __ns4__unregisterQuery *)soap_id_enter(soap, "", a, SOAP_TYPE___ns4__unregisterQuery, sizeof(struct __ns4__unregisterQuery), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns4__unregisterQuery(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__unregisterQuery && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__unregisterQuery(soap, "ns1:unregisterQuery", &a->ns1__unregisterQuery, ""))
				{	soap_flag_ns1__unregisterQuery--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns4__unregisterQuery(struct soap *soap, const struct __ns4__unregisterQuery *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns4__unregisterQuery(soap, tag?tag:"-ns4:unregisterQuery", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__unregisterQuery * SOAP_FMAC4 soap_get___ns4__unregisterQuery(struct soap *soap, struct __ns4__unregisterQuery *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns4__unregisterQuery(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns4__unregisterQuery * SOAP_FMAC2 soap_instantiate___ns4__unregisterQuery(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns4__unregisterQuery(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns4__unregisterQuery, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__unregisterQuery);
		if (size)
			*size = sizeof(struct __ns4__unregisterQuery);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__unregisterQuery[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns4__unregisterQuery);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns4__unregisterQuery*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns4__unregisterQuery(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns4__unregisterQuery %p -> %p\n", q, p));
	*(struct __ns4__unregisterQuery*)p = *(struct __ns4__unregisterQuery*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns4__registerQuery(struct soap *soap, struct __ns4__registerQuery *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__registerQuery = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns4__registerQuery(struct soap *soap, const struct __ns4__registerQuery *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__registerQuery(soap, &a->ns1__registerQuery);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns4__registerQuery(struct soap *soap, const char *tag, int id, const struct __ns4__registerQuery *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__registerQuery(soap, "ns1:registerQuery", -1, &a->ns1__registerQuery, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__registerQuery * SOAP_FMAC4 soap_in___ns4__registerQuery(struct soap *soap, const char *tag, struct __ns4__registerQuery *a, const char *type)
{
	size_t soap_flag_ns1__registerQuery = 1;
	short soap_flag;
	a = (struct __ns4__registerQuery *)soap_id_enter(soap, "", a, SOAP_TYPE___ns4__registerQuery, sizeof(struct __ns4__registerQuery), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns4__registerQuery(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__registerQuery && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__registerQuery(soap, "ns1:registerQuery", &a->ns1__registerQuery, ""))
				{	soap_flag_ns1__registerQuery--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns4__registerQuery(struct soap *soap, const struct __ns4__registerQuery *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns4__registerQuery(soap, tag?tag:"-ns4:registerQuery", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__registerQuery * SOAP_FMAC4 soap_get___ns4__registerQuery(struct soap *soap, struct __ns4__registerQuery *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns4__registerQuery(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns4__registerQuery * SOAP_FMAC2 soap_instantiate___ns4__registerQuery(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns4__registerQuery(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns4__registerQuery, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__registerQuery);
		if (size)
			*size = sizeof(struct __ns4__registerQuery);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__registerQuery[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns4__registerQuery);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns4__registerQuery*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns4__registerQuery(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns4__registerQuery %p -> %p\n", q, p));
	*(struct __ns4__registerQuery*)p = *(struct __ns4__registerQuery*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns4__getNextData(struct soap *soap, struct __ns4__getNextData *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getNextData = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns4__getNextData(struct soap *soap, const struct __ns4__getNextData *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getNextData(soap, &a->ns1__getNextData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns4__getNextData(struct soap *soap, const char *tag, int id, const struct __ns4__getNextData *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__getNextData(soap, "ns1:getNextData", -1, &a->ns1__getNextData, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__getNextData * SOAP_FMAC4 soap_in___ns4__getNextData(struct soap *soap, const char *tag, struct __ns4__getNextData *a, const char *type)
{
	size_t soap_flag_ns1__getNextData = 1;
	short soap_flag;
	a = (struct __ns4__getNextData *)soap_id_enter(soap, "", a, SOAP_TYPE___ns4__getNextData, sizeof(struct __ns4__getNextData), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns4__getNextData(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getNextData && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getNextData(soap, "ns1:getNextData", &a->ns1__getNextData, ""))
				{	soap_flag_ns1__getNextData--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns4__getNextData(struct soap *soap, const struct __ns4__getNextData *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns4__getNextData(soap, tag?tag:"-ns4:getNextData", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__getNextData * SOAP_FMAC4 soap_get___ns4__getNextData(struct soap *soap, struct __ns4__getNextData *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns4__getNextData(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns4__getNextData * SOAP_FMAC2 soap_instantiate___ns4__getNextData(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns4__getNextData(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns4__getNextData, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__getNextData);
		if (size)
			*size = sizeof(struct __ns4__getNextData);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__getNextData[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns4__getNextData);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns4__getNextData*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns4__getNextData(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns4__getNextData %p -> %p\n", q, p));
	*(struct __ns4__getNextData*)p = *(struct __ns4__getNextData*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns4__listVirtualSensorNames(struct soap *soap, struct __ns4__listVirtualSensorNames *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__listVirtualSensorNames = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns4__listVirtualSensorNames(struct soap *soap, const struct __ns4__listVirtualSensorNames *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__listVirtualSensorNames(soap, &a->ns1__listVirtualSensorNames);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns4__listVirtualSensorNames(struct soap *soap, const char *tag, int id, const struct __ns4__listVirtualSensorNames *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__listVirtualSensorNames(soap, "ns1:listVirtualSensorNames", -1, &a->ns1__listVirtualSensorNames, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__listVirtualSensorNames * SOAP_FMAC4 soap_in___ns4__listVirtualSensorNames(struct soap *soap, const char *tag, struct __ns4__listVirtualSensorNames *a, const char *type)
{
	size_t soap_flag_ns1__listVirtualSensorNames = 1;
	short soap_flag;
	a = (struct __ns4__listVirtualSensorNames *)soap_id_enter(soap, "", a, SOAP_TYPE___ns4__listVirtualSensorNames, sizeof(struct __ns4__listVirtualSensorNames), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns4__listVirtualSensorNames(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__listVirtualSensorNames && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__listVirtualSensorNames(soap, "ns1:listVirtualSensorNames", &a->ns1__listVirtualSensorNames, ""))
				{	soap_flag_ns1__listVirtualSensorNames--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns4__listVirtualSensorNames(struct soap *soap, const struct __ns4__listVirtualSensorNames *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns4__listVirtualSensorNames(soap, tag?tag:"-ns4:listVirtualSensorNames", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__listVirtualSensorNames * SOAP_FMAC4 soap_get___ns4__listVirtualSensorNames(struct soap *soap, struct __ns4__listVirtualSensorNames *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns4__listVirtualSensorNames(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns4__listVirtualSensorNames * SOAP_FMAC2 soap_instantiate___ns4__listVirtualSensorNames(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns4__listVirtualSensorNames(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns4__listVirtualSensorNames, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__listVirtualSensorNames);
		if (size)
			*size = sizeof(struct __ns4__listVirtualSensorNames);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__listVirtualSensorNames[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns4__listVirtualSensorNames);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns4__listVirtualSensorNames*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns4__listVirtualSensorNames(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns4__listVirtualSensorNames %p -> %p\n", q, p));
	*(struct __ns4__listVirtualSensorNames*)p = *(struct __ns4__listVirtualSensorNames*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns4__getMultiData(struct soap *soap, struct __ns4__getMultiData *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getMultiData = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns4__getMultiData(struct soap *soap, const struct __ns4__getMultiData *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getMultiData(soap, &a->ns1__getMultiData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns4__getMultiData(struct soap *soap, const char *tag, int id, const struct __ns4__getMultiData *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__getMultiData(soap, "ns1:getMultiData", -1, &a->ns1__getMultiData, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__getMultiData * SOAP_FMAC4 soap_in___ns4__getMultiData(struct soap *soap, const char *tag, struct __ns4__getMultiData *a, const char *type)
{
	size_t soap_flag_ns1__getMultiData = 1;
	short soap_flag;
	a = (struct __ns4__getMultiData *)soap_id_enter(soap, "", a, SOAP_TYPE___ns4__getMultiData, sizeof(struct __ns4__getMultiData), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns4__getMultiData(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getMultiData && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getMultiData(soap, "ns1:getMultiData", &a->ns1__getMultiData, ""))
				{	soap_flag_ns1__getMultiData--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns4__getMultiData(struct soap *soap, const struct __ns4__getMultiData *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns4__getMultiData(soap, tag?tag:"-ns4:getMultiData", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__getMultiData * SOAP_FMAC4 soap_get___ns4__getMultiData(struct soap *soap, struct __ns4__getMultiData *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns4__getMultiData(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns4__getMultiData * SOAP_FMAC2 soap_instantiate___ns4__getMultiData(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns4__getMultiData(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns4__getMultiData, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__getMultiData);
		if (size)
			*size = sizeof(struct __ns4__getMultiData);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__getMultiData[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns4__getMultiData);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns4__getMultiData*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns4__getMultiData(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns4__getMultiData %p -> %p\n", q, p));
	*(struct __ns4__getMultiData*)p = *(struct __ns4__getMultiData*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns4__getContainerInfo(struct soap *soap, struct __ns4__getContainerInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getContainerInfo = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns4__getContainerInfo(struct soap *soap, const struct __ns4__getContainerInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getContainerInfo(soap, &a->ns1__getContainerInfo);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns4__getContainerInfo(struct soap *soap, const char *tag, int id, const struct __ns4__getContainerInfo *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__getContainerInfo(soap, "ns1:getContainerInfo", -1, &a->ns1__getContainerInfo, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__getContainerInfo * SOAP_FMAC4 soap_in___ns4__getContainerInfo(struct soap *soap, const char *tag, struct __ns4__getContainerInfo *a, const char *type)
{
	size_t soap_flag_ns1__getContainerInfo = 1;
	short soap_flag;
	a = (struct __ns4__getContainerInfo *)soap_id_enter(soap, "", a, SOAP_TYPE___ns4__getContainerInfo, sizeof(struct __ns4__getContainerInfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns4__getContainerInfo(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getContainerInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getContainerInfo(soap, "ns1:getContainerInfo", &a->ns1__getContainerInfo, ""))
				{	soap_flag_ns1__getContainerInfo--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns4__getContainerInfo(struct soap *soap, const struct __ns4__getContainerInfo *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns4__getContainerInfo(soap, tag?tag:"-ns4:getContainerInfo", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__getContainerInfo * SOAP_FMAC4 soap_get___ns4__getContainerInfo(struct soap *soap, struct __ns4__getContainerInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns4__getContainerInfo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns4__getContainerInfo * SOAP_FMAC2 soap_instantiate___ns4__getContainerInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns4__getContainerInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns4__getContainerInfo, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__getContainerInfo);
		if (size)
			*size = sizeof(struct __ns4__getContainerInfo);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns4__getContainerInfo[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns4__getContainerInfo);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns4__getContainerInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns4__getContainerInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns4__getContainerInfo %p -> %p\n", q, p));
	*(struct __ns4__getContainerInfo*)p = *(struct __ns4__getContainerInfo*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__listWrapperURLsResponse(struct soap *soap, _ns1__listWrapperURLsResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__listWrapperURLsResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__listWrapperURLsResponse(struct soap *soap, const char *tag, int id, _ns1__listWrapperURLsResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__listWrapperURLsResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__listWrapperURLsResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__listWrapperURLsResponse(struct soap *soap, const char *tag, _ns1__listWrapperURLsResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__listWrapperURLsResponse **)soap_malloc(soap, sizeof(_ns1__listWrapperURLsResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__listWrapperURLsResponse *)soap_instantiate__ns1__listWrapperURLsResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__listWrapperURLsResponse ** p = (_ns1__listWrapperURLsResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__listWrapperURLsResponse, sizeof(_ns1__listWrapperURLsResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__listWrapperURLsResponse(struct soap *soap, _ns1__listWrapperURLsResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__listWrapperURLsResponse);
	if (soap_out_PointerTo_ns1__listWrapperURLsResponse(soap, tag?tag:"ns1:listWrapperURLsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__listWrapperURLsResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__listWrapperURLsResponse(struct soap *soap, _ns1__listWrapperURLsResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__listWrapperURLsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__listWrapperURLs(struct soap *soap, _ns1__listWrapperURLs *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__listWrapperURLs))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__listWrapperURLs(struct soap *soap, const char *tag, int id, _ns1__listWrapperURLs *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__listWrapperURLs);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__listWrapperURLs ** SOAP_FMAC4 soap_in_PointerTo_ns1__listWrapperURLs(struct soap *soap, const char *tag, _ns1__listWrapperURLs **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__listWrapperURLs **)soap_malloc(soap, sizeof(_ns1__listWrapperURLs *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__listWrapperURLs *)soap_instantiate__ns1__listWrapperURLs(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__listWrapperURLs ** p = (_ns1__listWrapperURLs **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__listWrapperURLs, sizeof(_ns1__listWrapperURLs), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__listWrapperURLs(struct soap *soap, _ns1__listWrapperURLs *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__listWrapperURLs);
	if (soap_out_PointerTo_ns1__listWrapperURLs(soap, tag?tag:"ns1:listWrapperURLs", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__listWrapperURLs ** SOAP_FMAC4 soap_get_PointerTo_ns1__listWrapperURLs(struct soap *soap, _ns1__listWrapperURLs **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__listWrapperURLs(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__createVirtualSensorResponse(struct soap *soap, _ns1__createVirtualSensorResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__createVirtualSensorResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__createVirtualSensorResponse(struct soap *soap, const char *tag, int id, _ns1__createVirtualSensorResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__createVirtualSensorResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__createVirtualSensorResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__createVirtualSensorResponse(struct soap *soap, const char *tag, _ns1__createVirtualSensorResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__createVirtualSensorResponse **)soap_malloc(soap, sizeof(_ns1__createVirtualSensorResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__createVirtualSensorResponse *)soap_instantiate__ns1__createVirtualSensorResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__createVirtualSensorResponse ** p = (_ns1__createVirtualSensorResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__createVirtualSensorResponse, sizeof(_ns1__createVirtualSensorResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__createVirtualSensorResponse(struct soap *soap, _ns1__createVirtualSensorResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__createVirtualSensorResponse);
	if (soap_out_PointerTo_ns1__createVirtualSensorResponse(soap, tag?tag:"ns1:createVirtualSensorResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__createVirtualSensorResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__createVirtualSensorResponse(struct soap *soap, _ns1__createVirtualSensorResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__createVirtualSensorResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__createVirtualSensor(struct soap *soap, _ns1__createVirtualSensor *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__createVirtualSensor))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__createVirtualSensor(struct soap *soap, const char *tag, int id, _ns1__createVirtualSensor *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__createVirtualSensor);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__createVirtualSensor ** SOAP_FMAC4 soap_in_PointerTo_ns1__createVirtualSensor(struct soap *soap, const char *tag, _ns1__createVirtualSensor **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__createVirtualSensor **)soap_malloc(soap, sizeof(_ns1__createVirtualSensor *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__createVirtualSensor *)soap_instantiate__ns1__createVirtualSensor(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__createVirtualSensor ** p = (_ns1__createVirtualSensor **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__createVirtualSensor, sizeof(_ns1__createVirtualSensor), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__createVirtualSensor(struct soap *soap, _ns1__createVirtualSensor *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__createVirtualSensor);
	if (soap_out_PointerTo_ns1__createVirtualSensor(soap, tag?tag:"ns1:createVirtualSensor", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__createVirtualSensor ** SOAP_FMAC4 soap_get_PointerTo_ns1__createVirtualSensor(struct soap *soap, _ns1__createVirtualSensor **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__createVirtualSensor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getVirtualSensorsDetailsResponse(struct soap *soap, _ns1__getVirtualSensorsDetailsResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getVirtualSensorsDetailsResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getVirtualSensorsDetailsResponse(struct soap *soap, const char *tag, int id, _ns1__getVirtualSensorsDetailsResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getVirtualSensorsDetailsResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__getVirtualSensorsDetailsResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getVirtualSensorsDetailsResponse(struct soap *soap, const char *tag, _ns1__getVirtualSensorsDetailsResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__getVirtualSensorsDetailsResponse **)soap_malloc(soap, sizeof(_ns1__getVirtualSensorsDetailsResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__getVirtualSensorsDetailsResponse *)soap_instantiate__ns1__getVirtualSensorsDetailsResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__getVirtualSensorsDetailsResponse ** p = (_ns1__getVirtualSensorsDetailsResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getVirtualSensorsDetailsResponse, sizeof(_ns1__getVirtualSensorsDetailsResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getVirtualSensorsDetailsResponse(struct soap *soap, _ns1__getVirtualSensorsDetailsResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getVirtualSensorsDetailsResponse);
	if (soap_out_PointerTo_ns1__getVirtualSensorsDetailsResponse(soap, tag?tag:"ns1:getVirtualSensorsDetailsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__getVirtualSensorsDetailsResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getVirtualSensorsDetailsResponse(struct soap *soap, _ns1__getVirtualSensorsDetailsResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getVirtualSensorsDetailsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getVirtualSensorsDetails(struct soap *soap, _ns1__getVirtualSensorsDetails *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getVirtualSensorsDetails))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getVirtualSensorsDetails(struct soap *soap, const char *tag, int id, _ns1__getVirtualSensorsDetails *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getVirtualSensorsDetails);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__getVirtualSensorsDetails ** SOAP_FMAC4 soap_in_PointerTo_ns1__getVirtualSensorsDetails(struct soap *soap, const char *tag, _ns1__getVirtualSensorsDetails **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__getVirtualSensorsDetails **)soap_malloc(soap, sizeof(_ns1__getVirtualSensorsDetails *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__getVirtualSensorsDetails *)soap_instantiate__ns1__getVirtualSensorsDetails(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__getVirtualSensorsDetails ** p = (_ns1__getVirtualSensorsDetails **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getVirtualSensorsDetails, sizeof(_ns1__getVirtualSensorsDetails), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getVirtualSensorsDetails(struct soap *soap, _ns1__getVirtualSensorsDetails *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getVirtualSensorsDetails);
	if (soap_out_PointerTo_ns1__getVirtualSensorsDetails(soap, tag?tag:"ns1:getVirtualSensorsDetails", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__getVirtualSensorsDetails ** SOAP_FMAC4 soap_get_PointerTo_ns1__getVirtualSensorsDetails(struct soap *soap, _ns1__getVirtualSensorsDetails **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getVirtualSensorsDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__deleteVirtualSensorResponse(struct soap *soap, _ns1__deleteVirtualSensorResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__deleteVirtualSensorResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__deleteVirtualSensorResponse(struct soap *soap, const char *tag, int id, _ns1__deleteVirtualSensorResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__deleteVirtualSensorResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__deleteVirtualSensorResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__deleteVirtualSensorResponse(struct soap *soap, const char *tag, _ns1__deleteVirtualSensorResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__deleteVirtualSensorResponse **)soap_malloc(soap, sizeof(_ns1__deleteVirtualSensorResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__deleteVirtualSensorResponse *)soap_instantiate__ns1__deleteVirtualSensorResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__deleteVirtualSensorResponse ** p = (_ns1__deleteVirtualSensorResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__deleteVirtualSensorResponse, sizeof(_ns1__deleteVirtualSensorResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__deleteVirtualSensorResponse(struct soap *soap, _ns1__deleteVirtualSensorResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__deleteVirtualSensorResponse);
	if (soap_out_PointerTo_ns1__deleteVirtualSensorResponse(soap, tag?tag:"ns1:deleteVirtualSensorResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__deleteVirtualSensorResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__deleteVirtualSensorResponse(struct soap *soap, _ns1__deleteVirtualSensorResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__deleteVirtualSensorResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__deleteVirtualSensor(struct soap *soap, _ns1__deleteVirtualSensor *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__deleteVirtualSensor))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__deleteVirtualSensor(struct soap *soap, const char *tag, int id, _ns1__deleteVirtualSensor *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__deleteVirtualSensor);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__deleteVirtualSensor ** SOAP_FMAC4 soap_in_PointerTo_ns1__deleteVirtualSensor(struct soap *soap, const char *tag, _ns1__deleteVirtualSensor **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__deleteVirtualSensor **)soap_malloc(soap, sizeof(_ns1__deleteVirtualSensor *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__deleteVirtualSensor *)soap_instantiate__ns1__deleteVirtualSensor(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__deleteVirtualSensor ** p = (_ns1__deleteVirtualSensor **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__deleteVirtualSensor, sizeof(_ns1__deleteVirtualSensor), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__deleteVirtualSensor(struct soap *soap, _ns1__deleteVirtualSensor *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__deleteVirtualSensor);
	if (soap_out_PointerTo_ns1__deleteVirtualSensor(soap, tag?tag:"ns1:deleteVirtualSensor", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__deleteVirtualSensor ** SOAP_FMAC4 soap_get_PointerTo_ns1__deleteVirtualSensor(struct soap *soap, _ns1__deleteVirtualSensor **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__deleteVirtualSensor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getLatestMultiDataResponse(struct soap *soap, _ns1__getLatestMultiDataResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getLatestMultiDataResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getLatestMultiDataResponse(struct soap *soap, const char *tag, int id, _ns1__getLatestMultiDataResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getLatestMultiDataResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__getLatestMultiDataResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getLatestMultiDataResponse(struct soap *soap, const char *tag, _ns1__getLatestMultiDataResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__getLatestMultiDataResponse **)soap_malloc(soap, sizeof(_ns1__getLatestMultiDataResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__getLatestMultiDataResponse *)soap_instantiate__ns1__getLatestMultiDataResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__getLatestMultiDataResponse ** p = (_ns1__getLatestMultiDataResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getLatestMultiDataResponse, sizeof(_ns1__getLatestMultiDataResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getLatestMultiDataResponse(struct soap *soap, _ns1__getLatestMultiDataResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getLatestMultiDataResponse);
	if (soap_out_PointerTo_ns1__getLatestMultiDataResponse(soap, tag?tag:"ns1:getLatestMultiDataResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__getLatestMultiDataResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getLatestMultiDataResponse(struct soap *soap, _ns1__getLatestMultiDataResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getLatestMultiDataResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getLatestMultiData(struct soap *soap, _ns1__getLatestMultiData *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getLatestMultiData))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getLatestMultiData(struct soap *soap, const char *tag, int id, _ns1__getLatestMultiData *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getLatestMultiData);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__getLatestMultiData ** SOAP_FMAC4 soap_in_PointerTo_ns1__getLatestMultiData(struct soap *soap, const char *tag, _ns1__getLatestMultiData **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__getLatestMultiData **)soap_malloc(soap, sizeof(_ns1__getLatestMultiData *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__getLatestMultiData *)soap_instantiate__ns1__getLatestMultiData(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__getLatestMultiData ** p = (_ns1__getLatestMultiData **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getLatestMultiData, sizeof(_ns1__getLatestMultiData), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getLatestMultiData(struct soap *soap, _ns1__getLatestMultiData *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getLatestMultiData);
	if (soap_out_PointerTo_ns1__getLatestMultiData(soap, tag?tag:"ns1:getLatestMultiData", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__getLatestMultiData ** SOAP_FMAC4 soap_get_PointerTo_ns1__getLatestMultiData(struct soap *soap, _ns1__getLatestMultiData **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getLatestMultiData(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__unregisterQueryResponse(struct soap *soap, _ns1__unregisterQueryResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__unregisterQueryResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__unregisterQueryResponse(struct soap *soap, const char *tag, int id, _ns1__unregisterQueryResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__unregisterQueryResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__unregisterQueryResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__unregisterQueryResponse(struct soap *soap, const char *tag, _ns1__unregisterQueryResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__unregisterQueryResponse **)soap_malloc(soap, sizeof(_ns1__unregisterQueryResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__unregisterQueryResponse *)soap_instantiate__ns1__unregisterQueryResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__unregisterQueryResponse ** p = (_ns1__unregisterQueryResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__unregisterQueryResponse, sizeof(_ns1__unregisterQueryResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__unregisterQueryResponse(struct soap *soap, _ns1__unregisterQueryResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__unregisterQueryResponse);
	if (soap_out_PointerTo_ns1__unregisterQueryResponse(soap, tag?tag:"ns1:unregisterQueryResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__unregisterQueryResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__unregisterQueryResponse(struct soap *soap, _ns1__unregisterQueryResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__unregisterQueryResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__unregisterQuery(struct soap *soap, _ns1__unregisterQuery *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__unregisterQuery))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__unregisterQuery(struct soap *soap, const char *tag, int id, _ns1__unregisterQuery *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__unregisterQuery);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__unregisterQuery ** SOAP_FMAC4 soap_in_PointerTo_ns1__unregisterQuery(struct soap *soap, const char *tag, _ns1__unregisterQuery **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__unregisterQuery **)soap_malloc(soap, sizeof(_ns1__unregisterQuery *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__unregisterQuery *)soap_instantiate__ns1__unregisterQuery(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__unregisterQuery ** p = (_ns1__unregisterQuery **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__unregisterQuery, sizeof(_ns1__unregisterQuery), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__unregisterQuery(struct soap *soap, _ns1__unregisterQuery *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__unregisterQuery);
	if (soap_out_PointerTo_ns1__unregisterQuery(soap, tag?tag:"ns1:unregisterQuery", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__unregisterQuery ** SOAP_FMAC4 soap_get_PointerTo_ns1__unregisterQuery(struct soap *soap, _ns1__unregisterQuery **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__unregisterQuery(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__registerQueryResponse(struct soap *soap, _ns1__registerQueryResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__registerQueryResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__registerQueryResponse(struct soap *soap, const char *tag, int id, _ns1__registerQueryResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__registerQueryResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__registerQueryResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__registerQueryResponse(struct soap *soap, const char *tag, _ns1__registerQueryResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__registerQueryResponse **)soap_malloc(soap, sizeof(_ns1__registerQueryResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__registerQueryResponse *)soap_instantiate__ns1__registerQueryResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__registerQueryResponse ** p = (_ns1__registerQueryResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__registerQueryResponse, sizeof(_ns1__registerQueryResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__registerQueryResponse(struct soap *soap, _ns1__registerQueryResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__registerQueryResponse);
	if (soap_out_PointerTo_ns1__registerQueryResponse(soap, tag?tag:"ns1:registerQueryResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__registerQueryResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__registerQueryResponse(struct soap *soap, _ns1__registerQueryResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__registerQueryResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__registerQuery(struct soap *soap, _ns1__registerQuery *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__registerQuery))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__registerQuery(struct soap *soap, const char *tag, int id, _ns1__registerQuery *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__registerQuery);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__registerQuery ** SOAP_FMAC4 soap_in_PointerTo_ns1__registerQuery(struct soap *soap, const char *tag, _ns1__registerQuery **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__registerQuery **)soap_malloc(soap, sizeof(_ns1__registerQuery *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__registerQuery *)soap_instantiate__ns1__registerQuery(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__registerQuery ** p = (_ns1__registerQuery **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__registerQuery, sizeof(_ns1__registerQuery), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__registerQuery(struct soap *soap, _ns1__registerQuery *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__registerQuery);
	if (soap_out_PointerTo_ns1__registerQuery(soap, tag?tag:"ns1:registerQuery", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__registerQuery ** SOAP_FMAC4 soap_get_PointerTo_ns1__registerQuery(struct soap *soap, _ns1__registerQuery **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__registerQuery(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getNextDataResponse(struct soap *soap, _ns1__getNextDataResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getNextDataResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getNextDataResponse(struct soap *soap, const char *tag, int id, _ns1__getNextDataResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getNextDataResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__getNextDataResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getNextDataResponse(struct soap *soap, const char *tag, _ns1__getNextDataResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__getNextDataResponse **)soap_malloc(soap, sizeof(_ns1__getNextDataResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__getNextDataResponse *)soap_instantiate__ns1__getNextDataResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__getNextDataResponse ** p = (_ns1__getNextDataResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getNextDataResponse, sizeof(_ns1__getNextDataResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getNextDataResponse(struct soap *soap, _ns1__getNextDataResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getNextDataResponse);
	if (soap_out_PointerTo_ns1__getNextDataResponse(soap, tag?tag:"ns1:getNextDataResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__getNextDataResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getNextDataResponse(struct soap *soap, _ns1__getNextDataResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getNextDataResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getNextData(struct soap *soap, _ns1__getNextData *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getNextData))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getNextData(struct soap *soap, const char *tag, int id, _ns1__getNextData *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getNextData);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__getNextData ** SOAP_FMAC4 soap_in_PointerTo_ns1__getNextData(struct soap *soap, const char *tag, _ns1__getNextData **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__getNextData **)soap_malloc(soap, sizeof(_ns1__getNextData *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__getNextData *)soap_instantiate__ns1__getNextData(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__getNextData ** p = (_ns1__getNextData **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getNextData, sizeof(_ns1__getNextData), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getNextData(struct soap *soap, _ns1__getNextData *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getNextData);
	if (soap_out_PointerTo_ns1__getNextData(soap, tag?tag:"ns1:getNextData", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__getNextData ** SOAP_FMAC4 soap_get_PointerTo_ns1__getNextData(struct soap *soap, _ns1__getNextData **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getNextData(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__listVirtualSensorNamesResponse(struct soap *soap, _ns1__listVirtualSensorNamesResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__listVirtualSensorNamesResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__listVirtualSensorNamesResponse(struct soap *soap, const char *tag, int id, _ns1__listVirtualSensorNamesResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__listVirtualSensorNamesResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__listVirtualSensorNamesResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__listVirtualSensorNamesResponse(struct soap *soap, const char *tag, _ns1__listVirtualSensorNamesResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__listVirtualSensorNamesResponse **)soap_malloc(soap, sizeof(_ns1__listVirtualSensorNamesResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__listVirtualSensorNamesResponse *)soap_instantiate__ns1__listVirtualSensorNamesResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__listVirtualSensorNamesResponse ** p = (_ns1__listVirtualSensorNamesResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__listVirtualSensorNamesResponse, sizeof(_ns1__listVirtualSensorNamesResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__listVirtualSensorNamesResponse(struct soap *soap, _ns1__listVirtualSensorNamesResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__listVirtualSensorNamesResponse);
	if (soap_out_PointerTo_ns1__listVirtualSensorNamesResponse(soap, tag?tag:"ns1:listVirtualSensorNamesResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__listVirtualSensorNamesResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__listVirtualSensorNamesResponse(struct soap *soap, _ns1__listVirtualSensorNamesResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__listVirtualSensorNamesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__listVirtualSensorNames(struct soap *soap, _ns1__listVirtualSensorNames *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__listVirtualSensorNames))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__listVirtualSensorNames(struct soap *soap, const char *tag, int id, _ns1__listVirtualSensorNames *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__listVirtualSensorNames);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__listVirtualSensorNames ** SOAP_FMAC4 soap_in_PointerTo_ns1__listVirtualSensorNames(struct soap *soap, const char *tag, _ns1__listVirtualSensorNames **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__listVirtualSensorNames **)soap_malloc(soap, sizeof(_ns1__listVirtualSensorNames *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__listVirtualSensorNames *)soap_instantiate__ns1__listVirtualSensorNames(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__listVirtualSensorNames ** p = (_ns1__listVirtualSensorNames **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__listVirtualSensorNames, sizeof(_ns1__listVirtualSensorNames), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__listVirtualSensorNames(struct soap *soap, _ns1__listVirtualSensorNames *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__listVirtualSensorNames);
	if (soap_out_PointerTo_ns1__listVirtualSensorNames(soap, tag?tag:"ns1:listVirtualSensorNames", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__listVirtualSensorNames ** SOAP_FMAC4 soap_get_PointerTo_ns1__listVirtualSensorNames(struct soap *soap, _ns1__listVirtualSensorNames **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__listVirtualSensorNames(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getMultiDataResponse(struct soap *soap, _ns1__getMultiDataResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getMultiDataResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getMultiDataResponse(struct soap *soap, const char *tag, int id, _ns1__getMultiDataResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getMultiDataResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__getMultiDataResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getMultiDataResponse(struct soap *soap, const char *tag, _ns1__getMultiDataResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__getMultiDataResponse **)soap_malloc(soap, sizeof(_ns1__getMultiDataResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__getMultiDataResponse *)soap_instantiate__ns1__getMultiDataResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__getMultiDataResponse ** p = (_ns1__getMultiDataResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getMultiDataResponse, sizeof(_ns1__getMultiDataResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getMultiDataResponse(struct soap *soap, _ns1__getMultiDataResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getMultiDataResponse);
	if (soap_out_PointerTo_ns1__getMultiDataResponse(soap, tag?tag:"ns1:getMultiDataResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__getMultiDataResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getMultiDataResponse(struct soap *soap, _ns1__getMultiDataResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getMultiDataResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getMultiData(struct soap *soap, _ns1__getMultiData *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getMultiData))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getMultiData(struct soap *soap, const char *tag, int id, _ns1__getMultiData *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getMultiData);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__getMultiData ** SOAP_FMAC4 soap_in_PointerTo_ns1__getMultiData(struct soap *soap, const char *tag, _ns1__getMultiData **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__getMultiData **)soap_malloc(soap, sizeof(_ns1__getMultiData *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__getMultiData *)soap_instantiate__ns1__getMultiData(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__getMultiData ** p = (_ns1__getMultiData **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getMultiData, sizeof(_ns1__getMultiData), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getMultiData(struct soap *soap, _ns1__getMultiData *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getMultiData);
	if (soap_out_PointerTo_ns1__getMultiData(soap, tag?tag:"ns1:getMultiData", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__getMultiData ** SOAP_FMAC4 soap_get_PointerTo_ns1__getMultiData(struct soap *soap, _ns1__getMultiData **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getMultiData(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getContainerInfoResponse(struct soap *soap, _ns1__getContainerInfoResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getContainerInfoResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getContainerInfoResponse(struct soap *soap, const char *tag, int id, _ns1__getContainerInfoResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getContainerInfoResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__getContainerInfoResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getContainerInfoResponse(struct soap *soap, const char *tag, _ns1__getContainerInfoResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__getContainerInfoResponse **)soap_malloc(soap, sizeof(_ns1__getContainerInfoResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__getContainerInfoResponse *)soap_instantiate__ns1__getContainerInfoResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__getContainerInfoResponse ** p = (_ns1__getContainerInfoResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getContainerInfoResponse, sizeof(_ns1__getContainerInfoResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getContainerInfoResponse(struct soap *soap, _ns1__getContainerInfoResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getContainerInfoResponse);
	if (soap_out_PointerTo_ns1__getContainerInfoResponse(soap, tag?tag:"ns1:getContainerInfoResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__getContainerInfoResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getContainerInfoResponse(struct soap *soap, _ns1__getContainerInfoResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getContainerInfoResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getContainerInfo(struct soap *soap, _ns1__getContainerInfo *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getContainerInfo))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getContainerInfo(struct soap *soap, const char *tag, int id, _ns1__getContainerInfo *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getContainerInfo);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__getContainerInfo ** SOAP_FMAC4 soap_in_PointerTo_ns1__getContainerInfo(struct soap *soap, const char *tag, _ns1__getContainerInfo **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__getContainerInfo **)soap_malloc(soap, sizeof(_ns1__getContainerInfo *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__getContainerInfo *)soap_instantiate__ns1__getContainerInfo(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__getContainerInfo ** p = (_ns1__getContainerInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getContainerInfo, sizeof(_ns1__getContainerInfo), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getContainerInfo(struct soap *soap, _ns1__getContainerInfo *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getContainerInfo);
	if (soap_out_PointerTo_ns1__getContainerInfo(soap, tag?tag:"ns1:getContainerInfo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__getContainerInfo ** SOAP_FMAC4 soap_get_PointerTo_ns1__getContainerInfo(struct soap *soap, _ns1__getContainerInfo **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getContainerInfo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__GSNWebService_USCOREVirtualSensorDetails(struct soap *soap, ns2__GSNWebService_USCOREVirtualSensorDetails *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__GSNWebService_USCOREVirtualSensorDetails))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__GSNWebService_USCOREVirtualSensorDetails(struct soap *soap, const char *tag, int id, ns2__GSNWebService_USCOREVirtualSensorDetails *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__GSNWebService_USCOREVirtualSensorDetails);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREVirtualSensorDetails ** SOAP_FMAC4 soap_in_PointerTons2__GSNWebService_USCOREVirtualSensorDetails(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREVirtualSensorDetails **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns2__GSNWebService_USCOREVirtualSensorDetails **)soap_malloc(soap, sizeof(ns2__GSNWebService_USCOREVirtualSensorDetails *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns2__GSNWebService_USCOREVirtualSensorDetails *)soap_instantiate_ns2__GSNWebService_USCOREVirtualSensorDetails(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns2__GSNWebService_USCOREVirtualSensorDetails ** p = (ns2__GSNWebService_USCOREVirtualSensorDetails **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__GSNWebService_USCOREVirtualSensorDetails, sizeof(ns2__GSNWebService_USCOREVirtualSensorDetails), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__GSNWebService_USCOREVirtualSensorDetails(struct soap *soap, ns2__GSNWebService_USCOREVirtualSensorDetails *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__GSNWebService_USCOREVirtualSensorDetails);
	if (soap_out_PointerTons2__GSNWebService_USCOREVirtualSensorDetails(soap, tag?tag:"ns2:GSNWebService_VirtualSensorDetails", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREVirtualSensorDetails ** SOAP_FMAC4 soap_get_PointerTons2__GSNWebService_USCOREVirtualSensorDetails(struct soap *soap, ns2__GSNWebService_USCOREVirtualSensorDetails **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__GSNWebService_USCOREVirtualSensorDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToLONG64(struct soap *soap, LONG64 *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToLONG64(struct soap *soap, const char *tag, int id, LONG64 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_LONG64);
	if (id < 0)
		return soap->error;
	return soap_out_LONG64(soap, tag, id, *a, type);
}

SOAP_FMAC3 LONG64 ** SOAP_FMAC4 soap_in_PointerToLONG64(struct soap *soap, const char *tag, LONG64 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (LONG64 **)soap_malloc(soap, sizeof(LONG64 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_LONG64(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (LONG64 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_LONG64, sizeof(LONG64), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToLONG64(struct soap *soap, LONG64 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToLONG64);
	if (soap_out_PointerToLONG64(soap, tag?tag:"long", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 LONG64 ** SOAP_FMAC4 soap_get_PointerToLONG64(struct soap *soap, LONG64 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToLONG64(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons3__AggregationCriterion(struct soap *soap, ns3__AggregationCriterion *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns3__AggregationCriterion))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons3__AggregationCriterion(struct soap *soap, const char *tag, int id, ns3__AggregationCriterion *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns3__AggregationCriterion);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns3__AggregationCriterion ** SOAP_FMAC4 soap_in_PointerTons3__AggregationCriterion(struct soap *soap, const char *tag, ns3__AggregationCriterion **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns3__AggregationCriterion **)soap_malloc(soap, sizeof(ns3__AggregationCriterion *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns3__AggregationCriterion *)soap_instantiate_ns3__AggregationCriterion(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns3__AggregationCriterion ** p = (ns3__AggregationCriterion **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns3__AggregationCriterion, sizeof(ns3__AggregationCriterion), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons3__AggregationCriterion(struct soap *soap, ns3__AggregationCriterion *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons3__AggregationCriterion);
	if (soap_out_PointerTons3__AggregationCriterion(soap, tag?tag:"ns3:AggregationCriterion", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns3__AggregationCriterion ** SOAP_FMAC4 soap_get_PointerTons3__AggregationCriterion(struct soap *soap, ns3__AggregationCriterion **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons3__AggregationCriterion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons3__StandardCriterion(struct soap *soap, ns3__StandardCriterion *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns3__StandardCriterion))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons3__StandardCriterion(struct soap *soap, const char *tag, int id, ns3__StandardCriterion *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns3__StandardCriterion);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns3__StandardCriterion ** SOAP_FMAC4 soap_in_PointerTons3__StandardCriterion(struct soap *soap, const char *tag, ns3__StandardCriterion **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns3__StandardCriterion **)soap_malloc(soap, sizeof(ns3__StandardCriterion *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns3__StandardCriterion *)soap_instantiate_ns3__StandardCriterion(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns3__StandardCriterion ** p = (ns3__StandardCriterion **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns3__StandardCriterion, sizeof(ns3__StandardCriterion), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons3__StandardCriterion(struct soap *soap, ns3__StandardCriterion *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons3__StandardCriterion);
	if (soap_out_PointerTons3__StandardCriterion(soap, tag?tag:"ns3:StandardCriterion", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns3__StandardCriterion ** SOAP_FMAC4 soap_get_PointerTons3__StandardCriterion(struct soap *soap, ns3__StandardCriterion **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons3__StandardCriterion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__GSNWebService_USCOREQueryResult(struct soap *soap, ns2__GSNWebService_USCOREQueryResult *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__GSNWebService_USCOREQueryResult))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__GSNWebService_USCOREQueryResult(struct soap *soap, const char *tag, int id, ns2__GSNWebService_USCOREQueryResult *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__GSNWebService_USCOREQueryResult);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREQueryResult ** SOAP_FMAC4 soap_in_PointerTons2__GSNWebService_USCOREQueryResult(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREQueryResult **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns2__GSNWebService_USCOREQueryResult **)soap_malloc(soap, sizeof(ns2__GSNWebService_USCOREQueryResult *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns2__GSNWebService_USCOREQueryResult *)soap_instantiate_ns2__GSNWebService_USCOREQueryResult(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns2__GSNWebService_USCOREQueryResult ** p = (ns2__GSNWebService_USCOREQueryResult **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__GSNWebService_USCOREQueryResult, sizeof(ns2__GSNWebService_USCOREQueryResult), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__GSNWebService_USCOREQueryResult(struct soap *soap, ns2__GSNWebService_USCOREQueryResult *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__GSNWebService_USCOREQueryResult);
	if (soap_out_PointerTons2__GSNWebService_USCOREQueryResult(soap, tag?tag:"ns2:GSNWebService_QueryResult", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREQueryResult ** SOAP_FMAC4 soap_get_PointerTons2__GSNWebService_USCOREQueryResult(struct soap *soap, ns2__GSNWebService_USCOREQueryResult **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__GSNWebService_USCOREQueryResult(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__GSNWebService_USCOREFieldSelector(struct soap *soap, ns2__GSNWebService_USCOREFieldSelector *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__GSNWebService_USCOREFieldSelector))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__GSNWebService_USCOREFieldSelector(struct soap *soap, const char *tag, int id, ns2__GSNWebService_USCOREFieldSelector *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__GSNWebService_USCOREFieldSelector);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREFieldSelector ** SOAP_FMAC4 soap_in_PointerTons2__GSNWebService_USCOREFieldSelector(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREFieldSelector **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns2__GSNWebService_USCOREFieldSelector **)soap_malloc(soap, sizeof(ns2__GSNWebService_USCOREFieldSelector *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns2__GSNWebService_USCOREFieldSelector *)soap_instantiate_ns2__GSNWebService_USCOREFieldSelector(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns2__GSNWebService_USCOREFieldSelector ** p = (ns2__GSNWebService_USCOREFieldSelector **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__GSNWebService_USCOREFieldSelector, sizeof(ns2__GSNWebService_USCOREFieldSelector), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__GSNWebService_USCOREFieldSelector(struct soap *soap, ns2__GSNWebService_USCOREFieldSelector *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__GSNWebService_USCOREFieldSelector);
	if (soap_out_PointerTons2__GSNWebService_USCOREFieldSelector(soap, tag?tag:"ns2:GSNWebService_FieldSelector", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREFieldSelector ** SOAP_FMAC4 soap_get_PointerTons2__GSNWebService_USCOREFieldSelector(struct soap *soap, ns2__GSNWebService_USCOREFieldSelector **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__GSNWebService_USCOREFieldSelector(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__GSNWebService_USCOREContainerDetails(struct soap *soap, ns2__GSNWebService_USCOREContainerDetails *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__GSNWebService_USCOREContainerDetails))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__GSNWebService_USCOREContainerDetails(struct soap *soap, const char *tag, int id, ns2__GSNWebService_USCOREContainerDetails *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__GSNWebService_USCOREContainerDetails);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREContainerDetails ** SOAP_FMAC4 soap_in_PointerTons2__GSNWebService_USCOREContainerDetails(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREContainerDetails **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns2__GSNWebService_USCOREContainerDetails **)soap_malloc(soap, sizeof(ns2__GSNWebService_USCOREContainerDetails *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns2__GSNWebService_USCOREContainerDetails *)soap_instantiate_ns2__GSNWebService_USCOREContainerDetails(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns2__GSNWebService_USCOREContainerDetails ** p = (ns2__GSNWebService_USCOREContainerDetails **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__GSNWebService_USCOREContainerDetails, sizeof(ns2__GSNWebService_USCOREContainerDetails), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__GSNWebService_USCOREContainerDetails(struct soap *soap, ns2__GSNWebService_USCOREContainerDetails *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__GSNWebService_USCOREContainerDetails);
	if (soap_out_PointerTons2__GSNWebService_USCOREContainerDetails(soap, tag?tag:"ns2:GSNWebService_ContainerDetails", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREContainerDetails ** SOAP_FMAC4 soap_get_PointerTons2__GSNWebService_USCOREContainerDetails(struct soap *soap, ns2__GSNWebService_USCOREContainerDetails **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__GSNWebService_USCOREContainerDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__GSNWebService_USCOREACDetails(struct soap *soap, ns2__GSNWebService_USCOREACDetails *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__GSNWebService_USCOREACDetails))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__GSNWebService_USCOREACDetails(struct soap *soap, const char *tag, int id, ns2__GSNWebService_USCOREACDetails *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__GSNWebService_USCOREACDetails);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREACDetails ** SOAP_FMAC4 soap_in_PointerTons2__GSNWebService_USCOREACDetails(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREACDetails **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns2__GSNWebService_USCOREACDetails **)soap_malloc(soap, sizeof(ns2__GSNWebService_USCOREACDetails *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns2__GSNWebService_USCOREACDetails *)soap_instantiate_ns2__GSNWebService_USCOREACDetails(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns2__GSNWebService_USCOREACDetails ** p = (ns2__GSNWebService_USCOREACDetails **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__GSNWebService_USCOREACDetails, sizeof(ns2__GSNWebService_USCOREACDetails), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__GSNWebService_USCOREACDetails(struct soap *soap, ns2__GSNWebService_USCOREACDetails *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__GSNWebService_USCOREACDetails);
	if (soap_out_PointerTons2__GSNWebService_USCOREACDetails(soap, tag?tag:"ns2:GSNWebService_ACDetails", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREACDetails ** SOAP_FMAC4 soap_get_PointerTons2__GSNWebService_USCOREACDetails(struct soap *soap, ns2__GSNWebService_USCOREACDetails **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__GSNWebService_USCOREACDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__GSNWebService_USCOREWrapperURL(struct soap *soap, ns2__GSNWebService_USCOREWrapperURL *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__GSNWebService_USCOREWrapperURL))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__GSNWebService_USCOREWrapperURL(struct soap *soap, const char *tag, int id, ns2__GSNWebService_USCOREWrapperURL *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__GSNWebService_USCOREWrapperURL);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREWrapperURL ** SOAP_FMAC4 soap_in_PointerTons2__GSNWebService_USCOREWrapperURL(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREWrapperURL **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns2__GSNWebService_USCOREWrapperURL **)soap_malloc(soap, sizeof(ns2__GSNWebService_USCOREWrapperURL *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns2__GSNWebService_USCOREWrapperURL *)soap_instantiate_ns2__GSNWebService_USCOREWrapperURL(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns2__GSNWebService_USCOREWrapperURL ** p = (ns2__GSNWebService_USCOREWrapperURL **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__GSNWebService_USCOREWrapperURL, sizeof(ns2__GSNWebService_USCOREWrapperURL), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__GSNWebService_USCOREWrapperURL(struct soap *soap, ns2__GSNWebService_USCOREWrapperURL *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__GSNWebService_USCOREWrapperURL);
	if (soap_out_PointerTons2__GSNWebService_USCOREWrapperURL(soap, tag?tag:"ns2:GSNWebService_WrapperURL", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREWrapperURL ** SOAP_FMAC4 soap_get_PointerTons2__GSNWebService_USCOREWrapperURL(struct soap *soap, ns2__GSNWebService_USCOREWrapperURL **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__GSNWebService_USCOREWrapperURL(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__GSNWebService_USCOREWrapperDetails(struct soap *soap, ns2__GSNWebService_USCOREWrapperDetails *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__GSNWebService_USCOREWrapperDetails))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__GSNWebService_USCOREWrapperDetails(struct soap *soap, const char *tag, int id, ns2__GSNWebService_USCOREWrapperDetails *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__GSNWebService_USCOREWrapperDetails);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREWrapperDetails ** SOAP_FMAC4 soap_in_PointerTons2__GSNWebService_USCOREWrapperDetails(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREWrapperDetails **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns2__GSNWebService_USCOREWrapperDetails **)soap_malloc(soap, sizeof(ns2__GSNWebService_USCOREWrapperDetails *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns2__GSNWebService_USCOREWrapperDetails *)soap_instantiate_ns2__GSNWebService_USCOREWrapperDetails(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns2__GSNWebService_USCOREWrapperDetails ** p = (ns2__GSNWebService_USCOREWrapperDetails **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__GSNWebService_USCOREWrapperDetails, sizeof(ns2__GSNWebService_USCOREWrapperDetails), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__GSNWebService_USCOREWrapperDetails(struct soap *soap, ns2__GSNWebService_USCOREWrapperDetails *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__GSNWebService_USCOREWrapperDetails);
	if (soap_out_PointerTons2__GSNWebService_USCOREWrapperDetails(soap, tag?tag:"ns2:GSNWebService_WrapperDetails", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREWrapperDetails ** SOAP_FMAC4 soap_get_PointerTons2__GSNWebService_USCOREWrapperDetails(struct soap *soap, ns2__GSNWebService_USCOREWrapperDetails **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__GSNWebService_USCOREWrapperDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__GSNWebService_USCOREConfPredicate(struct soap *soap, ns2__GSNWebService_USCOREConfPredicate *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__GSNWebService_USCOREConfPredicate))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__GSNWebService_USCOREConfPredicate(struct soap *soap, const char *tag, int id, ns2__GSNWebService_USCOREConfPredicate *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__GSNWebService_USCOREConfPredicate);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfPredicate ** SOAP_FMAC4 soap_in_PointerTons2__GSNWebService_USCOREConfPredicate(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREConfPredicate **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns2__GSNWebService_USCOREConfPredicate **)soap_malloc(soap, sizeof(ns2__GSNWebService_USCOREConfPredicate *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns2__GSNWebService_USCOREConfPredicate *)soap_instantiate_ns2__GSNWebService_USCOREConfPredicate(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns2__GSNWebService_USCOREConfPredicate ** p = (ns2__GSNWebService_USCOREConfPredicate **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__GSNWebService_USCOREConfPredicate, sizeof(ns2__GSNWebService_USCOREConfPredicate), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__GSNWebService_USCOREConfPredicate(struct soap *soap, ns2__GSNWebService_USCOREConfPredicate *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfPredicate);
	if (soap_out_PointerTons2__GSNWebService_USCOREConfPredicate(soap, tag?tag:"ns2:GSNWebService_ConfPredicate", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfPredicate ** SOAP_FMAC4 soap_get_PointerTons2__GSNWebService_USCOREConfPredicate(struct soap *soap, ns2__GSNWebService_USCOREConfPredicate **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__GSNWebService_USCOREConfPredicate(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__GSNWebService_USCOREConfWrapper(struct soap *soap, ns2__GSNWebService_USCOREConfWrapper *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__GSNWebService_USCOREConfWrapper))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__GSNWebService_USCOREConfWrapper(struct soap *soap, const char *tag, int id, ns2__GSNWebService_USCOREConfWrapper *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__GSNWebService_USCOREConfWrapper);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfWrapper ** SOAP_FMAC4 soap_in_PointerTons2__GSNWebService_USCOREConfWrapper(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREConfWrapper **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns2__GSNWebService_USCOREConfWrapper **)soap_malloc(soap, sizeof(ns2__GSNWebService_USCOREConfWrapper *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns2__GSNWebService_USCOREConfWrapper *)soap_instantiate_ns2__GSNWebService_USCOREConfWrapper(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns2__GSNWebService_USCOREConfWrapper ** p = (ns2__GSNWebService_USCOREConfWrapper **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__GSNWebService_USCOREConfWrapper, sizeof(ns2__GSNWebService_USCOREConfWrapper), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__GSNWebService_USCOREConfWrapper(struct soap *soap, ns2__GSNWebService_USCOREConfWrapper *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfWrapper);
	if (soap_out_PointerTons2__GSNWebService_USCOREConfWrapper(soap, tag?tag:"ns2:GSNWebService_ConfWrapper", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfWrapper ** SOAP_FMAC4 soap_get_PointerTons2__GSNWebService_USCOREConfWrapper(struct soap *soap, ns2__GSNWebService_USCOREConfWrapper **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__GSNWebService_USCOREConfWrapper(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__GSNWebService_USCOREConfProcessor(struct soap *soap, ns2__GSNWebService_USCOREConfProcessor *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__GSNWebService_USCOREConfProcessor))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__GSNWebService_USCOREConfProcessor(struct soap *soap, const char *tag, int id, ns2__GSNWebService_USCOREConfProcessor *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__GSNWebService_USCOREConfProcessor);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfProcessor ** SOAP_FMAC4 soap_in_PointerTons2__GSNWebService_USCOREConfProcessor(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREConfProcessor **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns2__GSNWebService_USCOREConfProcessor **)soap_malloc(soap, sizeof(ns2__GSNWebService_USCOREConfProcessor *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns2__GSNWebService_USCOREConfProcessor *)soap_instantiate_ns2__GSNWebService_USCOREConfProcessor(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns2__GSNWebService_USCOREConfProcessor ** p = (ns2__GSNWebService_USCOREConfProcessor **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__GSNWebService_USCOREConfProcessor, sizeof(ns2__GSNWebService_USCOREConfProcessor), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__GSNWebService_USCOREConfProcessor(struct soap *soap, ns2__GSNWebService_USCOREConfProcessor *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfProcessor);
	if (soap_out_PointerTons2__GSNWebService_USCOREConfProcessor(soap, tag?tag:"ns2:GSNWebService_ConfProcessor", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfProcessor ** SOAP_FMAC4 soap_get_PointerTons2__GSNWebService_USCOREConfProcessor(struct soap *soap, ns2__GSNWebService_USCOREConfProcessor **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__GSNWebService_USCOREConfProcessor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__GSNWebService_USCOREConfOutputStructure(struct soap *soap, ns2__GSNWebService_USCOREConfOutputStructure *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__GSNWebService_USCOREConfOutputStructure))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__GSNWebService_USCOREConfOutputStructure(struct soap *soap, const char *tag, int id, ns2__GSNWebService_USCOREConfOutputStructure *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__GSNWebService_USCOREConfOutputStructure);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfOutputStructure ** SOAP_FMAC4 soap_in_PointerTons2__GSNWebService_USCOREConfOutputStructure(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREConfOutputStructure **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns2__GSNWebService_USCOREConfOutputStructure **)soap_malloc(soap, sizeof(ns2__GSNWebService_USCOREConfOutputStructure *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns2__GSNWebService_USCOREConfOutputStructure *)soap_instantiate_ns2__GSNWebService_USCOREConfOutputStructure(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns2__GSNWebService_USCOREConfOutputStructure ** p = (ns2__GSNWebService_USCOREConfOutputStructure **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__GSNWebService_USCOREConfOutputStructure, sizeof(ns2__GSNWebService_USCOREConfOutputStructure), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__GSNWebService_USCOREConfOutputStructure(struct soap *soap, ns2__GSNWebService_USCOREConfOutputStructure *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfOutputStructure);
	if (soap_out_PointerTons2__GSNWebService_USCOREConfOutputStructure(soap, tag?tag:"ns2:GSNWebService_ConfOutputStructure", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfOutputStructure ** SOAP_FMAC4 soap_get_PointerTons2__GSNWebService_USCOREConfOutputStructure(struct soap *soap, ns2__GSNWebService_USCOREConfOutputStructure **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__GSNWebService_USCOREConfOutputStructure(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__GSNWebService_USCOREConfInfo(struct soap *soap, ns2__GSNWebService_USCOREConfInfo *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__GSNWebService_USCOREConfInfo))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__GSNWebService_USCOREConfInfo(struct soap *soap, const char *tag, int id, ns2__GSNWebService_USCOREConfInfo *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__GSNWebService_USCOREConfInfo);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfInfo ** SOAP_FMAC4 soap_in_PointerTons2__GSNWebService_USCOREConfInfo(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREConfInfo **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns2__GSNWebService_USCOREConfInfo **)soap_malloc(soap, sizeof(ns2__GSNWebService_USCOREConfInfo *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns2__GSNWebService_USCOREConfInfo *)soap_instantiate_ns2__GSNWebService_USCOREConfInfo(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns2__GSNWebService_USCOREConfInfo ** p = (ns2__GSNWebService_USCOREConfInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__GSNWebService_USCOREConfInfo, sizeof(ns2__GSNWebService_USCOREConfInfo), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__GSNWebService_USCOREConfInfo(struct soap *soap, ns2__GSNWebService_USCOREConfInfo *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfInfo);
	if (soap_out_PointerTons2__GSNWebService_USCOREConfInfo(soap, tag?tag:"ns2:GSNWebService_ConfInfo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfInfo ** SOAP_FMAC4 soap_get_PointerTons2__GSNWebService_USCOREConfInfo(struct soap *soap, ns2__GSNWebService_USCOREConfInfo **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__GSNWebService_USCOREConfInfo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__GSNWebService_USCOREConfAddressing(struct soap *soap, ns2__GSNWebService_USCOREConfAddressing *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__GSNWebService_USCOREConfAddressing))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__GSNWebService_USCOREConfAddressing(struct soap *soap, const char *tag, int id, ns2__GSNWebService_USCOREConfAddressing *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__GSNWebService_USCOREConfAddressing);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfAddressing ** SOAP_FMAC4 soap_in_PointerTons2__GSNWebService_USCOREConfAddressing(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREConfAddressing **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns2__GSNWebService_USCOREConfAddressing **)soap_malloc(soap, sizeof(ns2__GSNWebService_USCOREConfAddressing *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns2__GSNWebService_USCOREConfAddressing *)soap_instantiate_ns2__GSNWebService_USCOREConfAddressing(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns2__GSNWebService_USCOREConfAddressing ** p = (ns2__GSNWebService_USCOREConfAddressing **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__GSNWebService_USCOREConfAddressing, sizeof(ns2__GSNWebService_USCOREConfAddressing), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__GSNWebService_USCOREConfAddressing(struct soap *soap, ns2__GSNWebService_USCOREConfAddressing *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__GSNWebService_USCOREConfAddressing);
	if (soap_out_PointerTons2__GSNWebService_USCOREConfAddressing(soap, tag?tag:"ns2:GSNWebService_ConfAddressing", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREConfAddressing ** SOAP_FMAC4 soap_get_PointerTons2__GSNWebService_USCOREConfAddressing(struct soap *soap, ns2__GSNWebService_USCOREConfAddressing **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__GSNWebService_USCOREConfAddressing(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__GSNWebService_USCOREDataField(struct soap *soap, ns2__GSNWebService_USCOREDataField *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__GSNWebService_USCOREDataField))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__GSNWebService_USCOREDataField(struct soap *soap, const char *tag, int id, ns2__GSNWebService_USCOREDataField *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__GSNWebService_USCOREDataField);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREDataField ** SOAP_FMAC4 soap_in_PointerTons2__GSNWebService_USCOREDataField(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREDataField **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns2__GSNWebService_USCOREDataField **)soap_malloc(soap, sizeof(ns2__GSNWebService_USCOREDataField *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns2__GSNWebService_USCOREDataField *)soap_instantiate_ns2__GSNWebService_USCOREDataField(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns2__GSNWebService_USCOREDataField ** p = (ns2__GSNWebService_USCOREDataField **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__GSNWebService_USCOREDataField, sizeof(ns2__GSNWebService_USCOREDataField), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__GSNWebService_USCOREDataField(struct soap *soap, ns2__GSNWebService_USCOREDataField *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__GSNWebService_USCOREDataField);
	if (soap_out_PointerTons2__GSNWebService_USCOREDataField(soap, tag?tag:"ns2:GSNWebService_DataField", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREDataField ** SOAP_FMAC4 soap_get_PointerTons2__GSNWebService_USCOREDataField(struct soap *soap, ns2__GSNWebService_USCOREDataField **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__GSNWebService_USCOREDataField(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__GSNWebService_USCOREStreamElement(struct soap *soap, ns2__GSNWebService_USCOREStreamElement *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__GSNWebService_USCOREStreamElement))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__GSNWebService_USCOREStreamElement(struct soap *soap, const char *tag, int id, ns2__GSNWebService_USCOREStreamElement *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__GSNWebService_USCOREStreamElement);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREStreamElement ** SOAP_FMAC4 soap_in_PointerTons2__GSNWebService_USCOREStreamElement(struct soap *soap, const char *tag, ns2__GSNWebService_USCOREStreamElement **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns2__GSNWebService_USCOREStreamElement **)soap_malloc(soap, sizeof(ns2__GSNWebService_USCOREStreamElement *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns2__GSNWebService_USCOREStreamElement *)soap_instantiate_ns2__GSNWebService_USCOREStreamElement(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns2__GSNWebService_USCOREStreamElement ** p = (ns2__GSNWebService_USCOREStreamElement **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__GSNWebService_USCOREStreamElement, sizeof(ns2__GSNWebService_USCOREStreamElement), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__GSNWebService_USCOREStreamElement(struct soap *soap, ns2__GSNWebService_USCOREStreamElement *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__GSNWebService_USCOREStreamElement);
	if (soap_out_PointerTons2__GSNWebService_USCOREStreamElement(soap, tag?tag:"ns2:GSNWebService_StreamElement", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns2__GSNWebService_USCOREStreamElement ** SOAP_FMAC4 soap_get_PointerTons2__GSNWebService_USCOREStreamElement(struct soap *soap, ns2__GSNWebService_USCOREStreamElement **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__GSNWebService_USCOREStreamElement(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTostd__string(struct soap *soap, std::string *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_std__string))
		soap_serialize_std__string(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTostd__string(struct soap *soap, const char *tag, int id, std::string *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_std__string);
	if (id < 0)
		return soap->error;
	return soap_out_std__string(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_in_PointerTostd__string(struct soap *soap, const char *tag, std::string **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (std::string **)soap_malloc(soap, sizeof(std::string *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_std__string(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (std::string **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_std__string, sizeof(std::string), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTostd__string(struct soap *soap, std::string *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTostd__string);
	if (soap_out_PointerTostd__string(soap, tag?tag:"string", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_get_PointerTostd__string(struct soap *soap, std::string **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTostd__string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToint(struct soap *soap, int *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_int);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToint(struct soap *soap, const char *tag, int id, int *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_int);
	if (id < 0)
		return soap->error;
	return soap_out_int(soap, tag, id, *a, type);
}

SOAP_FMAC3 int ** SOAP_FMAC4 soap_in_PointerToint(struct soap *soap, const char *tag, int **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (int **)soap_malloc(soap, sizeof(int *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_int(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (int **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_int, sizeof(int), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToint(struct soap *soap, int *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToint);
	if (soap_out_PointerToint(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int ** SOAP_FMAC4 soap_get_PointerToint(struct soap *soap, int **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToint(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL(struct soap *soap, std::vector<ns2__GSNWebService_USCOREWrapperURL * >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL(struct soap *soap, const std::vector<ns2__GSNWebService_USCOREWrapperURL * >*a)
{
	for (std::vector<ns2__GSNWebService_USCOREWrapperURL * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTons2__GSNWebService_USCOREWrapperURL(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL(struct soap *soap, const char *tag, int id, const std::vector<ns2__GSNWebService_USCOREWrapperURL * >*a, const char *type)
{
	for (std::vector<ns2__GSNWebService_USCOREWrapperURL * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTons2__GSNWebService_USCOREWrapperURL(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<ns2__GSNWebService_USCOREWrapperURL * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL(struct soap *soap, const char *tag, std::vector<ns2__GSNWebService_USCOREWrapperURL * >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL(soap, -1)))
		return NULL;
	ns2__GSNWebService_USCOREWrapperURL *n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n = NULL;
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_ns2__GSNWebService_USCOREWrapperURL, SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL, sizeof(ns2__GSNWebService_USCOREWrapperURL), 1))
				break;
			if (!soap_in_PointerTons2__GSNWebService_USCOREWrapperURL(soap, tag, NULL, "ns2:GSNWebService_WrapperURL"))
				break;
		}
		else
		{
			if (!soap_in_PointerTons2__GSNWebService_USCOREWrapperURL(soap, tag, &n, "ns2:GSNWebService_WrapperURL"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<ns2__GSNWebService_USCOREWrapperURL * > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns2__GSNWebService_USCOREWrapperURL * >);
		if (size)
			*size = sizeof(std::vector<ns2__GSNWebService_USCOREWrapperURL * >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns2__GSNWebService_USCOREWrapperURL * >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<ns2__GSNWebService_USCOREWrapperURL * >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<ns2__GSNWebService_USCOREWrapperURL * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperURL(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<ns2__GSNWebService_USCOREWrapperURL * > %p -> %p\n", q, p));
	*(std::vector<ns2__GSNWebService_USCOREWrapperURL * >*)p = *(std::vector<ns2__GSNWebService_USCOREWrapperURL * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails(struct soap *soap, std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails(struct soap *soap, const std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >*a)
{
	for (std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTons2__GSNWebService_USCOREVirtualSensorDetails(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails(struct soap *soap, const char *tag, int id, const std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >*a, const char *type)
{
	for (std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTons2__GSNWebService_USCOREVirtualSensorDetails(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails(struct soap *soap, const char *tag, std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails(soap, -1)))
		return NULL;
	ns2__GSNWebService_USCOREVirtualSensorDetails *n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n = NULL;
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_ns2__GSNWebService_USCOREVirtualSensorDetails, SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails, sizeof(ns2__GSNWebService_USCOREVirtualSensorDetails), 1))
				break;
			if (!soap_in_PointerTons2__GSNWebService_USCOREVirtualSensorDetails(soap, tag, NULL, "ns2:GSNWebService_VirtualSensorDetails"))
				break;
		}
		else
		{
			if (!soap_in_PointerTons2__GSNWebService_USCOREVirtualSensorDetails(soap, tag, &n, "ns2:GSNWebService_VirtualSensorDetails"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >);
		if (size)
			*size = sizeof(std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREVirtualSensorDetails(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * > %p -> %p\n", q, p));
	*(std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >*)p = *(std::vector<ns2__GSNWebService_USCOREVirtualSensorDetails * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType(struct soap *soap, std::vector<enum ns2__GSNWebService_USCOREDetailsType >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType(struct soap *soap, const std::vector<enum ns2__GSNWebService_USCOREDetailsType >*a)
{
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType(struct soap *soap, const char *tag, int id, const std::vector<enum ns2__GSNWebService_USCOREDetailsType >*a, const char *type)
{
	for (std::vector<enum ns2__GSNWebService_USCOREDetailsType >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_ns2__GSNWebService_USCOREDetailsType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<enum ns2__GSNWebService_USCOREDetailsType >* SOAP_FMAC4 soap_in_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType(struct soap *soap, const char *tag, std::vector<enum ns2__GSNWebService_USCOREDetailsType >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType(soap, -1)))
		return NULL;
	enum ns2__GSNWebService_USCOREDetailsType n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		soap_default_ns2__GSNWebService_USCOREDetailsType(soap, &n);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_ns2__GSNWebService_USCOREDetailsType, SOAP_TYPE_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType, sizeof(enum ns2__GSNWebService_USCOREDetailsType), 0))
				break;
			if (!soap_in_ns2__GSNWebService_USCOREDetailsType(soap, tag, NULL, "ns2:GSNWebService_DetailsType"))
				break;
		}
		else
		{
			if (!soap_in_ns2__GSNWebService_USCOREDetailsType(soap, tag, &n, "ns2:GSNWebService_DetailsType"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<enum ns2__GSNWebService_USCOREDetailsType > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<enum ns2__GSNWebService_USCOREDetailsType >);
		if (size)
			*size = sizeof(std::vector<enum ns2__GSNWebService_USCOREDetailsType >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<enum ns2__GSNWebService_USCOREDetailsType >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<enum ns2__GSNWebService_USCOREDetailsType >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<enum ns2__GSNWebService_USCOREDetailsType >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfns2__GSNWebService_USCOREDetailsType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<enum ns2__GSNWebService_USCOREDetailsType > %p -> %p\n", q, p));
	*(std::vector<enum ns2__GSNWebService_USCOREDetailsType >*)p = *(std::vector<enum ns2__GSNWebService_USCOREDetailsType >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTons3__StandardCriterion(struct soap *soap, std::vector<ns3__StandardCriterion * >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTons3__StandardCriterion(struct soap *soap, const std::vector<ns3__StandardCriterion * >*a)
{
	for (std::vector<ns3__StandardCriterion * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTons3__StandardCriterion(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTons3__StandardCriterion(struct soap *soap, const char *tag, int id, const std::vector<ns3__StandardCriterion * >*a, const char *type)
{
	for (std::vector<ns3__StandardCriterion * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTons3__StandardCriterion(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<ns3__StandardCriterion * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTons3__StandardCriterion(struct soap *soap, const char *tag, std::vector<ns3__StandardCriterion * >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTons3__StandardCriterion(soap, -1)))
		return NULL;
	ns3__StandardCriterion *n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n = NULL;
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_ns3__StandardCriterion, SOAP_TYPE_std__vectorTemplateOfPointerTons3__StandardCriterion, sizeof(ns3__StandardCriterion), 1))
				break;
			if (!soap_in_PointerTons3__StandardCriterion(soap, tag, NULL, "ns3:StandardCriterion"))
				break;
		}
		else
		{
			if (!soap_in_PointerTons3__StandardCriterion(soap, tag, &n, "ns3:StandardCriterion"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<ns3__StandardCriterion * > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfPointerTons3__StandardCriterion(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTons3__StandardCriterion(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTons3__StandardCriterion, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns3__StandardCriterion * >);
		if (size)
			*size = sizeof(std::vector<ns3__StandardCriterion * >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns3__StandardCriterion * >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<ns3__StandardCriterion * >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<ns3__StandardCriterion * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTons3__StandardCriterion(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<ns3__StandardCriterion * > %p -> %p\n", q, p));
	*(std::vector<ns3__StandardCriterion * >*)p = *(std::vector<ns3__StandardCriterion * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(struct soap *soap, std::vector<ns2__GSNWebService_USCOREQueryResult * >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(struct soap *soap, const std::vector<ns2__GSNWebService_USCOREQueryResult * >*a)
{
	for (std::vector<ns2__GSNWebService_USCOREQueryResult * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTons2__GSNWebService_USCOREQueryResult(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(struct soap *soap, const char *tag, int id, const std::vector<ns2__GSNWebService_USCOREQueryResult * >*a, const char *type)
{
	for (std::vector<ns2__GSNWebService_USCOREQueryResult * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTons2__GSNWebService_USCOREQueryResult(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<ns2__GSNWebService_USCOREQueryResult * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(struct soap *soap, const char *tag, std::vector<ns2__GSNWebService_USCOREQueryResult * >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(soap, -1)))
		return NULL;
	ns2__GSNWebService_USCOREQueryResult *n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n = NULL;
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_ns2__GSNWebService_USCOREQueryResult, SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult, sizeof(ns2__GSNWebService_USCOREQueryResult), 1))
				break;
			if (!soap_in_PointerTons2__GSNWebService_USCOREQueryResult(soap, tag, NULL, "ns2:GSNWebService_QueryResult"))
				break;
		}
		else
		{
			if (!soap_in_PointerTons2__GSNWebService_USCOREQueryResult(soap, tag, &n, "ns2:GSNWebService_QueryResult"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<ns2__GSNWebService_USCOREQueryResult * > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns2__GSNWebService_USCOREQueryResult * >);
		if (size)
			*size = sizeof(std::vector<ns2__GSNWebService_USCOREQueryResult * >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns2__GSNWebService_USCOREQueryResult * >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<ns2__GSNWebService_USCOREQueryResult * >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<ns2__GSNWebService_USCOREQueryResult * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREQueryResult(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<ns2__GSNWebService_USCOREQueryResult * > %p -> %p\n", q, p));
	*(std::vector<ns2__GSNWebService_USCOREQueryResult * >*)p = *(std::vector<ns2__GSNWebService_USCOREQueryResult * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(struct soap *soap, std::vector<ns2__GSNWebService_USCOREFieldSelector * >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(struct soap *soap, const std::vector<ns2__GSNWebService_USCOREFieldSelector * >*a)
{
	for (std::vector<ns2__GSNWebService_USCOREFieldSelector * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTons2__GSNWebService_USCOREFieldSelector(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(struct soap *soap, const char *tag, int id, const std::vector<ns2__GSNWebService_USCOREFieldSelector * >*a, const char *type)
{
	for (std::vector<ns2__GSNWebService_USCOREFieldSelector * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTons2__GSNWebService_USCOREFieldSelector(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<ns2__GSNWebService_USCOREFieldSelector * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(struct soap *soap, const char *tag, std::vector<ns2__GSNWebService_USCOREFieldSelector * >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(soap, -1)))
		return NULL;
	ns2__GSNWebService_USCOREFieldSelector *n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n = NULL;
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_ns2__GSNWebService_USCOREFieldSelector, SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector, sizeof(ns2__GSNWebService_USCOREFieldSelector), 1))
				break;
			if (!soap_in_PointerTons2__GSNWebService_USCOREFieldSelector(soap, tag, NULL, "ns2:GSNWebService_FieldSelector"))
				break;
		}
		else
		{
			if (!soap_in_PointerTons2__GSNWebService_USCOREFieldSelector(soap, tag, &n, "ns2:GSNWebService_FieldSelector"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<ns2__GSNWebService_USCOREFieldSelector * > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns2__GSNWebService_USCOREFieldSelector * >);
		if (size)
			*size = sizeof(std::vector<ns2__GSNWebService_USCOREFieldSelector * >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns2__GSNWebService_USCOREFieldSelector * >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<ns2__GSNWebService_USCOREFieldSelector * >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<ns2__GSNWebService_USCOREFieldSelector * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREFieldSelector(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<ns2__GSNWebService_USCOREFieldSelector * > %p -> %p\n", q, p));
	*(std::vector<ns2__GSNWebService_USCOREFieldSelector * >*)p = *(std::vector<ns2__GSNWebService_USCOREFieldSelector * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails(struct soap *soap, std::vector<ns2__GSNWebService_USCOREWrapperDetails * >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails(struct soap *soap, const std::vector<ns2__GSNWebService_USCOREWrapperDetails * >*a)
{
	for (std::vector<ns2__GSNWebService_USCOREWrapperDetails * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTons2__GSNWebService_USCOREWrapperDetails(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails(struct soap *soap, const char *tag, int id, const std::vector<ns2__GSNWebService_USCOREWrapperDetails * >*a, const char *type)
{
	for (std::vector<ns2__GSNWebService_USCOREWrapperDetails * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTons2__GSNWebService_USCOREWrapperDetails(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<ns2__GSNWebService_USCOREWrapperDetails * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails(struct soap *soap, const char *tag, std::vector<ns2__GSNWebService_USCOREWrapperDetails * >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails(soap, -1)))
		return NULL;
	ns2__GSNWebService_USCOREWrapperDetails *n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n = NULL;
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_ns2__GSNWebService_USCOREWrapperDetails, SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails, sizeof(ns2__GSNWebService_USCOREWrapperDetails), 1))
				break;
			if (!soap_in_PointerTons2__GSNWebService_USCOREWrapperDetails(soap, tag, NULL, "ns2:GSNWebService_WrapperDetails"))
				break;
		}
		else
		{
			if (!soap_in_PointerTons2__GSNWebService_USCOREWrapperDetails(soap, tag, &n, "ns2:GSNWebService_WrapperDetails"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<ns2__GSNWebService_USCOREWrapperDetails * > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns2__GSNWebService_USCOREWrapperDetails * >);
		if (size)
			*size = sizeof(std::vector<ns2__GSNWebService_USCOREWrapperDetails * >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns2__GSNWebService_USCOREWrapperDetails * >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<ns2__GSNWebService_USCOREWrapperDetails * >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<ns2__GSNWebService_USCOREWrapperDetails * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREWrapperDetails(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<ns2__GSNWebService_USCOREWrapperDetails * > %p -> %p\n", q, p));
	*(std::vector<ns2__GSNWebService_USCOREWrapperDetails * >*)p = *(std::vector<ns2__GSNWebService_USCOREWrapperDetails * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(struct soap *soap, std::vector<ns2__GSNWebService_USCOREConfPredicate * >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(struct soap *soap, const std::vector<ns2__GSNWebService_USCOREConfPredicate * >*a)
{
	for (std::vector<ns2__GSNWebService_USCOREConfPredicate * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTons2__GSNWebService_USCOREConfPredicate(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(struct soap *soap, const char *tag, int id, const std::vector<ns2__GSNWebService_USCOREConfPredicate * >*a, const char *type)
{
	for (std::vector<ns2__GSNWebService_USCOREConfPredicate * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTons2__GSNWebService_USCOREConfPredicate(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<ns2__GSNWebService_USCOREConfPredicate * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(struct soap *soap, const char *tag, std::vector<ns2__GSNWebService_USCOREConfPredicate * >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(soap, -1)))
		return NULL;
	ns2__GSNWebService_USCOREConfPredicate *n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n = NULL;
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_ns2__GSNWebService_USCOREConfPredicate, SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate, sizeof(ns2__GSNWebService_USCOREConfPredicate), 1))
				break;
			if (!soap_in_PointerTons2__GSNWebService_USCOREConfPredicate(soap, tag, NULL, "ns2:GSNWebService_ConfPredicate"))
				break;
		}
		else
		{
			if (!soap_in_PointerTons2__GSNWebService_USCOREConfPredicate(soap, tag, &n, "ns2:GSNWebService_ConfPredicate"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<ns2__GSNWebService_USCOREConfPredicate * > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns2__GSNWebService_USCOREConfPredicate * >);
		if (size)
			*size = sizeof(std::vector<ns2__GSNWebService_USCOREConfPredicate * >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns2__GSNWebService_USCOREConfPredicate * >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<ns2__GSNWebService_USCOREConfPredicate * >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<ns2__GSNWebService_USCOREConfPredicate * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREConfPredicate(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<ns2__GSNWebService_USCOREConfPredicate * > %p -> %p\n", q, p));
	*(std::vector<ns2__GSNWebService_USCOREConfPredicate * >*)p = *(std::vector<ns2__GSNWebService_USCOREConfPredicate * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(struct soap *soap, std::vector<ns2__GSNWebService_USCOREDataField * >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(struct soap *soap, const std::vector<ns2__GSNWebService_USCOREDataField * >*a)
{
	for (std::vector<ns2__GSNWebService_USCOREDataField * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTons2__GSNWebService_USCOREDataField(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(struct soap *soap, const char *tag, int id, const std::vector<ns2__GSNWebService_USCOREDataField * >*a, const char *type)
{
	for (std::vector<ns2__GSNWebService_USCOREDataField * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTons2__GSNWebService_USCOREDataField(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<ns2__GSNWebService_USCOREDataField * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(struct soap *soap, const char *tag, std::vector<ns2__GSNWebService_USCOREDataField * >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(soap, -1)))
		return NULL;
	ns2__GSNWebService_USCOREDataField *n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n = NULL;
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_ns2__GSNWebService_USCOREDataField, SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField, sizeof(ns2__GSNWebService_USCOREDataField), 1))
				break;
			if (!soap_in_PointerTons2__GSNWebService_USCOREDataField(soap, tag, NULL, "ns2:GSNWebService_DataField"))
				break;
		}
		else
		{
			if (!soap_in_PointerTons2__GSNWebService_USCOREDataField(soap, tag, &n, "ns2:GSNWebService_DataField"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<ns2__GSNWebService_USCOREDataField * > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns2__GSNWebService_USCOREDataField * >);
		if (size)
			*size = sizeof(std::vector<ns2__GSNWebService_USCOREDataField * >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns2__GSNWebService_USCOREDataField * >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<ns2__GSNWebService_USCOREDataField * >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<ns2__GSNWebService_USCOREDataField * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREDataField(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<ns2__GSNWebService_USCOREDataField * > %p -> %p\n", q, p));
	*(std::vector<ns2__GSNWebService_USCOREDataField * >*)p = *(std::vector<ns2__GSNWebService_USCOREDataField * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement(struct soap *soap, std::vector<ns2__GSNWebService_USCOREStreamElement * >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement(struct soap *soap, const std::vector<ns2__GSNWebService_USCOREStreamElement * >*a)
{
	for (std::vector<ns2__GSNWebService_USCOREStreamElement * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTons2__GSNWebService_USCOREStreamElement(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement(struct soap *soap, const char *tag, int id, const std::vector<ns2__GSNWebService_USCOREStreamElement * >*a, const char *type)
{
	for (std::vector<ns2__GSNWebService_USCOREStreamElement * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTons2__GSNWebService_USCOREStreamElement(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<ns2__GSNWebService_USCOREStreamElement * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement(struct soap *soap, const char *tag, std::vector<ns2__GSNWebService_USCOREStreamElement * >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement(soap, -1)))
		return NULL;
	ns2__GSNWebService_USCOREStreamElement *n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n = NULL;
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_ns2__GSNWebService_USCOREStreamElement, SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement, sizeof(ns2__GSNWebService_USCOREStreamElement), 1))
				break;
			if (!soap_in_PointerTons2__GSNWebService_USCOREStreamElement(soap, tag, NULL, "ns2:GSNWebService_StreamElement"))
				break;
		}
		else
		{
			if (!soap_in_PointerTons2__GSNWebService_USCOREStreamElement(soap, tag, &n, "ns2:GSNWebService_StreamElement"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<ns2__GSNWebService_USCOREStreamElement * > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns2__GSNWebService_USCOREStreamElement * >);
		if (size)
			*size = sizeof(std::vector<ns2__GSNWebService_USCOREStreamElement * >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<ns2__GSNWebService_USCOREStreamElement * >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<ns2__GSNWebService_USCOREStreamElement * >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<ns2__GSNWebService_USCOREStreamElement * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTons2__GSNWebService_USCOREStreamElement(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<ns2__GSNWebService_USCOREStreamElement * > %p -> %p\n", q, p));
	*(std::vector<ns2__GSNWebService_USCOREStreamElement * >*)p = *(std::vector<ns2__GSNWebService_USCOREStreamElement * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfstd__string(struct soap *soap, std::vector<std::string >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfstd__string(struct soap *soap, const std::vector<std::string >*a)
{
	for (std::vector<std::string >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_std__string(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfstd__string(struct soap *soap, const char *tag, int id, const std::vector<std::string >*a, const char *type)
{
	for (std::vector<std::string >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_std__string(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<std::string >* SOAP_FMAC4 soap_in_std__vectorTemplateOfstd__string(struct soap *soap, const char *tag, std::vector<std::string >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfstd__string(soap, -1)))
		return NULL;
	std::string n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		soap_default_std__string(soap, &n);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_std__string, SOAP_TYPE_std__vectorTemplateOfstd__string, sizeof(std::string), 0))
				break;
			if (!soap_in_std__string(soap, tag, NULL, "xsd:string"))
				break;
		}
		else
		{
			if (!soap_in_std__string(soap, tag, &n, "xsd:string"))
				break;
		}
		soap_update_pointers(soap, (char*)&n, (char*)&n + sizeof(n), (char*)&(*a->insert(a->end(), n)), (char*)&n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<std::string > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfstd__string(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfstd__string(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfstd__string, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<std::string >);
		if (size)
			*size = sizeof(std::vector<std::string >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<std::string >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<std::string >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<std::string >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfstd__string(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<std::string > %p -> %p\n", q, p));
	*(std::vector<std::string >*)p = *(std::vector<std::string >*)q;
}

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapC.cpp */
