# SPDX-License-Identifier: AGPL-3.0-or-later
import logging
import signal

from . import main, handle_signal
from ..sentry import maybe_init_sentry

if __name__ == '__main__':
    print('This is the backend background worker (for guest jobs cleanup).')
    logging.basicConfig(level=logging.INFO)

    signal.signal(signal.SIGTERM, handle_signal)
    signal.signal(signal.SIGINT, handle_signal)

    maybe_init_sentry()

    main()
