from typing import Set, Iterable

import unicodedata


def normalize(text: str) -> str:
    nkfd = unicodedata.normalize('NFKD', text)
    return "".join(c for c in nkfd if not unicodedata.combining(c)).casefold()


def compute_phonetic_set(texts: Iterable[str]) -> Set[str]:
    import jellyfish
    tokens: Set[str] = set()
    for text in texts:
        tokens.update(normalize(text).split())
    return {
        jellyfish.metaphone(token)
        for token in tokens
        if token
    }
