# SPDX-License-Identifier: AGPL-3.0-or-later
from pathlib import Path

from .metadata import NcmlImportantMetadata
from .parser import parse_ncml

# Suppose 'test_example.ncml' contains:
# <netcdf location="data.nc">
#   <dimension name="time" length="0" isUnlimited="true"/>
#   <attribute name="title" type="string" value="Sample Dataset"/>
#   <variable name="temp" type="float" shape="time lat lon">
#       <attribute name="units" type="string" value="K"/>
#   </variable>
# </netcdf>


if __name__ == "__main__":

    ncml_path = Path(__file__).parent / "test_example.ncml"
    ncml = parse_ncml(ncml_path)

    print(ncml.model_dump_json(indent=2))
    print(NcmlImportantMetadata.make_from_ncml(ncml).model_dump_json(indent=2))
    # This will output a validated JSON representation of the NcML contents.
