# SPDX-License-Identifier: AGPL-3.0-or-later
from typing import List, Optional
from pydantic import BaseModel, Field


class Dimension(BaseModel):
    name: str
    length: Optional[int] = None
    is_unlimited: Optional[bool] = Field(False, alias="isUnlimited")


class Attribute(BaseModel):
    name: str
    value: str
    type: Optional[str] = None


class Variable(BaseModel):
    name: str
    type: str
    shape: Optional[str] = None
    dimensions: Optional[str] = None
    attributes: List[Attribute] = []


class NcML(BaseModel):
    location: Optional[str] = None
    dimensions: List[Dimension] = []
    variables: List[Variable] = []
    attributes: List[Attribute] = []
