# SPDX-License-Identifier: AGPL-3.0-or-later

import datetime

from sqlalchemy.orm import Mapped, mapped_column

from ._tables_registry import tables_registry


@tables_registry.mapped_as_dataclass()
class NotificationSilence:
    """
    User's choice to silence notifications with a specific event fingerprint
    """

    __tablename__ = "notification_silence"

    recipient_id: Mapped[str] = mapped_column(primary_key=True)
    """External recipient/user id"""

    event_fingerprint: Mapped[str] = mapped_column(primary_key=True)

    created_at: Mapped[datetime.datetime] = mapped_column(
        nullable=False, default_factory=lambda: datetime.datetime.utcnow().replace(tzinfo=datetime.timezone.utc))
