# SPDX-License-Identifier: AGPL-3.0-or-later
from pydantic import BaseModel, ConfigDict
from sqlalchemy.orm import Mapped, mapped_column

from ._tables_registry import tables_registry


@tables_registry.mapped_as_dataclass()
class NotificationSetting:
    """
    User's choice of notification settings for an event type
    """

    __tablename__ = "notification_settings"

    recipient_id: Mapped[str] = mapped_column(primary_key=True)
    """External recipient/user id"""

    event_type: Mapped[str] = mapped_column(primary_key=True)

    email_enabled: Mapped[bool] = mapped_column(default=True)
    email_min_interval: Mapped[int] = mapped_column(default=60*10)
    """Seconds"""

    # events: Mapped[List['Event']] = relationship(
    #    "Event", primaryjoin="NotificationSetting.event_type == Event.event_type"
    # )


class NotificationSettingDTO(BaseModel):
    model_config = ConfigDict(from_attributes=True)

    recipient_id: str
    event_type: str
    email_enabled: bool = True
    email_min_interval: int = 60*10
