# SPDX-License-Identifier: AGPL-3.0-or-later

from enum import Enum

class EventType(str, Enum):
    """
    Enum representing different types of events.
    """
    dataset_cron_job = "dataset_cron_job"
    dataset_manual_job = "dataset_manual_job"
    data_owner_privilege_request = "data_owner_privilege_request"


# NOTE: These must not be too specific to allow coarse notification settings.
#       dataset_cron_job_schedule_fail = "dataset_cron_job_schedule_fail"
#       dataset_cron_job_run_fail = "dataset_cron_job_run_fail"
#       dataset_cron_job_logged_error = "dataset_cron_job_logged_error"
#       dataset_cron_job_logged_warning = "dataset_cron_job_logged_warning"
