# SPDX-License-Identifier: AGPL-3.0-or-later

from pydantic import BaseModel, ConfigDict
from typing import Optional
import datetime


class EventDTO(BaseModel):
    model_config = ConfigDict(from_attributes=True)

    id: str  # Unique identifier for the event
    from_user_id: Optional[str]  # ID of the user who triggered the event
    from_dataset_id: Optional[str]  # ID of the dataset associated with the event
    from_dataset_cron_id: Optional[str]  # ID of the cron job associated with the dataset
    from_job_id: Optional[str]  # ID of the job associated with the event
    event_type: Optional[str]  # Type of the event (e.g., job failure, privilege request)
    event_title: Optional[str]  # Short descriptive title of the event
    event_details: Optional[str]  # Additional detailed information about the event
    created_at: datetime.datetime  # Timestamp when the event was created
    fingerprint: Optional[str]  # Unique hash used to group similar events
