import json
import logging
import time
from pathlib import Path
from typing import Union, Optional

# from .exceptions import FuseMountException

_LOGGER = logging.getLogger(__name__)


def check_fuse_mount(
    *,
    local_mount_point: Union[Path, str],
    # raise_on_exceptions: bool = True,
    n_attempts: int = 20,
    timeout: float = 30.,
    log_file_path: Optional[Path] = None,
    log_distinguisher: str = '',
) -> None:
    """
    Check if the given path is a mount.
    Retries to allow mounting to take place in a matter of seconds in a concurrent process.
    """
    _start_time = time.monotonic()

    for attempts_left in reversed(range(n_attempts)):
        if local_mount_point.is_mount():
            if log_file_path:
                with Path(log_file_path).open('a') as log_file:
                    log_file.write(f"[[fuse:{json.dumps(log_distinguisher)}:check]]: Mount checked.\n")
            return
        _elapsed = time.monotonic() - _start_time
        if attempts_left > 0 and _elapsed < timeout:
            time.sleep(1.)
        else:
            if log_file_path:
                with Path(log_file_path).open('a') as log_file:
                    log_file.write(f"[[fuse:{json.dumps(log_distinguisher)}:check]]: Unable to check mount.\n")
            # if raise_on_exceptions:
            #     raise FuseMountException(f"Unable to check mount at {str(local_mount_point)}")
            # else:
            _LOGGER.error(f"Unable to check mount at {str(local_mount_point)}")

            return # NOTE: we might be in the case of _elapsed >= timeout while also having attempts_left > 0

    # Run fusermount -q , which returns 0 iff it finds the FUSE mount point.
    # NOTE: It looks like this usage of fusermount is no longer supported...
    #       «fusermount: old style mounting not supported»
    # for attempts_left in reversed(range(n_attempts)):
    #     try:
    #         _elapsed = time.monotonic() - _start_time
    #         subprocess.check_output(
    #             ['fusermount', '-q', str(local_mount_point)],
    #             timeout=max(timeout - _elapsed, 1.),
    #         )
    #     except (subprocess.TimeoutExpired, subprocess.CalledProcessError, FileNotFoundError, PermissionError):
    #         _elapsed = time.monotonic() - _start_time
    #         if attempts_left > 0 and _elapsed < timeout:
    #             time.sleep(1.)
    #         else:
    #             if raise_on_exceptions:
    #                 raise
    #             else:
    #                 _LOGGER.exception(f"Unable to check mount at {str(local_mount_point)}")
    #     else:
    #         break
