# SPDX-License-Identifier: AGPL-3.0-or-later

from pydantic.dataclasses import dataclass

from .config_file import TextConfigFile
from ..job_env_config import JobEnvConfig


@dataclass(frozen=True)
class JobEnvConfigFile:
    file: TextConfigFile

    def create(self, cfg: JobEnvConfig) -> None:
        self.file.create(cfg.model_dump_json(indent=1))

    def read(self) -> JobEnvConfig:
        if not self.file.path.exists():
            return JobEnvConfig()
        return JobEnvConfig.model_validate_json(self.file.read())

    def update(self, cfg: JobEnvConfig) -> None:
        self.file.update(cfg.model_dump_json(indent=1), must_exist=False)


# NOTE: It's important that the configuration schema allows for an empty config as default (existence of the empty set).
