# SPDX-License-Identifier: AGPL-3.0-or-later

from pydantic.dataclasses import dataclass

from .config_file import TextConfigFile
from ..fuse.configs import FuseMountListConfig

FuseConfig = FuseMountListConfig

@dataclass(frozen=True)
class FuseConfigFile:
    file: TextConfigFile

    def create(self, cfg: FuseConfig) -> None:
        self.file.create(cfg.model_dump_json(indent=1))

    def read(self) -> FuseConfig:
        if not self.file.path.exists():
            return FuseConfig(mounts=dict())
        return FuseConfig.model_validate_json(self.file.read())

    def update(self, cfg: FuseConfig) -> None:
        self.file.update(cfg.model_dump_json(indent=1), must_exist=False)


# NOTE: It's important that the configuration schema allows for an empty config as default (existence of the empty set).
