# SPDX-License-Identifier: AGPL-3.0-or-later
import logging
import signal
import sys

from . import main, JobRunnerEnvSettings
from ..sentry import maybe_init_sentry

def handle_signal(signum, frame):
    print(f"Received signal {signum}. Terminating gracefully...")
    sys.exit(0)

if __name__ == '__main__':
    print('This is the job runner.')
    logging.basicConfig(level=logging.INFO)

    signal.signal(signal.SIGTERM, handle_signal)
    signal.signal(signal.SIGINT, handle_signal)

    maybe_init_sentry()

    main(JobRunnerEnvSettings())