from litestar import put, get
from litestar.exceptions import NotAuthorizedException

from .reflection import MyUserDepT
from ....models import EntityManager
from ....models.errors import NotFound
from ....models.job_env_config import JobEnvConfig
from ....models.users import User


@get("/", sync_to_thread=True)
def load_user_profile_job_env_config(my_user: MyUserDepT) -> JobEnvConfig:
    if my_user is None:
        raise NotFound('No user to get the env config from')
    return my_user.job_env_config


@put("/", sync_to_thread=True)
def store_user_profile_job_env_config(
    my_user: MyUserDepT,
    data: JobEnvConfig,
    entity_manager: EntityManager
) -> None:
    if my_user is None:
        raise NotAuthorizedException
    with entity_manager.users.transaction() as tx:
        user: User = tx.get(User, my_user.id)
        assert user is not None
        user.job_env_config = data


# router = Router(
#     path='/job_env_config',
#     route_handlers=[
#         _load,
#         _store,
#     ],
# ),
