# SPDX-License-Identifier: AGPL-3.0-or-later
from litestar import Router
from litestar.di import Provide

from .configuration import _retrieve_frontend_configuration
from .reflection import get_me, get_my_user
from .ssh_authorized_keys import get_ssh_authorized_keys, add_ssh_authorized_key, rm_ssh_authorized_key
from . import job_env_config

user_router = Router(
    path="/me",
    tags=['auth'],
    route_handlers=[
        get_me,
        _retrieve_frontend_configuration,
        # job_env_config.router,  # This does not work for mysterious error from litestar validation.
        Router(
            path='/job_env_config',
            route_handlers=[
                job_env_config.load_user_profile_job_env_config,
                job_env_config.store_user_profile_job_env_config,
            ],
        ),
        Router(
            path='/ssh_authorized_keys',
            route_handlers=[
                get_ssh_authorized_keys,
                add_ssh_authorized_key,
                rm_ssh_authorized_key,
            ]
        ),
    ],
    dependencies={
        'my_user': Provide(get_my_user, sync_to_thread=True),
    }
)