import {useEffect, useState} from "react";

export function usePromise<T>(f: () => Promise<T | undefined>, deps?: unknown[], swr: boolean = false): [T | undefined, {
    error: Error | undefined,
    isLoading: boolean
}] {
    const [result, setResult] = useState<T>()
    const [error, setError] = useState<Error>()
    const [loading, setLoading] = useState<boolean>(true)
    useEffect(() => {
        setLoading(true)
        if (!swr) {
            setResult(undefined)
        }
        setError(undefined);
        let cancelled = false;
        (async () => {
            try {
                const res = await f?.()
                if (cancelled) {
                    return
                }
                setResult(res)
            }
            catch (e) {
                setResult(undefined)
                setError(e)
            }
            finally {
                if (!cancelled) {
                    setLoading(false)
                }
            }
        })();
        return () => {
            cancelled = true;
        }
    }, deps ?? [])
    return [result, {error, isLoading: loading}]
}
