import * as React from "react";
import {useState} from "react";
import {Input} from "antd";
import {ControlLabel} from "./ControlLabel";

export const FloatingLabelInput: React.FC<{
    label: string;
    value: string | undefined;
    onChange: (value: string) => void;
    style?: React.CSSProperties;
    allowClear?: boolean
}> = (props) => {
    const [isFocused, setIsFocused] = useState(false);

    return (
        <div style={{position: 'relative', ...(props.style)}}>
            <div
                style={{
                    contain: 'paint', // The input uses z-index on hover -- let's isolate to avoid it to go above the label.
                    padding: '3px', // The input has a nice glare on focus -- let's give space to allow it within the paint containment.
                    margin: '-3px' // Compensation for the above padding.
                }}
            >
                <Input
                    value={props.value}
                    onChange={(e) => props.onChange(e.target.value)}
                    onFocus={() => setIsFocused(true)}
                    onBlur={() => setIsFocused(false)}
                    allowClear={props.allowClear}
                />
            </div>
            <div
                style={{
                    position: 'absolute',
                    top: props.value || isFocused ? '-22px' : '3px',
                    left: props.value || isFocused ? '1px' : '10px',
                    transition: 'all 0.2s ease',
                    pointerEvents: 'none',
                }}
            >
                <ControlLabel
                    style={{
                        color: props.value || isFocused ? undefined : '#aaa',
                    }}
                >
                    {props.label}
                </ControlLabel>
            </div>
        </div>
    );
};