import * as React from 'react';
import {makeStyles, shorthands, tokens} from '@fluentui/react-components';
import {useScreenSize} from "../hooks/useScreenSize";

interface DetailsBoxProps {
    columns?: number;
    details: { label?: React.ReactNode; value?: React.ReactNode }[];
}

const useStyles = makeStyles({
    box: {
        ...shorthands.border('thin', 'solid', tokens.colorNeutralStroke2),
        ...shorthands.padding(tokens.spacingVerticalM, tokens.spacingHorizontalM),
        borderRadius: tokens.borderRadiusMedium,
        columnRuleColor: tokens.colorNeutralStroke2,
        columnRuleStyle: 'solid',
        columnRuleWidth: 'thin',
        columnGap: `calc(2 * ${tokens.spacingHorizontalM})`,
        lineHeight: '1.5em',
    },
    detail: {
        // marginBottom: tokens.spacingVerticalXXS,
        '& code': {
            fontSize: '0.9em',
        }
    },
});

export const DetailsBox: React.FC<DetailsBoxProps> = (props) => {
    const styles = useStyles();
    const {isMobile} = useScreenSize()

    return <div
        className={styles.box}
        style={{columns: props.columns ?? (isMobile ? 1 : 2)}}
    >
        {props.details.map(
            (detail, index) =>
                (detail.label && detail.value) &&
                <div
                    key={`${index}-${detail?.label ?? ''}`}
                    className={styles.detail}
                >
                    {detail.label && <span
                        style={{color: tokens.colorNeutralForeground4, fontSize: '0.9em'}}
                    >
                        {detail.label}:&nbsp;
                    </span>}
                    {detail.value}
                </div>
        )}
    </div>
};
