import * as React from 'react'
import {Route, Routes} from "react-router-dom";
import {Sticky} from "meteoio-ui/src/components/Sticky";
import {MainContentSplit} from "meteoio-ui/src/layouts/MainContentSplit";
import {NavLinksList} from "meteoio-ui/src/components/NavLinksList";
import {MainTopBar} from "../_common/MainTopBar";
import {NotFound} from "../_common/NotFound";
import {ChevronRightRegular} from "@fluentui/react-icons";
import {UserPage_Home} from "./UserPage_Home";
import {UserPage_Profile} from "./UserPage_Profile";
import {UserPage_JobEnv} from "./UserPage_JobEnv";
import {UserPage_Events} from "./UserPage_Events";
import {UserPage_EventDetails} from "./UserPage_EventDetails";


export const UserPages: React.FC = () => {
    return <>
        <MainTopBar startExtra={<>
            <ChevronRightRegular/>
            <b>User</b>
        </>}/>
        <MainContentSplit
            nav={<Sticky top={65}>
                <NavLinksList
                    links={[
                        {to: '/user/profile', children: <>Profile</>},
                        {to: '/user/job_env', children: <>Environment variables</>},
                        {to: '/user/events', children: <>Recent events</>},
                        // {to: '/user/permissions', children: <>Access and permissions</>},
                        // TODO: SFTP access
                    ]}
                />
            </Sticky>}
        >
            <Routes>
                <Route index Component={UserPage_Home}/>
                <Route path={"profile"} Component={UserPage_Profile}/>
                <Route path={"job_env"} Component={UserPage_JobEnv}/>
                {/*<Route path={"permissions"} Component={UserPage_Profile}/>*/}
                <Route path={"events"} Component={UserPage_Events}/>
                <Route path={"events/:eventId"} Component={UserPage_EventDetails}/>
                <Route path={"*"} Component={NotFound}/>
            </Routes>
        </MainContentSplit>
    </>
}


// TODO?: In-app notifications view? Maybe review notifications data model first.
