import * as React from 'react'
import {Stack} from "meteoio-ui/src/layouts/Stack";
import {
    fetchPublicMeJobEnvConfigLoadUserProfileJobEnvConfig,
    fetchPublicMeJobEnvConfigStoreUserProfileJobEnvConfig
} from "meteoio-platform-client";
import {EnvSettingsEditor} from "../_common/EnvSettingsEditor";

export const UserPage_JobEnv: React.FC = () => {
    return <>
        <Stack rowGap="XXXL" maxWidth={700} center>
            <br />
            {/*<PageTitle>User environment variables</PageTitle>*/}
            <EnvSettingsEditor
                level="user"
                onStore={async (entries) => {
                    await fetchPublicMeJobEnvConfigStoreUserProfileJobEnvConfig({
                        body: {entries}
                    })
                }}
                onLoad={async () => {
                    return (await fetchPublicMeJobEnvConfigLoadUserProfileJobEnvConfig({})).entries
                }}
            />
            <br />
        </Stack>
    </>
}
