import * as React from 'react';
import {Link, useParams} from 'react-router-dom';
import {useInternalEventsEventIdGetEventById} from 'meteoio-platform-client/generated/backendComponents';
import {PageTitle} from 'meteoio-ui/src/components/PageTitle';
import {DetailsBox} from 'meteoio-ui/src/components/DetailsBox';
import {MaybeErrorAlert} from 'meteoio-ui/src/components/MaybeErrorAlert';
import {Spinner} from 'meteoio-ui/src/components/Spinner';
import {Stack} from 'meteoio-ui/src/layouts/Stack';
import {RelativeTimeText} from "meteoio-ui/src/components/RelativeTimeText";
import {tokens} from "@fluentui/react-components";

export const UserPage_EventDetails: React.FC = () => {
    const {eventId} = useParams<{ eventId: string }>();
    const event = useInternalEventsEventIdGetEventById({
        pathParams: {eventId}
    });

    if (event.isLoading) {
        return <Spinner tall />;
    }

    if (event.error || !event.data) {
        return <MaybeErrorAlert error={event.error} />;
    }

    return <>
        <br />
        <Stack rowGap="XL" center maxWidth={700}>
            <PageTitle>Event Details</PageTitle>
            <DetailsBox
                details={[
                    {
                        label: 'Dataset ID',
                        value: event.data.from_dataset_id && (
                            <Link to={`/datasets/${event.data.from_dataset_id}`}>
                                <code>{event.data.from_dataset_id}</code>
                            </Link>
                        ),
                    },
                    {
                        label: 'Cron Job ID',
                        value: event.data.from_dataset_cron_id && (
                            <Link to={`/datasets/${event.data.from_dataset_id}/cron/${event.data.from_dataset_cron_id}`}>
                                <code>{event.data.from_dataset_cron_id}</code>
                            </Link>
                        ),
                    },
                    {
                        label: 'Job ID',
                        value: event.data.from_job_id && (
                            <Link to={`/jobs/${event.data.from_job_id}`}>
                                <code>{event.data.from_job_id}</code>
                            </Link>
                        ),
                    },
                    {label: 'Event Type', value: event.data.event_type},
                    // {label: 'Title', value: event.data.event_title},
                    {label: 'Timestamp', value: <RelativeTimeText date={event.data.created_at}/>},
                ]}
            />
            <Stack rowGap="None">
                <span style={{color: tokens.colorNeutralForeground4}}>Title</span>
                <PageTitle>
                    <span style={{textTransform: 'capitalize'}}>
                        {event?.data?.event_title || (event?.data?.event_type ? event?.data?.event_type.replace(/_/g, ' ') : 'Unknown Event')}
                    </span>
                </PageTitle>
            </Stack>
            <Stack rowGap="None">
                <span style={{color: tokens.colorNeutralForeground4}}>Details</span>
                <div style={{
                    whiteSpace: 'pre-wrap',
                    fontFamily: 'monospace',
                }}>
                    {event?.data?.event_details ?? <>[no details available]</>}
                </div>
            </Stack>
        </Stack>
    </>
};
