import React, { useState } from 'react';
import { AsyncActionButton } from 'meteoio-ui/src/components/AsyncActionButton';
import { Badge } from '@fluentui/react-components';
import { fetchInternalRequestDataOwnerPrivilegeRequestDataOwnerPrivilege } from 'meteoio-platform-client';
import { useDialogs } from 'meteoio-ui/src/hooks/useDialogs';
import { usePublicMeGetMe } from 'meteoio-platform-client';

export const RequestDataOwnerPrivilegeButton: React.FC = () => {
    const [isDisabled, setIsDisabled] = useState(false);
    const { strong_modal_info, message } = useDialogs();
    const { data: userData, isLoading } = usePublicMeGetMe({});

    const handleRequestDataOwnerPrivilege = async () => {
        try {
            await fetchInternalRequestDataOwnerPrivilegeRequestDataOwnerPrivilege({});
            await strong_modal_info('Your request to become a data owner has been submitted successfully. The administrators will evaluate your request shortly.');
            setIsDisabled(true); // Disable the button after a successful request
        } catch (err) {
            console.error(err);
            message.error('Failed to submit the request. Please try again later.');
        }
    };

    if (isLoading) {
        return null; // Optionally, show a loading spinner here
    }

    if (userData?.can_create_datasets) {
        return <Badge appearance="filled" color="success">Data Owner: you can create datasets.</Badge>;
    }

    return (
        <AsyncActionButton
            appearance="secondary"
            label="Request Data Owner Privilege"
            onClick={handleRequestDataOwnerPrivilege}
            disabled={isDisabled} // Disable the button if the request was successful
        />
    );
};