import * as React from 'react'
import {Segmented} from "antd";
import {JobLogFileTerm} from "./JobLogFile";
import useLocalStorageState from "meteoio-ui/src/hooks/useLocalStorageState";
import {JobLogRegexes} from "./JobLogRegexes";
import {JobFuseLogContent} from "./JobFuseLogContent";
import {JobStraceParsed} from "./JobStraceParsed";
import {DataQAAnalysisView} from "./DataQAAnalysisView";


const SUB_TAB_STORAGE_KEY = '_LAST_PREFERRED_TAB_VQyATcZ7UIMy1LSe9A1T'

export const Tab_Logs: React.FC = () => {
    const [tab, setTab] = useLocalStorageState<'stdout' | 'strace' |  'opens' | 'regexes' | 'fuse_log' | 'data_qa'>(SUB_TAB_STORAGE_KEY, 'regexes')

    return <>
        <Segmented
            block
            size="small"
            value={tab}
            options={[
                {value: 'regexes', label: 'Highlights'},
                {value: 'stdout', label: 'Stdout/stderr'},
                {value: 'fuse_log', label: 'FUSE'},
                {value: 'data_qa', label: 'Data QA'},
                {value: 'strace', label: 'Strace'},
                {value: 'opens', label: 'Opened files'},
            ]}
            onChange={value => setTab(value as typeof tab)}
        />

        {tab === 'regexes' && <JobLogFileTerm which="stdout" ContentComponent={JobLogRegexes}/>}
        {tab === 'stdout' && <JobLogFileTerm which="stdout"/>}
        {tab === 'strace' && <JobLogFileTerm which="strace"/>}
        {tab === 'fuse_log' && <JobLogFileTerm which="fuse" ContentComponent={JobFuseLogContent}/>}
        {tab === 'data_qa' && <DataQAAnalysisView/>}
        {tab === 'opens' && <JobStraceParsed/>}
    </>
}
