import React from 'react';

// NOTE: This is meant for https://adc.met.no/using-the-ACDD-keywords-approach

/**
 * Parse the input string into a nested tree object.
 *
 * Example input:
 * "A > B > C, A > D, E"
 *
 * Produces:
 * {
 *   A: {
 *     B: { C: {} },
 *     D: {}
 *   },
 *   E: {}
 * }
 */
function parseTree(str) {
    const root = {};
    str.split(',').forEach(path => {
        const parts = path.split(' > ').map(s => s.trim());
        let node = root;
        parts.forEach(part => {
            if (!node[part]) {
                node[part] = {};
            }
            node = node[part];
        });
    });
    return root;
}

/** Recursive component to render a tree node */
function TreeNode({ node }) {
    return (
        <ul style={{margin: 0, paddingLeft: '1.5em'}}>
            {Object.entries(node).map(([label, children]) => (
                <li key={label}>
                    {label}
                    {/* Only recurse if there are further children */}
                    {Object.keys(children).length > 0 && (
                        <TreeNode node={children} />
                    )}
                </li>
            ))}
        </ul>
    );
}

/** Main component: takes a single prop `dataString` */
export const NcMLKeywordsTree: React.FC<{
    keywordsStr: string;
}> = props => {
    const treeData = React.useMemo(() => parseTree(props.keywordsStr), [props.keywordsStr]);

    return <div style={{ lineHeight: '1', fontSize: '0.9em', padding: '0.15em 0'}}>
        <TreeNode node={treeData} />
    </div>
}
