import * as React from 'react'
import {Badge, Tooltip} from "@fluentui/react-components";
import {JobListEntryDTO} from "meteoio-platform-client";

export const JobTypeBadge: React.FC<{
    jobEntry: JobListEntryDTO
}> = ({jobEntry}) => {
    
    const {badge, tooltip} = React.useMemo(() => {
        // Cronjob (automated dataset run)
        if (jobEntry.cron_id) {
            return {
                badge: <Badge appearance="filled" color="success">Cronjob</Badge>,
                tooltip: "Automated job triggered by a scheduled dataset cron task"
            };
        }
        
        // Dataset-related jobs
        if (jobEntry.dataset_id) {
            if (jobEntry.submitted_by_user_id) {
                // User manually triggered dataset run
                return {
                    badge: <Badge appearance="filled" color="brand">User Dataset Job</Badge>,
                    tooltip: "Dataset job manually triggered by an authenticated user"
                };
            } else {
                // Guest/public dataset rerun
                return {
                    badge: <Badge appearance="filled" color="informative">Guest Dataset Rerun</Badge>,
                    tooltip: "Public dataset rerun by an anonymous user"
                };
            }
        }
        
        // Non-dataset jobs
        if (jobEntry.submitted_by_user_id) {
            // Regular user job submission
            return {
                badge: <Badge appearance="filled" color="brand">User Job</Badge>,
                tooltip: "Job submitted by an authenticated user, with temporary data"
            };
        } else {
            // Regular guest job submission
            return {
                badge: <Badge appearance="filled" color="informative">Guest Job</Badge>,
                tooltip: "Job submitted by an anonymous user, with temporary data"
            };
        }
    }, [jobEntry])

    return (
        <Tooltip content={tooltip} relationship="label" withArrow positioning="after">
            {badge}
        </Tooltip>
    );
};