import * as React from "react";
import {useJobViewStyles} from "./styles";
import {useContext} from "react";
import {JobContext} from "./JobContext";
import {usePublicJobSubmissionJobIdStraceParsedStraceParsed} from "meteoio-platform-client";
import {useStateTransitionCallback} from "meteoio-ui/src/hooks/useStateTransitionEffect";
import {MaybeErrorAlert} from "meteoio-ui/src/components/MaybeErrorAlert";
import {Spinner} from "meteoio-ui/src/components/Spinner";
import {Stack} from "meteoio-ui/src/layouts/Stack";
import {mergeClasses} from "@fluentui/react-components";
import {SortableTable} from "meteoio-ui/src/components/SortableTable";
import {Empty} from "antd";
import {ProgressBar} from "meteoio-ui/src/components/ProgressBar";


export const JobStraceParsed: React.FC = () => {

    const styles = useJobViewStyles()
    const {jobId, status} = useContext(JobContext)

    const {
        data,
        error,
        isLoading,
        refetch,
        isRefetching,
    } = usePublicJobSubmissionJobIdStraceParsedStraceParsed({
        pathParams: {jobId},
    }, {
        cacheTime: 60_000,
        staleTime: 10_000,
    })

    useStateTransitionCallback(status?.is_finished, (prevState, newState) => {
        if (prevState === false && newState) {
            refetch?.()
        }
    }, [])

    if (error) {
        return <MaybeErrorAlert error={error}/>
    }

    if (isLoading) {
        return <Spinner tall/>
    }

    return <>
        <Stack rowGap="None" className={mergeClasses(styles.boxBorder, data?.length > 0 && styles.scrollX)}>
            {data?.length > 0 && <SortableTable
                noTopBottomBorder
                size="extra-small"
                rows={data}
                columns={[
                    {
                        field: 'offset_seconds',
                        title: 'Time ',
                        textAlign: 'end',
                        onRenderCellContent: row => <time>{row.offset_seconds?.toFixed?.(2) ?? '?'}s&nbsp;&nbsp;</time>
                    },
                    {
                        field: 'syscall',
                        title: 'Syscall',
                        onRenderCellContent: row => <code>{row.syscall}</code>
                    },
                    {
                        field: 'open_file_flags',
                        title: 'Flags',
                        onRenderCellContent: row => <code>{row.open_file_flags?.join?.('|') ?? ''}</code>
                    },
                    {
                        field: 'open_file_path',
                        title: 'File path',
                        // TODO?: onRenderCellContent: row => link to download the file?:
                    },
                ]}
            />}
            {status?.is_finished && data?.length <= 0 && <>
                <br/>
                <Empty description="No recognized operation has been traced."/>
                <br/>
            </>}
            {(!status?.is_finished || isRefetching) && <ProgressBar thickness="large"/>}
        </Stack>
    </>
}
