import * as React from "react";
import {useMemo} from "react";
import {Stack} from "meteoio-ui/src/layouts/Stack";
import {Alert} from 'meteoio-ui/src/components/Alert'
import {matchLines, RegexRow} from "./status.sh";
import {Empty} from "antd";


export const JobLogRegexes: React.FC<{
    text: string
}> = props => {

    const text = props.text

    const rows = useMemo<RegexRow[]>(() =>
        typeof text === 'string' ? matchLines(text) : [], [text])

    // const reduced = useMemo<ReducedT>(() =>
    //     reduceRows(rows), [rows])

    return <Stack rowGap="S">
        <Stack rowGap="None">
            {rows.map((row, i) =>
                //<Alert key={i} banner message={row.line} type={row.rule.level}/>
                <Alert key={i} level={row.rule.level} size="small">{row.line}</Alert>
            )}

            {rows?.length <= 0 && <>
                <br/>
                <Empty description="No recognized operation has been traced."/>
                <br/>
            </>}
        </Stack>
        {/*<SortableTable*/}
        {/*    size="extra-small"*/}
        {/*    noTopBottomBorder*/}
        {/*    columns={COLUMNS}*/}
        {/*    rows={rows}*/}
        {/*/>*/}
    </Stack>
}
