import * as React from "react";
import {useUIState} from "./contexts/ui-state-context";
import {LayoutColumnThree16Regular, List16Regular, Map16Regular} from "@fluentui/react-icons";
import {Button, Space, Tooltip} from "antd";

export const UiPresetSwitch: React.FC = () => {
    const {uiState, setPreset} = useUIState()
    const List = List16Regular
    const Map = Map16Regular
    const Columns = LayoutColumnThree16Regular

    return <>
        <Space>
            {/*<Typography.Text type="secondary">View:</Typography.Text>*/}
            <Space.Compact>
                <Tooltip title="Split View">
                    <Button
                        size="small"
                        type={uiState.preset === "split" ? "primary" : "default"}
                        icon={<Columns/>}
                        onClick={() => setPreset("split")}
                    />
                </Tooltip>
                <Tooltip title="List Only">
                    <Button
                        size="small"
                        type={uiState.preset === "list" ? "primary" : "default"}
                        icon={<List/>}
                        onClick={() => setPreset("list")}
                    />
                </Tooltip>
                <Tooltip title="Map Only">
                    <Button
                        size="small"
                        type={uiState.preset === "map" ? "primary" : "default"}
                        icon={<Map/>}
                        onClick={() => setPreset("map")}
                    />
                </Tooltip>
            </Space.Compact>
        </Space>
    </>
}