
export type NcMLSearchEntry = {
    ds_id: string
    job_id: string
    ncml_imp: NcmlImportantMetadata
}

export type NcmlImportantMetadata = {
    /**
     * Returns the bounding box as [minLon, minLat, maxLon, maxLat] in EPSG:4326.
     * If geospatial_bounds_crs != EPSG:4326, reprojects the four corners.
     * Returns None if any coordinate is missing.
     */
    bbox?: null | number[]
    creator_name?: null | string
    creator_type?: null | string
    date_created?: null | string
    geospatial_bounds?: null | string
    geospatial_bounds_crs?: null | string
    geospatial_lat_max?: null | number
    geospatial_lat_min?: null | number
    geospatial_lon_max?: null | number
    geospatial_lon_min?: null | number
    geospatial_vertical_max?: null | number
    geospatial_vertical_min?: null | number
    geospatial_vertical_positive?: null | string
    geospatial_vertical_units?: null | string
    history?: null | string
    keywords?: null | string
    keywords_vocabulary?: null | string
    location?: null | string
    location_station?: null | string
    product_version?: null | string
    source?: null | string
    time_coverage_end?: null | string
    time_coverage_resolution?: null | string
    time_coverage_resolution_seconds?: null | number
    time_coverage_start?: null | string
    title?: null | string
    variables?: null | string[]
}

// Derived types for easier component usage
export interface ProcessedDataset {
    id: string
    dsId: string
    jobId: string
    title: string
    description: string
    latitude: number
    longitude: number
    bbox?: [number, number, number, number] // [minLon, minLat, maxLon, maxLat]
    dateCreated?: string
    timeCoverageStart?: string
    timeCoverageEnd?: string
    variables: string[]
    keywords: string[]
    location?: string
    locationStation?: string
    creatorName?: string
    source?: string
}

export interface FilterState {
    searchTerm: string
    dateRange: [Date | null, Date | null]
    variables: string[]
    keywords: string[]
    creators: string[]
    sources: string[]
    locations: string[]
    // Pagination
    limit: number
    offset: number
}
