import * as React from "react";
import {useData} from "./contexts/data-context";
import {useUIState} from "./contexts/ui-state-context";
import {usePublicJobSubmissionJobIdStraceOutputsStraceOutputs} from "meteoio-platform-client";
import {Modal} from "meteoio-ui/src/components/Modal";
import {Spinner} from "@fluentui/react-components";
import {JobFileViewComponent} from "../../jobs/JobFileViewPage";

export const ItemDetailsModal: React.FC = () => {
    const {filteredDatasets} = useData()
    const {uiState, setPopupItemId} = useUIState()
    const itemId = uiState.popupItemId
    const item = itemId ? filteredDatasets?.find?.(item => item?.id == itemId) : undefined

    // FIXME: Brittle logic to find the full NCML file path [e227680d-a53a-4ea4-9b3d-ace7dc480149]
    const jobOutputs = usePublicJobSubmissionJobIdStraceOutputsStraceOutputs({
        pathParams: {jobId: item?.jobId},
    }, {
        cacheTime: 10_000,
        staleTime: 5_000,
        enabled: !!item,
    })
    const ncmlOut = React.useMemo(() => {
        return jobOutputs.data?.find?.(out => {
            const pathParts = out.open_file_path.split('/')
            const filename = pathParts[pathParts.length - 1]
            if (!filename.endsWith('.ncml')) {
                return false
            }
            const fileBaseName = filename.replace(/\.ncml$/, '')
            return fileBaseName === item?.locationStation
        })
    }, [jobOutputs.data, item?.locationStation])

    if (!item) {
        return null
    }
    return <Modal
        open
        onCancel={() => setPopupItemId(null)}
        footer={null}
        width={jobOutputs.data ? 1000 : 300}
    >
        {jobOutputs.isLoading && <Spinner/>}
        {jobOutputs.data && <JobFileViewComponent
            jobId={item.jobId}
            filePath={ncmlOut?.open_file_path}
        />}
    </Modal>
}
