import * as React from 'react'
import {DatePicker, Input, Space, Spin, Typography} from "antd"
import {useData} from "./contexts/data-context"
import {makeStyles, shorthands} from "@griffel/react"
import dayjs from "dayjs"
import {UiPresetSwitch} from "./ui-preset-switch";
import {Stack} from "meteoio-ui/src/layouts/Stack";

const {Title, Text} = Typography
const {RangePicker} = DatePicker

const useStyles = makeStyles({
    panel: {
        height: "100%",
        overflowY: "auto",
        // backgroundColor: "#fdfdfd",
        backgroundColor: "#fff",
        ...shorthands.borderRight("1px", "solid", "#f0f0f0"),
        display: "flex",
        flexDirection: "column",
        padding: '0 16px'
    },
    space: {
        width: "100%",
    },
    loadingOverlay: {
        position: "relative",
        "&::after": {
            content: '""',
            position: "absolute",
            top: 0,
            left: 0,
            right: 0,
            bottom: 0,
            backgroundColor: "rgba(255, 255, 255, 0.7)",
            zIndex: 1,
        },
    },
})

export function FilterPanel() {
    const classes = useStyles()
    const {filters, updateFilters, isLoading} = useData()

    const handleDateChange = (dates: any, dateStrings: [string, string]) => {
        const [start, end] = dates ? dates.map((d: any) => d.toDate()) : [null, null]
        updateFilters({dateRange: [start, end]})
    }

    const handleSearchChange = (value: string) => {
        updateFilters({searchTerm: value, offset: 0}) // Reset offset when searching
    }

    return (
        <div className={classes.panel}>
            <div style={{
                // borderBottom: '1px solid #7773'
            }}>
                <Stack horizontal justifyContent={"space-between"} alignItems={"baseline"}>
                    <Title level={4} style={{marginTop: 0}}>
                        Search
                        &nbsp;
                    </Title>
                    <UiPresetSwitch/>
                </Stack>
            </div>
            <div>
                <Text type="secondary">Select your filter criteria</Text>
                {isLoading && <Spin size="small" style={{marginLeft: 8}}/>}
            </div>

            {/*{isError && (*/}
            {/*    <Alert*/}
            {/*        message="Error loading data"*/}
            {/*        description={getMaybeErrorMessageString(error)}*/}
            {/*        type="error"*/}
            {/*        style={{margin: "16px 0"}}*/}
            {/*        showIcon*/}
            {/*    />*/}
            {/*)}*/}

            <div style={{flex: 1, overflowY: "auto", padding: "24px 0"}}>
                <Space direction="vertical" size="large" className={classes.space}>
                    <Space direction="vertical" className={classes.space}>
                        <Text strong>
                            Free text search
                        </Text>
                        <Input.Search
                            placeholder="Search in title and description..."
                            onSearch={handleSearchChange}
                            onChange={(e) => {
                                if (e.target.value === "") {
                                    handleSearchChange("")
                                }
                            }}
                            allowClear
                            loading={isLoading}
                        />
                    </Space>

                    <Space direction="vertical" className={classes.space}>
                        <Text strong>Date range</Text>
                        <RangePicker
                            // mode={['year', 'year']}
                            style={{width: "100%"}}
                            onChange={handleDateChange}
                            value={
                                filters.dateRange[0] && filters.dateRange[1]
                                    ? [dayjs(filters.dateRange[0]), dayjs(filters.dateRange[1])]
                                    : null
                            }
                            disabled={isLoading}
                            allowEmpty
                        />
                    </Space>

                    {/*<Space direction="vertical" className={classes.space}>*/}
                    {/*  <Text strong>Variables</Text>*/}
                    {/*  <Select*/}
                    {/*    mode="multiple"*/}
                    {/*    allowClear*/}
                    {/*    style={{ width: "100%" }}*/}
                    {/*    placeholder="Select variables"*/}
                    {/*    onChange={(values) => updateFilters({ variables: values })}*/}
                    {/*    options={uniqueValues.variables.map((v) => ({ label: v, value: v }))}*/}
                    {/*    value={filters.variables}*/}
                    {/*    disabled={isLoading}*/}
                    {/*    loading={isLoading}*/}
                    {/*  />*/}
                    {/*</Space>*/}

                    {/*<Space direction="vertical" className={classes.space}>*/}
                    {/*  <Text strong>Keywords</Text>*/}
                    {/*  <Select*/}
                    {/*    mode="multiple"*/}
                    {/*    allowClear*/}
                    {/*    style={{ width: "100%" }}*/}
                    {/*    placeholder="Select keywords"*/}
                    {/*    onChange={(values) => updateFilters({ keywords: values })}*/}
                    {/*    options={uniqueValues.keywords.map((k) => ({ label: k, value: k }))}*/}
                    {/*    value={filters.keywords}*/}
                    {/*    disabled={isLoading}*/}
                    {/*    loading={isLoading}*/}
                    {/*  />*/}
                    {/*</Space>*/}

                    {/*<Space direction="vertical" className={classes.space}>*/}
                    {/*  <Text strong>Creator</Text>*/}
                    {/*  <Select*/}
                    {/*    mode="multiple"*/}
                    {/*    allowClear*/}
                    {/*    style={{ width: "100%" }}*/}
                    {/*    placeholder="Select creators"*/}
                    {/*    onChange={(values) => updateFilters({ creators: values })}*/}
                    {/*    options={uniqueValues.creators.map((c) => ({ label: c, value: c }))}*/}
                    {/*    value={filters.creators}*/}
                    {/*    disabled={isLoading}*/}
                    {/*    loading={isLoading}*/}
                    {/*  />*/}
                    {/*</Space>*/}

                    {/*<Space direction="vertical" className={classes.space}>*/}
                    {/*  <Text strong>Source</Text>*/}
                    {/*  <Select*/}
                    {/*    mode="multiple"*/}
                    {/*    allowClear*/}
                    {/*    style={{ width: "100%" }}*/}
                    {/*    placeholder="Select sources"*/}
                    {/*    onChange={(values) => updateFilters({ sources: values })}*/}
                    {/*    options={uniqueValues.sources.map((s) => ({ label: s, value: s }))}*/}
                    {/*    value={filters.sources}*/}
                    {/*    disabled={isLoading}*/}
                    {/*    loading={isLoading}*/}
                    {/*  />*/}
                    {/*</Space>*/}

                    {/*<Space direction="vertical" className={classes.space}>*/}
                    {/*  <Text strong>Location</Text>*/}
                    {/*  <Select*/}
                    {/*    mode="multiple"*/}
                    {/*    allowClear*/}
                    {/*    style={{ width: "100%" }}*/}
                    {/*    placeholder="Select locations"*/}
                    {/*    onChange={(values) => updateFilters({ locations: values })}*/}
                    {/*    options={uniqueValues.locations.map((l) => ({ label: l, value: l }))}*/}
                    {/*    value={filters.locations}*/}
                    {/*    disabled={isLoading}*/}
                    {/*    loading={isLoading}*/}
                    {/*  />*/}
                    {/*</Space>*/}
                </Space>
            </div>
        </div>
    )
}
