import * as React from 'react'

import {Layout} from "antd"
import {useUIState} from "./contexts/ui-state-context"
import {makeStyles, shorthands} from "@griffel/react"
import {Panel, PanelGroup, PanelResizeHandle} from "react-resizable-panels"
// import { List, Map, Columns } from "lucide-react"
import {FilterPanel} from "./filter-panel"
import {DatasetList} from "./dataset-list"
import {MapComponent} from "./map-component"
import {useData} from "./contexts/data-context";

const {Sider, Content} = Layout

const useStyles = makeStyles({
    rootLayout: {
        height: "calc(100vh - 40px)",
        backgroundColor: "#fff",
    },
    header: {
        backgroundColor: "#fff",
        // ...shorthands.borderBottom("1px", "solid", "#f0f0f0"),
        display: "flex",
        alignItems: "center",
        justifyContent: "space-between",
        ...shorthands.padding(0, "24px"),
    },
    sider: {
        backgroundColor: "transparent",
        ...shorthands.borderRight("1px", "solid", "#f0f0f0"),
    },
    content: {
        ...shorthands.padding("0"),
        backgroundColor: "#fff",
        display: "flex",
        flexDirection: "row",
    },
    panelGroup: {
        width: "100%",
        height: "100%",
    },
    resizeHandle: {
        width: "8px",
        backgroundColor: "#f0f2f5",
        cursor: "col-resize",
        display: "flex",
        alignItems: "center",
        justifyContent: "center",
        ...shorthands.borderLeft("1px", "solid", "#e0e0e0"),
        ...shorthands.borderRight("1px", "solid", "#e0e0e0"),
    },
    resizeHandleInner: {
        width: "2px",
        height: "30px",
        backgroundColor: "#c1c1c1",
        ...shorthands.borderRadius("2px"),
    },
})

export function DataPortalLayout() {
    const classes = useStyles()
    const {uiState} = useUIState()
    const {isError} = useData()

    return (
        <Layout className={classes.rootLayout}>
            <Layout style={{backgroundColor: 'transparent', paddingTop: 10}}>
                <Sider width={300} className={classes.sider}>
                    <FilterPanel/>
                </Sider>
                <Content className={classes.content}>
                    <PanelGroup direction="horizontal" dir="ltr" className={classes.panelGroup}>
                        {(uiState.showList || isError) && (
                            <Panel defaultSize={40} minSize={30} id="list-panel">
                                <DatasetList/>
                            </Panel>
                        )}
                        {uiState.showList && uiState.showMap && !isError && (
                            <PanelResizeHandle className={classes.resizeHandle}>
                                <div className={classes.resizeHandleInner}/>
                            </PanelResizeHandle>
                        )}
                        {uiState.showMap && !isError && (
                            <Panel defaultSize={60} minSize={20} id="map-panel">
                                <MapComponent/>
                            </Panel>
                        )}
                    </PanelGroup>
                </Content>
            </Layout>
        </Layout>
    )
}
