import * as React from "react";
import {DatasetRevisionsListEntry} from "meteoio-platform-client";
import {Stack} from "meteoio-ui/src/layouts/Stack";
import {makeStyles, mergeClasses, Text, tokens} from "@fluentui/react-components";
import {RelativeTimeText} from "meteoio-ui/src/components/RelativeTimeText";
import {address_book} from "../../../address_book";
import {useNavigate, useParams} from "react-router-dom";

const useStyles = makeStyles({
    rowBtn: {
        borderRadius: '0.4em',
        marginTop: '-0.2em',
        padding: '0.3em 1em',
        cursor: 'pointer',
        margin: 0,
        display: 'block',
        border: '0 none',
        minWidth: '200px',
        maxWidth: 'calc(95vw - 8em)',
        backgroundColor: 'transparent',
        position: 'relative',

        '&:hover': {
            backgroundColor: tokens.colorNeutralBackground2Hover,
        },
    },

    rowBtn_open: {
        backgroundColor: tokens.colorBrandBackground2Hover
    },

    rowBtn_pending: {
        backgroundColor: tokens.colorPaletteYellowBackground2,

        '&:hover': {
            backgroundColor: tokens.colorPaletteYellowBackground3
        }
    }
})

export const DsRevisionRow: React.FC<{
    pending?: boolean
    row: DatasetRevisionsListEntry,
    previousRevision?: DatasetRevisionsListEntry,
    isLatest?: boolean,
}> = props => {
    const {datasetId, revId} = useParams()
    const {row} = props
    const styles = useStyles()
    const navigate = useNavigate()

    const displayTitle = row.title || (
        row.number == 1
            ? 'Initial version'
            : (props.pending ? 'Pending revision' : `Version ${row.number}`)
    )

    const isSelected = revId === row.id || (props.pending && revId === 'draft')

    return (
        <Stack horizontal alignItems="flex-start" columnGap="M">
            <button
                type="button"
                role="navigation"
                className={mergeClasses(styles.rowBtn, props.pending && styles.rowBtn_pending, isSelected && styles.rowBtn_open)}
                onClick={() => navigate(address_book.datasets.revisions.view_one(datasetId, props.pending ? 'draft' : row.id))}
            >
                <Text block truncate size={300} wrap={false} style={{maxHeight: '2em', fontWeight: '600'}}>
                    {displayTitle}
                </Text>
                {!props.pending ? <>
                    <Text block truncate size={200} style={{color: tokens.colorNeutralForeground3}}>
                        {row.confirmed_at && <RelativeTimeText date={row.confirmed_at}/>}
                        {row.updated_at !== row.confirmed_at ? <>
                            &nbsp;- Updated <RelativeTimeText date={row.updated_at}/>
                        </> : <></>}
                        {row.emptied_at ? <>
                            &nbsp;- <span style={{color: tokens.colorStatusDangerForeground1}}>Contents cleared <RelativeTimeText date={row.emptied_at}/></span>
                        </> : <></>}
                    </Text>
                </> : <>
                    <Text block truncate size={200} style={isSelected ? {opacity: 0} : {color: tokens.colorPaletteYellowForeground2}}>
                        Click to view details
                    </Text>
                </>}
            </button>
        </Stack>
    )
}