import * as React from 'react'
import {Badge, Text, tokens} from "@fluentui/react-components";
import {Timeline} from 'antd'
import {
    useInternalDatasetsDatasetIdRevisionsGetRevisions,
    useInternalDatasetsDatasetIdRevisionsTxIdMessageGetRevision
} from "meteoio-platform-client";
import {useParams} from "react-router-dom";
import {useDatasetConfigTx} from "../../useDatasetConfigTx";
import {Spinner} from "meteoio-ui/src/components/Spinner";
import {MaybeErrorAlert} from "meteoio-ui/src/components/MaybeErrorAlert";
import {DsRevisionRow} from "./DsRevisionRow";
import {DsRevisionDetails} from "./DsRevisionDetails";
import {Alert} from 'meteoio-ui/src/components/Alert';
import {Panel, PanelGroup, PanelResizeHandle} from "react-resizable-panels"


export const DatasetIniRevisionsList: React.FC = () => {
    const {datasetId, revId} = useParams()
    const [txId, {isHead}] = useDatasetConfigTx(datasetId)
    const revisions = useInternalDatasetsDatasetIdRevisionsGetRevisions({
        pathParams: {
            datasetId,
        }
    })
    const pending_rev = useInternalDatasetsDatasetIdRevisionsTxIdMessageGetRevision({
        pathParams: {
            datasetId,
            txId,
        }
    }, {
        enabled: !isHead
    })

    // const num_col_w = useMemo(() => `${Math.floor(2 + Math.log10((revisions?.data?.length ?? 1) + 1))}ch`, [revisions.data])

    if (revisions.isLoading || (!isHead && pending_rev.isLoading)) {
        return <Spinner tall/>
    }

    return <main style={{
            paddingLeft: '2em',
            height: 'calc(100vh - 200px)',
            // marginTop: `calc(-1 * ${tokens.spacingVerticalXXXL})`,
            // paddingTop: '1em',
        }}>
            <MaybeErrorAlert error={revisions.error}/>
            <MaybeErrorAlert error={pending_rev.error}/>
        <PanelGroup direction="horizontal" dir="ltr">
            <Panel defaultSize={30} minSize={15} id="list-panel" style={{
                padding: '0.5em 2em',
                overflowY: 'auto'
            }}>
                <br />
                <Timeline
                    mode="left"
                    reverse
                    items={[
                        ...(revisions?.data ?? []).map((row, i) => {
                            return {
                                key: row.id,
                                // label: <>{row.number}</>,
                                children: <DsRevisionRow
                                    row={row}
                                    previousRevision={revisions?.data?.[i-1]}
                                    // num_col_w={num_col_w}
                                    isLatest={i === (revisions?.data?.length ?? 0) -1}
                                />,
                                dot: <Badge appearance="tint">
                                    {row.number}
                                </Badge>,
                            }
                        }),
                        ...(isHead || !pending_rev?.data ? [] : [
                            {
                                key: 'draft',
                                pending: true,
                                color: tokens.colorNeutralForegroundDisabled,
                                // label: '',
                                children: <DsRevisionRow
                                    pending
                                    row={pending_rev?.data}
                                    // num_col_w={num_col_w}
                                />,
                            }
                        ])
                    ]}
                />

                {revisions?.data?.length > 0 ? <Text block style={{marginTop: '1em', fontStyle: 'italic', color: tokens.colorNeutralForegroundDisabled}}>
                    This dataset has {revisions?.data?.length} confirmed version{revisions?.data?.length > 1 ? 's' : ''}.
                </Text> : <Alert level="info">
                    This dataset was created without versioning. There is only the current version.
                </Alert>}
                <br/>

            </Panel>
            {revId && <>
                <PanelResizeHandle style={{
                    width: '4px',
                    backgroundColor: tokens.colorNeutralStroke2,
                    cursor: 'col-resize',
                    position: 'relative'
                }}>
                    <div style={{
                        position: 'absolute',
                        top: '50%',
                        left: '50%',
                        transform: 'translate(-50%, -50%)',
                        width: '1px',
                        height: '20px',
                        backgroundColor: tokens.colorNeutralStroke1
                    }}/>
                </PanelResizeHandle>
                <Panel defaultSize={70} minSize={50} id="details-panel" style={{overflowY: 'auto'}}>
                    {(() => {
                        const selectedRevision = revId === 'draft' 
                            ? pending_rev?.data
                            : revisions?.data?.find(r => r.id === revId);
                        
                        if (!selectedRevision) return null;
                        
                        const revIndex = revisions?.data?.findIndex(r => r.id === selectedRevision.id) ?? -1;
                        const previousRevision = revIndex > 0 ? revisions?.data?.[revIndex - 1] : undefined;
                        const isLatest = revIndex === (revisions?.data?.length ?? 0) - 1;
                        
                        return <DsRevisionDetails
                            pending={revId === 'draft'}
                            row={selectedRevision}
                            previousRevision={previousRevision}
                            isLatest={isLatest}
                        />;
                    })()}
                </Panel>
            </>}
        </PanelGroup>
    </main>
}
