import * as React from 'react'
import {Stack} from "meteoio-ui/src/layouts/Stack";
import {
    fetchInternalDatasetsDatasetIdConfigTxsBeginConfigWriteTx,
    fetchInternalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnv,
    fetchInternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnv,
    JobEnvConfig,
} from "meteoio-platform-client";
import {useDatasetConfigTx} from "./useDatasetConfigTx";
import {useNavigate, useParams} from "react-router-dom";
import {getMaybeErrorMessageString} from "meteoio-ui/src/components/MaybeErrorAlert";
import {useDatasetConfigTxDraftPusher} from "./useDatasetConfigTxDraftPusher";
import {App} from "antd";
import {EnvSettingsEditor} from "../_common/EnvSettingsEditor";
import {AsyncActionButton} from "meteoio-ui/src/components/AsyncActionButton";
import {EditRegular} from "@fluentui/react-icons/lib/fonts";


export const DatasetJobEnvSettings: React.FC = () => {
    return <>
        <Stack maxWidth={700} center>
            <DatasetJobEnvSettingsEditor/>
            <br/>
            <br/>
        </Stack>
    </>
}

const DatasetJobEnvSettingsEditor: React.FC = () => {
    const {datasetId, fuseConfKey} = useParams()
    const [txId, {isHead, setConfigTxId}] = useDatasetConfigTx(datasetId)
    const navigate = useNavigate()
    const {modal} = App.useApp()

    const [draft, setDraft, {error, isLoading, reload}] = useDatasetConfigTxDraftPusher<JobEnvConfig>(
        `c548048b-abb0-4925-b8e0-4de58cd160db-ds-${datasetId}-tx-${txId}`,
        isHead ? undefined : async (draft) => {
            try {
                await fetchInternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnv({
                    pathParams: {datasetId, txId},
                    body: draft
                })
            }
            catch (e) {
                modal.error({
                    content: getMaybeErrorMessageString(e)
                })
            }
        },
        async () => {
            return await fetchInternalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnv({
                pathParams: {
                    datasetId,
                    txId,
                },
            })
        })

    return <EnvSettingsEditor
        level="dataset"
        headerExtra={isHead ? <>
            <AsyncActionButton
                icon={<EditRegular/>}
                label="Start editing..."
                onClick={async () => {
                    const res = await fetchInternalDatasetsDatasetIdConfigTxsBeginConfigWriteTx({
                        pathParams: {
                            datasetId,
                        }
                    })
                    setConfigTxId(res.id)
                }}
            />
        </> : null}
        immediateLoadedValue={draft?.entries}
        // onStore={async (entries) => {
        //     setDraft({entries})
        // }}
        onChangeImmediate={entries => setDraft({entries})}
        // onDiscard={props.onDiscard}
        disabled={isHead}
        useImmediateOnly
        compilingDatasetId={datasetId}  // NOTE: not necessary, would be ignored. Still logical to provide them.
        compilingDatasetTxId={txId}  // NOTE: not necessary, would be ignored. Still logical to provide them.
    />
}
