import {SimplePropertiesSchema} from "meteoio-ui/src/components/SimpleProperties";
import * as Schemas from "meteoio-platform-client/generated/backendSchemas";
import {DropdownFieldOption} from "meteoio-ui/src/components/DropdownField";


export type FuseConfig = Schemas.FuseMountListConfig
export type FuseConfigElement = FuseConfig['mounts'][string]

export const COMMON_FIELDS_SCHEMA: SimplePropertiesSchema<FuseConfigElement> = {
    'local_mount_sub_path': {
        title: 'Mount sub path',
        description: 'Local mount point, relative to dataset root (e.g.: "mnt" without leading dots or slashes)',
        type: 'line',
        required: true,
    },
    'title': {
        title: 'Title or comment',
        description: 'Readable description for your own convenience (optional)',
        type: 'line',
    },
}

export const SCHEMAS: { option: DropdownFieldOption, schema: SimplePropertiesSchema<FuseConfigElement> }[] = [
    {
        option: {
            value: 'sshfs',
            label: 'SFTP',
        },
        schema: {
            remote_host: {
                title: 'Host',
                type: 'line',
                required: true,
                description: 'Hostname or IP address of the SSH server',
            },
            remote_port: {
                title: 'Port',
                type: 'int',
                required: true,
                min: 1,
                max: 65535,
                description: 'SSH port (default: 22)',
            },
            remote_path: {
                title: 'Remote Path',
                type: 'line',
                required: true,
                description: 'Remote path to mount (default: /remote_directory)',
            },
            username: {
                title: 'Username',
                type: 'line',
                required: true,
            },
            password: {
                title: 'Password',
                type: 'password',
                required: false,
            },
            timeout: {
                title: 'Timeout',
                type: 'int',
                required: false,
                min: 1,
                max: 60,
                description: 'Connection timeout in seconds (default: 10)',
            }
        }
    },
    {
        option: {
            value: 'smb',
            label: 'SMB',
        },
        schema: {
            remote_host: {
                title: 'Remote host',
                type: 'line',
                required: true,
                description: 'The remote host or IP address of the SMB server.',
            },
            username: {
                title: 'Username',
                type: 'line',
                required: false,
            },
            password: {
                title: 'Password',
                type: 'password',
                required: false,
            },
            remote_path: {
                title: 'Remote Folder path',
                type: 'line',
                required: true,
            },
            timeout: {
                title: 'Timeout',
                type: 'int',
                required: false,
                min: 1,
                max: 60,
                description: 'Connection timeout in seconds (default: 10)',
            }
        }
    },
    {
        option: {
            value: 's3',
            label: 'S3',
        },
        schema: {
            remote_url: {
                title: 'S3 server URL',
                type: 'line',
                required: true,
                description: 'e.g.: https://example.com/',
            },
            bucket_name: {
                title: 'Bucket Name',
                type: 'line',
                required: true,
            },
            username: {
                title: 'Username or access key ID',
                type: 'line',
                required: false,
            },
            password: {
                title: 'Password or secret access key',
                type: 'password',
                required: false,
            },
            request_style: {
                title: 'Request style',
                type: 'enum',
                required: false,
                description: 'Default: virtual-hosted',
                options: [
                    { value: 'path', label: 'Path-style requests' },
                    { value: 'virtual-hosted', label: 'Virtual-hosted-style request' },
                ],
            },
            timeout: {
                title: 'Timeout',
                type: 'int',
                required: false,
                min: 1,
                max: 60,
                description: 'Connection timeout in seconds (default: 10)',
            }
        }
    },
    {
        option: {
            value: 'webdav',
            label: 'WebDAV',
        },
        schema: {
            remote_url: {
                title: 'WebDav folder URL',
                type: 'line',
                required: true,
                description: '(e.g.: http://example.com/remote.php/dav/files)',
            },
            username: {
                title: 'Username',
                type: 'line',
                required: false,
            },
            password: {
                title: 'Password',
                type: 'password',
                required: false,
            },
            timeout: {
                title: 'Timeout',
                type: 'int',
                required: false,
                min: 1,
                max: 60,
                description: 'Connection timeout in seconds (default: 10)',
            }
        }
    }
];

// TODO: Defaults? Load them from the server?

