import * as React from 'react'
import {Route, Routes, Link, useLocation} from "react-router-dom";
import {AdminPage_Home} from "./AdminPage_Home";
import {Sticky} from "meteoio-ui/src/components/Sticky";
import {MainContentSplit} from "meteoio-ui/src/layouts/MainContentSplit";
import {NavLinksList} from "meteoio-ui/src/components/NavLinksList";
import {AdminPage_Users} from "./AdminPage_Users";
import {AdminPage_Jobs} from "./AdminPage_Jobs";
import {MainTopBar} from "../_common/MainTopBar";
import {NotFound} from "../_common/NotFound";
import {AdminPage_Datasets} from "./AdminPage_Datasets";
import {AdminPage_Customization} from "./AdminPage_Customization";
import {ChevronRightRegular} from "@fluentui/react-icons";
import {AdminPage_Env} from "./AdminPage_Env";
import {AdminPage_Events} from './AdminPage_Events';
import {AdminPage_UserDetails} from './AdminPage_UserDetails';
import {AdminPage_DatasetDetails} from './AdminPage_DatasetDetails';
import {AdminPage_EventDetails} from './AdminPage_EventDetails';

export interface AdminNavItem {
    to: string;
    label: string;
    description: string;
}

const ADMIN_NAV_ITEMS: AdminNavItem[] = [
    {
        to: '/admin/users',
        label: 'Users',
        description: 'Manage user accounts, permissions, and access'
    },
    {
        to: '/admin/datasets',
        label: 'Datasets',
        description: 'Monitor dataset usage and ownership'
    },
    {
        to: '/admin/jobs',
        label: 'Guest Jobs',
        description: 'Track job execution and resource consumption'
    },
    {
        to: '/admin/events',
        label: 'Recent events',
        description: 'Review system events and errors'
    },
    {
        to: '/admin/customization',
        label: 'Customization',
        description: 'Configure platform appearance'
    },
    {
        to: '/admin/env',
        label: 'Environment variables',
        description: 'Manage system variables'
    }
];

export const AdminPages: React.FC = () => {
    const location = useLocation()
    const isHomePage = location.pathname === '/admin'
    
    return <>
        <MainTopBar startExtra={<>
            <ChevronRightRegular/>
            <Link to="/admin" style={{ textDecoration: 'none', color: 'inherit', fontWeight: 'bold' }}>
                Admin
            </Link>
        </>}/>
        <MainContentSplit
            nav={!isHomePage ? <Sticky top={65}>
                <NavLinksList
                    links={[
                        {to: '/admin', children: <>Home</>, end: true},
                        ...ADMIN_NAV_ITEMS.map(item => ({
                            to: item.to,
                            children: <>{item.label}</>
                        }))
                    ]}
                />
            </Sticky> : undefined}
        >
            <Routes>
                <Route index element={<AdminPage_Home navItems={ADMIN_NAV_ITEMS} />}/>
                <Route path={"users"} Component={AdminPage_Users}/>
                <Route path={"users/:userId"} Component={AdminPage_UserDetails}/>
                <Route path={"jobs"} Component={AdminPage_Jobs}/>
                <Route path={"datasets"} Component={AdminPage_Datasets}/>
                <Route path={"datasets/:datasetId"} Component={AdminPage_DatasetDetails}/>
                <Route path={"customization"} Component={AdminPage_Customization}/>
                <Route path={"env"} Component={AdminPage_Env}/>
                <Route path={"customization/:customizationSettingsPage"} Component={AdminPage_Customization}/>
                <Route path={"events"} Component={AdminPage_Events}/>
                <Route path={"events/:eventId"} Component={AdminPage_EventDetails}/>
                <Route path={"*"} Component={NotFound}/>
            </Routes>
        </MainContentSplit>
    </>
}
