import * as React from 'react';
import { useParams } from 'react-router-dom';
import { useAdminUsersUserIdGetUser } from 'meteoio-platform-client';
import { MaybeErrorAlert } from 'meteoio-ui/src/components/MaybeErrorAlert';
import { Spinner } from 'meteoio-ui/src/components/Spinner';
import { Stack } from 'meteoio-ui/src/layouts/Stack';
import { PageTitle } from 'meteoio-ui/src/components/PageTitle';
import { FreeTextField } from 'meteoio-ui/src/components/FreeTextField';
import { SortableTable } from 'meteoio-ui/src/components/SortableTable';
import { RelativeTimeText } from 'meteoio-ui/src/components/RelativeTimeText';
import { CanCreateDatasetsCtrl } from './AdminPage_Users';
import { Text } from '@fluentui/react-components';

export const AdminPage_UserDetails: React.FC = () => {
    const { userId } = useParams<{ userId: string }>();
    const { data: user, isLoading, error } = useAdminUsersUserIdGetUser({
        pathParams: { userId: userId! },
    });

    if (error) {
        return <MaybeErrorAlert error={error} />;
    }
    if (isLoading || !user) {
        return <Spinner tall />;
    }

    return (
        <Stack rowGap="XL" maxWidth={600} center>
            <PageTitle>User Details</PageTitle>
            <Stack rowGap="M">
                <FreeTextField label="ID" value={user.id} readOnly />
                <FreeTextField label="Full Name" value={user.full_name ?? ''} readOnly />
                <FreeTextField label="Email" value={user.email ?? ''} readOnly />
            </Stack>
            {user.created_at && <span>
                <span>Created:</span> <RelativeTimeText date={user.created_at} />
            </span>}
            <span>
                Can login with email and password? {user.email && user.has_password ? 'Yes' : 'No'}
            </span>
            {(user?.openid?.length ?? 0) >= 1 ? (
                <SortableTable
                    columns={[
                        { field: 'issuer', title: 'OpenID Issuer' },
                        { field: 'subject', title: 'OpenID Subject' },
                    ]}
                    rows={user.openid}
                    size="extra-small"
                />
            ) : (
                <span>OpenID credentials: none</span>
            )}
            <CanCreateDatasetsCtrl user={user} />
        </Stack>
    );
};