import * as React from 'react'
import {Stack} from "meteoio-ui/src/layouts/Stack";
import {PageTitle} from "meteoio-ui/src/components/PageTitle";
import {Card, CardHeader, Link, Text, makeStyles, tokens, shorthands} from "@fluentui/react-components";
import { ImGit, ImBooks } from "react-icons/im";
import {OpenRegular, ArrowRightFilled} from "@fluentui/react-icons";
import {AdminNavItem} from "./AdminPages";
import {Link as RouterLink} from "react-router-dom";
import { PageSectionTitle } from 'meteoio-ui/src/components/PageSectionTitle';

interface AdminPageHomeProps {
    navItems: AdminNavItem[];
}

const useStyles = makeStyles({
    navLink: {
        display: 'block',
        textDecorationLine: 'none',
        color: tokens.colorNeutralForeground2Link,
        ...shorthands.padding(tokens.spacingVerticalSNudge, tokens.spacingHorizontalM),
        ...shorthands.transition('background-color', '0.2s', '0', 'ease'),

        '& big': {
            fontSize: '1.1em',
            fontWeight: '600',
        },
        
        ':hover': {
            color: tokens.colorNeutralForeground2Link,
            backgroundColor: tokens.colorNeutralBackground3Hover,
        },
        
        ':hover .arrow': {
            color: tokens.colorBrandForegroundLinkHover,
            transform: 'translate(12px, 4px)',
            opacity: 1,
        }
    },
    mainStack: {
        marginTop: '30px',
        display: 'flex',
        rowGap: '100px',
        columnGap: '15vw',
        flexWrap: 'wrap',
        padding: '0 8px'
    },
    navLinkDescription: {
        color: tokens.colorNeutralForeground3,
        fontSize: tokens.fontSizeBase200,
    },
    arrow: {
        color: tokens.colorBrandForegroundLink,
        fontSize: '0.9em',
        display: 'inline-block',
        transform: 'translate(9px, 4px)',
        opacity: 0.75,
        ...shorthands.transition('transform, opacity', '0.2s', '0', 'ease'),
    },
    cardDescription: {
        color: tokens.colorNeutralForeground3,
        display: 'block',
    }
});

export const AdminPage_Home: React.FC<AdminPageHomeProps> = ({ navItems }) => {
    const styles = useStyles();
    
    return <>
        <div
            horizontal
            wrap
            rowGap="XL"
            columnGap="XXXL"
            maxWidth={700}
            className={styles.mainStack}
        >
            {/* Card 1: Admin Features */}
            <div>
                <PageTitle>Administration</PageTitle>
                <Text className={styles.cardDescription}>Manage and monitor your MeteoIO platform</Text>
                <br />
                <Stack rowGap="None">
                    {navItems.map(item => (
                        <RouterLink 
                            key={item.to} 
                            to={item.to}
                            className={styles.navLink}
                        >
                            <div>
                                <big>{item.label}</big>
                                <span className={`arrow ${styles.arrow}`}>
                                    <ArrowRightFilled />
                                </span>
                                <div className={styles.navLinkDescription}>
                                    {item.description}
                                </div>
                            </div>
                        </RouterLink>
                    ))}
                </Stack>
            </div>
            
            {/* Card 2: Developer Resources */}
            <div>
                <PageTitle>Resources</PageTitle>
                <Text className={styles.cardDescription}>Repository, documentation, and issue tracking</Text>
                <br />
                <div style={{ padding: '8px 16px', display: 'flex', flexFlow: 'column', rowGap: '1em' }}>
                    
                    <Link 
                        href="docs/"
                        target="_blank"
                        style={{ display: 'flex', alignItems: 'center', gap: '8px' }}
                    >
                        <ImBooks style={{ fontSize: '1.5em' }} />
                        <Text size={400}>Internal documentation</Text>
                        <OpenRegular fontSize={16} />
                    </Link>

                    <div style={{display: 'flex', columnGap: '2em', flexWrap: 'wrap'}}>
                        <Link 
                            href="https://code.wsl.ch/snow-models/meteoio-webservice" 
                            target="_blank"
                            style={{ display: 'flex', alignItems: 'center', gap: '8px' }}
                        >
                            <ImGit style={{ fontSize: '1.5em' }} />
                            <Text size={400}>Source Code Repository</Text>
                            <OpenRegular fontSize={16} />
                        </Link>
                        
                        <Link 
                            href="https://code.wsl.ch/snow-models/meteoio-webservice/-/issues" 
                            target="_blank"
                            style={{ display: 'flex', alignItems: 'center', gap: '8px' }}
                        >
                            <Text size={400}>Report Issues</Text>
                            <OpenRegular fontSize={16} />
                        </Link>
                    </div>
                </div>
            </div>
        </div>
    </>
}
