import * as React from 'react'
import {
    AppCustomizationSettingsInstance,
    fetchAdminSettingsRead,
    fetchAdminSettingsWrite,
} from "meteoio-platform-client";
import {EnvSettingsEditor} from "../_common/EnvSettingsEditor";
import {Stack} from "meteoio-ui/src/layouts/Stack";
import {useQueryClient} from "../_common/backend";

export const AdminPage_Env: React.FC = () => {
    const queryClient = useQueryClient()
    return <>
        <br/>
        <br/>
        <Stack maxWidth={700} center>
            <EnvSettingsEditor
                level="system"
                onStore={async (entries) => {
                    const _remote = await fetchAdminSettingsRead({})
                    const body: AppCustomizationSettingsInstance = {
                        ..._remote,
                        jobs_env_config: {entries},
                        // Avoid lost update anomaly by reloading the data that is not being edited here, due to usage of local storage for customization settings
                    }
                    await fetchAdminSettingsWrite({body})
                    await queryClient.invalidateQueries()
                }}
                onLoad={async () => {
                    return (await fetchAdminSettingsRead({}))?.jobs_env_config?.entries ?? []
                }}
                // onDiscard={props.onDiscard}
            />
        </Stack>
        <br/>
        <br/>
    </>
}
