/**
 * Generated by @openapi-codegen
 *
 * @version v4
 */
export type Actor = {
  email?: null | string;
  full_name: string;
  type?: "person" | any;
};

export type AppCustomizationSettingsInstance = {
  app_logo_url: string;
  /**
   * @default METEOROLOGICAL DATA OWNERS PLATFORM
   */
  app_long_title?: string;
  /**
   * @default MeteoIO Web Service
   */
  app_short_title?: string;
  /**
   * @default SUPPORTING TIME SERIES PROCESSING WITH METEOIO
   */
  app_subtitle?: string;
  brand_colors: BrandColors;
  /**
   * System-level configuration of base environment variable configuration for all data processing jobs
   */
  jobs_env_config?: null | JobEnvConfig;
  /**
     * @default Create your online workspace, upload your datasets and [MeteoIO](https://meteoio.slf.ch) configurations, keep a revisions log and schedule cron jobs. It is recommended to rely on [Inishell](https://inishell.slf.ch) to create configuration files.
    
    You can also submit guest jobs to process data with MeteoIO and have the result temporarily available for you to download.
     */
  welcome_data_owners?: string;
  /**
     * @default Authorized users can create their online workspace, upload their datasets and [MeteoIO](https://meteoio.slf.ch) configurations, keep a revisions log and schedule cron jobs.
    
    As a guest, you will be able to view published datasets or, after [ORCID](https://orcid.org/) Login, submit jobs to process data with MeteoIO and have the result temporarily available for you to download.
    
    As a new user, you are definitely welcomed to have a look at the [documentation](docs/)!
     */
  welcome_guests?: string;
  /**
     * @default Authorized users can create their online workspace, upload their datasets and [MeteoIO](https://meteoio.slf.ch) configurations, keep a revisions log and schedule cron jobs.
    
    With your account, you can submit jobs to process data with MeteoIO and have the result temporarily available for you to download. It is recommended to rely on [Inishell](https://inishell.slf.ch) to create configuration files.
     */
  welcome_restricted_internal?: string;
};

export type BrandColors = {
  ["10"]: string;
  ["20"]: string;
  ["30"]: string;
  ["40"]: string;
  ["50"]: string;
  ["60"]: string;
  ["70"]: string;
  ["80"]: string;
  ["90"]: string;
  ["100"]: string;
  ["110"]: string;
  ["120"]: string;
  ["130"]: string;
  ["140"]: string;
  ["150"]: string;
  ["160"]: string;
};

export type CronJob = {
  cron: string;
  id?: null | string;
  job_env?: null | JobEnvConfig;
  params: TimeSeriesJobParams;
  title?: null | string;
  type: string;
};

export type DataQAAggregatedParameter = {
  first_timestamp?: null | string;
  /**
   * @default {}
   */
  kind_count?: {
    [key: string]: number;
  };
  last_timestamp?: null | string;
  parameter: string;
  /**
   * @default 0
   */
  total_count?: number;
};

export type DataQAAggregatedStation = {
  /**
   * @default {}
   */
  parameters?: {
    [key: string]: DataQAAggregatedParameter;
  };
  station: string;
  /**
   * @default 0
   */
  total_count?: number;
};

export type DataQAAnalysisView = {
  stations: DataQAAggregatedStation[];
};

export type DataQATimeline = {
  data: DataQATimelineStation[];
  reprocessing_warnings: string[];
};

export type DataQATimelineParameter = {
  /**
   * @default 0
   */
  no_timestamp_count?: number;
  parameter: string;
  segments: DataQATimelineSegment[];
};

export type DataQATimelineSegment = {
  /**
   * @default 0
   */
  count?: number;
  /**
   * @format date-time
   */
  end: string;
  kind: string;
  /**
   * @format date-time
   */
  start: string;
};

export type DataQATimelineStation = {
  parameters: DataQATimelineParameter[];
  station: string;
};

export type DatasetHeading = {
  creators?: Actor[];
  description?: null | string;
  licenses?: License[];
  locations?: Location[];
  title?: null | string;
};

export type DatasetListEntry = {
  access: "private" | "public";
  /**
   * @format date-time
   */
  created_at: string;
  heading?: null | DatasetHeading;
  id: string;
  owner_user_id: string;
};

export type DatasetRevisionMsg = {
  message?: null | string;
  title?: null | string;
};

export type DatasetRevisionsListEntry = {
  confirmed_at?: null | string;
  created_at?: null | string;
  created_from_id?: null | string;
  emptied_at?: null | string;
  id: string;
  message?: null | string;
  number?: null | number;
  title?: null | string;
  updated_at?: null | string;
};

export type DsRunDto = {
  /**
   * @format date-time
   */
  created_at: string;
  cron_id?: null | string;
  dataset_id: string;
  ini_name?: null | string;
  job_id: string;
  released: boolean;
};

export type EmailPasswordLoginDto = {
  /**
   * must be in lower case
   *
   * @maxLength 200
   * @minLength 3
   */
  email: string;
  secret_password: string;
};

export type EventDTO = {
  /**
   * @format date-time
   */
  created_at: string;
  event_details?: null | string;
  event_title?: null | string;
  event_type?: null | string;
  fingerprint?: null | string;
  from_dataset_cron_id?: null | string;
  from_dataset_id?: null | string;
  from_job_id?: null | string;
  from_user_id?: null | string;
  id: string;
};

export type FileUploadFormData = {
  /**
   * @format binary
   */
  file: Blob;
};

export type FrontendConfiguration = {
  general_access_level: "guest" | "authenticated" | "data_owner";
  /**
   * @default false
   */
  has_ldap?: boolean;
  settings: AppCustomizationSettingsInstance;
  welcome: string;
};

export type FsSnapshotCache = {
  /**
   * @format date-time
   */
  cached_at: string;
  tree: TreeNode;
};

export type FsSnapshotJobParams = {
  /**
   * @default 10000
   */
  hard_max_entries?: null | number;
  /**
   * @default 60
   */
  hard_timeout?: null | number;
  /**
   * @default 10000
   */
  soft_max_entries?: null | number;
  /**
   * @default 60
   */
  soft_timeout?: null | number;
};

export type FuseMountListConfig = {
  mounts: {
    [key: string]:
      | SSHFSMountConfig
      | SMBMountConfig
      | S3MountConfig
      | WebDavMountConfig;
  };
};

export type GenericIdDto = {
  id: string;
};

export type JobEnvConfig = {
  entries: JobEnvConfigEntry[];
};

export type JobEnvConfigEntry = {
  id: string;
  key: string;
  value: string;
};

export type JobListEntryDTO = {
  created_at?: null | string;
  cron_id?: null | string;
  dataset_id?: null | string;
  id: string;
  submitted_by_user_id?: null | string;
};

export type JobStats = {
  created?: null | string;
  disk_usage_bytes?: null | number;
  preparation_seconds?: null | number;
  processing_seconds?: null | number;
  return_code?: null | number;
  status: JobStatus;
  wait_seconds?: null | number;
};

export type JobStatus = {
  is_broken: boolean;
  is_created: boolean;
  is_finished: boolean;
  is_queued: boolean;
  is_returned: boolean;
  is_running: boolean;
  is_started: boolean;
};

export type LdapLoginForm = {
  password: string;
  user_domain?: null | string;
  username: string;
};

export type License = {
  name: string;
};

export type Location = {
  coordSys?: null | string;
  elevation?: null | number;
  latitude?: null | number;
  longitude?: null | number;
};

export type LoginStatus = {
  status: "failed" | "welcome_back";
};

export type MetaConfig = {
  heading?: null | DatasetHeading;
  main_ini_name?: null | string;
};

export type NcMLSearchEntry = {
  ds_id: string;
  job_id: string;
  ncml_imp: NcmlImportantMetadata;
};

export type NcmlImportantMetadata = {
  /**
   * Returns the bounding box as [minLon, minLat, maxLon, maxLat] in EPSG:4326.
   * If geospatial_bounds_crs != EPSG:4326, reprojects the four corners.
   * Returns None if any coordinate is missing.
   */
  bbox?: null | number[];
  contributor_email?: null | string;
  contributor_name?: null | string;
  creator_email?: null | string;
  creator_name?: null | string;
  creator_type?: null | string;
  dataset_production_status?: null | string;
  date_created?: null | string;
  geospatial_bounds?: null | string;
  geospatial_bounds_crs?: null | string;
  geospatial_lat_max?: null | number;
  geospatial_lat_min?: null | number;
  geospatial_lon_max?: null | number;
  geospatial_lon_min?: null | number;
  geospatial_vertical_max?: null | number;
  geospatial_vertical_min?: null | number;
  geospatial_vertical_positive?: null | string;
  geospatial_vertical_units?: null | string;
  history?: null | string;
  id?: null | string;
  keywords?: null | string;
  keywords_vocabulary?: null | string;
  license?: null | string;
  location?: null | string;
  location_station?: null | string;
  metadata_link?: null | string;
  operational_status?: null | string;
  product_version?: null | string;
  program?: null | string;
  project?: null | string;
  references?: null | string;
  source?: null | string;
  time_coverage_end?: null | string;
  time_coverage_resolution?: null | string;
  time_coverage_resolution_seconds?: null | number;
  time_coverage_start?: null | string;
  title?: null | string;
  variables?: null | string[];
};

export type OicInitResponse = {
  login_url: string;
};

export type OicProvidersListItem = {
  config_key: string;
  icon?: "orcid.org" | any;
  login_button_label: string;
};

export type OicProvidersListResponse = {
  providers: OicProvidersListItem[];
};

export type Range = {
  begin?: null | string;
  duration_days?: null | number;
  end?: null | string;
};

export type S3MountConfig = {
  /**
   * The name of the S3 bucket to mount.
   */
  bucket_name: string;
  driver: string;
  /**
   * @default mnt
   */
  local_mount_sub_path?: string;
  password?: null | string;
  /**
   * S3 server url (e.g.: https://example.com/)
   */
  remote_url: string;
  /**
   * Use path-style requests (e.g. for non-Amazon S3 implementation) instead of virtual-hosted-style requests.
   *
   * @default virtual-hosted
   */
  request_style?: "virtual-hosted" | "path";
  /**
   * Connection timeout in seconds.
   *
   * @default 10
   */
  timeout?: number;
  title?: null | string;
  username?: null | string;
};

export type SMBMountConfig = {
  driver: string;
  /**
   * @default mnt
   */
  local_mount_sub_path?: string;
  /**
   * Password for SMB authentication.
   */
  password?: null | string;
  /**
   * The remote host or IP address of the SMB server.
   */
  remote_host: string;
  /**
   * The remote SMB folder to mount (e.g., 'Share').
   */
  remote_path: string;
  /**
   * Connection timeout in seconds.
   *
   * @default 10
   */
  timeout?: number;
  title?: null | string;
  /**
   * Username for SMB authentication.
   */
  username?: null | string;
};

export type SSHAuthorizedKey = {
  entry_id?: null | string;
  fingerprint?: null | string;
  insert_date?: null | string;
  public_key: string;
  /**
   * @default
   */
  public_title?: null | string;
};

export type SSHAuthorizedKeyAddResponse = {
  added_entry_id?: null | string;
  error?: null | string;
};

export type SSHFSMountConfig = {
  driver: string;
  identity_file_path?: null | string;
  /**
   * @default mnt
   */
  local_mount_sub_path?: string;
  password?: null | string;
  remote_host: string;
  /**
   * @default ~
   */
  remote_path?: string;
  /**
   * @default 22
   */
  remote_port?: number;
  title?: null | string;
  username: string;
};

export type StraceDto = {
  current_file_size?: null | number;
  offset_seconds: number;
  open_file_flags?: null | string[];
  open_file_path?: null | string;
  syscall: string;
};

export type TimeSeriesJobParams = {
  ini: string;
  range: Range;
  resolution_minutes?: null | number;
};

export type TreeNode = {
  c?: null | TreeNode[];
  e?: null | boolean;
  m?: null | number;
  n: string;
  s?: null | number;
  t: string;
};

export type UserOidReflection = {
  issuer: string;
  subject: string;
};

export type UserReflection = {
  /**
   * @default false
   */
  can_create_datasets?: boolean;
  created_at?: null | string;
  display_name?: null | string;
  email?: null | string;
  full_name?: null | string;
  /**
   * @default false
   */
  has_password?: boolean;
  id?: null | string;
  /**
   * @default false
   */
  is_admin?: boolean;
  /**
   * @default false
   */
  is_logged_in?: boolean;
  openid?: UserOidReflection[];
};

export type WebDavMountConfig = {
  driver: string;
  /**
   * @default mnt
   */
  local_mount_sub_path?: string;
  /**
   * Password for WebDAV authentication.
   */
  password?: null | string;
  /**
   * WebDav folder URL (e.g.: http://example.com/remote.php/dav/files)
   */
  remote_url: string;
  /**
   * Connection timeout in seconds.
   *
   * @default 10
   */
  timeout?: number;
  title?: null | string;
  /**
   * Username for WebDAV authentication.
   */
  username?: null | string;
};

export type JobAccessLevelResponse = {
  access_level: "full" | "limited";
};

export type DatasetsHeadingDtosFsEntry = {
  /**
   * @format date-time
   */
  date: string;
  path: string;
  size: number;
  type: "file" | "folder";
};

export type FilesFsEntry = {
  /**
   * @format date-time
   */
  date: string;
  path: string;
  size: number;
  type: "file" | "folder";
};
