/**
 * Generated by @openapi-codegen
 *
 * @version v4
 */
import * as reactQuery from "@tanstack/react-query";
import { useBackendContext, BackendContext } from "./backendContext";
import type * as Fetcher from "./backendFetcher";
import { backendFetch } from "./backendFetcher";
import type * as Schemas from "./backendSchemas";

export type AdminDatasetsListDatasetsQueryParams = {
  /**
   * @default 1000
   */
  limit?: number;
  /**
   * @default 0
   */
  offset?: number;
};

export type AdminDatasetsListDatasetsError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type AdminDatasetsListDatasetsResponse = {
  items?: Schemas.DatasetListEntry[];
  /**
   * Maximal number of items to send.
   */
  limit?: number;
  /**
   * Offset from the beginning of the query.
   */
  offset?: number;
  /**
   * Total number of items.
   */
  total?: number;
};

export type AdminDatasetsListDatasetsVariables = {
  queryParams?: AdminDatasetsListDatasetsQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchAdminDatasetsListDatasets = (
  variables: AdminDatasetsListDatasetsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    AdminDatasetsListDatasetsResponse,
    AdminDatasetsListDatasetsError,
    undefined,
    {},
    AdminDatasetsListDatasetsQueryParams,
    {}
  >({ url: "/admin/datasets", method: "get", ...variables, signal });

export const useAdminDatasetsListDatasets = <
  TData = AdminDatasetsListDatasetsResponse
>(
  variables: AdminDatasetsListDatasetsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      AdminDatasetsListDatasetsResponse,
      AdminDatasetsListDatasetsError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    AdminDatasetsListDatasetsResponse,
    AdminDatasetsListDatasetsError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/admin/datasets",
      operationId: "adminDatasetsListDatasets",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchAdminDatasetsListDatasets(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type AdminDatasetsDatasetIdDeleteDatasetPathParams = {
  datasetId: string;
};

export type AdminDatasetsDatasetIdDeleteDatasetQueryParams = {
  owner_user_id_for_check: string;
};

export type AdminDatasetsDatasetIdDeleteDatasetError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type AdminDatasetsDatasetIdDeleteDatasetVariables = {
  pathParams: AdminDatasetsDatasetIdDeleteDatasetPathParams;
  queryParams: AdminDatasetsDatasetIdDeleteDatasetQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchAdminDatasetsDatasetIdDeleteDataset = (
  variables: AdminDatasetsDatasetIdDeleteDatasetVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    AdminDatasetsDatasetIdDeleteDatasetError,
    undefined,
    {},
    AdminDatasetsDatasetIdDeleteDatasetQueryParams,
    AdminDatasetsDatasetIdDeleteDatasetPathParams
  >({
    url: "/admin/datasets/{datasetId}",
    method: "delete",
    ...variables,
    signal,
  });

export const useAdminDatasetsDatasetIdDeleteDataset = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      AdminDatasetsDatasetIdDeleteDatasetError,
      AdminDatasetsDatasetIdDeleteDatasetVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    AdminDatasetsDatasetIdDeleteDatasetError,
    AdminDatasetsDatasetIdDeleteDatasetVariables
  >({
    mutationFn: (variables: AdminDatasetsDatasetIdDeleteDatasetVariables) =>
      fetchAdminDatasetsDatasetIdDeleteDataset({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type AdminDatasetsDatasetIdGetDatasetPathParams = {
  datasetId: string;
};

export type AdminDatasetsDatasetIdGetDatasetError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type AdminDatasetsDatasetIdGetDatasetVariables = {
  pathParams: AdminDatasetsDatasetIdGetDatasetPathParams;
} & BackendContext["fetcherOptions"];

export const fetchAdminDatasetsDatasetIdGetDataset = (
  variables: AdminDatasetsDatasetIdGetDatasetVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.DatasetListEntry,
    AdminDatasetsDatasetIdGetDatasetError,
    undefined,
    {},
    {},
    AdminDatasetsDatasetIdGetDatasetPathParams
  >({
    url: "/admin/datasets/{datasetId}",
    method: "get",
    ...variables,
    signal,
  });

export const useAdminDatasetsDatasetIdGetDataset = <
  TData = Schemas.DatasetListEntry
>(
  variables: AdminDatasetsDatasetIdGetDatasetVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.DatasetListEntry,
      AdminDatasetsDatasetIdGetDatasetError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.DatasetListEntry,
    AdminDatasetsDatasetIdGetDatasetError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/admin/datasets/{dataset_id}",
      operationId: "adminDatasetsDatasetIdGetDataset",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchAdminDatasetsDatasetIdGetDataset(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type AdminDatasetsDatasetIdOwnerTransferTransferDatasetPathParams = {
  datasetId: string;
};

export type AdminDatasetsDatasetIdOwnerTransferTransferDatasetQueryParams = {
  old_owner_user_id: string;
  new_owner_user_id: string;
};

export type AdminDatasetsDatasetIdOwnerTransferTransferDatasetError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type AdminDatasetsDatasetIdOwnerTransferTransferDatasetVariables = {
  pathParams: AdminDatasetsDatasetIdOwnerTransferTransferDatasetPathParams;
  queryParams: AdminDatasetsDatasetIdOwnerTransferTransferDatasetQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchAdminDatasetsDatasetIdOwnerTransferTransferDataset = (
  variables: AdminDatasetsDatasetIdOwnerTransferTransferDatasetVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    AdminDatasetsDatasetIdOwnerTransferTransferDatasetError,
    undefined,
    {},
    AdminDatasetsDatasetIdOwnerTransferTransferDatasetQueryParams,
    AdminDatasetsDatasetIdOwnerTransferTransferDatasetPathParams
  >({
    url: "/admin/datasets/{datasetId}/owner_transfer",
    method: "post",
    ...variables,
    signal,
  });

export const useAdminDatasetsDatasetIdOwnerTransferTransferDataset = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      AdminDatasetsDatasetIdOwnerTransferTransferDatasetError,
      AdminDatasetsDatasetIdOwnerTransferTransferDatasetVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    AdminDatasetsDatasetIdOwnerTransferTransferDatasetError,
    AdminDatasetsDatasetIdOwnerTransferTransferDatasetVariables
  >({
    mutationFn: (
      variables: AdminDatasetsDatasetIdOwnerTransferTransferDatasetVariables
    ) =>
      fetchAdminDatasetsDatasetIdOwnerTransferTransferDataset({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type AdminEventsListEventsQueryParams = {
  /**
   * @default 1000
   */
  limit?: number;
  /**
   * @default 0
   */
  offset?: number;
  event_type?: null | string;
  from_user_id?: null | string;
  fingerprint?: null | string;
};

export type AdminEventsListEventsError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type AdminEventsListEventsResponse = {
  items?: Schemas.EventDTO[];
  /**
   * Maximal number of items to send.
   */
  limit?: number;
  /**
   * Offset from the beginning of the query.
   */
  offset?: number;
  /**
   * Total number of items.
   */
  total?: number;
};

export type AdminEventsListEventsVariables = {
  queryParams?: AdminEventsListEventsQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchAdminEventsListEvents = (
  variables: AdminEventsListEventsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    AdminEventsListEventsResponse,
    AdminEventsListEventsError,
    undefined,
    {},
    AdminEventsListEventsQueryParams,
    {}
  >({ url: "/admin/events", method: "get", ...variables, signal });

export const useAdminEventsListEvents = <TData = AdminEventsListEventsResponse>(
  variables: AdminEventsListEventsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      AdminEventsListEventsResponse,
      AdminEventsListEventsError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    AdminEventsListEventsResponse,
    AdminEventsListEventsError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/admin/events",
      operationId: "adminEventsListEvents",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchAdminEventsListEvents({ ...fetcherOptions, ...variables }, signal),
    ...options,
    ...queryOptions,
  });
};

export type AdminEventsEventIdGetEventByIdPathParams = {
  eventId: string;
};

export type AdminEventsEventIdGetEventByIdError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type AdminEventsEventIdGetEventByIdVariables = {
  pathParams: AdminEventsEventIdGetEventByIdPathParams;
} & BackendContext["fetcherOptions"];

export const fetchAdminEventsEventIdGetEventById = (
  variables: AdminEventsEventIdGetEventByIdVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.EventDTO,
    AdminEventsEventIdGetEventByIdError,
    undefined,
    {},
    {},
    AdminEventsEventIdGetEventByIdPathParams
  >({ url: "/admin/events/{eventId}", method: "get", ...variables, signal });

export const useAdminEventsEventIdGetEventById = <TData = Schemas.EventDTO>(
  variables: AdminEventsEventIdGetEventByIdVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.EventDTO,
      AdminEventsEventIdGetEventByIdError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.EventDTO,
    AdminEventsEventIdGetEventByIdError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/admin/events/{event_id}",
      operationId: "adminEventsEventIdGetEventById",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchAdminEventsEventIdGetEventById(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type AdminJobsListJobsQueryParams = {
  /**
   * @default 1000
   */
  limit?: number;
  /**
   * @default 0
   */
  offset?: number;
};

export type AdminJobsListJobsError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type AdminJobsListJobsResponse = {
  items?: Schemas.JobListEntryDTO[];
  /**
   * Maximal number of items to send.
   */
  limit?: number;
  /**
   * Offset from the beginning of the query.
   */
  offset?: number;
  /**
   * Total number of items.
   */
  total?: number;
};

export type AdminJobsListJobsVariables = {
  queryParams?: AdminJobsListJobsQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchAdminJobsListJobs = (
  variables: AdminJobsListJobsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    AdminJobsListJobsResponse,
    AdminJobsListJobsError,
    undefined,
    {},
    AdminJobsListJobsQueryParams,
    {}
  >({ url: "/admin/jobs", method: "get", ...variables, signal });

export const useAdminJobsListJobs = <TData = AdminJobsListJobsResponse>(
  variables: AdminJobsListJobsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      AdminJobsListJobsResponse,
      AdminJobsListJobsError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    AdminJobsListJobsResponse,
    AdminJobsListJobsError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/admin/jobs",
      operationId: "adminJobsListJobs",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchAdminJobsListJobs({ ...fetcherOptions, ...variables }, signal),
    ...options,
    ...queryOptions,
  });
};

export type AdminJobsJobIdDeleteJobPathParams = {
  jobId: string;
};

export type AdminJobsJobIdDeleteJobError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type AdminJobsJobIdDeleteJobVariables = {
  pathParams: AdminJobsJobIdDeleteJobPathParams;
} & BackendContext["fetcherOptions"];

export const fetchAdminJobsJobIdDeleteJob = (
  variables: AdminJobsJobIdDeleteJobVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    AdminJobsJobIdDeleteJobError,
    undefined,
    {},
    {},
    AdminJobsJobIdDeleteJobPathParams
  >({ url: "/admin/jobs/{jobId}", method: "delete", ...variables, signal });

export const useAdminJobsJobIdDeleteJob = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      AdminJobsJobIdDeleteJobError,
      AdminJobsJobIdDeleteJobVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    AdminJobsJobIdDeleteJobError,
    AdminJobsJobIdDeleteJobVariables
  >({
    mutationFn: (variables: AdminJobsJobIdDeleteJobVariables) =>
      fetchAdminJobsJobIdDeleteJob({ ...fetcherOptions, ...variables }),
    ...options,
  });
};

export type AdminJobsJobIdGetJobDetailsPathParams = {
  jobId: string;
};

export type AdminJobsJobIdGetJobDetailsError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type AdminJobsJobIdGetJobDetailsVariables = {
  pathParams: AdminJobsJobIdGetJobDetailsPathParams;
} & BackendContext["fetcherOptions"];

export const fetchAdminJobsJobIdGetJobDetails = (
  variables: AdminJobsJobIdGetJobDetailsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.JobListEntryDTO,
    AdminJobsJobIdGetJobDetailsError,
    undefined,
    {},
    {},
    AdminJobsJobIdGetJobDetailsPathParams
  >({ url: "/admin/jobs/{jobId}", method: "get", ...variables, signal });

export const useAdminJobsJobIdGetJobDetails = <TData = Schemas.JobListEntryDTO>(
  variables: AdminJobsJobIdGetJobDetailsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.JobListEntryDTO,
      AdminJobsJobIdGetJobDetailsError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.JobListEntryDTO,
    AdminJobsJobIdGetJobDetailsError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/admin/jobs/{job_id}",
      operationId: "adminJobsJobIdGetJobDetails",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchAdminJobsJobIdGetJobDetails(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type AdminSettingsReadError = Fetcher.ErrorWrapper<undefined>;

export type AdminSettingsReadVariables = BackendContext["fetcherOptions"];

export const fetchAdminSettingsRead = (
  variables: AdminSettingsReadVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.AppCustomizationSettingsInstance,
    AdminSettingsReadError,
    undefined,
    {},
    {},
    {}
  >({ url: "/admin/settings", method: "get", ...variables, signal });

export const useAdminSettingsRead = <
  TData = Schemas.AppCustomizationSettingsInstance
>(
  variables: AdminSettingsReadVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.AppCustomizationSettingsInstance,
      AdminSettingsReadError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.AppCustomizationSettingsInstance,
    AdminSettingsReadError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/admin/settings",
      operationId: "adminSettingsRead",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchAdminSettingsRead({ ...fetcherOptions, ...variables }, signal),
    ...options,
    ...queryOptions,
  });
};

export type AdminSettingsWriteError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type AdminSettingsWriteVariables = {
  body: Schemas.AppCustomizationSettingsInstance;
} & BackendContext["fetcherOptions"];

export const fetchAdminSettingsWrite = (
  variables: AdminSettingsWriteVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    AdminSettingsWriteError,
    Schemas.AppCustomizationSettingsInstance,
    {},
    {},
    {}
  >({ url: "/admin/settings", method: "put", ...variables, signal });

export const useAdminSettingsWrite = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      AdminSettingsWriteError,
      AdminSettingsWriteVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    AdminSettingsWriteError,
    AdminSettingsWriteVariables
  >({
    mutationFn: (variables: AdminSettingsWriteVariables) =>
      fetchAdminSettingsWrite({ ...fetcherOptions, ...variables }),
    ...options,
  });
};

export type AdminSettingsFactoryDefaultGetFactoryDefaultError =
  Fetcher.ErrorWrapper<undefined>;

export type AdminSettingsFactoryDefaultGetFactoryDefaultVariables =
  BackendContext["fetcherOptions"];

export const fetchAdminSettingsFactoryDefaultGetFactoryDefault = (
  variables: AdminSettingsFactoryDefaultGetFactoryDefaultVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.AppCustomizationSettingsInstance,
    AdminSettingsFactoryDefaultGetFactoryDefaultError,
    undefined,
    {},
    {},
    {}
  >({
    url: "/admin/settings/factory_default",
    method: "get",
    ...variables,
    signal,
  });

export const useAdminSettingsFactoryDefaultGetFactoryDefault = <
  TData = Schemas.AppCustomizationSettingsInstance
>(
  variables: AdminSettingsFactoryDefaultGetFactoryDefaultVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.AppCustomizationSettingsInstance,
      AdminSettingsFactoryDefaultGetFactoryDefaultError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.AppCustomizationSettingsInstance,
    AdminSettingsFactoryDefaultGetFactoryDefaultError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/admin/settings/factory_default",
      operationId: "adminSettingsFactoryDefaultGetFactoryDefault",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchAdminSettingsFactoryDefaultGetFactoryDefault(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type AdminUsersListUsersQueryParams = {
  /**
   * @default 1000
   */
  limit?: number;
  /**
   * @default 0
   */
  offset?: number;
};

export type AdminUsersListUsersError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type AdminUsersListUsersResponse = {
  items?: Schemas.UserReflection[];
  /**
   * Maximal number of items to send.
   */
  limit?: number;
  /**
   * Offset from the beginning of the query.
   */
  offset?: number;
  /**
   * Total number of items.
   */
  total?: number;
};

export type AdminUsersListUsersVariables = {
  queryParams?: AdminUsersListUsersQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchAdminUsersListUsers = (
  variables: AdminUsersListUsersVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    AdminUsersListUsersResponse,
    AdminUsersListUsersError,
    undefined,
    {},
    AdminUsersListUsersQueryParams,
    {}
  >({ url: "/admin/users", method: "get", ...variables, signal });

export const useAdminUsersListUsers = <TData = AdminUsersListUsersResponse>(
  variables: AdminUsersListUsersVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      AdminUsersListUsersResponse,
      AdminUsersListUsersError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    AdminUsersListUsersResponse,
    AdminUsersListUsersError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/admin/users",
      operationId: "adminUsersListUsers",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchAdminUsersListUsers({ ...fetcherOptions, ...variables }, signal),
    ...options,
    ...queryOptions,
  });
};

export type AdminUsersEditUserIdCanCreateDatasetsResetCanCreateDatasetsPathParams =
  {
    editUserId: string;
  };

export type AdminUsersEditUserIdCanCreateDatasetsResetCanCreateDatasetsError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type AdminUsersEditUserIdCanCreateDatasetsResetCanCreateDatasetsVariables =
  {
    pathParams: AdminUsersEditUserIdCanCreateDatasetsResetCanCreateDatasetsPathParams;
  } & BackendContext["fetcherOptions"];

export const fetchAdminUsersEditUserIdCanCreateDatasetsResetCanCreateDatasets =
  (
    variables: AdminUsersEditUserIdCanCreateDatasetsResetCanCreateDatasetsVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      undefined,
      AdminUsersEditUserIdCanCreateDatasetsResetCanCreateDatasetsError,
      undefined,
      {},
      {},
      AdminUsersEditUserIdCanCreateDatasetsResetCanCreateDatasetsPathParams
    >({
      url: "/admin/users/{editUserId}/can_create_datasets",
      method: "delete",
      ...variables,
      signal,
    });

export const useAdminUsersEditUserIdCanCreateDatasetsResetCanCreateDatasets = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      AdminUsersEditUserIdCanCreateDatasetsResetCanCreateDatasetsError,
      AdminUsersEditUserIdCanCreateDatasetsResetCanCreateDatasetsVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    AdminUsersEditUserIdCanCreateDatasetsResetCanCreateDatasetsError,
    AdminUsersEditUserIdCanCreateDatasetsResetCanCreateDatasetsVariables
  >({
    mutationFn: (
      variables: AdminUsersEditUserIdCanCreateDatasetsResetCanCreateDatasetsVariables
    ) =>
      fetchAdminUsersEditUserIdCanCreateDatasetsResetCanCreateDatasets({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type AdminUsersEditUserIdCanCreateDatasetsSetCanCreateDatasetsPathParams =
  {
    editUserId: string;
  };

export type AdminUsersEditUserIdCanCreateDatasetsSetCanCreateDatasetsError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type AdminUsersEditUserIdCanCreateDatasetsSetCanCreateDatasetsVariables =
  {
    pathParams: AdminUsersEditUserIdCanCreateDatasetsSetCanCreateDatasetsPathParams;
  } & BackendContext["fetcherOptions"];

export const fetchAdminUsersEditUserIdCanCreateDatasetsSetCanCreateDatasets = (
  variables: AdminUsersEditUserIdCanCreateDatasetsSetCanCreateDatasetsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    AdminUsersEditUserIdCanCreateDatasetsSetCanCreateDatasetsError,
    undefined,
    {},
    {},
    AdminUsersEditUserIdCanCreateDatasetsSetCanCreateDatasetsPathParams
  >({
    url: "/admin/users/{editUserId}/can_create_datasets",
    method: "post",
    ...variables,
    signal,
  });

export const useAdminUsersEditUserIdCanCreateDatasetsSetCanCreateDatasets = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      AdminUsersEditUserIdCanCreateDatasetsSetCanCreateDatasetsError,
      AdminUsersEditUserIdCanCreateDatasetsSetCanCreateDatasetsVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    AdminUsersEditUserIdCanCreateDatasetsSetCanCreateDatasetsError,
    AdminUsersEditUserIdCanCreateDatasetsSetCanCreateDatasetsVariables
  >({
    mutationFn: (
      variables: AdminUsersEditUserIdCanCreateDatasetsSetCanCreateDatasetsVariables
    ) =>
      fetchAdminUsersEditUserIdCanCreateDatasetsSetCanCreateDatasets({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type AdminUsersUserIdGetUserPathParams = {
  userId: string;
};

export type AdminUsersUserIdGetUserError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type AdminUsersUserIdGetUserVariables = {
  pathParams: AdminUsersUserIdGetUserPathParams;
} & BackendContext["fetcherOptions"];

export const fetchAdminUsersUserIdGetUser = (
  variables: AdminUsersUserIdGetUserVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.UserReflection,
    AdminUsersUserIdGetUserError,
    undefined,
    {},
    {},
    AdminUsersUserIdGetUserPathParams
  >({ url: "/admin/users/{userId}", method: "get", ...variables, signal });

export const useAdminUsersUserIdGetUser = <TData = Schemas.UserReflection>(
  variables: AdminUsersUserIdGetUserVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.UserReflection,
      AdminUsersUserIdGetUserError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.UserReflection,
    AdminUsersUserIdGetUserError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/admin/users/{user_id}",
      operationId: "adminUsersUserIdGetUser",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchAdminUsersUserIdGetUser({ ...fetcherOptions, ...variables }, signal),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsListError = Fetcher.ErrorWrapper<undefined>;

export type InternalDatasetsListResponse = Schemas.DatasetListEntry[];

export type InternalDatasetsListVariables = BackendContext["fetcherOptions"];

export const fetchInternalDatasetsList = (
  variables: InternalDatasetsListVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    InternalDatasetsListResponse,
    InternalDatasetsListError,
    undefined,
    {},
    {},
    {}
  >({ url: "/internal/datasets", method: "get", ...variables, signal });

export const useInternalDatasetsList = <TData = InternalDatasetsListResponse>(
  variables: InternalDatasetsListVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      InternalDatasetsListResponse,
      InternalDatasetsListError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    InternalDatasetsListResponse,
    InternalDatasetsListError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets",
      operationId: "internalDatasetsList",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsList({ ...fetcherOptions, ...variables }, signal),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsCreateError = Fetcher.ErrorWrapper<undefined>;

export type InternalDatasetsCreateVariables = BackendContext["fetcherOptions"];

export const fetchInternalDatasetsCreate = (
  variables: InternalDatasetsCreateVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.GenericIdDto,
    InternalDatasetsCreateError,
    undefined,
    {},
    {},
    {}
  >({ url: "/internal/datasets", method: "post", ...variables, signal });

export const useInternalDatasetsCreate = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      Schemas.GenericIdDto,
      InternalDatasetsCreateError,
      InternalDatasetsCreateVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    Schemas.GenericIdDto,
    InternalDatasetsCreateError,
    InternalDatasetsCreateVariables
  >({
    mutationFn: (variables: InternalDatasetsCreateVariables) =>
      fetchInternalDatasetsCreate({ ...fetcherOptions, ...variables }),
    ...options,
  });
};

export type InternalDatasetsTryFindRunJobIdTryFindRunPathParams = {
  jobId: string;
};

export type InternalDatasetsTryFindRunJobIdTryFindRunError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsTryFindRunJobIdTryFindRunVariables = {
  pathParams: InternalDatasetsTryFindRunJobIdTryFindRunPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsTryFindRunJobIdTryFindRun = (
  variables: InternalDatasetsTryFindRunJobIdTryFindRunVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    null | Schemas.DsRunDto,
    InternalDatasetsTryFindRunJobIdTryFindRunError,
    undefined,
    {},
    {},
    InternalDatasetsTryFindRunJobIdTryFindRunPathParams
  >({
    url: "/internal/datasets/try_find_run/{jobId}",
    method: "get",
    ...variables,
    signal,
  });

export const useInternalDatasetsTryFindRunJobIdTryFindRun = <
  TData = null | Schemas.DsRunDto
>(
  variables: InternalDatasetsTryFindRunJobIdTryFindRunVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      null | Schemas.DsRunDto,
      InternalDatasetsTryFindRunJobIdTryFindRunError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    null | Schemas.DsRunDto,
    InternalDatasetsTryFindRunJobIdTryFindRunError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/try_find_run/{job_id}",
      operationId: "internalDatasetsTryFindRunJobIdTryFindRun",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsTryFindRunJobIdTryFindRun(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdDeletePathParams = {
  datasetId: string;
};

export type InternalDatasetsDatasetIdDeleteQueryParams = {
  owner_user_id_for_check: string;
  dataset_id_for_check: string;
};

export type InternalDatasetsDatasetIdDeleteError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type InternalDatasetsDatasetIdDeleteVariables = {
  pathParams: InternalDatasetsDatasetIdDeletePathParams;
  queryParams: InternalDatasetsDatasetIdDeleteQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdDelete = (
  variables: InternalDatasetsDatasetIdDeleteVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdDeleteError,
    undefined,
    {},
    InternalDatasetsDatasetIdDeleteQueryParams,
    InternalDatasetsDatasetIdDeletePathParams
  >({
    url: "/internal/datasets/{datasetId}",
    method: "delete",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdDelete = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalDatasetsDatasetIdDeleteError,
      InternalDatasetsDatasetIdDeleteVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalDatasetsDatasetIdDeleteError,
    InternalDatasetsDatasetIdDeleteVariables
  >({
    mutationFn: (variables: InternalDatasetsDatasetIdDeleteVariables) =>
      fetchInternalDatasetsDatasetIdDelete({ ...fetcherOptions, ...variables }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdReadPathParams = {
  datasetId: string;
};

export type InternalDatasetsDatasetIdReadError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type InternalDatasetsDatasetIdReadVariables = {
  pathParams: InternalDatasetsDatasetIdReadPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdRead = (
  variables: InternalDatasetsDatasetIdReadVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    null | Schemas.DatasetHeading,
    InternalDatasetsDatasetIdReadError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdReadPathParams
  >({
    url: "/internal/datasets/{datasetId}",
    method: "get",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdRead = <
  TData = null | Schemas.DatasetHeading
>(
  variables: InternalDatasetsDatasetIdReadVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      null | Schemas.DatasetHeading,
      InternalDatasetsDatasetIdReadError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    null | Schemas.DatasetHeading,
    InternalDatasetsDatasetIdReadError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/{dataset_id}",
      operationId: "internalDatasetsDatasetIdRead",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsDatasetIdRead(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdAccessGetAccessPathParams = {
  datasetId: string;
};

export type InternalDatasetsDatasetIdAccessGetAccessError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdAccessGetAccessVariables = {
  pathParams: InternalDatasetsDatasetIdAccessGetAccessPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdAccessGetAccess = (
  variables: InternalDatasetsDatasetIdAccessGetAccessVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.GenericIdDto,
    InternalDatasetsDatasetIdAccessGetAccessError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdAccessGetAccessPathParams
  >({
    url: "/internal/datasets/{datasetId}/access",
    method: "get",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdAccessGetAccess = <
  TData = Schemas.GenericIdDto
>(
  variables: InternalDatasetsDatasetIdAccessGetAccessVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.GenericIdDto,
      InternalDatasetsDatasetIdAccessGetAccessError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.GenericIdDto,
    InternalDatasetsDatasetIdAccessGetAccessError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/{dataset_id}/access",
      operationId: "internalDatasetsDatasetIdAccessGetAccess",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsDatasetIdAccessGetAccess(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdAccessSetAccessPathParams = {
  datasetId: string;
};

export type InternalDatasetsDatasetIdAccessSetAccessQueryParams = {
  access: "private" | "public";
};

export type InternalDatasetsDatasetIdAccessSetAccessError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdAccessSetAccessVariables = {
  pathParams: InternalDatasetsDatasetIdAccessSetAccessPathParams;
  queryParams: InternalDatasetsDatasetIdAccessSetAccessQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdAccessSetAccess = (
  variables: InternalDatasetsDatasetIdAccessSetAccessVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdAccessSetAccessError,
    undefined,
    {},
    InternalDatasetsDatasetIdAccessSetAccessQueryParams,
    InternalDatasetsDatasetIdAccessSetAccessPathParams
  >({
    url: "/internal/datasets/{datasetId}/access",
    method: "put",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdAccessSetAccess = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalDatasetsDatasetIdAccessSetAccessError,
      InternalDatasetsDatasetIdAccessSetAccessVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalDatasetsDatasetIdAccessSetAccessError,
    InternalDatasetsDatasetIdAccessSetAccessVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdAccessSetAccessVariables
    ) =>
      fetchInternalDatasetsDatasetIdAccessSetAccess({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdAllRunsListAllRunsPathParams = {
  datasetId: string;
};

export type InternalDatasetsDatasetIdAllRunsListAllRunsError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdAllRunsListAllRunsResponse =
  Schemas.DsRunDto[];

export type InternalDatasetsDatasetIdAllRunsListAllRunsVariables = {
  pathParams: InternalDatasetsDatasetIdAllRunsListAllRunsPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdAllRunsListAllRuns = (
  variables: InternalDatasetsDatasetIdAllRunsListAllRunsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    InternalDatasetsDatasetIdAllRunsListAllRunsResponse,
    InternalDatasetsDatasetIdAllRunsListAllRunsError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdAllRunsListAllRunsPathParams
  >({
    url: "/internal/datasets/{datasetId}/all_runs",
    method: "get",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdAllRunsListAllRuns = <
  TData = InternalDatasetsDatasetIdAllRunsListAllRunsResponse
>(
  variables: InternalDatasetsDatasetIdAllRunsListAllRunsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      InternalDatasetsDatasetIdAllRunsListAllRunsResponse,
      InternalDatasetsDatasetIdAllRunsListAllRunsError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    InternalDatasetsDatasetIdAllRunsListAllRunsResponse,
    InternalDatasetsDatasetIdAllRunsListAllRunsError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/{dataset_id}/all_runs",
      operationId: "internalDatasetsDatasetIdAllRunsListAllRuns",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsDatasetIdAllRunsListAllRuns(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdConfigTxsGetConfigPendingTxsPathParams = {
  datasetId: string;
};

export type InternalDatasetsDatasetIdConfigTxsGetConfigPendingTxsError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsGetConfigPendingTxsResponse =
  string[];

export type InternalDatasetsDatasetIdConfigTxsGetConfigPendingTxsVariables = {
  pathParams: InternalDatasetsDatasetIdConfigTxsGetConfigPendingTxsPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsGetConfigPendingTxs = (
  variables: InternalDatasetsDatasetIdConfigTxsGetConfigPendingTxsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    InternalDatasetsDatasetIdConfigTxsGetConfigPendingTxsResponse,
    InternalDatasetsDatasetIdConfigTxsGetConfigPendingTxsError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdConfigTxsGetConfigPendingTxsPathParams
  >({
    url: "/internal/datasets/{datasetId}/config_txs",
    method: "get",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdConfigTxsGetConfigPendingTxs = <
  TData = InternalDatasetsDatasetIdConfigTxsGetConfigPendingTxsResponse
>(
  variables: InternalDatasetsDatasetIdConfigTxsGetConfigPendingTxsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      InternalDatasetsDatasetIdConfigTxsGetConfigPendingTxsResponse,
      InternalDatasetsDatasetIdConfigTxsGetConfigPendingTxsError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    InternalDatasetsDatasetIdConfigTxsGetConfigPendingTxsResponse,
    InternalDatasetsDatasetIdConfigTxsGetConfigPendingTxsError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/{dataset_id}/config_txs",
      operationId: "internalDatasetsDatasetIdConfigTxsGetConfigPendingTxs",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsDatasetIdConfigTxsGetConfigPendingTxs(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdConfigTxsBeginConfigWriteTxPathParams = {
  datasetId: string;
};

export type InternalDatasetsDatasetIdConfigTxsBeginConfigWriteTxError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsBeginConfigWriteTxVariables = {
  pathParams: InternalDatasetsDatasetIdConfigTxsBeginConfigWriteTxPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsBeginConfigWriteTx = (
  variables: InternalDatasetsDatasetIdConfigTxsBeginConfigWriteTxVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.GenericIdDto,
    InternalDatasetsDatasetIdConfigTxsBeginConfigWriteTxError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdConfigTxsBeginConfigWriteTxPathParams
  >({
    url: "/internal/datasets/{datasetId}/config_txs",
    method: "post",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdConfigTxsBeginConfigWriteTx = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      Schemas.GenericIdDto,
      InternalDatasetsDatasetIdConfigTxsBeginConfigWriteTxError,
      InternalDatasetsDatasetIdConfigTxsBeginConfigWriteTxVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    Schemas.GenericIdDto,
    InternalDatasetsDatasetIdConfigTxsBeginConfigWriteTxError,
    InternalDatasetsDatasetIdConfigTxsBeginConfigWriteTxVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdConfigTxsBeginConfigWriteTxVariables
    ) =>
      fetchInternalDatasetsDatasetIdConfigTxsBeginConfigWriteTx({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdConfigTxsTxIdDeleteConfigWriteTxPathParams =
  {
    datasetId: string;
    txId: string;
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdDeleteConfigWriteTxError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdDeleteConfigWriteTxVariables =
  {
    pathParams: InternalDatasetsDatasetIdConfigTxsTxIdDeleteConfigWriteTxPathParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdDeleteConfigWriteTx = (
  variables: InternalDatasetsDatasetIdConfigTxsTxIdDeleteConfigWriteTxVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdConfigTxsTxIdDeleteConfigWriteTxError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdConfigTxsTxIdDeleteConfigWriteTxPathParams
  >({
    url: "/internal/datasets/{datasetId}/config_txs/{txId}",
    method: "delete",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdConfigTxsTxIdDeleteConfigWriteTx = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdDeleteConfigWriteTxError,
      InternalDatasetsDatasetIdConfigTxsTxIdDeleteConfigWriteTxVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalDatasetsDatasetIdConfigTxsTxIdDeleteConfigWriteTxError,
    InternalDatasetsDatasetIdConfigTxsTxIdDeleteConfigWriteTxVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdConfigTxsTxIdDeleteConfigWriteTxVariables
    ) =>
      fetchInternalDatasetsDatasetIdConfigTxsTxIdDeleteConfigWriteTx({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdConfigTxsTxIdApplyApplyConfigWriteTxPathParams =
  {
    datasetId: string;
    txId: string;
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdApplyApplyConfigWriteTxError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdApplyApplyConfigWriteTxVariables =
  {
    pathParams: InternalDatasetsDatasetIdConfigTxsTxIdApplyApplyConfigWriteTxPathParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdApplyApplyConfigWriteTx =
  (
    variables: InternalDatasetsDatasetIdConfigTxsTxIdApplyApplyConfigWriteTxVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdApplyApplyConfigWriteTxError,
      undefined,
      {},
      {},
      InternalDatasetsDatasetIdConfigTxsTxIdApplyApplyConfigWriteTxPathParams
    >({
      url: "/internal/datasets/{datasetId}/config_txs/{txId}/apply",
      method: "post",
      ...variables,
      signal,
    });

export const useInternalDatasetsDatasetIdConfigTxsTxIdApplyApplyConfigWriteTx =
  (
    options?: Omit<
      reactQuery.UseMutationOptions<
        undefined,
        InternalDatasetsDatasetIdConfigTxsTxIdApplyApplyConfigWriteTxError,
        InternalDatasetsDatasetIdConfigTxsTxIdApplyApplyConfigWriteTxVariables
      >,
      "mutationFn"
    >
  ) => {
    const { fetcherOptions } = useBackendContext();
    return reactQuery.useMutation<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdApplyApplyConfigWriteTxError,
      InternalDatasetsDatasetIdConfigTxsTxIdApplyApplyConfigWriteTxVariables
    >({
      mutationFn: (
        variables: InternalDatasetsDatasetIdConfigTxsTxIdApplyApplyConfigWriteTxVariables
      ) =>
        fetchInternalDatasetsDatasetIdConfigTxsTxIdApplyApplyConfigWriteTx({
          ...fetcherOptions,
          ...variables,
        }),
      ...options,
    });
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdClearContentsClearConfigContentsPathParams =
  {
    datasetId: string;
    txId: string;
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdClearContentsClearConfigContentsError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdClearContentsClearConfigContentsVariables =
  {
    pathParams: InternalDatasetsDatasetIdConfigTxsTxIdClearContentsClearConfigContentsPathParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdClearContentsClearConfigContents =
  (
    variables: InternalDatasetsDatasetIdConfigTxsTxIdClearContentsClearConfigContentsVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdClearContentsClearConfigContentsError,
      undefined,
      {},
      {},
      InternalDatasetsDatasetIdConfigTxsTxIdClearContentsClearConfigContentsPathParams
    >({
      url: "/internal/datasets/{datasetId}/config_txs/{txId}/clear_contents",
      method: "post",
      ...variables,
      signal,
    });

export const useInternalDatasetsDatasetIdConfigTxsTxIdClearContentsClearConfigContents =
  (
    options?: Omit<
      reactQuery.UseMutationOptions<
        undefined,
        InternalDatasetsDatasetIdConfigTxsTxIdClearContentsClearConfigContentsError,
        InternalDatasetsDatasetIdConfigTxsTxIdClearContentsClearConfigContentsVariables
      >,
      "mutationFn"
    >
  ) => {
    const { fetcherOptions } = useBackendContext();
    return reactQuery.useMutation<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdClearContentsClearConfigContentsError,
      InternalDatasetsDatasetIdConfigTxsTxIdClearContentsClearConfigContentsVariables
    >({
      mutationFn: (
        variables: InternalDatasetsDatasetIdConfigTxsTxIdClearContentsClearConfigContentsVariables
      ) =>
        fetchInternalDatasetsDatasetIdConfigTxsTxIdClearContentsClearConfigContents(
          { ...fetcherOptions, ...variables }
        ),
      ...options,
    });
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobsPathParams =
  {
    txId: string;
    datasetId: string;
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobsError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobsResponse =
  Schemas.CronJob[];

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobsVariables =
  {
    pathParams: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobsPathParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobs = (
  variables: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    InternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobsResponse,
    InternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobsError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobsPathParams
  >({
    url: "/internal/datasets/{datasetId}/config_txs/{txId}/cron/jobs",
    method: "get",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobs = <
  TData = InternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobsResponse
>(
  variables: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobsResponse,
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobsError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    InternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobsResponse,
    InternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobsError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/cron/jobs",
      operationId: "internalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobs",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobs(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsCreateCronJobPathParams =
  {
    txId: string;
    datasetId: string;
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsCreateCronJobError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsCreateCronJobVariables =
  {
    body: Schemas.CronJob;
    pathParams: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsCreateCronJobPathParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdCronJobsCreateCronJob =
  (
    variables: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsCreateCronJobVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      Schemas.GenericIdDto,
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsCreateCronJobError,
      Schemas.CronJob,
      {},
      {},
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsCreateCronJobPathParams
    >({
      url: "/internal/datasets/{datasetId}/config_txs/{txId}/cron/jobs",
      method: "post",
      ...variables,
      signal,
    });

export const useInternalDatasetsDatasetIdConfigTxsTxIdCronJobsCreateCronJob = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      Schemas.GenericIdDto,
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsCreateCronJobError,
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsCreateCronJobVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    Schemas.GenericIdDto,
    InternalDatasetsDatasetIdConfigTxsTxIdCronJobsCreateCronJobError,
    InternalDatasetsDatasetIdConfigTxsTxIdCronJobsCreateCronJobVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsCreateCronJobVariables
    ) =>
      fetchInternalDatasetsDatasetIdConfigTxsTxIdCronJobsCreateCronJob({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdDeleteCronJobPathParams =
  {
    txId: string;
    datasetId: string;
    jobId: string;
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdDeleteCronJobError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdDeleteCronJobVariables =
  {
    pathParams: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdDeleteCronJobPathParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdDeleteCronJob =
  (
    variables: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdDeleteCronJobVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdDeleteCronJobError,
      undefined,
      {},
      {},
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdDeleteCronJobPathParams
    >({
      url: "/internal/datasets/{datasetId}/config_txs/{txId}/cron/jobs/{jobId}",
      method: "delete",
      ...variables,
      signal,
    });

export const useInternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdDeleteCronJob =
  (
    options?: Omit<
      reactQuery.UseMutationOptions<
        undefined,
        InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdDeleteCronJobError,
        InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdDeleteCronJobVariables
      >,
      "mutationFn"
    >
  ) => {
    const { fetcherOptions } = useBackendContext();
    return reactQuery.useMutation<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdDeleteCronJobError,
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdDeleteCronJobVariables
    >({
      mutationFn: (
        variables: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdDeleteCronJobVariables
      ) =>
        fetchInternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdDeleteCronJob({
          ...fetcherOptions,
          ...variables,
        }),
      ...options,
    });
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdReadCronJobPathParams =
  {
    txId: string;
    datasetId: string;
    jobId: string;
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdReadCronJobError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdReadCronJobVariables =
  {
    pathParams: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdReadCronJobPathParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdReadCronJob =
  (
    variables: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdReadCronJobVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      Schemas.CronJob,
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdReadCronJobError,
      undefined,
      {},
      {},
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdReadCronJobPathParams
    >({
      url: "/internal/datasets/{datasetId}/config_txs/{txId}/cron/jobs/{jobId}",
      method: "get",
      ...variables,
      signal,
    });

export const useInternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdReadCronJob =
  <TData = Schemas.CronJob>(
    variables: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdReadCronJobVariables,
    options?: Omit<
      reactQuery.UseQueryOptions<
        Schemas.CronJob,
        InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdReadCronJobError,
        TData
      >,
      "queryKey" | "queryFn"
    >
  ) => {
    const { fetcherOptions, queryOptions, queryKeyFn } =
      useBackendContext(options);
    return reactQuery.useQuery<
      Schemas.CronJob,
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdReadCronJobError,
      TData
    >({
      queryKey: queryKeyFn({
        path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/cron/jobs/{job_id}",
        operationId:
          "internalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdReadCronJob",
        variables,
      }),
      queryFn: ({ signal }) =>
        fetchInternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdReadCronJob(
          { ...fetcherOptions, ...variables },
          signal
        ),
      ...options,
      ...queryOptions,
    });
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdUpdateCronJobPathParams =
  {
    txId: string;
    datasetId: string;
    jobId: string;
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdUpdateCronJobError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdUpdateCronJobVariables =
  {
    body: Schemas.CronJob;
    pathParams: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdUpdateCronJobPathParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdUpdateCronJob =
  (
    variables: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdUpdateCronJobVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdUpdateCronJobError,
      Schemas.CronJob,
      {},
      {},
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdUpdateCronJobPathParams
    >({
      url: "/internal/datasets/{datasetId}/config_txs/{txId}/cron/jobs/{jobId}",
      method: "put",
      ...variables,
      signal,
    });

export const useInternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdUpdateCronJob =
  (
    options?: Omit<
      reactQuery.UseMutationOptions<
        undefined,
        InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdUpdateCronJobError,
        InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdUpdateCronJobVariables
      >,
      "mutationFn"
    >
  ) => {
    const { fetcherOptions } = useBackendContext();
    return reactQuery.useMutation<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdUpdateCronJobError,
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdUpdateCronJobVariables
    >({
      mutationFn: (
        variables: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdUpdateCronJobVariables
      ) =>
        fetchInternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdUpdateCronJob({
          ...fetcherOptions,
          ...variables,
        }),
      ...options,
    });
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdTriggerTriggerCronJobPathParams =
  {
    datasetId: string;
    txId: string;
    jobId: string;
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdTriggerTriggerCronJobError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdTriggerTriggerCronJobVariables =
  {
    pathParams: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdTriggerTriggerCronJobPathParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdTriggerTriggerCronJob =
  (
    variables: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdTriggerTriggerCronJobVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      Schemas.GenericIdDto,
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdTriggerTriggerCronJobError,
      undefined,
      {},
      {},
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdTriggerTriggerCronJobPathParams
    >({
      url: "/internal/datasets/{datasetId}/config_txs/{txId}/cron/jobs/{jobId}/trigger",
      method: "post",
      ...variables,
      signal,
    });

export const useInternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdTriggerTriggerCronJob =
  (
    options?: Omit<
      reactQuery.UseMutationOptions<
        Schemas.GenericIdDto,
        InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdTriggerTriggerCronJobError,
        InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdTriggerTriggerCronJobVariables
      >,
      "mutationFn"
    >
  ) => {
    const { fetcherOptions } = useBackendContext();
    return reactQuery.useMutation<
      Schemas.GenericIdDto,
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdTriggerTriggerCronJobError,
      InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdTriggerTriggerCronJobVariables
    >({
      mutationFn: (
        variables: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdTriggerTriggerCronJobVariables
      ) =>
        fetchInternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdTriggerTriggerCronJob(
          { ...fetcherOptions, ...variables }
        ),
      ...options,
    });
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdDiffFromOtherTxIdGetConfigDiffPathParams =
  {
    datasetId: string;
    txId: string;
    otherTxId: string;
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdDiffFromOtherTxIdGetConfigDiffError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdDiffFromOtherTxIdGetConfigDiffVariables =
  {
    pathParams: InternalDatasetsDatasetIdConfigTxsTxIdDiffFromOtherTxIdGetConfigDiffPathParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdDiffFromOtherTxIdGetConfigDiff =
  (
    variables: InternalDatasetsDatasetIdConfigTxsTxIdDiffFromOtherTxIdGetConfigDiffVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdDiffFromOtherTxIdGetConfigDiffError,
      undefined,
      {},
      {},
      InternalDatasetsDatasetIdConfigTxsTxIdDiffFromOtherTxIdGetConfigDiffPathParams
    >({
      url: "/internal/datasets/{datasetId}/config_txs/{txId}/diff_from/{otherTxId}",
      method: "get",
      ...variables,
      signal,
    });

export const useInternalDatasetsDatasetIdConfigTxsTxIdDiffFromOtherTxIdGetConfigDiff =
  <TData = undefined>(
    variables: InternalDatasetsDatasetIdConfigTxsTxIdDiffFromOtherTxIdGetConfigDiffVariables,
    options?: Omit<
      reactQuery.UseQueryOptions<
        undefined,
        InternalDatasetsDatasetIdConfigTxsTxIdDiffFromOtherTxIdGetConfigDiffError,
        TData
      >,
      "queryKey" | "queryFn"
    >
  ) => {
    const { fetcherOptions, queryOptions, queryKeyFn } =
      useBackendContext(options);
    return reactQuery.useQuery<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdDiffFromOtherTxIdGetConfigDiffError,
      TData
    >({
      queryKey: queryKeyFn({
        path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/diff_from/{other_tx_id}",
        operationId:
          "internalDatasetsDatasetIdConfigTxsTxIdDiffFromOtherTxIdGetConfigDiff",
        variables,
      }),
      queryFn: ({ signal }) =>
        fetchInternalDatasetsDatasetIdConfigTxsTxIdDiffFromOtherTxIdGetConfigDiff(
          { ...fetcherOptions, ...variables },
          signal
        ),
      ...options,
      ...queryOptions,
    });
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdExportExportConfigDirectoryPathParams =
  {
    txId: string;
    datasetId: string;
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdExportExportConfigDirectoryError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdExportExportConfigDirectoryVariables =
  {
    pathParams: InternalDatasetsDatasetIdConfigTxsTxIdExportExportConfigDirectoryPathParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdExportExportConfigDirectory =
  (
    variables: InternalDatasetsDatasetIdConfigTxsTxIdExportExportConfigDirectoryVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdExportExportConfigDirectoryError,
      undefined,
      {},
      {},
      InternalDatasetsDatasetIdConfigTxsTxIdExportExportConfigDirectoryPathParams
    >({
      url: "/internal/datasets/{datasetId}/config_txs/{txId}/export",
      method: "get",
      ...variables,
      signal,
    });

export const useInternalDatasetsDatasetIdConfigTxsTxIdExportExportConfigDirectory =
  <TData = undefined>(
    variables: InternalDatasetsDatasetIdConfigTxsTxIdExportExportConfigDirectoryVariables,
    options?: Omit<
      reactQuery.UseQueryOptions<
        undefined,
        InternalDatasetsDatasetIdConfigTxsTxIdExportExportConfigDirectoryError,
        TData
      >,
      "queryKey" | "queryFn"
    >
  ) => {
    const { fetcherOptions, queryOptions, queryKeyFn } =
      useBackendContext(options);
    return reactQuery.useQuery<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdExportExportConfigDirectoryError,
      TData
    >({
      queryKey: queryKeyFn({
        path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/export",
        operationId:
          "internalDatasetsDatasetIdConfigTxsTxIdExportExportConfigDirectory",
        variables,
      }),
      queryFn: ({ signal }) =>
        fetchInternalDatasetsDatasetIdConfigTxsTxIdExportExportConfigDirectory(
          { ...fetcherOptions, ...variables },
          signal
        ),
      ...options,
      ...queryOptions,
    });
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdFuseGetFusePathParams = {
  txId: string;
  datasetId: string;
};

export type InternalDatasetsDatasetIdConfigTxsTxIdFuseGetFuseError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdFuseGetFuseVariables = {
  pathParams: InternalDatasetsDatasetIdConfigTxsTxIdFuseGetFusePathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdFuseGetFuse = (
  variables: InternalDatasetsDatasetIdConfigTxsTxIdFuseGetFuseVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.FuseMountListConfig,
    InternalDatasetsDatasetIdConfigTxsTxIdFuseGetFuseError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdConfigTxsTxIdFuseGetFusePathParams
  >({
    url: "/internal/datasets/{datasetId}/config_txs/{txId}/fuse",
    method: "get",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdConfigTxsTxIdFuseGetFuse = <
  TData = Schemas.FuseMountListConfig
>(
  variables: InternalDatasetsDatasetIdConfigTxsTxIdFuseGetFuseVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.FuseMountListConfig,
      InternalDatasetsDatasetIdConfigTxsTxIdFuseGetFuseError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.FuseMountListConfig,
    InternalDatasetsDatasetIdConfigTxsTxIdFuseGetFuseError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/fuse",
      operationId: "internalDatasetsDatasetIdConfigTxsTxIdFuseGetFuse",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsDatasetIdConfigTxsTxIdFuseGetFuse(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdConfigTxsTxIdFuseSetFusePathParams = {
  txId: string;
  datasetId: string;
};

export type InternalDatasetsDatasetIdConfigTxsTxIdFuseSetFuseError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdFuseSetFuseVariables = {
  body: Schemas.FuseMountListConfig;
  pathParams: InternalDatasetsDatasetIdConfigTxsTxIdFuseSetFusePathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdFuseSetFuse = (
  variables: InternalDatasetsDatasetIdConfigTxsTxIdFuseSetFuseVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdConfigTxsTxIdFuseSetFuseError,
    Schemas.FuseMountListConfig,
    {},
    {},
    InternalDatasetsDatasetIdConfigTxsTxIdFuseSetFusePathParams
  >({
    url: "/internal/datasets/{datasetId}/config_txs/{txId}/fuse",
    method: "put",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdConfigTxsTxIdFuseSetFuse = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdFuseSetFuseError,
      InternalDatasetsDatasetIdConfigTxsTxIdFuseSetFuseVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalDatasetsDatasetIdConfigTxsTxIdFuseSetFuseError,
    InternalDatasetsDatasetIdConfigTxsTxIdFuseSetFuseVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdConfigTxsTxIdFuseSetFuseVariables
    ) =>
      fetchInternalDatasetsDatasetIdConfigTxsTxIdFuseSetFuse({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdConfigTxsTxIdImportImportConfigDirectoryPathParams =
  {
    txId: string;
    datasetId: string;
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdImportImportConfigDirectoryError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdImportImportConfigDirectoryVariables =
  {
    body: Schemas.FileUploadFormData;
    pathParams: InternalDatasetsDatasetIdConfigTxsTxIdImportImportConfigDirectoryPathParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdImportImportConfigDirectory =
  (
    variables: InternalDatasetsDatasetIdConfigTxsTxIdImportImportConfigDirectoryVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdImportImportConfigDirectoryError,
      Schemas.FileUploadFormData,
      {},
      {},
      InternalDatasetsDatasetIdConfigTxsTxIdImportImportConfigDirectoryPathParams
    >({
      url: "/internal/datasets/{datasetId}/config_txs/{txId}/import",
      method: "post",
      ...variables,
      signal,
    });

export const useInternalDatasetsDatasetIdConfigTxsTxIdImportImportConfigDirectory =
  (
    options?: Omit<
      reactQuery.UseMutationOptions<
        undefined,
        InternalDatasetsDatasetIdConfigTxsTxIdImportImportConfigDirectoryError,
        InternalDatasetsDatasetIdConfigTxsTxIdImportImportConfigDirectoryVariables
      >,
      "mutationFn"
    >
  ) => {
    const { fetcherOptions } = useBackendContext();
    return reactQuery.useMutation<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdImportImportConfigDirectoryError,
      InternalDatasetsDatasetIdConfigTxsTxIdImportImportConfigDirectoryVariables
    >({
      mutationFn: (
        variables: InternalDatasetsDatasetIdConfigTxsTxIdImportImportConfigDirectoryVariables
      ) =>
        fetchInternalDatasetsDatasetIdConfigTxsTxIdImportImportConfigDirectory({
          ...fetcherOptions,
          ...variables,
        }),
      ...options,
    });
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdInisListInisPathParams = {
  txId: string;
  datasetId: string;
};

export type InternalDatasetsDatasetIdConfigTxsTxIdInisListInisError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdInisListInisResponse =
  string[];

export type InternalDatasetsDatasetIdConfigTxsTxIdInisListInisVariables = {
  pathParams: InternalDatasetsDatasetIdConfigTxsTxIdInisListInisPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdInisListInis = (
  variables: InternalDatasetsDatasetIdConfigTxsTxIdInisListInisVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    InternalDatasetsDatasetIdConfigTxsTxIdInisListInisResponse,
    InternalDatasetsDatasetIdConfigTxsTxIdInisListInisError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdConfigTxsTxIdInisListInisPathParams
  >({
    url: "/internal/datasets/{datasetId}/config_txs/{txId}/inis",
    method: "get",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdConfigTxsTxIdInisListInis = <
  TData = InternalDatasetsDatasetIdConfigTxsTxIdInisListInisResponse
>(
  variables: InternalDatasetsDatasetIdConfigTxsTxIdInisListInisVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      InternalDatasetsDatasetIdConfigTxsTxIdInisListInisResponse,
      InternalDatasetsDatasetIdConfigTxsTxIdInisListInisError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    InternalDatasetsDatasetIdConfigTxsTxIdInisListInisResponse,
    InternalDatasetsDatasetIdConfigTxsTxIdInisListInisError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/inis",
      operationId: "internalDatasetsDatasetIdConfigTxsTxIdInisListInis",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsDatasetIdConfigTxsTxIdInisListInis(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdConfigTxsTxIdInisNameDeleteIniPathParams =
  {
    txId: string;
    datasetId: string;
    name: string;
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdInisNameDeleteIniError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdInisNameDeleteIniVariables = {
  pathParams: InternalDatasetsDatasetIdConfigTxsTxIdInisNameDeleteIniPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdInisNameDeleteIni = (
  variables: InternalDatasetsDatasetIdConfigTxsTxIdInisNameDeleteIniVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdConfigTxsTxIdInisNameDeleteIniError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdConfigTxsTxIdInisNameDeleteIniPathParams
  >({
    url: "/internal/datasets/{datasetId}/config_txs/{txId}/inis/{name}",
    method: "delete",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdConfigTxsTxIdInisNameDeleteIni = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdInisNameDeleteIniError,
      InternalDatasetsDatasetIdConfigTxsTxIdInisNameDeleteIniVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalDatasetsDatasetIdConfigTxsTxIdInisNameDeleteIniError,
    InternalDatasetsDatasetIdConfigTxsTxIdInisNameDeleteIniVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdConfigTxsTxIdInisNameDeleteIniVariables
    ) =>
      fetchInternalDatasetsDatasetIdConfigTxsTxIdInisNameDeleteIni({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdConfigTxsTxIdInisNameReadIniPathParams = {
  txId: string;
  datasetId: string;
  name: string;
};

export type InternalDatasetsDatasetIdConfigTxsTxIdInisNameReadIniError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdInisNameReadIniVariables = {
  pathParams: InternalDatasetsDatasetIdConfigTxsTxIdInisNameReadIniPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdInisNameReadIni = (
  variables: InternalDatasetsDatasetIdConfigTxsTxIdInisNameReadIniVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdConfigTxsTxIdInisNameReadIniError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdConfigTxsTxIdInisNameReadIniPathParams
  >({
    url: "/internal/datasets/{datasetId}/config_txs/{txId}/inis/{name}",
    method: "get",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdConfigTxsTxIdInisNameReadIni = <
  TData = undefined
>(
  variables: InternalDatasetsDatasetIdConfigTxsTxIdInisNameReadIniVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdInisNameReadIniError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    undefined,
    InternalDatasetsDatasetIdConfigTxsTxIdInisNameReadIniError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/inis/{name}",
      operationId: "internalDatasetsDatasetIdConfigTxsTxIdInisNameReadIni",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsDatasetIdConfigTxsTxIdInisNameReadIni(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdConfigTxsTxIdInisNameCreateIniPathParams =
  {
    txId: string;
    datasetId: string;
    name: string;
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdInisNameCreateIniError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdInisNameCreateIniVariables = {
  body: Schemas.FileUploadFormData;
  pathParams: InternalDatasetsDatasetIdConfigTxsTxIdInisNameCreateIniPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdInisNameCreateIni = (
  variables: InternalDatasetsDatasetIdConfigTxsTxIdInisNameCreateIniVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdConfigTxsTxIdInisNameCreateIniError,
    Schemas.FileUploadFormData,
    {},
    {},
    InternalDatasetsDatasetIdConfigTxsTxIdInisNameCreateIniPathParams
  >({
    url: "/internal/datasets/{datasetId}/config_txs/{txId}/inis/{name}",
    method: "post",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdConfigTxsTxIdInisNameCreateIni = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdInisNameCreateIniError,
      InternalDatasetsDatasetIdConfigTxsTxIdInisNameCreateIniVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalDatasetsDatasetIdConfigTxsTxIdInisNameCreateIniError,
    InternalDatasetsDatasetIdConfigTxsTxIdInisNameCreateIniVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdConfigTxsTxIdInisNameCreateIniVariables
    ) =>
      fetchInternalDatasetsDatasetIdConfigTxsTxIdInisNameCreateIni({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdConfigTxsTxIdInisNameUpdateIniPathParams =
  {
    txId: string;
    datasetId: string;
    name: string;
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdInisNameUpdateIniError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdInisNameUpdateIniVariables = {
  body: Schemas.FileUploadFormData;
  pathParams: InternalDatasetsDatasetIdConfigTxsTxIdInisNameUpdateIniPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdInisNameUpdateIni = (
  variables: InternalDatasetsDatasetIdConfigTxsTxIdInisNameUpdateIniVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdConfigTxsTxIdInisNameUpdateIniError,
    Schemas.FileUploadFormData,
    {},
    {},
    InternalDatasetsDatasetIdConfigTxsTxIdInisNameUpdateIniPathParams
  >({
    url: "/internal/datasets/{datasetId}/config_txs/{txId}/inis/{name}",
    method: "put",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdConfigTxsTxIdInisNameUpdateIni = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdInisNameUpdateIniError,
      InternalDatasetsDatasetIdConfigTxsTxIdInisNameUpdateIniVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalDatasetsDatasetIdConfigTxsTxIdInisNameUpdateIniError,
    InternalDatasetsDatasetIdConfigTxsTxIdInisNameUpdateIniVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdConfigTxsTxIdInisNameUpdateIniVariables
    ) =>
      fetchInternalDatasetsDatasetIdConfigTxsTxIdInisNameUpdateIni({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnvPathParams = {
  txId: string;
  datasetId: string;
};

export type InternalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnvError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnvVariables = {
  pathParams: InternalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnvPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnv = (
  variables: InternalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnvVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.JobEnvConfig,
    InternalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnvError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnvPathParams
  >({
    url: "/internal/datasets/{datasetId}/config_txs/{txId}/job_env",
    method: "get",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnv = <
  TData = Schemas.JobEnvConfig
>(
  variables: InternalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnvVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.JobEnvConfig,
      InternalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnvError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.JobEnvConfig,
    InternalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnvError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/job_env",
      operationId: "internalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnv",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnv(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnvPathParams = {
  txId: string;
  datasetId: string;
};

export type InternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnvError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnvVariables = {
  body: Schemas.JobEnvConfig;
  pathParams: InternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnvPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnv = (
  variables: InternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnvVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnvError,
    Schemas.JobEnvConfig,
    {},
    {},
    InternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnvPathParams
  >({
    url: "/internal/datasets/{datasetId}/config_txs/{txId}/job_env",
    method: "put",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnv = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnvError,
      InternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnvVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnvError,
    InternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnvVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnvVariables
    ) =>
      fetchInternalDatasetsDatasetIdConfigTxsTxIdJobEnvSetJobEnv({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdConfigTxsTxIdMetaGetMetaPathParams = {
  txId: string;
  datasetId: string;
};

export type InternalDatasetsDatasetIdConfigTxsTxIdMetaGetMetaError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdMetaGetMetaVariables = {
  pathParams: InternalDatasetsDatasetIdConfigTxsTxIdMetaGetMetaPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdMetaGetMeta = (
  variables: InternalDatasetsDatasetIdConfigTxsTxIdMetaGetMetaVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.MetaConfig,
    InternalDatasetsDatasetIdConfigTxsTxIdMetaGetMetaError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdConfigTxsTxIdMetaGetMetaPathParams
  >({
    url: "/internal/datasets/{datasetId}/config_txs/{txId}/meta",
    method: "get",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdConfigTxsTxIdMetaGetMeta = <
  TData = Schemas.MetaConfig
>(
  variables: InternalDatasetsDatasetIdConfigTxsTxIdMetaGetMetaVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.MetaConfig,
      InternalDatasetsDatasetIdConfigTxsTxIdMetaGetMetaError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.MetaConfig,
    InternalDatasetsDatasetIdConfigTxsTxIdMetaGetMetaError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/meta",
      operationId: "internalDatasetsDatasetIdConfigTxsTxIdMetaGetMeta",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsDatasetIdConfigTxsTxIdMetaGetMeta(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdConfigTxsTxIdMetaSetMetaPathParams = {
  txId: string;
  datasetId: string;
};

export type InternalDatasetsDatasetIdConfigTxsTxIdMetaSetMetaError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdMetaSetMetaVariables = {
  body: Schemas.MetaConfig;
  pathParams: InternalDatasetsDatasetIdConfigTxsTxIdMetaSetMetaPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdMetaSetMeta = (
  variables: InternalDatasetsDatasetIdConfigTxsTxIdMetaSetMetaVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdConfigTxsTxIdMetaSetMetaError,
    Schemas.MetaConfig,
    {},
    {},
    InternalDatasetsDatasetIdConfigTxsTxIdMetaSetMetaPathParams
  >({
    url: "/internal/datasets/{datasetId}/config_txs/{txId}/meta",
    method: "put",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdConfigTxsTxIdMetaSetMeta = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdMetaSetMetaError,
      InternalDatasetsDatasetIdConfigTxsTxIdMetaSetMetaVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalDatasetsDatasetIdConfigTxsTxIdMetaSetMetaError,
    InternalDatasetsDatasetIdConfigTxsTxIdMetaSetMetaVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdConfigTxsTxIdMetaSetMetaVariables
    ) =>
      fetchInternalDatasetsDatasetIdConfigTxsTxIdMetaSetMeta({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdConfigTxsTxIdRestoreFromOtherTxIdRestoreConfigPathParams =
  {
    datasetId: string;
    txId: string;
    otherTxId: string;
  };

export type InternalDatasetsDatasetIdConfigTxsTxIdRestoreFromOtherTxIdRestoreConfigError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdConfigTxsTxIdRestoreFromOtherTxIdRestoreConfigVariables =
  {
    pathParams: InternalDatasetsDatasetIdConfigTxsTxIdRestoreFromOtherTxIdRestoreConfigPathParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdConfigTxsTxIdRestoreFromOtherTxIdRestoreConfig =
  (
    variables: InternalDatasetsDatasetIdConfigTxsTxIdRestoreFromOtherTxIdRestoreConfigVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdRestoreFromOtherTxIdRestoreConfigError,
      undefined,
      {},
      {},
      InternalDatasetsDatasetIdConfigTxsTxIdRestoreFromOtherTxIdRestoreConfigPathParams
    >({
      url: "/internal/datasets/{datasetId}/config_txs/{txId}/restore_from/{otherTxId}",
      method: "post",
      ...variables,
      signal,
    });

export const useInternalDatasetsDatasetIdConfigTxsTxIdRestoreFromOtherTxIdRestoreConfig =
  (
    options?: Omit<
      reactQuery.UseMutationOptions<
        undefined,
        InternalDatasetsDatasetIdConfigTxsTxIdRestoreFromOtherTxIdRestoreConfigError,
        InternalDatasetsDatasetIdConfigTxsTxIdRestoreFromOtherTxIdRestoreConfigVariables
      >,
      "mutationFn"
    >
  ) => {
    const { fetcherOptions } = useBackendContext();
    return reactQuery.useMutation<
      undefined,
      InternalDatasetsDatasetIdConfigTxsTxIdRestoreFromOtherTxIdRestoreConfigError,
      InternalDatasetsDatasetIdConfigTxsTxIdRestoreFromOtherTxIdRestoreConfigVariables
    >({
      mutationFn: (
        variables: InternalDatasetsDatasetIdConfigTxsTxIdRestoreFromOtherTxIdRestoreConfigVariables
      ) =>
        fetchInternalDatasetsDatasetIdConfigTxsTxIdRestoreFromOtherTxIdRestoreConfig(
          { ...fetcherOptions, ...variables }
        ),
      ...options,
    });
  };

export type InternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshotPathParams =
  {
    datasetId: string;
  };

export type InternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshotQueryParams =
  {
    tx_id: string;
  };

export type InternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshotError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshotVariables =
  {
    pathParams: InternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshotPathParams;
    queryParams: InternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshotQueryParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshot =
  (
    variables: InternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshotVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      null | Schemas.FsSnapshotCache,
      InternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshotError,
      undefined,
      {},
      InternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshotQueryParams,
      InternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshotPathParams
    >({
      url: "/internal/datasets/{datasetId}/fs_snapshot/cached",
      method: "get",
      ...variables,
      signal,
    });

export const useInternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshot = <
  TData = null | Schemas.FsSnapshotCache
>(
  variables: InternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshotVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      null | Schemas.FsSnapshotCache,
      InternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshotError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    null | Schemas.FsSnapshotCache,
    InternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshotError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/{dataset_id}/fs_snapshot/cached",
      operationId:
        "internalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshot",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshot(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshotPathParams = {
  datasetId: string;
};

export type InternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshotQueryParams = {
  tx_id: string;
};

export type InternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshotError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshotVariables = {
  body: Schemas.FsSnapshotJobParams;
  pathParams: InternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshotPathParams;
  queryParams: InternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshotQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshot = (
  variables: InternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshotVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshotError,
    Schemas.FsSnapshotJobParams,
    {},
    InternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshotQueryParams,
    InternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshotPathParams
  >({
    url: "/internal/datasets/{datasetId}/fs_snapshot/take",
    method: "post",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshot = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshotError,
      InternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshotVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshotError,
    InternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshotVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshotVariables
    ) =>
      fetchInternalDatasetsDatasetIdFsSnapshotTakeTakeFsSnapshot({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdInputDirMkInputDirPathParams = {
  datasetId: string;
};

export type InternalDatasetsDatasetIdInputDirMkInputDirQueryParams = {
  path: string;
};

export type InternalDatasetsDatasetIdInputDirMkInputDirError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdInputDirMkInputDirVariables = {
  pathParams: InternalDatasetsDatasetIdInputDirMkInputDirPathParams;
  queryParams: InternalDatasetsDatasetIdInputDirMkInputDirQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdInputDirMkInputDir = (
  variables: InternalDatasetsDatasetIdInputDirMkInputDirVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdInputDirMkInputDirError,
    undefined,
    {},
    InternalDatasetsDatasetIdInputDirMkInputDirQueryParams,
    InternalDatasetsDatasetIdInputDirMkInputDirPathParams
  >({
    url: "/internal/datasets/{datasetId}/input/dir",
    method: "post",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdInputDirMkInputDir = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalDatasetsDatasetIdInputDirMkInputDirError,
      InternalDatasetsDatasetIdInputDirMkInputDirVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalDatasetsDatasetIdInputDirMkInputDirError,
    InternalDatasetsDatasetIdInputDirMkInputDirVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdInputDirMkInputDirVariables
    ) =>
      fetchInternalDatasetsDatasetIdInputDirMkInputDir({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdInputFilesRmInputFilePathParams = {
  datasetId: string;
};

export type InternalDatasetsDatasetIdInputFilesRmInputFileQueryParams = {
  path: string;
};

export type InternalDatasetsDatasetIdInputFilesRmInputFileError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdInputFilesRmInputFileVariables = {
  pathParams: InternalDatasetsDatasetIdInputFilesRmInputFilePathParams;
  queryParams: InternalDatasetsDatasetIdInputFilesRmInputFileQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdInputFilesRmInputFile = (
  variables: InternalDatasetsDatasetIdInputFilesRmInputFileVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdInputFilesRmInputFileError,
    undefined,
    {},
    InternalDatasetsDatasetIdInputFilesRmInputFileQueryParams,
    InternalDatasetsDatasetIdInputFilesRmInputFilePathParams
  >({
    url: "/internal/datasets/{datasetId}/input/files",
    method: "delete",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdInputFilesRmInputFile = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalDatasetsDatasetIdInputFilesRmInputFileError,
      InternalDatasetsDatasetIdInputFilesRmInputFileVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalDatasetsDatasetIdInputFilesRmInputFileError,
    InternalDatasetsDatasetIdInputFilesRmInputFileVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdInputFilesRmInputFileVariables
    ) =>
      fetchInternalDatasetsDatasetIdInputFilesRmInputFile({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdInputFilesGetInputFilePathParams = {
  datasetId: string;
};

export type InternalDatasetsDatasetIdInputFilesGetInputFileQueryParams = {
  path: string;
};

export type InternalDatasetsDatasetIdInputFilesGetInputFileError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdInputFilesGetInputFileVariables = {
  pathParams: InternalDatasetsDatasetIdInputFilesGetInputFilePathParams;
  queryParams: InternalDatasetsDatasetIdInputFilesGetInputFileQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdInputFilesGetInputFile = (
  variables: InternalDatasetsDatasetIdInputFilesGetInputFileVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdInputFilesGetInputFileError,
    undefined,
    {},
    InternalDatasetsDatasetIdInputFilesGetInputFileQueryParams,
    InternalDatasetsDatasetIdInputFilesGetInputFilePathParams
  >({
    url: "/internal/datasets/{datasetId}/input/files",
    method: "get",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdInputFilesGetInputFile = <
  TData = undefined
>(
  variables: InternalDatasetsDatasetIdInputFilesGetInputFileVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      undefined,
      InternalDatasetsDatasetIdInputFilesGetInputFileError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    undefined,
    InternalDatasetsDatasetIdInputFilesGetInputFileError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/{dataset_id}/input/files",
      operationId: "internalDatasetsDatasetIdInputFilesGetInputFile",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsDatasetIdInputFilesGetInputFile(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdInputFilesPutInputFilePathParams = {
  datasetId: string;
};

export type InternalDatasetsDatasetIdInputFilesPutInputFileQueryParams = {
  path: string;
};

export type InternalDatasetsDatasetIdInputFilesPutInputFileError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdInputFilesPutInputFileVariables = {
  body: Schemas.FileUploadFormData;
  pathParams: InternalDatasetsDatasetIdInputFilesPutInputFilePathParams;
  queryParams: InternalDatasetsDatasetIdInputFilesPutInputFileQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdInputFilesPutInputFile = (
  variables: InternalDatasetsDatasetIdInputFilesPutInputFileVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdInputFilesPutInputFileError,
    Schemas.FileUploadFormData,
    {},
    InternalDatasetsDatasetIdInputFilesPutInputFileQueryParams,
    InternalDatasetsDatasetIdInputFilesPutInputFilePathParams
  >({
    url: "/internal/datasets/{datasetId}/input/files",
    method: "put",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdInputFilesPutInputFile = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalDatasetsDatasetIdInputFilesPutInputFileError,
      InternalDatasetsDatasetIdInputFilesPutInputFileVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalDatasetsDatasetIdInputFilesPutInputFileError,
    InternalDatasetsDatasetIdInputFilesPutInputFileVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdInputFilesPutInputFileVariables
    ) =>
      fetchInternalDatasetsDatasetIdInputFilesPutInputFile({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdInputFilesRenameRenameInputFilePathParams =
  {
    datasetId: string;
  };

export type InternalDatasetsDatasetIdInputFilesRenameRenameInputFileQueryParams =
  {
    path: string;
    new_name: string;
  };

export type InternalDatasetsDatasetIdInputFilesRenameRenameInputFileError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdInputFilesRenameRenameInputFileVariables =
  {
    pathParams: InternalDatasetsDatasetIdInputFilesRenameRenameInputFilePathParams;
    queryParams: InternalDatasetsDatasetIdInputFilesRenameRenameInputFileQueryParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdInputFilesRenameRenameInputFile = (
  variables: InternalDatasetsDatasetIdInputFilesRenameRenameInputFileVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdInputFilesRenameRenameInputFileError,
    undefined,
    {},
    InternalDatasetsDatasetIdInputFilesRenameRenameInputFileQueryParams,
    InternalDatasetsDatasetIdInputFilesRenameRenameInputFilePathParams
  >({
    url: "/internal/datasets/{datasetId}/input/files/rename",
    method: "post",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdInputFilesRenameRenameInputFile = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalDatasetsDatasetIdInputFilesRenameRenameInputFileError,
      InternalDatasetsDatasetIdInputFilesRenameRenameInputFileVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalDatasetsDatasetIdInputFilesRenameRenameInputFileError,
    InternalDatasetsDatasetIdInputFilesRenameRenameInputFileVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdInputFilesRenameRenameInputFileVariables
    ) =>
      fetchInternalDatasetsDatasetIdInputFilesRenameRenameInputFile({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdInputListListInputFilesPathParams = {
  datasetId: string;
};

export type InternalDatasetsDatasetIdInputListListInputFilesQueryParams = {
  /**
   * @default /
   */
  path?: null | string;
};

export type InternalDatasetsDatasetIdInputListListInputFilesError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdInputListListInputFilesResponse =
  Schemas.DatasetsHeadingDtosFsEntry[];

export type InternalDatasetsDatasetIdInputListListInputFilesVariables = {
  pathParams: InternalDatasetsDatasetIdInputListListInputFilesPathParams;
  queryParams?: InternalDatasetsDatasetIdInputListListInputFilesQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdInputListListInputFiles = (
  variables: InternalDatasetsDatasetIdInputListListInputFilesVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    InternalDatasetsDatasetIdInputListListInputFilesResponse,
    InternalDatasetsDatasetIdInputListListInputFilesError,
    undefined,
    {},
    InternalDatasetsDatasetIdInputListListInputFilesQueryParams,
    InternalDatasetsDatasetIdInputListListInputFilesPathParams
  >({
    url: "/internal/datasets/{datasetId}/input/list",
    method: "get",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdInputListListInputFiles = <
  TData = InternalDatasetsDatasetIdInputListListInputFilesResponse
>(
  variables: InternalDatasetsDatasetIdInputListListInputFilesVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      InternalDatasetsDatasetIdInputListListInputFilesResponse,
      InternalDatasetsDatasetIdInputListListInputFilesError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    InternalDatasetsDatasetIdInputListListInputFilesResponse,
    InternalDatasetsDatasetIdInputListListInputFilesError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/{dataset_id}/input/list",
      operationId: "internalDatasetsDatasetIdInputListListInputFiles",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsDatasetIdInputListListInputFiles(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFilesPathParams =
  {
    datasetId: string;
  };

export type InternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFilesQueryParams =
  {
    tx_id: string;
    job_id: string;
    ini_name: string;
  };

export type InternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFilesError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFilesVariables =
  {
    pathParams: InternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFilesPathParams;
    queryParams: InternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFilesQueryParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFiles =
  (
    variables: InternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFilesVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      undefined,
      InternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFilesError,
      undefined,
      {},
      InternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFilesQueryParams,
      InternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFilesPathParams
    >({
      url: "/internal/datasets/{datasetId}/load_guest_job_files",
      method: "post",
      ...variables,
      signal,
    });

export const useInternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFiles = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFilesError,
      InternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFilesVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFilesError,
    InternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFilesVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFilesVariables
    ) =>
      fetchInternalDatasetsDatasetIdLoadGuestJobFilesLoadGuestJobFiles({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalDatasetsDatasetIdReleasedRunsListRunsPathParams = {
  datasetId: string;
};

export type InternalDatasetsDatasetIdReleasedRunsListRunsError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdReleasedRunsListRunsResponse =
  Schemas.DsRunDto[];

export type InternalDatasetsDatasetIdReleasedRunsListRunsVariables = {
  pathParams: InternalDatasetsDatasetIdReleasedRunsListRunsPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdReleasedRunsListRuns = (
  variables: InternalDatasetsDatasetIdReleasedRunsListRunsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    InternalDatasetsDatasetIdReleasedRunsListRunsResponse,
    InternalDatasetsDatasetIdReleasedRunsListRunsError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdReleasedRunsListRunsPathParams
  >({
    url: "/internal/datasets/{datasetId}/released_runs",
    method: "get",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdReleasedRunsListRuns = <
  TData = InternalDatasetsDatasetIdReleasedRunsListRunsResponse
>(
  variables: InternalDatasetsDatasetIdReleasedRunsListRunsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      InternalDatasetsDatasetIdReleasedRunsListRunsResponse,
      InternalDatasetsDatasetIdReleasedRunsListRunsError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    InternalDatasetsDatasetIdReleasedRunsListRunsResponse,
    InternalDatasetsDatasetIdReleasedRunsListRunsError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/{dataset_id}/released_runs",
      operationId: "internalDatasetsDatasetIdReleasedRunsListRuns",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsDatasetIdReleasedRunsListRuns(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdRevisionsGetRevisionsPathParams = {
  datasetId: string;
};

export type InternalDatasetsDatasetIdRevisionsGetRevisionsError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdRevisionsGetRevisionsResponse =
  Schemas.DatasetRevisionsListEntry[];

export type InternalDatasetsDatasetIdRevisionsGetRevisionsVariables = {
  pathParams: InternalDatasetsDatasetIdRevisionsGetRevisionsPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdRevisionsGetRevisions = (
  variables: InternalDatasetsDatasetIdRevisionsGetRevisionsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    InternalDatasetsDatasetIdRevisionsGetRevisionsResponse,
    InternalDatasetsDatasetIdRevisionsGetRevisionsError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdRevisionsGetRevisionsPathParams
  >({
    url: "/internal/datasets/{datasetId}/revisions",
    method: "get",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdRevisionsGetRevisions = <
  TData = InternalDatasetsDatasetIdRevisionsGetRevisionsResponse
>(
  variables: InternalDatasetsDatasetIdRevisionsGetRevisionsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      InternalDatasetsDatasetIdRevisionsGetRevisionsResponse,
      InternalDatasetsDatasetIdRevisionsGetRevisionsError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    InternalDatasetsDatasetIdRevisionsGetRevisionsResponse,
    InternalDatasetsDatasetIdRevisionsGetRevisionsError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/{dataset_id}/revisions",
      operationId: "internalDatasetsDatasetIdRevisionsGetRevisions",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsDatasetIdRevisionsGetRevisions(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdRevisionsTxIdMessageGetRevisionPathParams =
  {
    datasetId: string;
    txId: string;
  };

export type InternalDatasetsDatasetIdRevisionsTxIdMessageGetRevisionError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdRevisionsTxIdMessageGetRevisionVariables =
  {
    pathParams: InternalDatasetsDatasetIdRevisionsTxIdMessageGetRevisionPathParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdRevisionsTxIdMessageGetRevision = (
  variables: InternalDatasetsDatasetIdRevisionsTxIdMessageGetRevisionVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.DatasetRevisionsListEntry,
    InternalDatasetsDatasetIdRevisionsTxIdMessageGetRevisionError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdRevisionsTxIdMessageGetRevisionPathParams
  >({
    url: "/internal/datasets/{datasetId}/revisions/{txId}/message",
    method: "get",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdRevisionsTxIdMessageGetRevision = <
  TData = Schemas.DatasetRevisionsListEntry
>(
  variables: InternalDatasetsDatasetIdRevisionsTxIdMessageGetRevisionVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.DatasetRevisionsListEntry,
      InternalDatasetsDatasetIdRevisionsTxIdMessageGetRevisionError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.DatasetRevisionsListEntry,
    InternalDatasetsDatasetIdRevisionsTxIdMessageGetRevisionError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/datasets/{dataset_id}/revisions/{tx_id}/message",
      operationId: "internalDatasetsDatasetIdRevisionsTxIdMessageGetRevision",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalDatasetsDatasetIdRevisionsTxIdMessageGetRevision(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalDatasetsDatasetIdRevisionsTxIdMessagePutRevisionMessagePathParams =
  {
    datasetId: string;
    txId: string;
  };

export type InternalDatasetsDatasetIdRevisionsTxIdMessagePutRevisionMessageError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdRevisionsTxIdMessagePutRevisionMessageVariables =
  {
    body: Schemas.DatasetRevisionMsg;
    pathParams: InternalDatasetsDatasetIdRevisionsTxIdMessagePutRevisionMessagePathParams;
  } & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdRevisionsTxIdMessagePutRevisionMessage =
  (
    variables: InternalDatasetsDatasetIdRevisionsTxIdMessagePutRevisionMessageVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      undefined,
      InternalDatasetsDatasetIdRevisionsTxIdMessagePutRevisionMessageError,
      Schemas.DatasetRevisionMsg,
      {},
      {},
      InternalDatasetsDatasetIdRevisionsTxIdMessagePutRevisionMessagePathParams
    >({
      url: "/internal/datasets/{datasetId}/revisions/{txId}/message",
      method: "put",
      ...variables,
      signal,
    });

export const useInternalDatasetsDatasetIdRevisionsTxIdMessagePutRevisionMessage =
  (
    options?: Omit<
      reactQuery.UseMutationOptions<
        undefined,
        InternalDatasetsDatasetIdRevisionsTxIdMessagePutRevisionMessageError,
        InternalDatasetsDatasetIdRevisionsTxIdMessagePutRevisionMessageVariables
      >,
      "mutationFn"
    >
  ) => {
    const { fetcherOptions } = useBackendContext();
    return reactQuery.useMutation<
      undefined,
      InternalDatasetsDatasetIdRevisionsTxIdMessagePutRevisionMessageError,
      InternalDatasetsDatasetIdRevisionsTxIdMessagePutRevisionMessageVariables
    >({
      mutationFn: (
        variables: InternalDatasetsDatasetIdRevisionsTxIdMessagePutRevisionMessageVariables
      ) =>
        fetchInternalDatasetsDatasetIdRevisionsTxIdMessagePutRevisionMessage({
          ...fetcherOptions,
          ...variables,
        }),
      ...options,
    });
  };

export type InternalDatasetsDatasetIdRunsJobIdReleaseReleaseRunPathParams = {
  datasetId: string;
  jobId: string;
};

export type InternalDatasetsDatasetIdRunsJobIdReleaseReleaseRunError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type InternalDatasetsDatasetIdRunsJobIdReleaseReleaseRunVariables = {
  pathParams: InternalDatasetsDatasetIdRunsJobIdReleaseReleaseRunPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalDatasetsDatasetIdRunsJobIdReleaseReleaseRun = (
  variables: InternalDatasetsDatasetIdRunsJobIdReleaseReleaseRunVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalDatasetsDatasetIdRunsJobIdReleaseReleaseRunError,
    undefined,
    {},
    {},
    InternalDatasetsDatasetIdRunsJobIdReleaseReleaseRunPathParams
  >({
    url: "/internal/datasets/{datasetId}/runs/{jobId}/release",
    method: "post",
    ...variables,
    signal,
  });

export const useInternalDatasetsDatasetIdRunsJobIdReleaseReleaseRun = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalDatasetsDatasetIdRunsJobIdReleaseReleaseRunError,
      InternalDatasetsDatasetIdRunsJobIdReleaseReleaseRunVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalDatasetsDatasetIdRunsJobIdReleaseReleaseRunError,
    InternalDatasetsDatasetIdRunsJobIdReleaseReleaseRunVariables
  >({
    mutationFn: (
      variables: InternalDatasetsDatasetIdRunsJobIdReleaseReleaseRunVariables
    ) =>
      fetchInternalDatasetsDatasetIdRunsJobIdReleaseReleaseRun({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalEventsListEventsQueryParams = {
  /**
   * @default 1000
   */
  limit?: number;
  /**
   * @default 0
   */
  offset?: number;
  event_type?: null | string;
  fingerprint?: null | string;
};

export type InternalEventsListEventsError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type InternalEventsListEventsResponse = {
  items?: Schemas.EventDTO[];
  /**
   * Maximal number of items to send.
   */
  limit?: number;
  /**
   * Offset from the beginning of the query.
   */
  offset?: number;
  /**
   * Total number of items.
   */
  total?: number;
};

export type InternalEventsListEventsVariables = {
  queryParams?: InternalEventsListEventsQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalEventsListEvents = (
  variables: InternalEventsListEventsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    InternalEventsListEventsResponse,
    InternalEventsListEventsError,
    undefined,
    {},
    InternalEventsListEventsQueryParams,
    {}
  >({ url: "/internal/events", method: "get", ...variables, signal });

export const useInternalEventsListEvents = <
  TData = InternalEventsListEventsResponse
>(
  variables: InternalEventsListEventsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      InternalEventsListEventsResponse,
      InternalEventsListEventsError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    InternalEventsListEventsResponse,
    InternalEventsListEventsError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/events",
      operationId: "internalEventsListEvents",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalEventsListEvents(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalEventsEventIdGetEventByIdPathParams = {
  eventId: string;
};

export type InternalEventsEventIdGetEventByIdError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type InternalEventsEventIdGetEventByIdVariables = {
  pathParams: InternalEventsEventIdGetEventByIdPathParams;
} & BackendContext["fetcherOptions"];

export const fetchInternalEventsEventIdGetEventById = (
  variables: InternalEventsEventIdGetEventByIdVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.EventDTO,
    InternalEventsEventIdGetEventByIdError,
    undefined,
    {},
    {},
    InternalEventsEventIdGetEventByIdPathParams
  >({ url: "/internal/events/{eventId}", method: "get", ...variables, signal });

export const useInternalEventsEventIdGetEventById = <TData = Schemas.EventDTO>(
  variables: InternalEventsEventIdGetEventByIdVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.EventDTO,
      InternalEventsEventIdGetEventByIdError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.EventDTO,
    InternalEventsEventIdGetEventByIdError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/events/{event_id}",
      operationId: "internalEventsEventIdGetEventById",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalEventsEventIdGetEventById(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type InternalRequestDataOwnerPrivilegeRequestDataOwnerPrivilegeError =
  Fetcher.ErrorWrapper<undefined>;

export type InternalRequestDataOwnerPrivilegeRequestDataOwnerPrivilegeVariables =
  BackendContext["fetcherOptions"];

export const fetchInternalRequestDataOwnerPrivilegeRequestDataOwnerPrivilege = (
  variables: InternalRequestDataOwnerPrivilegeRequestDataOwnerPrivilegeVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    InternalRequestDataOwnerPrivilegeRequestDataOwnerPrivilegeError,
    undefined,
    {},
    {},
    {}
  >({
    url: "/internal/request_data_owner_privilege",
    method: "post",
    ...variables,
    signal,
  });

export const useInternalRequestDataOwnerPrivilegeRequestDataOwnerPrivilege = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      InternalRequestDataOwnerPrivilegeRequestDataOwnerPrivilegeError,
      InternalRequestDataOwnerPrivilegeRequestDataOwnerPrivilegeVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    InternalRequestDataOwnerPrivilegeRequestDataOwnerPrivilegeError,
    InternalRequestDataOwnerPrivilegeRequestDataOwnerPrivilegeVariables
  >({
    mutationFn: (
      variables: InternalRequestDataOwnerPrivilegeRequestDataOwnerPrivilegeVariables
    ) =>
      fetchInternalRequestDataOwnerPrivilegeRequestDataOwnerPrivilege({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type InternalSystemEnvReadSystemEnvError =
  Fetcher.ErrorWrapper<undefined>;

export type InternalSystemEnvReadSystemEnvVariables =
  BackendContext["fetcherOptions"];

export const fetchInternalSystemEnvReadSystemEnv = (
  variables: InternalSystemEnvReadSystemEnvVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    null | Schemas.JobEnvConfig,
    InternalSystemEnvReadSystemEnvError,
    undefined,
    {},
    {},
    {}
  >({ url: "/internal/system_env", method: "get", ...variables, signal });

export const useInternalSystemEnvReadSystemEnv = <
  TData = null | Schemas.JobEnvConfig
>(
  variables: InternalSystemEnvReadSystemEnvVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      null | Schemas.JobEnvConfig,
      InternalSystemEnvReadSystemEnvError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    null | Schemas.JobEnvConfig,
    InternalSystemEnvReadSystemEnvError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/internal/system_env",
      operationId: "internalSystemEnvReadSystemEnv",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchInternalSystemEnvReadSystemEnv(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicDatasetsListDatasetsQueryParams = {
  /**
   * @default 1000
   */
  limit?: number;
  /**
   * @default 0
   */
  offset?: number;
};

export type PublicDatasetsListDatasetsError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type PublicDatasetsListDatasetsResponse = {
  items?: Schemas.DatasetListEntry[];
  /**
   * Maximal number of items to send.
   */
  limit?: number;
  /**
   * Offset from the beginning of the query.
   */
  offset?: number;
  /**
   * Total number of items.
   */
  total?: number;
};

export type PublicDatasetsListDatasetsVariables = {
  queryParams?: PublicDatasetsListDatasetsQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicDatasetsListDatasets = (
  variables: PublicDatasetsListDatasetsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    PublicDatasetsListDatasetsResponse,
    PublicDatasetsListDatasetsError,
    undefined,
    {},
    PublicDatasetsListDatasetsQueryParams,
    {}
  >({ url: "/public/datasets", method: "get", ...variables, signal });

export const usePublicDatasetsListDatasets = <
  TData = PublicDatasetsListDatasetsResponse
>(
  variables: PublicDatasetsListDatasetsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      PublicDatasetsListDatasetsResponse,
      PublicDatasetsListDatasetsError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    PublicDatasetsListDatasetsResponse,
    PublicDatasetsListDatasetsError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/datasets",
      operationId: "publicDatasetsListDatasets",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicDatasetsListDatasets(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicDatasetsNcmlSearchSearchDatasetsQueryParams = {
  bbox?: null | string;
  time_start?: null | string;
  time_end?: null | string;
  text_query?: null | string;
  /**
   * @default 1000
   */
  limit?: number;
  /**
   * @default 0
   */
  offset?: number;
};

export type PublicDatasetsNcmlSearchSearchDatasetsError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type PublicDatasetsNcmlSearchSearchDatasetsResponse = {
  items?: Schemas.NcMLSearchEntry[];
  /**
   * Maximal number of items to send.
   */
  limit?: number;
  /**
   * Offset from the beginning of the query.
   */
  offset?: number;
  /**
   * Total number of items.
   */
  total?: number;
};

export type PublicDatasetsNcmlSearchSearchDatasetsVariables = {
  queryParams?: PublicDatasetsNcmlSearchSearchDatasetsQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicDatasetsNcmlSearchSearchDatasets = (
  variables: PublicDatasetsNcmlSearchSearchDatasetsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    PublicDatasetsNcmlSearchSearchDatasetsResponse,
    PublicDatasetsNcmlSearchSearchDatasetsError,
    undefined,
    {},
    PublicDatasetsNcmlSearchSearchDatasetsQueryParams,
    {}
  >({
    url: "/public/datasets/ncml_search",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicDatasetsNcmlSearchSearchDatasets = <
  TData = PublicDatasetsNcmlSearchSearchDatasetsResponse
>(
  variables: PublicDatasetsNcmlSearchSearchDatasetsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      PublicDatasetsNcmlSearchSearchDatasetsResponse,
      PublicDatasetsNcmlSearchSearchDatasetsError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    PublicDatasetsNcmlSearchSearchDatasetsResponse,
    PublicDatasetsNcmlSearchSearchDatasetsError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/datasets/ncml_search",
      operationId: "publicDatasetsNcmlSearchSearchDatasets",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicDatasetsNcmlSearchSearchDatasets(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicDatasetsDatasetIdGetDatasetPathParams = {
  datasetId: string;
};

export type PublicDatasetsDatasetIdGetDatasetError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type PublicDatasetsDatasetIdGetDatasetVariables = {
  pathParams: PublicDatasetsDatasetIdGetDatasetPathParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicDatasetsDatasetIdGetDataset = (
  variables: PublicDatasetsDatasetIdGetDatasetVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.DatasetListEntry,
    PublicDatasetsDatasetIdGetDatasetError,
    undefined,
    {},
    {},
    PublicDatasetsDatasetIdGetDatasetPathParams
  >({
    url: "/public/datasets/{datasetId}",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicDatasetsDatasetIdGetDataset = <
  TData = Schemas.DatasetListEntry
>(
  variables: PublicDatasetsDatasetIdGetDatasetVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.DatasetListEntry,
      PublicDatasetsDatasetIdGetDatasetError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.DatasetListEntry,
    PublicDatasetsDatasetIdGetDatasetError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/datasets/{dataset_id}",
      operationId: "publicDatasetsDatasetIdGetDataset",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicDatasetsDatasetIdGetDataset(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerunPathParams =
  {
    datasetId: string;
  };

export type PublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerunQueryParams =
  {
    job_id: string;
    ini_name: string;
  };

export type PublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerunError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type PublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerunVariables =
  {
    pathParams: PublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerunPathParams;
    queryParams: PublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerunQueryParams;
  } & BackendContext["fetcherOptions"];

export const fetchPublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerun =
  (
    variables: PublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerunVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      undefined,
      PublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerunError,
      undefined,
      {},
      PublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerunQueryParams,
      PublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerunPathParams
    >({
      url: "/public/datasets/{datasetId}/load_guest_job_files_for_rerun",
      method: "post",
      ...variables,
      signal,
    });

export const usePublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerun =
  (
    options?: Omit<
      reactQuery.UseMutationOptions<
        undefined,
        PublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerunError,
        PublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerunVariables
      >,
      "mutationFn"
    >
  ) => {
    const { fetcherOptions } = useBackendContext();
    return reactQuery.useMutation<
      undefined,
      PublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerunError,
      PublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerunVariables
    >({
      mutationFn: (
        variables: PublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerunVariables
      ) =>
        fetchPublicDatasetsDatasetIdLoadGuestJobFilesForRerunLoadGuestJobFilesForRerun(
          { ...fetcherOptions, ...variables }
        ),
      ...options,
    });
  };

export type PublicDatasetsDatasetIdReleasedJobsGetReleasedJobsPathParams = {
  datasetId: string;
};

export type PublicDatasetsDatasetIdReleasedJobsGetReleasedJobsError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type PublicDatasetsDatasetIdReleasedJobsGetReleasedJobsResponse =
  Schemas.DsRunDto[];

export type PublicDatasetsDatasetIdReleasedJobsGetReleasedJobsVariables = {
  pathParams: PublicDatasetsDatasetIdReleasedJobsGetReleasedJobsPathParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicDatasetsDatasetIdReleasedJobsGetReleasedJobs = (
  variables: PublicDatasetsDatasetIdReleasedJobsGetReleasedJobsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    PublicDatasetsDatasetIdReleasedJobsGetReleasedJobsResponse,
    PublicDatasetsDatasetIdReleasedJobsGetReleasedJobsError,
    undefined,
    {},
    {},
    PublicDatasetsDatasetIdReleasedJobsGetReleasedJobsPathParams
  >({
    url: "/public/datasets/{datasetId}/released_jobs",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicDatasetsDatasetIdReleasedJobsGetReleasedJobs = <
  TData = PublicDatasetsDatasetIdReleasedJobsGetReleasedJobsResponse
>(
  variables: PublicDatasetsDatasetIdReleasedJobsGetReleasedJobsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      PublicDatasetsDatasetIdReleasedJobsGetReleasedJobsResponse,
      PublicDatasetsDatasetIdReleasedJobsGetReleasedJobsError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    PublicDatasetsDatasetIdReleasedJobsGetReleasedJobsResponse,
    PublicDatasetsDatasetIdReleasedJobsGetReleasedJobsError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/datasets/{dataset_id}/released_jobs",
      operationId: "publicDatasetsDatasetIdReleasedJobsGetReleasedJobs",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicDatasetsDatasetIdReleasedJobsGetReleasedJobs(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicJobSubmissionListMyJobsError =
  Fetcher.ErrorWrapper<undefined>;

export type PublicJobSubmissionListMyJobsResponse = Schemas.JobListEntryDTO[];

export type PublicJobSubmissionListMyJobsVariables =
  BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionListMyJobs = (
  variables: PublicJobSubmissionListMyJobsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    PublicJobSubmissionListMyJobsResponse,
    PublicJobSubmissionListMyJobsError,
    undefined,
    {},
    {},
    {}
  >({ url: "/public/job_submission", method: "get", ...variables, signal });

export const usePublicJobSubmissionListMyJobs = <
  TData = PublicJobSubmissionListMyJobsResponse
>(
  variables: PublicJobSubmissionListMyJobsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      PublicJobSubmissionListMyJobsResponse,
      PublicJobSubmissionListMyJobsError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    PublicJobSubmissionListMyJobsResponse,
    PublicJobSubmissionListMyJobsError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/job_submission",
      operationId: "publicJobSubmissionListMyJobs",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicJobSubmissionListMyJobs(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicJobSubmissionCreateError = Fetcher.ErrorWrapper<undefined>;

export type PublicJobSubmissionCreateVariables =
  BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionCreate = (
  variables: PublicJobSubmissionCreateVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.JobListEntryDTO,
    PublicJobSubmissionCreateError,
    undefined,
    {},
    {},
    {}
  >({ url: "/public/job_submission", method: "post", ...variables, signal });

export const usePublicJobSubmissionCreate = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      Schemas.JobListEntryDTO,
      PublicJobSubmissionCreateError,
      PublicJobSubmissionCreateVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    Schemas.JobListEntryDTO,
    PublicJobSubmissionCreateError,
    PublicJobSubmissionCreateVariables
  >({
    mutationFn: (variables: PublicJobSubmissionCreateVariables) =>
      fetchPublicJobSubmissionCreate({ ...fetcherOptions, ...variables }),
    ...options,
  });
};

export type PublicJobSubmissionJobIdAccessLevelGetJobAccessLevelPathParams = {
  jobId: string;
};

export type PublicJobSubmissionJobIdAccessLevelGetJobAccessLevelError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type PublicJobSubmissionJobIdAccessLevelGetJobAccessLevelVariables = {
  pathParams: PublicJobSubmissionJobIdAccessLevelGetJobAccessLevelPathParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionJobIdAccessLevelGetJobAccessLevel = (
  variables: PublicJobSubmissionJobIdAccessLevelGetJobAccessLevelVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.JobAccessLevelResponse,
    PublicJobSubmissionJobIdAccessLevelGetJobAccessLevelError,
    undefined,
    {},
    {},
    PublicJobSubmissionJobIdAccessLevelGetJobAccessLevelPathParams
  >({
    url: "/public/job_submission/{jobId}/access_level",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicJobSubmissionJobIdAccessLevelGetJobAccessLevel = <
  TData = Schemas.JobAccessLevelResponse
>(
  variables: PublicJobSubmissionJobIdAccessLevelGetJobAccessLevelVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.JobAccessLevelResponse,
      PublicJobSubmissionJobIdAccessLevelGetJobAccessLevelError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.JobAccessLevelResponse,
    PublicJobSubmissionJobIdAccessLevelGetJobAccessLevelError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/job_submission/{job_id}/access_level",
      operationId: "publicJobSubmissionJobIdAccessLevelGetJobAccessLevel",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicJobSubmissionJobIdAccessLevelGetJobAccessLevel(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicJobSubmissionJobIdDataQaAnalysisGetDataQaParsedPathParams = {
  jobId: string;
};

export type PublicJobSubmissionJobIdDataQaAnalysisGetDataQaParsedError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type PublicJobSubmissionJobIdDataQaAnalysisGetDataQaParsedVariables = {
  pathParams: PublicJobSubmissionJobIdDataQaAnalysisGetDataQaParsedPathParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionJobIdDataQaAnalysisGetDataQaParsed = (
  variables: PublicJobSubmissionJobIdDataQaAnalysisGetDataQaParsedVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.DataQAAnalysisView,
    PublicJobSubmissionJobIdDataQaAnalysisGetDataQaParsedError,
    undefined,
    {},
    {},
    PublicJobSubmissionJobIdDataQaAnalysisGetDataQaParsedPathParams
  >({
    url: "/public/job_submission/{jobId}/data_qa/analysis",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicJobSubmissionJobIdDataQaAnalysisGetDataQaParsed = <
  TData = Schemas.DataQAAnalysisView
>(
  variables: PublicJobSubmissionJobIdDataQaAnalysisGetDataQaParsedVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.DataQAAnalysisView,
      PublicJobSubmissionJobIdDataQaAnalysisGetDataQaParsedError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.DataQAAnalysisView,
    PublicJobSubmissionJobIdDataQaAnalysisGetDataQaParsedError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/job_submission/{job_id}/data_qa/analysis",
      operationId: "publicJobSubmissionJobIdDataQaAnalysisGetDataQaParsed",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicJobSubmissionJobIdDataQaAnalysisGetDataQaParsed(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimelinePathParams =
  {
    jobId: string;
  };

export type PublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimelineQueryParams =
  {
    filter_station?: null | string;
    filter_parameter?: null | string;
  };

export type PublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimelineError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type PublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimelineVariables =
  {
    pathParams: PublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimelinePathParams;
    queryParams?: PublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimelineQueryParams;
  } & BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimeline =
  (
    variables: PublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimelineVariables,
    signal?: AbortSignal
  ) =>
    backendFetch<
      Schemas.DataQATimeline,
      PublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimelineError,
      undefined,
      {},
      PublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimelineQueryParams,
      PublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimelinePathParams
    >({
      url: "/public/job_submission/{jobId}/data_qa/timeline",
      method: "get",
      ...variables,
      signal,
    });

export const usePublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimeline =
  <TData = Schemas.DataQATimeline>(
    variables: PublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimelineVariables,
    options?: Omit<
      reactQuery.UseQueryOptions<
        Schemas.DataQATimeline,
        PublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimelineError,
        TData
      >,
      "queryKey" | "queryFn"
    >
  ) => {
    const { fetcherOptions, queryOptions, queryKeyFn } =
      useBackendContext(options);
    return reactQuery.useQuery<
      Schemas.DataQATimeline,
      PublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimelineError,
      TData
    >({
      queryKey: queryKeyFn({
        path: "/public/job_submission/{job_id}/data_qa/timeline",
        operationId:
          "publicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimeline",
        variables,
      }),
      queryFn: ({ signal }) =>
        fetchPublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimeline(
          { ...fetcherOptions, ...variables },
          signal
        ),
      ...options,
      ...queryOptions,
    });
  };

export type PublicJobSubmissionJobIdFilesGetFilePathParams = {
  jobId: string;
};

export type PublicJobSubmissionJobIdFilesGetFileQueryParams = {
  path: string;
};

export type PublicJobSubmissionJobIdFilesGetFileError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type PublicJobSubmissionJobIdFilesGetFileVariables = {
  pathParams: PublicJobSubmissionJobIdFilesGetFilePathParams;
  queryParams: PublicJobSubmissionJobIdFilesGetFileQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionJobIdFilesGetFile = (
  variables: PublicJobSubmissionJobIdFilesGetFileVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    PublicJobSubmissionJobIdFilesGetFileError,
    undefined,
    {},
    PublicJobSubmissionJobIdFilesGetFileQueryParams,
    PublicJobSubmissionJobIdFilesGetFilePathParams
  >({
    url: "/public/job_submission/{jobId}/files",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicJobSubmissionJobIdFilesGetFile = <TData = undefined>(
  variables: PublicJobSubmissionJobIdFilesGetFileVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      undefined,
      PublicJobSubmissionJobIdFilesGetFileError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    undefined,
    PublicJobSubmissionJobIdFilesGetFileError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/job_submission/{job_id}/files",
      operationId: "publicJobSubmissionJobIdFilesGetFile",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicJobSubmissionJobIdFilesGetFile(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicJobSubmissionJobIdFilesPutFilePathParams = {
  jobId: string;
};

export type PublicJobSubmissionJobIdFilesPutFileQueryParams = {
  path: string;
};

export type PublicJobSubmissionJobIdFilesPutFileError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type PublicJobSubmissionJobIdFilesPutFileVariables = {
  body: Schemas.FileUploadFormData;
  pathParams: PublicJobSubmissionJobIdFilesPutFilePathParams;
  queryParams: PublicJobSubmissionJobIdFilesPutFileQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionJobIdFilesPutFile = (
  variables: PublicJobSubmissionJobIdFilesPutFileVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    PublicJobSubmissionJobIdFilesPutFileError,
    Schemas.FileUploadFormData,
    {},
    PublicJobSubmissionJobIdFilesPutFileQueryParams,
    PublicJobSubmissionJobIdFilesPutFilePathParams
  >({
    url: "/public/job_submission/{jobId}/files",
    method: "put",
    ...variables,
    signal,
  });

export const usePublicJobSubmissionJobIdFilesPutFile = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      PublicJobSubmissionJobIdFilesPutFileError,
      PublicJobSubmissionJobIdFilesPutFileVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    PublicJobSubmissionJobIdFilesPutFileError,
    PublicJobSubmissionJobIdFilesPutFileVariables
  >({
    mutationFn: (variables: PublicJobSubmissionJobIdFilesPutFileVariables) =>
      fetchPublicJobSubmissionJobIdFilesPutFile({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type PublicJobSubmissionJobIdFilesListListFilesPathParams = {
  jobId: string;
};

export type PublicJobSubmissionJobIdFilesListListFilesQueryParams = {
  /**
   * @default /
   */
  path?: null | string;
};

export type PublicJobSubmissionJobIdFilesListListFilesError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type PublicJobSubmissionJobIdFilesListListFilesResponse =
  Schemas.FilesFsEntry[];

export type PublicJobSubmissionJobIdFilesListListFilesVariables = {
  pathParams: PublicJobSubmissionJobIdFilesListListFilesPathParams;
  queryParams?: PublicJobSubmissionJobIdFilesListListFilesQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionJobIdFilesListListFiles = (
  variables: PublicJobSubmissionJobIdFilesListListFilesVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    PublicJobSubmissionJobIdFilesListListFilesResponse,
    PublicJobSubmissionJobIdFilesListListFilesError,
    undefined,
    {},
    PublicJobSubmissionJobIdFilesListListFilesQueryParams,
    PublicJobSubmissionJobIdFilesListListFilesPathParams
  >({
    url: "/public/job_submission/{jobId}/files_list",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicJobSubmissionJobIdFilesListListFiles = <
  TData = PublicJobSubmissionJobIdFilesListListFilesResponse
>(
  variables: PublicJobSubmissionJobIdFilesListListFilesVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      PublicJobSubmissionJobIdFilesListListFilesResponse,
      PublicJobSubmissionJobIdFilesListListFilesError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    PublicJobSubmissionJobIdFilesListListFilesResponse,
    PublicJobSubmissionJobIdFilesListListFilesError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/job_submission/{job_id}/files_list",
      operationId: "publicJobSubmissionJobIdFilesListListFiles",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicJobSubmissionJobIdFilesListListFiles(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicJobSubmissionJobIdFuseLogGetFuseLogPathParams = {
  jobId: string;
};

export type PublicJobSubmissionJobIdFuseLogGetFuseLogError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type PublicJobSubmissionJobIdFuseLogGetFuseLogVariables = {
  pathParams: PublicJobSubmissionJobIdFuseLogGetFuseLogPathParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionJobIdFuseLogGetFuseLog = (
  variables: PublicJobSubmissionJobIdFuseLogGetFuseLogVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    PublicJobSubmissionJobIdFuseLogGetFuseLogError,
    undefined,
    {},
    {},
    PublicJobSubmissionJobIdFuseLogGetFuseLogPathParams
  >({
    url: "/public/job_submission/{jobId}/fuse_log",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicJobSubmissionJobIdFuseLogGetFuseLog = <TData = undefined>(
  variables: PublicJobSubmissionJobIdFuseLogGetFuseLogVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      undefined,
      PublicJobSubmissionJobIdFuseLogGetFuseLogError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    undefined,
    PublicJobSubmissionJobIdFuseLogGetFuseLogError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/job_submission/{job_id}/fuse_log",
      operationId: "publicJobSubmissionJobIdFuseLogGetFuseLog",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicJobSubmissionJobIdFuseLogGetFuseLog(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicJobSubmissionJobIdNcmlImpsGetNcmlImpsListPathParams = {
  jobId: string;
};

export type PublicJobSubmissionJobIdNcmlImpsGetNcmlImpsListError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type PublicJobSubmissionJobIdNcmlImpsGetNcmlImpsListResponse =
  Schemas.NcmlImportantMetadata[];

export type PublicJobSubmissionJobIdNcmlImpsGetNcmlImpsListVariables = {
  pathParams: PublicJobSubmissionJobIdNcmlImpsGetNcmlImpsListPathParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionJobIdNcmlImpsGetNcmlImpsList = (
  variables: PublicJobSubmissionJobIdNcmlImpsGetNcmlImpsListVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    PublicJobSubmissionJobIdNcmlImpsGetNcmlImpsListResponse,
    PublicJobSubmissionJobIdNcmlImpsGetNcmlImpsListError,
    undefined,
    {},
    {},
    PublicJobSubmissionJobIdNcmlImpsGetNcmlImpsListPathParams
  >({
    url: "/public/job_submission/{jobId}/ncml_imps",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicJobSubmissionJobIdNcmlImpsGetNcmlImpsList = <
  TData = PublicJobSubmissionJobIdNcmlImpsGetNcmlImpsListResponse
>(
  variables: PublicJobSubmissionJobIdNcmlImpsGetNcmlImpsListVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      PublicJobSubmissionJobIdNcmlImpsGetNcmlImpsListResponse,
      PublicJobSubmissionJobIdNcmlImpsGetNcmlImpsListError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    PublicJobSubmissionJobIdNcmlImpsGetNcmlImpsListResponse,
    PublicJobSubmissionJobIdNcmlImpsGetNcmlImpsListError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/job_submission/{job_id}/ncml_imps",
      operationId: "publicJobSubmissionJobIdNcmlImpsGetNcmlImpsList",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicJobSubmissionJobIdNcmlImpsGetNcmlImpsList(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicJobSubmissionJobIdStartStartPathParams = {
  jobId: string;
};

export type PublicJobSubmissionJobIdStartStartError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type PublicJobSubmissionJobIdStartStartVariables = {
  body: Schemas.TimeSeriesJobParams;
  pathParams: PublicJobSubmissionJobIdStartStartPathParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionJobIdStartStart = (
  variables: PublicJobSubmissionJobIdStartStartVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    PublicJobSubmissionJobIdStartStartError,
    Schemas.TimeSeriesJobParams,
    {},
    {},
    PublicJobSubmissionJobIdStartStartPathParams
  >({
    url: "/public/job_submission/{jobId}/start",
    method: "post",
    ...variables,
    signal,
  });

export const usePublicJobSubmissionJobIdStartStart = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      PublicJobSubmissionJobIdStartStartError,
      PublicJobSubmissionJobIdStartStartVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    PublicJobSubmissionJobIdStartStartError,
    PublicJobSubmissionJobIdStartStartVariables
  >({
    mutationFn: (variables: PublicJobSubmissionJobIdStartStartVariables) =>
      fetchPublicJobSubmissionJobIdStartStart({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type PublicJobSubmissionJobIdStatsStatsPathParams = {
  jobId: string;
};

export type PublicJobSubmissionJobIdStatsStatsError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type PublicJobSubmissionJobIdStatsStatsVariables = {
  pathParams: PublicJobSubmissionJobIdStatsStatsPathParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionJobIdStatsStats = (
  variables: PublicJobSubmissionJobIdStatsStatsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.JobStats,
    PublicJobSubmissionJobIdStatsStatsError,
    undefined,
    {},
    {},
    PublicJobSubmissionJobIdStatsStatsPathParams
  >({
    url: "/public/job_submission/{jobId}/stats",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicJobSubmissionJobIdStatsStats = <TData = Schemas.JobStats>(
  variables: PublicJobSubmissionJobIdStatsStatsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.JobStats,
      PublicJobSubmissionJobIdStatsStatsError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.JobStats,
    PublicJobSubmissionJobIdStatsStatsError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/job_submission/{job_id}/stats",
      operationId: "publicJobSubmissionJobIdStatsStats",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicJobSubmissionJobIdStatsStats(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicJobSubmissionJobIdStatusStatusPathParams = {
  jobId: string;
};

export type PublicJobSubmissionJobIdStatusStatusError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type PublicJobSubmissionJobIdStatusStatusVariables = {
  pathParams: PublicJobSubmissionJobIdStatusStatusPathParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionJobIdStatusStatus = (
  variables: PublicJobSubmissionJobIdStatusStatusVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.JobStatus,
    PublicJobSubmissionJobIdStatusStatusError,
    undefined,
    {},
    {},
    PublicJobSubmissionJobIdStatusStatusPathParams
  >({
    url: "/public/job_submission/{jobId}/status",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicJobSubmissionJobIdStatusStatus = <
  TData = Schemas.JobStatus
>(
  variables: PublicJobSubmissionJobIdStatusStatusVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.JobStatus,
      PublicJobSubmissionJobIdStatusStatusError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.JobStatus,
    PublicJobSubmissionJobIdStatusStatusError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/job_submission/{job_id}/status",
      operationId: "publicJobSubmissionJobIdStatusStatus",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicJobSubmissionJobIdStatusStatus(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicJobSubmissionJobIdStdoutStdoutPathParams = {
  jobId: string;
};

export type PublicJobSubmissionJobIdStdoutStdoutError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type PublicJobSubmissionJobIdStdoutStdoutVariables = {
  pathParams: PublicJobSubmissionJobIdStdoutStdoutPathParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionJobIdStdoutStdout = (
  variables: PublicJobSubmissionJobIdStdoutStdoutVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    PublicJobSubmissionJobIdStdoutStdoutError,
    undefined,
    {},
    {},
    PublicJobSubmissionJobIdStdoutStdoutPathParams
  >({
    url: "/public/job_submission/{jobId}/stdout",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicJobSubmissionJobIdStdoutStdout = <TData = undefined>(
  variables: PublicJobSubmissionJobIdStdoutStdoutVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      undefined,
      PublicJobSubmissionJobIdStdoutStdoutError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    undefined,
    PublicJobSubmissionJobIdStdoutStdoutError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/job_submission/{job_id}/stdout",
      operationId: "publicJobSubmissionJobIdStdoutStdout",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicJobSubmissionJobIdStdoutStdout(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicJobSubmissionJobIdStraceStracePathParams = {
  jobId: string;
};

export type PublicJobSubmissionJobIdStraceStraceError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type PublicJobSubmissionJobIdStraceStraceVariables = {
  pathParams: PublicJobSubmissionJobIdStraceStracePathParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionJobIdStraceStrace = (
  variables: PublicJobSubmissionJobIdStraceStraceVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    PublicJobSubmissionJobIdStraceStraceError,
    undefined,
    {},
    {},
    PublicJobSubmissionJobIdStraceStracePathParams
  >({
    url: "/public/job_submission/{jobId}/strace",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicJobSubmissionJobIdStraceStrace = <TData = undefined>(
  variables: PublicJobSubmissionJobIdStraceStraceVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      undefined,
      PublicJobSubmissionJobIdStraceStraceError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    undefined,
    PublicJobSubmissionJobIdStraceStraceError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/job_submission/{job_id}/strace",
      operationId: "publicJobSubmissionJobIdStraceStrace",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicJobSubmissionJobIdStraceStrace(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicJobSubmissionJobIdStraceOutputsStraceOutputsPathParams = {
  jobId: string;
};

export type PublicJobSubmissionJobIdStraceOutputsStraceOutputsError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type PublicJobSubmissionJobIdStraceOutputsStraceOutputsResponse =
  Schemas.StraceDto[];

export type PublicJobSubmissionJobIdStraceOutputsStraceOutputsVariables = {
  pathParams: PublicJobSubmissionJobIdStraceOutputsStraceOutputsPathParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionJobIdStraceOutputsStraceOutputs = (
  variables: PublicJobSubmissionJobIdStraceOutputsStraceOutputsVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    PublicJobSubmissionJobIdStraceOutputsStraceOutputsResponse,
    PublicJobSubmissionJobIdStraceOutputsStraceOutputsError,
    undefined,
    {},
    {},
    PublicJobSubmissionJobIdStraceOutputsStraceOutputsPathParams
  >({
    url: "/public/job_submission/{jobId}/strace/outputs",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicJobSubmissionJobIdStraceOutputsStraceOutputs = <
  TData = PublicJobSubmissionJobIdStraceOutputsStraceOutputsResponse
>(
  variables: PublicJobSubmissionJobIdStraceOutputsStraceOutputsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      PublicJobSubmissionJobIdStraceOutputsStraceOutputsResponse,
      PublicJobSubmissionJobIdStraceOutputsStraceOutputsError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    PublicJobSubmissionJobIdStraceOutputsStraceOutputsResponse,
    PublicJobSubmissionJobIdStraceOutputsStraceOutputsError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/job_submission/{job_id}/strace/outputs",
      operationId: "publicJobSubmissionJobIdStraceOutputsStraceOutputs",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicJobSubmissionJobIdStraceOutputsStraceOutputs(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicJobSubmissionJobIdStraceParsedStraceParsedPathParams = {
  jobId: string;
};

export type PublicJobSubmissionJobIdStraceParsedStraceParsedError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type PublicJobSubmissionJobIdStraceParsedStraceParsedResponse =
  Schemas.StraceDto[];

export type PublicJobSubmissionJobIdStraceParsedStraceParsedVariables = {
  pathParams: PublicJobSubmissionJobIdStraceParsedStraceParsedPathParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicJobSubmissionJobIdStraceParsedStraceParsed = (
  variables: PublicJobSubmissionJobIdStraceParsedStraceParsedVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    PublicJobSubmissionJobIdStraceParsedStraceParsedResponse,
    PublicJobSubmissionJobIdStraceParsedStraceParsedError,
    undefined,
    {},
    {},
    PublicJobSubmissionJobIdStraceParsedStraceParsedPathParams
  >({
    url: "/public/job_submission/{jobId}/strace/parsed",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicJobSubmissionJobIdStraceParsedStraceParsed = <
  TData = PublicJobSubmissionJobIdStraceParsedStraceParsedResponse
>(
  variables: PublicJobSubmissionJobIdStraceParsedStraceParsedVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      PublicJobSubmissionJobIdStraceParsedStraceParsedResponse,
      PublicJobSubmissionJobIdStraceParsedStraceParsedError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    PublicJobSubmissionJobIdStraceParsedStraceParsedResponse,
    PublicJobSubmissionJobIdStraceParsedStraceParsedError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/job_submission/{job_id}/strace/parsed",
      operationId: "publicJobSubmissionJobIdStraceParsedStraceParsed",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicJobSubmissionJobIdStraceParsedStraceParsed(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicLdapAuthenticateAuthenticateError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type PublicLdapAuthenticateAuthenticateVariables = {
  body: Schemas.LdapLoginForm;
} & BackendContext["fetcherOptions"];

export const fetchPublicLdapAuthenticateAuthenticate = (
  variables: PublicLdapAuthenticateAuthenticateVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.LoginStatus,
    PublicLdapAuthenticateAuthenticateError,
    Schemas.LdapLoginForm,
    {},
    {},
    {}
  >({ url: "/public/ldap/authenticate", method: "post", ...variables, signal });

export const usePublicLdapAuthenticateAuthenticate = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      Schemas.LoginStatus,
      PublicLdapAuthenticateAuthenticateError,
      PublicLdapAuthenticateAuthenticateVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    Schemas.LoginStatus,
    PublicLdapAuthenticateAuthenticateError,
    PublicLdapAuthenticateAuthenticateVariables
  >({
    mutationFn: (variables: PublicLdapAuthenticateAuthenticateVariables) =>
      fetchPublicLdapAuthenticateAuthenticate({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type PublicLoginLoginError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type PublicLoginLoginVariables = {
  body: Schemas.EmailPasswordLoginDto;
} & BackendContext["fetcherOptions"];

export const fetchPublicLoginLogin = (
  variables: PublicLoginLoginVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.LoginStatus,
    PublicLoginLoginError,
    Schemas.EmailPasswordLoginDto,
    {},
    {},
    {}
  >({ url: "/public/login", method: "post", ...variables, signal });

export const usePublicLoginLogin = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      Schemas.LoginStatus,
      PublicLoginLoginError,
      PublicLoginLoginVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    Schemas.LoginStatus,
    PublicLoginLoginError,
    PublicLoginLoginVariables
  >({
    mutationFn: (variables: PublicLoginLoginVariables) =>
      fetchPublicLoginLogin({ ...fetcherOptions, ...variables }),
    ...options,
  });
};

export type PublicLogoutLogoutError = Fetcher.ErrorWrapper<undefined>;

export type PublicLogoutLogoutVariables = BackendContext["fetcherOptions"];

export const fetchPublicLogoutLogout = (
  variables: PublicLogoutLogoutVariables,
  signal?: AbortSignal
) =>
  backendFetch<undefined, PublicLogoutLogoutError, undefined, {}, {}, {}>({
    url: "/public/logout",
    method: "post",
    ...variables,
    signal,
  });

export const usePublicLogoutLogout = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      PublicLogoutLogoutError,
      PublicLogoutLogoutVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    PublicLogoutLogoutError,
    PublicLogoutLogoutVariables
  >({
    mutationFn: (variables: PublicLogoutLogoutVariables) =>
      fetchPublicLogoutLogout({ ...fetcherOptions, ...variables }),
    ...options,
  });
};

export type PublicMeGetMeError = Fetcher.ErrorWrapper<undefined>;

export type PublicMeGetMeVariables = BackendContext["fetcherOptions"];

export const fetchPublicMeGetMe = (
  variables: PublicMeGetMeVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.UserReflection,
    PublicMeGetMeError,
    undefined,
    {},
    {},
    {}
  >({ url: "/public/me", method: "get", ...variables, signal });

export const usePublicMeGetMe = <TData = Schemas.UserReflection>(
  variables: PublicMeGetMeVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.UserReflection,
      PublicMeGetMeError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<Schemas.UserReflection, PublicMeGetMeError, TData>(
    {
      queryKey: queryKeyFn({
        path: "/public/me",
        operationId: "publicMeGetMe",
        variables,
      }),
      queryFn: ({ signal }) =>
        fetchPublicMeGetMe({ ...fetcherOptions, ...variables }, signal),
      ...options,
      ...queryOptions,
    }
  );
};

export type PublicMeConfigurationRetrieveFrontendConfigurationError =
  Fetcher.ErrorWrapper<undefined>;

export type PublicMeConfigurationRetrieveFrontendConfigurationVariables =
  BackendContext["fetcherOptions"];

export const fetchPublicMeConfigurationRetrieveFrontendConfiguration = (
  variables: PublicMeConfigurationRetrieveFrontendConfigurationVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.FrontendConfiguration,
    PublicMeConfigurationRetrieveFrontendConfigurationError,
    undefined,
    {},
    {},
    {}
  >({ url: "/public/me/configuration", method: "get", ...variables, signal });

export const usePublicMeConfigurationRetrieveFrontendConfiguration = <
  TData = Schemas.FrontendConfiguration
>(
  variables: PublicMeConfigurationRetrieveFrontendConfigurationVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.FrontendConfiguration,
      PublicMeConfigurationRetrieveFrontendConfigurationError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.FrontendConfiguration,
    PublicMeConfigurationRetrieveFrontendConfigurationError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/me/configuration",
      operationId: "publicMeConfigurationRetrieveFrontendConfiguration",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicMeConfigurationRetrieveFrontendConfiguration(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicMeJobEnvConfigLoadUserProfileJobEnvConfigError =
  Fetcher.ErrorWrapper<undefined>;

export type PublicMeJobEnvConfigLoadUserProfileJobEnvConfigVariables =
  BackendContext["fetcherOptions"];

export const fetchPublicMeJobEnvConfigLoadUserProfileJobEnvConfig = (
  variables: PublicMeJobEnvConfigLoadUserProfileJobEnvConfigVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.JobEnvConfig,
    PublicMeJobEnvConfigLoadUserProfileJobEnvConfigError,
    undefined,
    {},
    {},
    {}
  >({ url: "/public/me/job_env_config", method: "get", ...variables, signal });

export const usePublicMeJobEnvConfigLoadUserProfileJobEnvConfig = <
  TData = Schemas.JobEnvConfig
>(
  variables: PublicMeJobEnvConfigLoadUserProfileJobEnvConfigVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.JobEnvConfig,
      PublicMeJobEnvConfigLoadUserProfileJobEnvConfigError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.JobEnvConfig,
    PublicMeJobEnvConfigLoadUserProfileJobEnvConfigError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/me/job_env_config",
      operationId: "publicMeJobEnvConfigLoadUserProfileJobEnvConfig",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicMeJobEnvConfigLoadUserProfileJobEnvConfig(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicMeJobEnvConfigStoreUserProfileJobEnvConfigError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type PublicMeJobEnvConfigStoreUserProfileJobEnvConfigVariables = {
  body: Schemas.JobEnvConfig;
} & BackendContext["fetcherOptions"];

export const fetchPublicMeJobEnvConfigStoreUserProfileJobEnvConfig = (
  variables: PublicMeJobEnvConfigStoreUserProfileJobEnvConfigVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    PublicMeJobEnvConfigStoreUserProfileJobEnvConfigError,
    Schemas.JobEnvConfig,
    {},
    {},
    {}
  >({ url: "/public/me/job_env_config", method: "put", ...variables, signal });

export const usePublicMeJobEnvConfigStoreUserProfileJobEnvConfig = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      PublicMeJobEnvConfigStoreUserProfileJobEnvConfigError,
      PublicMeJobEnvConfigStoreUserProfileJobEnvConfigVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    PublicMeJobEnvConfigStoreUserProfileJobEnvConfigError,
    PublicMeJobEnvConfigStoreUserProfileJobEnvConfigVariables
  >({
    mutationFn: (
      variables: PublicMeJobEnvConfigStoreUserProfileJobEnvConfigVariables
    ) =>
      fetchPublicMeJobEnvConfigStoreUserProfileJobEnvConfig({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type PublicMeSshAuthorizedKeysGetSshAuthorizedKeysError =
  Fetcher.ErrorWrapper<undefined>;

export type PublicMeSshAuthorizedKeysGetSshAuthorizedKeysResponse =
  Schemas.SSHAuthorizedKey[];

export type PublicMeSshAuthorizedKeysGetSshAuthorizedKeysVariables =
  BackendContext["fetcherOptions"];

export const fetchPublicMeSshAuthorizedKeysGetSshAuthorizedKeys = (
  variables: PublicMeSshAuthorizedKeysGetSshAuthorizedKeysVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    PublicMeSshAuthorizedKeysGetSshAuthorizedKeysResponse,
    PublicMeSshAuthorizedKeysGetSshAuthorizedKeysError,
    undefined,
    {},
    {},
    {}
  >({
    url: "/public/me/ssh_authorized_keys",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicMeSshAuthorizedKeysGetSshAuthorizedKeys = <
  TData = PublicMeSshAuthorizedKeysGetSshAuthorizedKeysResponse
>(
  variables: PublicMeSshAuthorizedKeysGetSshAuthorizedKeysVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      PublicMeSshAuthorizedKeysGetSshAuthorizedKeysResponse,
      PublicMeSshAuthorizedKeysGetSshAuthorizedKeysError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    PublicMeSshAuthorizedKeysGetSshAuthorizedKeysResponse,
    PublicMeSshAuthorizedKeysGetSshAuthorizedKeysError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/me/ssh_authorized_keys",
      operationId: "publicMeSshAuthorizedKeysGetSshAuthorizedKeys",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicMeSshAuthorizedKeysGetSshAuthorizedKeys(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicMeSshAuthorizedKeysAddSshAuthorizedKeyError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type PublicMeSshAuthorizedKeysAddSshAuthorizedKeyVariables = {
  body: Schemas.SSHAuthorizedKey;
} & BackendContext["fetcherOptions"];

export const fetchPublicMeSshAuthorizedKeysAddSshAuthorizedKey = (
  variables: PublicMeSshAuthorizedKeysAddSshAuthorizedKeyVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.SSHAuthorizedKeyAddResponse,
    PublicMeSshAuthorizedKeysAddSshAuthorizedKeyError,
    Schemas.SSHAuthorizedKey,
    {},
    {},
    {}
  >({
    url: "/public/me/ssh_authorized_keys",
    method: "post",
    ...variables,
    signal,
  });

export const usePublicMeSshAuthorizedKeysAddSshAuthorizedKey = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      Schemas.SSHAuthorizedKeyAddResponse,
      PublicMeSshAuthorizedKeysAddSshAuthorizedKeyError,
      PublicMeSshAuthorizedKeysAddSshAuthorizedKeyVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    Schemas.SSHAuthorizedKeyAddResponse,
    PublicMeSshAuthorizedKeysAddSshAuthorizedKeyError,
    PublicMeSshAuthorizedKeysAddSshAuthorizedKeyVariables
  >({
    mutationFn: (
      variables: PublicMeSshAuthorizedKeysAddSshAuthorizedKeyVariables
    ) =>
      fetchPublicMeSshAuthorizedKeysAddSshAuthorizedKey({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type PublicMeSshAuthorizedKeysEntryIdRmSshAuthorizedKeyPathParams = {
  entryId: string;
};

export type PublicMeSshAuthorizedKeysEntryIdRmSshAuthorizedKeyError =
  Fetcher.ErrorWrapper<{
    status: 400;
    payload: {
      detail: string;
      extra?: void;
      status_code: number;
    };
  }>;

export type PublicMeSshAuthorizedKeysEntryIdRmSshAuthorizedKeyVariables = {
  pathParams: PublicMeSshAuthorizedKeysEntryIdRmSshAuthorizedKeyPathParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicMeSshAuthorizedKeysEntryIdRmSshAuthorizedKey = (
  variables: PublicMeSshAuthorizedKeysEntryIdRmSshAuthorizedKeyVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    PublicMeSshAuthorizedKeysEntryIdRmSshAuthorizedKeyError,
    undefined,
    {},
    {},
    PublicMeSshAuthorizedKeysEntryIdRmSshAuthorizedKeyPathParams
  >({
    url: "/public/me/ssh_authorized_keys/{entryId}",
    method: "delete",
    ...variables,
    signal,
  });

export const usePublicMeSshAuthorizedKeysEntryIdRmSshAuthorizedKey = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      undefined,
      PublicMeSshAuthorizedKeysEntryIdRmSshAuthorizedKeyError,
      PublicMeSshAuthorizedKeysEntryIdRmSshAuthorizedKeyVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    undefined,
    PublicMeSshAuthorizedKeysEntryIdRmSshAuthorizedKeyError,
    PublicMeSshAuthorizedKeysEntryIdRmSshAuthorizedKeyVariables
  >({
    mutationFn: (
      variables: PublicMeSshAuthorizedKeysEntryIdRmSshAuthorizedKeyVariables
    ) =>
      fetchPublicMeSshAuthorizedKeysEntryIdRmSshAuthorizedKey({
        ...fetcherOptions,
        ...variables,
      }),
    ...options,
  });
};

export type PublicOicConfigOicProvidersListError =
  Fetcher.ErrorWrapper<undefined>;

export type PublicOicConfigOicProvidersListVariables =
  BackendContext["fetcherOptions"];

export const fetchPublicOicConfigOicProvidersList = (
  variables: PublicOicConfigOicProvidersListVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.OicProvidersListResponse,
    PublicOicConfigOicProvidersListError,
    undefined,
    {},
    {},
    {}
  >({ url: "/public/oic/config", method: "get", ...variables, signal });

export const usePublicOicConfigOicProvidersList = <
  TData = Schemas.OicProvidersListResponse
>(
  variables: PublicOicConfigOicProvidersListVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      Schemas.OicProvidersListResponse,
      PublicOicConfigOicProvidersListError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    Schemas.OicProvidersListResponse,
    PublicOicConfigOicProvidersListError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/oic/config",
      operationId: "publicOicConfigOicProvidersList",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicOicConfigOicProvidersList(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicOicIssuerCallbackOicCallbackPathParams = {
  issuer: string;
};

export type PublicOicIssuerCallbackOicCallbackError = Fetcher.ErrorWrapper<
  | {
      status: 303;
      payload: void;
    }
  | {
      status: 400;
      payload: {
        detail: string;
        extra?: void;
        status_code: number;
      };
    }
>;

export type PublicOicIssuerCallbackOicCallbackVariables = {
  pathParams: PublicOicIssuerCallbackOicCallbackPathParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicOicIssuerCallbackOicCallback = (
  variables: PublicOicIssuerCallbackOicCallbackVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    undefined,
    PublicOicIssuerCallbackOicCallbackError,
    undefined,
    {},
    {},
    PublicOicIssuerCallbackOicCallbackPathParams
  >({
    url: "/public/oic/{issuer}/callback",
    method: "get",
    ...variables,
    signal,
  });

export const usePublicOicIssuerCallbackOicCallback = <TData = undefined>(
  variables: PublicOicIssuerCallbackOicCallbackVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<
      undefined,
      PublicOicIssuerCallbackOicCallbackError,
      TData
    >,
    "queryKey" | "queryFn"
  >
) => {
  const { fetcherOptions, queryOptions, queryKeyFn } =
    useBackendContext(options);
  return reactQuery.useQuery<
    undefined,
    PublicOicIssuerCallbackOicCallbackError,
    TData
  >({
    queryKey: queryKeyFn({
      path: "/public/oic/{issuer}/callback",
      operationId: "publicOicIssuerCallbackOicCallback",
      variables,
    }),
    queryFn: ({ signal }) =>
      fetchPublicOicIssuerCallbackOicCallback(
        { ...fetcherOptions, ...variables },
        signal
      ),
    ...options,
    ...queryOptions,
  });
};

export type PublicOicIssuerInitOicInitPathParams = {
  issuer: string;
};

export type PublicOicIssuerInitOicInitQueryParams = {
  final_redirect_url: string;
};

export type PublicOicIssuerInitOicInitError = Fetcher.ErrorWrapper<{
  status: 400;
  payload: {
    detail: string;
    extra?: void;
    status_code: number;
  };
}>;

export type PublicOicIssuerInitOicInitVariables = {
  pathParams: PublicOicIssuerInitOicInitPathParams;
  queryParams: PublicOicIssuerInitOicInitQueryParams;
} & BackendContext["fetcherOptions"];

export const fetchPublicOicIssuerInitOicInit = (
  variables: PublicOicIssuerInitOicInitVariables,
  signal?: AbortSignal
) =>
  backendFetch<
    Schemas.OicInitResponse,
    PublicOicIssuerInitOicInitError,
    undefined,
    {},
    PublicOicIssuerInitOicInitQueryParams,
    PublicOicIssuerInitOicInitPathParams
  >({ url: "/public/oic/{issuer}/init", method: "post", ...variables, signal });

export const usePublicOicIssuerInitOicInit = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      Schemas.OicInitResponse,
      PublicOicIssuerInitOicInitError,
      PublicOicIssuerInitOicInitVariables
    >,
    "mutationFn"
  >
) => {
  const { fetcherOptions } = useBackendContext();
  return reactQuery.useMutation<
    Schemas.OicInitResponse,
    PublicOicIssuerInitOicInitError,
    PublicOicIssuerInitOicInitVariables
  >({
    mutationFn: (variables: PublicOicIssuerInitOicInitVariables) =>
      fetchPublicOicIssuerInitOicInit({ ...fetcherOptions, ...variables }),
    ...options,
  });
};

export type QueryOperation =
  | {
      path: "/admin/datasets";
      operationId: "adminDatasetsListDatasets";
      variables: AdminDatasetsListDatasetsVariables;
    }
  | {
      path: "/admin/datasets/{dataset_id}";
      operationId: "adminDatasetsDatasetIdGetDataset";
      variables: AdminDatasetsDatasetIdGetDatasetVariables;
    }
  | {
      path: "/admin/events";
      operationId: "adminEventsListEvents";
      variables: AdminEventsListEventsVariables;
    }
  | {
      path: "/admin/events/{event_id}";
      operationId: "adminEventsEventIdGetEventById";
      variables: AdminEventsEventIdGetEventByIdVariables;
    }
  | {
      path: "/admin/jobs";
      operationId: "adminJobsListJobs";
      variables: AdminJobsListJobsVariables;
    }
  | {
      path: "/admin/jobs/{job_id}";
      operationId: "adminJobsJobIdGetJobDetails";
      variables: AdminJobsJobIdGetJobDetailsVariables;
    }
  | {
      path: "/admin/settings";
      operationId: "adminSettingsRead";
      variables: AdminSettingsReadVariables;
    }
  | {
      path: "/admin/settings/factory_default";
      operationId: "adminSettingsFactoryDefaultGetFactoryDefault";
      variables: AdminSettingsFactoryDefaultGetFactoryDefaultVariables;
    }
  | {
      path: "/admin/users";
      operationId: "adminUsersListUsers";
      variables: AdminUsersListUsersVariables;
    }
  | {
      path: "/admin/users/{user_id}";
      operationId: "adminUsersUserIdGetUser";
      variables: AdminUsersUserIdGetUserVariables;
    }
  | {
      path: "/internal/datasets";
      operationId: "internalDatasetsList";
      variables: InternalDatasetsListVariables;
    }
  | {
      path: "/internal/datasets/try_find_run/{job_id}";
      operationId: "internalDatasetsTryFindRunJobIdTryFindRun";
      variables: InternalDatasetsTryFindRunJobIdTryFindRunVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}";
      operationId: "internalDatasetsDatasetIdRead";
      variables: InternalDatasetsDatasetIdReadVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/access";
      operationId: "internalDatasetsDatasetIdAccessGetAccess";
      variables: InternalDatasetsDatasetIdAccessGetAccessVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/all_runs";
      operationId: "internalDatasetsDatasetIdAllRunsListAllRuns";
      variables: InternalDatasetsDatasetIdAllRunsListAllRunsVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/config_txs";
      operationId: "internalDatasetsDatasetIdConfigTxsGetConfigPendingTxs";
      variables: InternalDatasetsDatasetIdConfigTxsGetConfigPendingTxsVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/cron/jobs";
      operationId: "internalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobs";
      variables: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsListCronJobsVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/cron/jobs/{job_id}";
      operationId: "internalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdReadCronJob";
      variables: InternalDatasetsDatasetIdConfigTxsTxIdCronJobsJobIdReadCronJobVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/diff_from/{other_tx_id}";
      operationId: "internalDatasetsDatasetIdConfigTxsTxIdDiffFromOtherTxIdGetConfigDiff";
      variables: InternalDatasetsDatasetIdConfigTxsTxIdDiffFromOtherTxIdGetConfigDiffVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/export";
      operationId: "internalDatasetsDatasetIdConfigTxsTxIdExportExportConfigDirectory";
      variables: InternalDatasetsDatasetIdConfigTxsTxIdExportExportConfigDirectoryVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/fuse";
      operationId: "internalDatasetsDatasetIdConfigTxsTxIdFuseGetFuse";
      variables: InternalDatasetsDatasetIdConfigTxsTxIdFuseGetFuseVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/inis";
      operationId: "internalDatasetsDatasetIdConfigTxsTxIdInisListInis";
      variables: InternalDatasetsDatasetIdConfigTxsTxIdInisListInisVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/inis/{name}";
      operationId: "internalDatasetsDatasetIdConfigTxsTxIdInisNameReadIni";
      variables: InternalDatasetsDatasetIdConfigTxsTxIdInisNameReadIniVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/job_env";
      operationId: "internalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnv";
      variables: InternalDatasetsDatasetIdConfigTxsTxIdJobEnvGetJobEnvVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/config_txs/{tx_id}/meta";
      operationId: "internalDatasetsDatasetIdConfigTxsTxIdMetaGetMeta";
      variables: InternalDatasetsDatasetIdConfigTxsTxIdMetaGetMetaVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/fs_snapshot/cached";
      operationId: "internalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshot";
      variables: InternalDatasetsDatasetIdFsSnapshotCachedGetCachedFsSnapshotVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/input/files";
      operationId: "internalDatasetsDatasetIdInputFilesGetInputFile";
      variables: InternalDatasetsDatasetIdInputFilesGetInputFileVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/input/list";
      operationId: "internalDatasetsDatasetIdInputListListInputFiles";
      variables: InternalDatasetsDatasetIdInputListListInputFilesVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/released_runs";
      operationId: "internalDatasetsDatasetIdReleasedRunsListRuns";
      variables: InternalDatasetsDatasetIdReleasedRunsListRunsVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/revisions";
      operationId: "internalDatasetsDatasetIdRevisionsGetRevisions";
      variables: InternalDatasetsDatasetIdRevisionsGetRevisionsVariables;
    }
  | {
      path: "/internal/datasets/{dataset_id}/revisions/{tx_id}/message";
      operationId: "internalDatasetsDatasetIdRevisionsTxIdMessageGetRevision";
      variables: InternalDatasetsDatasetIdRevisionsTxIdMessageGetRevisionVariables;
    }
  | {
      path: "/internal/events";
      operationId: "internalEventsListEvents";
      variables: InternalEventsListEventsVariables;
    }
  | {
      path: "/internal/events/{event_id}";
      operationId: "internalEventsEventIdGetEventById";
      variables: InternalEventsEventIdGetEventByIdVariables;
    }
  | {
      path: "/internal/system_env";
      operationId: "internalSystemEnvReadSystemEnv";
      variables: InternalSystemEnvReadSystemEnvVariables;
    }
  | {
      path: "/public/datasets";
      operationId: "publicDatasetsListDatasets";
      variables: PublicDatasetsListDatasetsVariables;
    }
  | {
      path: "/public/datasets/ncml_search";
      operationId: "publicDatasetsNcmlSearchSearchDatasets";
      variables: PublicDatasetsNcmlSearchSearchDatasetsVariables;
    }
  | {
      path: "/public/datasets/{dataset_id}";
      operationId: "publicDatasetsDatasetIdGetDataset";
      variables: PublicDatasetsDatasetIdGetDatasetVariables;
    }
  | {
      path: "/public/datasets/{dataset_id}/released_jobs";
      operationId: "publicDatasetsDatasetIdReleasedJobsGetReleasedJobs";
      variables: PublicDatasetsDatasetIdReleasedJobsGetReleasedJobsVariables;
    }
  | {
      path: "/public/job_submission";
      operationId: "publicJobSubmissionListMyJobs";
      variables: PublicJobSubmissionListMyJobsVariables;
    }
  | {
      path: "/public/job_submission/{job_id}/access_level";
      operationId: "publicJobSubmissionJobIdAccessLevelGetJobAccessLevel";
      variables: PublicJobSubmissionJobIdAccessLevelGetJobAccessLevelVariables;
    }
  | {
      path: "/public/job_submission/{job_id}/data_qa/analysis";
      operationId: "publicJobSubmissionJobIdDataQaAnalysisGetDataQaParsed";
      variables: PublicJobSubmissionJobIdDataQaAnalysisGetDataQaParsedVariables;
    }
  | {
      path: "/public/job_submission/{job_id}/data_qa/timeline";
      operationId: "publicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimeline";
      variables: PublicJobSubmissionJobIdDataQaTimelineGetDataQaParsedTimelineVariables;
    }
  | {
      path: "/public/job_submission/{job_id}/files";
      operationId: "publicJobSubmissionJobIdFilesGetFile";
      variables: PublicJobSubmissionJobIdFilesGetFileVariables;
    }
  | {
      path: "/public/job_submission/{job_id}/files_list";
      operationId: "publicJobSubmissionJobIdFilesListListFiles";
      variables: PublicJobSubmissionJobIdFilesListListFilesVariables;
    }
  | {
      path: "/public/job_submission/{job_id}/fuse_log";
      operationId: "publicJobSubmissionJobIdFuseLogGetFuseLog";
      variables: PublicJobSubmissionJobIdFuseLogGetFuseLogVariables;
    }
  | {
      path: "/public/job_submission/{job_id}/ncml_imps";
      operationId: "publicJobSubmissionJobIdNcmlImpsGetNcmlImpsList";
      variables: PublicJobSubmissionJobIdNcmlImpsGetNcmlImpsListVariables;
    }
  | {
      path: "/public/job_submission/{job_id}/stats";
      operationId: "publicJobSubmissionJobIdStatsStats";
      variables: PublicJobSubmissionJobIdStatsStatsVariables;
    }
  | {
      path: "/public/job_submission/{job_id}/status";
      operationId: "publicJobSubmissionJobIdStatusStatus";
      variables: PublicJobSubmissionJobIdStatusStatusVariables;
    }
  | {
      path: "/public/job_submission/{job_id}/stdout";
      operationId: "publicJobSubmissionJobIdStdoutStdout";
      variables: PublicJobSubmissionJobIdStdoutStdoutVariables;
    }
  | {
      path: "/public/job_submission/{job_id}/strace";
      operationId: "publicJobSubmissionJobIdStraceStrace";
      variables: PublicJobSubmissionJobIdStraceStraceVariables;
    }
  | {
      path: "/public/job_submission/{job_id}/strace/outputs";
      operationId: "publicJobSubmissionJobIdStraceOutputsStraceOutputs";
      variables: PublicJobSubmissionJobIdStraceOutputsStraceOutputsVariables;
    }
  | {
      path: "/public/job_submission/{job_id}/strace/parsed";
      operationId: "publicJobSubmissionJobIdStraceParsedStraceParsed";
      variables: PublicJobSubmissionJobIdStraceParsedStraceParsedVariables;
    }
  | {
      path: "/public/me";
      operationId: "publicMeGetMe";
      variables: PublicMeGetMeVariables;
    }
  | {
      path: "/public/me/configuration";
      operationId: "publicMeConfigurationRetrieveFrontendConfiguration";
      variables: PublicMeConfigurationRetrieveFrontendConfigurationVariables;
    }
  | {
      path: "/public/me/job_env_config";
      operationId: "publicMeJobEnvConfigLoadUserProfileJobEnvConfig";
      variables: PublicMeJobEnvConfigLoadUserProfileJobEnvConfigVariables;
    }
  | {
      path: "/public/me/ssh_authorized_keys";
      operationId: "publicMeSshAuthorizedKeysGetSshAuthorizedKeys";
      variables: PublicMeSshAuthorizedKeysGetSshAuthorizedKeysVariables;
    }
  | {
      path: "/public/oic/config";
      operationId: "publicOicConfigOicProvidersList";
      variables: PublicOicConfigOicProvidersListVariables;
    }
  | {
      path: "/public/oic/{issuer}/callback";
      operationId: "publicOicIssuerCallbackOicCallback";
      variables: PublicOicIssuerCallbackOicCallbackVariables;
    };
