---
title: Monitoring and notifications
summary: Introduction to service-generated events and their role in monitoring and notifications.
---

The service generates and stores event records that capture significant actions or occurrences within the platform.
They serve as a foundation for monitoring, troubleshooting, and notifying users about important activities or issues.

### Monitoring

Administrators can view all events generated by the service for an application-specific monitoring.

For example, administrators receive notifications when users request to become data owners, enabling them to review and approve such requests promptly.

Each event contains the following attributes:

- A unique identifier for the event.
- The ID of the user who triggered the event. This can either be a direct action by the user or an action performed by an automated cron job owned by the user.
- The ID of the dataset associated with the event.
- The ID of the dataset cron job associated with the event.
- The ID of the job associated with the event.
- The type of the event (e.g., job failure, privilege request).
- An unstructured text string for a short, human readable, descriptive title of the event.
- An unstructured text string for additional detailed information about the event.
- The timestamp when the event was created.
- A fingerprint: a unique hash used to group similar events and silence similar notifications.

### Notifications

The service implements a mechanism to alert users about critical events.
Events trigger notifications to users based on their preferences and settings.

Notifications can be delivered as emails via SMTP, ensuring that users are promptly informed about important events.

See [deployment instructions](./deployment.md) to set up the optional SMTP connection.

Users will be able to configure notification settings differently for three event types:

- Manual job failures (includes guest resampling of public datasets).
- Failures during cron job execution.
- Requests to become data owners.

Planned settings include:

- **Email notifications**: Enable or disable emails for specific event types.
- **Debounce interval**: Set a time interval to limit the frequency of emails for the same event type. For example, a 24-hour interval ensures at most one email per type per day (3 per day).

Users will be able to silence notifications for recurring events using the event fingerprint.

### Regex-based event details

Regex patterns will be implemented to extract event information from job logs (`stdout`/`stderr`). This will allow for more precise and automated parsing of event details, improving the accuracy and usability of event records.

The system will support capturing and displaying MeteoIO warnings in addition to errors. 
Notifications for warnings may also be implemented, depending on user preferences.


### Event fingerprint

The event fingerprint is a hash code based on the following attributes:

- The ID of the user who generated the event.
- The ID of the dataset associated with the event.
- The ID of the dataset cron job associated with the event.
- The type of the event.
- The title of the event.

Other event details are excluded from fingerprinting.

The fingerprint helps group similar events while ignoring minor differences, such as job-specific details, to simplify filtering and analysis. Additionally, it serves as the basis for notifications silencing, allowing users to suppress notifications for specific types of recurring events.

## Events dashboard

The **Recent events** page provides administrators with a detailed, read-only view of service-generated events.
This feature is designed to offer a clear and filterable overview of events, without allowing modifications or deletions.

### Features

- A view of recent events for effective system monitoring.
- Context menus for quick access to related details.
- The ability to dynamically filter events for specific cases or users.

### Event viewing

Events are displayed in a table with the following information:

- **Who**: The user who generated the event, with a link to the user's details. This can either be a direct action by the user or an action performed by an automated cron job owned by the user.
- **What**: The title or type of event.
- **When**: The event creation date and time.

### Dynamic filters

Administrators can apply filters to refine the event view.

A filter can be specified via a dedicated button in the header, or via the context menu on the event row in the table. 

Active filters appear as removable tags in a filter bar. 

Supported filters:

  - Filter by source user ID.
  - Filter by event fingerprint.
