---
title: Job Environment Variables Configuration
---

Environment variables can be configured at different scopes to control the behavior of MeteoIO jobs. These scopes include:

- **System**: Configured by system administrators in their system administration panel.
- **Data owner**: Configured by data owners in their user profile. 
- **Dataset**: Configured in the dataset settings, with versioning.
- **Cron Job**: Configured as part of a dataset's cron job settings (also versioned).

The table below summarizes whether each settings scope affects different types of jobs:

| Job Type                                                                 | System | Data owner | Dataset | Cron Job |
|--------------------------------------------------------------------------|--------|------------|---------|----------|
| Dataset cron job                                                         | Yes    | Yes        | Yes     | Yes      |
| Dataset manual job (test or released)                                    | Yes    | Yes        | Yes     | No       |
| Manual re-run of dataset output (manual releases and cron jobs)          | Yes    | Yes        | Yes     | No       |
| Manual re-run of a public dataset output (manual releases and cron jobs) | Yes    | Yes        | Yes     | No       |
| Guest job with guest-submitted data                                      | Yes    | No         | No      | No       |
| Guest job from WPS                                                       | No     | No         | No      | No       |

### Precedence and Overriding

- **Precedence of scopes**: When the same environment variable is defined in multiple scopes, the most specific scope takes precedence. The order of precedence is: **System** (lowest), **Data owner**, **Dataset**, **Cron Job** (highest).

- **Overriding within a scope**: If the same variable is defined multiple times within the same scope, the **last definition wins**.

### Notes

- Cron job-specific settings are currently **not applied** when manually re-running a cron job (e.g., resampling a published output).
- There's no exception for public datasets: the **data owner scope** refers to the profile of the dataset's owner, not the profile of the user performing the re-run.
