---
title: Becoming a Data Owner
---

## Role

The Data Owner is the person who is responsible for a certain data stream (usually provided by an Automatic Weather Station). The data owner checks that the station fulfills its role (so data comes when expected and the measurements are reasonably useful) and informs the technical team if this is not the case. The data owner is also the main contact point for the data users if they have questions regarding the data as well as to inform the data producers of scientific publications or operational data products that might be based on the collected data. The MeteoIO webservice provides various tools to fulfill these tasks as efficiently as possible[^1].

## Getting there...

First, in order to get the **Data Owner** role, follow these steps:

1. **Login**: To initiate the process of becoming a data owner, first log in via an identity provider such as ORCiD, OAuth (Microsoft) or LDAP. This ensures a secure and verified entry into the system.
2. **Dataset Creation Permission**: After logging in, notify the system administrator of your intent to create datasets. The software does (yet) not provide any specific way to get in touch with administrators. Once you had success, the administrator may grant you the necessary permissions to commence dataset creation.

## Setting your profile

When you manage several stations, you probably have many information that are in common accross these stations: your identity and contact information, your field of research, people who often collaborate with you. Therefore it makes sense to provide such information in your user profile as environment variables that will automatically be used to populate some of the metadata for your datasets. Thus you will have metadata rich dataset with minimal efforts!

After clicking on your username (upper right corner of the screen), select *Profile and environment settings*. By default, it opens the *Environment variables* table. When it starts, it is empty. You can simultaneously open Inishell on your computer, go to the *Output* tab, select a meteorological timeseries plugin such as NetCDF or iCSV and show the acdd metadata. There you can explore the available metadata fields and decide which ones you want to set in your profile, to be [inherited](job_env_config.md) by all your datasets (you can always overwrite such a variable per dataset or per cron job, see [Automation](data_owners_automation.md)).

<figure markdown>
  ![Principles](../img/Inishell_acdd_metadata.png){ width="700", .center }
</figure>

The following fields are well suited to be set in your profile (go to the [ACDD documentation](https://wiki.esipfed.org/Attribute_Convention_for_Data_Discovery_1-3#Global_Attributes) for more details):

| **Variable**              || **Variable**               |
|---------------------------||----------------------------|
| ACDD_CREATOR              || ISO_TOPIC_CATEGORY         |
| ACDD_CREATOR_EMAIL        || ACDD_INSTITUTION           |
| ACDD_CREATOR_TYPE         || USERNAME                   |
| ACDD_CREATOR_INSTITUTION  || ACDD_CONTRIBUTOR           |
| ACDD_KEYWORDS             || ACDD_CONTRIBUTOR_ROLE      |
| ACDD_KEYWORDS_VOCABULARY  || ACDD_SOURCE                |
| ACDD_ACTIVITY_TYPE        || ACDD_PROJECT               |
| ACDD_OPERATIONAL_STATUS   || ACDD_PROGRAM               |
| DATASET_PRODUCTION_STATUS || ACDD_NAMING_AUTHORITY      |
| ACDD_LICENSE              || ACDD_COVERAGE_CONTENT_TYPE |


[^1]: Please note that some of these features are still in development and therefore not accessible yet.