INIshell
====================

Introduction
--------------------

Welcome to Inishell, a flexible Graphical User Interface (GUI) for simulation software.
Inishell is open source under the GNU GPL3 license and is shipped as the GUI for various numerical modelling software packages to configure and run the simulations intuitively.

Inishell loads XML files containing a semantic description of the models' parameters and dynamically builds a GUI upon this information.
Hence, for the end user it offers a graphical user interface for provided modeling software which is tailored to rapid development and therefore hopefully never outdated. For the developer on the other hand, it offers the possibility to very easily set up a GUI for their application and keep it synchronized with the evolving models. Deploying a new feature in the GUI is then as easy as editing an XML text file and shipping this updated version to the user.

- For help concerning the installation of Inishell as well as general information please visit Inishell's project page at https://gitlabext.wsl.ch/snow-models/inishell - especially the wiki pages at https://gitlabext.wsl.ch/snow-models/inishell/-/wikis/home
- Once Inishell is running, it offers an extensive built-in help browser for both end users and developers.
- For technical information about the architecture and principles and how Inishell can help you as a developer please consult the paper shipped in the subfolder "resources/doc".
- For help about the software that is being configured through Inishell (i. e. the numerical model itself), see the respective vendor's documentation (and of course the help that is provided for it through Inishell).

Precompiled packages
--------------------

You can find precompiled packages for your plateform currently at https://models.slf.ch/p/inishell-ng/downloads/. These packages contain a precompiled version of the MeteoIO library as well as a small executable in order to be able to use it to preprocess meteorological timeseries.

Compilation from source
--------------------

You will need a C++ compiler (such as g++ on GNU/Linux), and the Qt compiler (translating code written for the Qt toolkit to pure C++).
On GNU/Linux, you can install relatively small toolkits to compile Inishell through the command line:

```bash
sudo apt install make
sudo apt install build-essential
sudo apt install qttools5-dev-tools
sudo apt install libqt5xmlpatterns5-dev
```

```bash
cd inishell
qmake
make
```

On other platforms you can either try to emulate this or you can install Qt Creator by downloading a copy from https://www.qt.io/download (choosing an open source license) and importing the file "inishell.pro". After configuring your compiler kit (e. g. Clang on macOS, Visual C++ on Windows or Code::Blocks on all platforms) you can build the project. On Windows, be sure to make the needed DLLs from the Qt installation directory accessible (by e. g. copying them alongside the exe). Static linking requires a static version of Qt. On macOS you also need XCode to run Qt Creator, which can be obtained from Apple with an Apple ID (which does not have to be a developer ID). Of course you can also use Qt Creator on GNU/Linux.

The compiled program can then be found in the "build" subdirectory.

*This project has been made possible with the support of the WSL Institute for Snow and Avalanche Research SLF (https://www.slf.ch).*
