/*****************************************************************************/
/*  Copyright 2019 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with INIshell. If not, see <http://www.gnu.org/licenses/>.
*/

#include "colors.h"

namespace colors {

/**
 * @brief Get color for a specific event or item.
 * @param[in] INIshell's name for the color.
 * @return Qt usable color.
 */
QColor getQColor(const QString &colorname)
{
	QString name(colorname.toLower());

	/* substitutions */
	if (name == "criticalerror")
		name = "lightred";
	else if (name == "error")
		name = "red";
	else if (name == "xmlerror")
		name = "red";
	else if (name == "fileerror")
		name = "red";
	else if (name == "fatalerror")
		name = "darkred";
	else if (name == "workflowerror")
		name = "darkpurple";
	else if (name == "info")
		name = "blue";
	else if (name == "warning")
		name = "orange";
	else if (name == "helptext")
		name = "gray";
	else if (name == "key")
		name = "darkblue";
	else if (name == "groupborder")
		name = "lightblue";
	else if (name == "frameborder")
		name = "purple";
	else if (name == "msg")
		name = "black";
	else if (name == "iniwarning")
		name = "orange";
	else if (name == "mandatory")
		name = "lightyellow";
	else if (name == "default_values")
		name = "lightmagenta";
	else if (name == "faulty_values")
		name = "lightred";
	else if (name == "valid_values")
		name = "lightgreen";
	else if (name == "sysinfo")
		name = "gray";

	/* syntax highlighter */
	if (name == "syntax_known_key")
		return Qt::darkGreen;
	else if (name == "syntax_unknown_key")
		return QColor("#00db7d");
	else if (name == "syntax_known_section")
		return Qt::darkRed;
	else if (name == "syntax_unknown_section")
		return QColor("#f21d0a");
	else if (name == "syntax_value")
		return Qt::black;
	else if (name == "syntax_background")
		return QColor("#fffffa");
	else if (name == "syntax_invalid")
		return QColor("#ff9500");
	else if (name == "syntax_comment")
		return Qt::blue;

	/* colors */
	if (name == "darkred")
		return Qt::darkRed;
	else if (name == "blue")
		return Qt::blue;
	else if (name == "lightblue")
		return {220, 235, 250};
	else if (name == "lightmagenta")
		return QColor("#faf2f8");
	else if (name == "darkblue")
		return {0, 0, 150};
	else if (name == "lightred")
		return {255, 190, 190};
	else if (name == "orange")
		return {255, 140, 0};
	else if (name == "red")
		return Qt::red;
	else if (name == "mediumred")
		return {250, 105, 105};
	else if (name == "lightred")
		return {250, 210, 210};
	else if (name == "gray")
		return {100, 100, 100};
	else if (name == "purple")
		return {110, 40, 160};
	else if (name == "darkpurple")
		return QColor("#7c00ad");
	else if (name == "yellow")
		return Qt::yellow;
	else if (name == "lightyellow")
		return QColor("#fcfbe6");
	else if (name == "gray")
		return Qt::gray;
	else if (name == "lightgreen")
		return {200, 255, 200};
	else
		return QColor(name); //let Qt pick (e. g. hex codes), black if not valid
}

} //namespace colors
